/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine;

import bloop.CompilerCache;
import bloop.ScalaInstance$;
import bloop.bsp.BspServer$;
import bloop.cli.AmmoniteRepl$;
import bloop.cli.BspProtocol;
import bloop.cli.BspProtocol$;
import bloop.cli.CliOptions;
import bloop.cli.Commands;
import bloop.cli.Commands$RawCommand$;
import bloop.cli.CommonOptions;
import bloop.cli.ExitStatus;
import bloop.cli.ExitStatus$;
import bloop.cli.ReplKind;
import bloop.cli.ReporterKind;
import bloop.cli.ReporterKind$;
import bloop.cli.ScalacRepl$;
import bloop.cli.Validate$;
import bloop.cli.completion.Case$;
import bloop.cli.completion.Mode;
import bloop.cli.completion.Mode$Commands$;
import bloop.cli.completion.Mode$Flags$;
import bloop.cli.completion.Mode$MainsFQCN$;
import bloop.cli.completion.Mode$ProjectBoundCommands$;
import bloop.cli.completion.Mode$Projects$;
import bloop.cli.completion.Mode$Protocols$;
import bloop.cli.completion.Mode$Reporters$;
import bloop.cli.completion.Mode$TestsFQCN$;
import bloop.config.Config;
import bloop.data.ClientInfo;
import bloop.data.JdkConfig;
import bloop.data.Platform;
import bloop.data.Project;
import bloop.engine.Action;
import bloop.engine.Aggregate;
import bloop.engine.Build;
import bloop.engine.ClientPool;
import bloop.engine.Dag;
import bloop.engine.Dag$;
import bloop.engine.Dag$PreOrder$;
import bloop.engine.ExecutionContext$;
import bloop.engine.Exit;
import bloop.engine.Feedback$;
import bloop.engine.Interpreter;
import bloop.engine.Interpreter$;
import bloop.engine.Leaf;
import bloop.engine.Parent;
import bloop.engine.Print;
import bloop.engine.Run;
import bloop.engine.State;
import bloop.engine.State$;
import bloop.engine.State$XState$;
import bloop.engine.caches.ResultsCache;
import bloop.engine.caches.SourceGeneratorCache;
import bloop.engine.tasks.CompileTask$;
import bloop.engine.tasks.LinkTask$;
import bloop.engine.tasks.RunMode;
import bloop.engine.tasks.RunMode$Normal$;
import bloop.engine.tasks.Tasks$;
import bloop.engine.tasks.TestFrameworkWithClasses;
import bloop.engine.tasks.TestTask$;
import bloop.engine.tasks.compilation.CompileClientStore$NoStore$;
import bloop.engine.tasks.toolchains.ScalaJsToolchain$;
import bloop.engine.tasks.toolchains.ScalaNativeToolchain$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.RelativePath$;
import bloop.io.SourceWatcher;
import bloop.io.SourceWatcher$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import bloop.logging.NoopLogger$;
import bloop.reporter.LogReporter;
import bloop.reporter.ReporterConfig;
import bloop.task.Task;
import bloop.task.Task$;
import bloop.testing.LoggingEventHandler;
import bloop.testing.TestInternals$;
import bloop.util.CrossPlatform$;
import caseapp.core.Arg;
import caseapp.core.help.CommandHelp;
import ch.epfl.scala.bsp.ScalaTestSuites;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import monix.execution.Scheduler;
import monix.reactive.subjects.BehaviorSubject;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Interpreter$ {
    public static Interpreter$ MODULE$;

    static {
        new Interpreter$();
    }

    public Task<State> execute(Action action, Task<State> stateTask) {
        return Interpreter$.execute$1(action, stateTask);
    }

    private Task<State> notHandled(String command, CliOptions cliOptions, State state) {
        String msg = new StringBuilder(55).append("The handling of `").append(command).append("` does not happen in the `Interpreter`").toString();
        Print printAction = new Print(msg, cliOptions.common(), new Exit(ExitStatus$.MODULE$.UnexpectedError()));
        return this.execute(printAction, (Task<State>)Task$.MODULE$.now((Object)state));
    }

    private final String t() {
        return "    ";
    }

    private Dag<Project> getProjectsDag(List<Project> projects, State state) {
        return new Aggregate<Project>((List)projects.map((Function1 & Serializable & scala.Serializable)p -> state.build().getDagFor((Project)p), List$.MODULE$.canBuildFrom()));
    }

    private Task<State> runBsp(Commands.ValidatedBsp cmd, State state) {
        Task<State> qual$1 = BspServer$.MODULE$.run(cmd, state, RelativePath$.MODULE$.apply(".bloop"), (Option<Promise<BoxedUnit>>)None$.MODULE$, (Option<BehaviorSubject<State>>)None$.MODULE$, ExecutionContext$.MODULE$.scheduler(), ExecutionContext$.MODULE$.ioScheduler());
        Scheduler x$1 = ExecutionContext$.MODULE$.ioScheduler();
        boolean x$2 = qual$1.executeOn$default$2();
        return qual$1.executeOn(x$1, x$2);
    }

    public Task<State> watch(List<Project> projects, State state, Function1<State, Task<State>> f) {
        List<Project> reachable = Dag$.MODULE$.dfs(this.getProjectsDag(projects, state), Dag$PreOrder$.MODULE$);
        List projectsSourcesAndDirs = (List)reachable.map((Function1 & Serializable & scala.Serializable)project -> project.allUnmanagedSourceFilesAndDirectories().map((Function1 & Serializable & scala.Serializable)unmanaged -> {
            List generatorSourceDirs = (List)project.sourceGenerators().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> (List)x$2.sourcesGlobs().map((Function1 & Serializable & scala.Serializable)x$3 -> new AbsolutePath(x$3.directory()), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
            return new Tuple2(unmanaged, (Object)generatorSourceDirs);
        }).map((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 != null) {
                List unmanaged = (List)tuple2._1();
                List generatorSourceDirs = (List)tuple2._2();
                return (List)unmanaged.$plus$plus((GenTraversableOnce)generatorSourceDirs, List$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        }), List$.MODULE$.canBuildFrom());
        List groupTasks = projectsSourcesAndDirs.grouped(8).map((Function1 & Serializable & scala.Serializable)group -> Task$.MODULE$.gatherUnordered((Iterable)group)).toList();
        return Task$.MODULE$.sequence((Iterable)groupTasks, List$.MODULE$.canBuildFrom()).map((Function1 & Serializable & scala.Serializable)fp -> (List)((List)fp.flatten((Function1)Predef$.MODULE$.$conforms()).flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)x$5 -> ((AbsolutePath)x$5).underlying(), List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)allSources -> {
            Function1 & Serializable & scala.Serializable fg;
            SourceWatcher watcher;
            block0: {
                watcher = SourceWatcher$.MODULE$.apply((List<String>)((List)projects.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name(), List$.MODULE$.canBuildFrom())), (Seq<Path>)allSources, state.logger());
                fg = (Function1 & Serializable & scala.Serializable)state2 -> {
                    State newState = (State)State$.MODULE$.stateCache().getUpdatedStateFrom((State)state2).getOrElse((Function0 & Serializable & scala.Serializable)() -> state2);
                    return ((Task)f.apply((Object)newState)).map((Function1 & Serializable & scala.Serializable)state -> {
                        watcher.notifyWatch();
                        return State$.MODULE$.stateCache().updateBuild((State)state);
                    });
                };
                if (CrossPlatform$.MODULE$.isWindows()) break block0;
                state.logger().info("\u001b[H\u001b[2J");
            }
            return ((Task)fg.apply((Object)state)).flatMap((Function1 & Serializable & scala.Serializable)newState -> watcher.watch((State)newState, (Function1<State, Task<State>>)fg));
        });
    }

    private Task<State> runCompile(Commands.CompilingCommand cmd, State state0, List<Project> projects, boolean noColor) {
        Task<State> task;
        if (cmd.incremental()) {
            task = Task$.MODULE$.now((Object)state0);
        } else {
            List projects2 = (List)state0.build().loadedProjects().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.project(), List$.MODULE$.canBuildFrom());
            task = Tasks$.MODULE$.clean(state0, (List<Project>)projects2, true);
        }
        Task<State> state2 = task;
        Task compileTask = state2.flatMap((Function1 & Serializable & scala.Serializable)state -> {
            ReporterConfig qual$1 = ReporterKind$.MODULE$.toReporterConfig(cmd.reporter());
            boolean x$1 = !noColor;
            boolean x$2 = qual$1.copy$default$2();
            boolean x$3 = qual$1.copy$default$3();
            boolean x$4 = qual$1.copy$default$4();
            boolean x$5 = qual$1.copy$default$5();
            String x$6 = qual$1.copy$default$6();
            String x$7 = qual$1.copy$default$7();
            String x$8 = qual$1.copy$default$8();
            String x$9 = qual$1.copy$default$9();
            String x$10 = qual$1.copy$default$10();
            String x$11 = qual$1.copy$default$11();
            Function1 x$12 = qual$1.copy$default$12();
            ReporterConfig config = qual$1.copy(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12);
            Dag<Project> dag = MODULE$.getProjectsDag(projects, (State)state);
            Function1 & Serializable & scala.Serializable createReporter = (Function1 & Serializable & scala.Serializable)inputs -> new LogReporter(inputs.project(), (Logger)inputs.logger(), inputs.cwd(), config);
            return CompileTask$.MODULE$.compile((State)state, dag, createReporter, cmd.pipeline(), (Promise<BoxedUnit>)Promise$.MODULE$.apply(), CompileClientStore$NoStore$.MODULE$, state.logger());
        });
        return compileTask.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.mergeStatus(ExitStatus$.MODULE$.Ok()));
    }

    private Task<State> compile(Commands.Compile cmd, State state) {
        List<Project> projects;
        Interpreter.ProjectLookup lookup = this.lookupProjects(cmd.projects(), (Function1<String, Option<Project>>)(Function1 & Serializable & scala.Serializable)x$9 -> state.build().getProjectFor((String)x$9));
        if (lookup.missing().nonEmpty()) {
            return Task$.MODULE$.now((Object)this.reportMissing(lookup.missing(), state));
        }
        List<Project> list = projects = !cmd.cascade() ? lookup.found() : Dag$.MODULE$.inverseDependencies(state.build().dags(), lookup.found()).reduced();
        if (!cmd.watch()) {
            return this.runCompile(cmd, state, projects, cmd.cliOptions().noColor());
        }
        return this.watch(projects, state, (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)x$10 -> MODULE$.runCompile(cmd, (State)x$10, projects, cmd.cliOptions().noColor()));
    }

    private Task<State> showProjects(Commands.Projects cmd, State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            if (cmd.dotGraph()) {
                String contents = Dag$.MODULE$.toDotGraph(state.build().dags());
                state.logger().info(contents);
            } else {
                String configDirectory = AbsolutePath$.MODULE$.syntax$extension(state.build().origin());
                state.logger().debug(new StringBuilder(24).append("Projects loaded from '").append(configDirectory).append("':").toString(), (DebugFilter)DebugFilter.All$.MODULE$);
                ((List)((SeqLike)state.build().loadedProjects().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.project().name(), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    Interpreter$.$anonfun$showProjects$3(state, x$1);
                    return BoxedUnit.UNIT;
                });
            }
            return state.mergeStatus(ExitStatus$.MODULE$.Ok());
        });
    }

    private <C extends Commands.CompilingCommand> Task<State> compileAnd(C cmd, State state, List<Project> projects, boolean noColor, String nextAction, Function1<State, Task<State>> next) {
        return this.runCompile(cmd, state, projects, noColor).flatMap((Function1 & Serializable & scala.Serializable)compiled -> {
            ExitStatus exitStatus = compiled.status();
            ExitStatus exitStatus2 = ExitStatus$.MODULE$.CompilationError();
            if (exitStatus == null ? exitStatus2 != null : !((Object)exitStatus).equals(exitStatus2)) {
                return (Task)next.apply(compiled);
            }
            String projectsString = projects.mkString(", ");
            return Task$.MODULE$.now((Object)State$XState$.MODULE$.withDebug$extension(State$.MODULE$.XState((State)compiled), new StringBuilder(37).append("Failed compilation for ").append(projectsString).append(". Skipping ").append(nextAction).append("...").toString(), (DebugFilter)DebugFilter.Compilation$.MODULE$));
        });
    }

    private Task<State> console(Commands.Console cmd, State state2) {
        List<String> list = cmd.projects();
        if (Nil$.MODULE$.equals(list)) {
            return Task$.MODULE$.now((Object)State$XState$.MODULE$.withError$extension0(State$.MODULE$.XState(state2), "Missing project in `console` invocation").mergeStatus(ExitStatus$.MODULE$.InvalidCommandLineOption()));
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String project = (String)colon2.head();
            List list2 = colon2.tl$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                Option<Project> option = state2.build().getProjectFor(project);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Project project2 = (Project)some.value();
                    return this.compileAnd(cmd, state2, (List<Project>)new .colon.colon((Object)project2, (List)Nil$.MODULE$), cmd.cliOptions().noColor(), "`console`", (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> {
                        ReplKind replKind = cmd.repl();
                        if (ScalacRepl$.MODULE$.equals(replKind)) {
                            if (cmd.ammoniteVersion().isDefined()) {
                                String errMsg = "Specifying an Ammonite version while using the Scalac console does not work";
                                return Task$.MODULE$.now((Object)State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState((State)state), errMsg, ExitStatus$.MODULE$.InvalidCommandLineOption()));
                            }
                            if (cmd.args().nonEmpty()) {
                                String errMsg = "Passing arguments to the Scalac console does not work";
                                return Task$.MODULE$.now((Object)State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState((State)state), errMsg, ExitStatus$.MODULE$.InvalidCommandLineOption()));
                            }
                            return Tasks$.MODULE$.console((State)state, project2);
                        }
                        if (AmmoniteRepl$.MODULE$.equals(replKind)) {
                            Dag<Project> dag = state.build().getDagFor(project2);
                            Object scalaVersion = Interpreter$.findScalaVersion$1(dag).getOrElse((Function0 & Serializable & scala.Serializable)() -> ScalaInstance$.MODULE$.scalaInstanceForJavaProjects(state.logger()));
                            String ammVersion = (String)cmd.ammoniteVersion().getOrElse((Function0 & Serializable & scala.Serializable)() -> "latest.release");
                            .colon.colon coursierCmd = new .colon.colon((Object)"coursier", (List)new .colon.colon((Object)"launch", (List)new .colon.colon((Object)new StringBuilder(22).append("com.lihaoyi:ammonite_").append(scalaVersion).append(":").append(ammVersion).toString(), (List)new .colon.colon((Object)"--main-class", (List)new .colon.colon((Object)"ammonite.Main", (List)Nil$.MODULE$)))));
                            AbsolutePath[] classpath = project2.fullRuntimeClasspath(dag, state.client());
                            String[] coursierClasspathArgs = (String[])Predef$.MODULE$.genericArrayOps((Object)classpath).flatMap((Function1 & Serializable & scala.Serializable)elem -> Interpreter$.$anonfun$console$8(((AbsolutePath)elem).underlying()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                            String string = "--";
                            List ammArgs = cmd.args().$colon$colon((Object)string);
                            String ammoniteCmd = ((TraversableOnce)((List)coursierCmd.$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coursierClasspathArgs)), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)ammArgs, List$.MODULE$.canBuildFrom())).mkString("\n");
                            Option<Path> option = cmd.outFile();
                            if (None$.MODULE$.equals(option)) {
                                return Task$.MODULE$.now((Object)State$XState$.MODULE$.withInfo$extension(State$.MODULE$.XState((State)state), ammoniteCmd));
                            }
                            if (option instanceof Some) {
                                Task task;
                                Some some = (Some)option;
                                Path outFile = (Path)some.value();
                                try {
                                    Files.write(outFile, ammoniteCmd.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                                    String msg = new StringBuilder(26).append("Wrote Ammonite command to ").append(outFile).toString();
                                    task = Task$.MODULE$.now((Object)State$XState$.MODULE$.withDebug$extension(State$.MODULE$.XState((State)state), msg, (DebugFilter)DebugFilter.All$.MODULE$));
                                }
                                catch (IOException iOException) {
                                    String msg = new StringBuilder(50).append("Unexpected error when writing Ammonite command to ").append(outFile).toString();
                                    task = Task$.MODULE$.now((Object)State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState((State)state), msg, ExitStatus$.MODULE$.RunError()));
                                }
                                return task;
                            }
                            throw new MatchError(option);
                        }
                        throw new MatchError((Object)replKind);
                    });
                }
                if (None$.MODULE$.equals(option)) {
                    String string = project;
                    return Task$.MODULE$.now((Object)this.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state2));
                }
                throw new MatchError(option);
            }
        }
        String stringProjects = ((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(2).append("'").append((String)p).append("'").toString(), List$.MODULE$.canBuildFrom())).mkString(", ");
        return Task$.MODULE$.now((Object)State$XState$.MODULE$.withError$extension0(State$.MODULE$.XState(state2), new StringBuilder(53).append("Unexpected list of projects in `console` invocation: ").append(stringProjects).toString()).mergeStatus(ExitStatus$.MODULE$.InvalidCommandLineOption()));
    }

    private Task<State> test(Commands.Test cmd, State state) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        Interpreter.ProjectLookup lookup = this.lookupProjects(cmd.projects(), (Function1<String, Option<Project>>)(Function1 & Serializable & scala.Serializable)x$16 -> Tasks$.MODULE$.pickTestProject((String)x$16, state));
        if (lookup.missing().nonEmpty()) {
            return Task$.MODULE$.now((Object)this.reportMissing(lookup.missing(), state));
        }
        List userSelectedProjects = lookup.found();
        if (!cmd.cascade()) {
            List projectsToTest = !cmd.includeDependencies() ? userSelectedProjects : (List)userSelectedProjects.flatMap((Function1 & Serializable & scala.Serializable)p -> Dag$.MODULE$.dfs(state.build().getDagFor((Project)p), Dag$PreOrder$.MODULE$), List$.MODULE$.canBuildFrom());
            tuple22 = new Tuple2((Object)userSelectedProjects, (Object)projectsToTest);
        } else {
            Dag.InverseDependencies<Project> result = Dag$.MODULE$.inverseDependencies(state.build().dags(), userSelectedProjects);
            tuple22 = tuple2 = new Tuple2(result.reduced(), result.allCascaded());
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List projectsToCompile = (List)tuple2._1();
        List projectsToTest = (List)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)projectsToCompile, (Object)projectsToTest);
        List projectsToCompile2 = (List)tuple23._1();
        List projectsToTest2 = (List)tuple23._2();
        state.logger().debug(new StringBuilder(38).append("Preparing compilation of ").append(projectsToCompile2.mkString(", ")).append(" transitively").toString(), (DebugFilter)DebugFilter.Test$.MODULE$);
        if (!cmd.watch()) {
            return this.testAllProjects$1(state, cmd, projectsToCompile2, state, projectsToTest2);
        }
        return this.watch((List<Project>)projectsToCompile2, state, (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)x$18 -> this.testAllProjects$1((State)x$18, cmd, projectsToCompile2, state, projectsToTest2));
    }

    private Interpreter.ProjectLookup lookupProjects(List<String> names, Function1<String, Option<Project>> lookup) {
        Tuple2 result = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Nil$.MODULE$), (Object)Nil$.MODULE$);
        Tuple2 tuple2 = (Tuple2)names.foldLeft((Object)result, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                String name = (String)tuple2._2();
                if (tuple22 != null) {
                    List projects = (List)tuple22._1();
                    List missing = (List)tuple22._2();
                    Option option = (Option)lookup.apply((Object)name);
                    if (option instanceof Some) {
                        Project project;
                        Some some = (Some)option;
                        Project project2 = project = (Project)some.value();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)projects.$colon$colon((Object)project2)), (Object)missing);
                    }
                    if (None$.MODULE$.equals(option)) {
                        String string = name;
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)projects), (Object)missing.$colon$colon((Object)string));
                    }
                    throw new MatchError((Object)option);
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List found = (List)tuple2._1();
        List missing = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)found, (Object)missing);
        List found2 = (List)tuple22._1();
        List missing2 = (List)tuple22._2();
        return new Interpreter.ProjectLookup((List<Project>)found2, (List<String>)missing2);
    }

    private Task<State> autocomplete(Commands.Autocomplete cmd, State state) {
        Mode mode = cmd.mode();
        if (Mode$ProjectBoundCommands$.MODULE$.equals(mode)) {
            return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Seq commandsAcceptingProjects = (Seq)Commands$RawCommand$.MODULE$.help().messages().collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Tuple2<Seq<String>, CommandHelp>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 != null) {
                            Seq name = (Seq)A1._1();
                            CommandHelp help = (CommandHelp)A1._2();
                            if (help.args().exists((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$1(x$22)))) {
                                return (B1)name.mkString(" ");
                            }
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Tuple2<Seq<String>, CommandHelp> x1) {
                        CommandHelp help;
                        Tuple2<Seq<String>, CommandHelp> tuple2 = x1;
                        return tuple2 != null && (help = (CommandHelp)tuple2._2()).args().exists((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$isDefinedAt$1(x$22)));
                    }

                    public static final /* synthetic */ boolean $anonfun$applyOrElse$1(Arg x$22) {
                        String string = x$22.name().name();
                        String string2 = "projects";
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }

                    public static final /* synthetic */ boolean $anonfun$isDefinedAt$1(Arg x$22) {
                        String string = x$22.name().name();
                        String string2 = "projects";
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(caseapp.core.Arg ), $anonfun$isDefinedAt$1$adapted(caseapp.core.Arg )}, serializedLambda);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                return State$XState$.MODULE$.withInfo$extension(State$.MODULE$.XState(state), commandsAcceptingProjects.mkString(" "));
            });
        }
        if (Mode$Commands$.MODULE$.equals(mode)) {
            return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Commands$RawCommand$.MODULE$.help().messages().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Interpreter$.$anonfun$autocomplete$3(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$23 -> {
                    Interpreter$.$anonfun$autocomplete$4(cmd, state, x$23);
                    return BoxedUnit.UNIT;
                });
                return state;
            });
        }
        if (Mode$Projects$.MODULE$.equals(mode)) {
            return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                ((List)state.build().loadedProjects().map((Function1 & Serializable & scala.Serializable)loadedProject -> {
                    Project project = loadedProject.project();
                    return new Tuple2(loadedProject, (Object)project);
                }, List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$24 -> {
                    Interpreter$.$anonfun$autocomplete$8(cmd, state, x$24);
                    return BoxedUnit.UNIT;
                });
                return state;
            });
        }
        if (Mode$Flags$.MODULE$.equals(mode)) {
            return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                cmd.command().foreach((Function1 & Serializable & scala.Serializable)command -> {
                    Interpreter$.$anonfun$autocomplete$11(cmd, state, command);
                    return BoxedUnit.UNIT;
                });
                return state;
            });
        }
        if (Mode$Reporters$.MODULE$.equals(mode)) {
            return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                ReporterKind$.MODULE$.reporters().foreach((Function1 & Serializable & scala.Serializable)reporter -> {
                    Interpreter$.$anonfun$autocomplete$16(cmd, state, reporter);
                    return BoxedUnit.UNIT;
                });
                return state;
            });
        }
        if (Mode$Protocols$.MODULE$.equals(mode)) {
            return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                BspProtocol$.MODULE$.protocols().foreach((Function1 & Serializable & scala.Serializable)protocol -> {
                    Interpreter$.$anonfun$autocomplete$19(cmd, state, protocol);
                    return BoxedUnit.UNIT;
                });
                return state;
            });
        }
        if (Mode$MainsFQCN$.MODULE$.equals(mode)) {
            return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                cmd.project().map((Function1 & Serializable & scala.Serializable)projectName -> {
                    NoopLogger$ x$1 = NoopLogger$.MODULE$;
                    Build x$2 = state.copy$default$1();
                    ResultsCache x$3 = state.copy$default$2();
                    CompilerCache x$4 = state.copy$default$3();
                    SourceGeneratorCache x$5 = state.copy$default$4();
                    ClientInfo x$6 = state.copy$default$5();
                    ClientPool x$7 = state.copy$default$6();
                    CommonOptions x$8 = state.copy$default$7();
                    ExitStatus x$9 = state.copy$default$8();
                    State stateWithNoopLogger = state.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$1);
                    return new Tuple2(projectName, (Object)stateWithNoopLogger);
                }).foreach((Function1 & Serializable & scala.Serializable)x$25 -> {
                    Interpreter$.$anonfun$autocomplete$23(state, cmd, x$25);
                    return BoxedUnit.UNIT;
                });
                return state;
            });
        }
        if (Mode$TestsFQCN$.MODULE$.equals(mode)) {
            Option printTestTask = cmd.project().map((Function1 & Serializable & scala.Serializable)projectName -> {
                NoopLogger$ x$10 = NoopLogger$.MODULE$;
                Build x$11 = state.copy$default$1();
                ResultsCache x$12 = state.copy$default$2();
                CompilerCache x$13 = state.copy$default$3();
                SourceGeneratorCache x$14 = state.copy$default$4();
                ClientInfo x$15 = state.copy$default$5();
                ClientPool x$16 = state.copy$default$6();
                CommonOptions x$17 = state.copy$default$7();
                ExitStatus x$18 = state.copy$default$8();
                State stateWithNoopLogger = state.copy(x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$10);
                return new Tuple2(projectName, (Object)stateWithNoopLogger);
            }).flatMap((Function1 & Serializable & scala.Serializable)x$26 -> {
                Tuple2 tuple2 = x$26;
                if (tuple2 != null) {
                    String projectName = (String)tuple2._1();
                    State stateWithNoopLogger = (State)tuple2._2();
                    return Tasks$.MODULE$.pickTestProject(projectName, stateWithNoopLogger).map((Function1 & Serializable & scala.Serializable)project -> TestTask$.MODULE$.findTestNamesWithFramework((Project)project, stateWithNoopLogger).map((Function1 & Serializable & scala.Serializable)discovered -> {
                        discovered.foreach((Function1 & Serializable & scala.Serializable)classesWithFramework -> {
                            Interpreter$.$anonfun$autocomplete$31(cmd, state, classesWithFramework);
                            return BoxedUnit.UNIT;
                        });
                        return state;
                    }));
                }
                throw new MatchError((Object)tuple2);
            });
            return (Task)printTestTask.getOrElse((Function0 & Serializable & scala.Serializable)() -> Task$.MODULE$.now((Object)state));
        }
        throw new MatchError((Object)mode);
    }

    private Task<State> configure(Commands.Configure cmd, State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            if (cmd.threads() == 0) {
                return state;
            }
            return State$XState$.MODULE$.withWarn$extension(State$.MODULE$.XState(state), "Dynamic thread configuration has been deprecated and is a no-op.");
        });
    }

    private Task<State> clean(Commands.Clean cmd, State state) {
        if (cmd.projects().isEmpty()) {
            List projects = (List)state.build().loadedProjects().map((Function1 & Serializable & scala.Serializable)x$27 -> x$27.project(), List$.MODULE$.canBuildFrom());
            return Tasks$.MODULE$.clean(state, (List<Project>)projects, cmd.includeDependencies()).map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.mergeStatus(ExitStatus$.MODULE$.Ok()));
        }
        Interpreter.ProjectLookup lookup = this.lookupProjects(cmd.projects(), (Function1<String, Option<Project>>)(Function1 & Serializable & scala.Serializable)x$29 -> state.build().getProjectFor((String)x$29));
        if (!lookup.missing().isEmpty()) {
            return Task$.MODULE$.now((Object)this.reportMissing(lookup.missing(), state));
        }
        return Tasks$.MODULE$.clean(state, lookup.found(), cmd.includeDependencies()).map((Function1 & Serializable & scala.Serializable)x$30 -> x$30.mergeStatus(ExitStatus$.MODULE$.Ok()));
    }

    public Task<State> link(Commands.Link cmd, State state2) {
        Interpreter.ProjectLookup lookup = this.lookupProjects(cmd.projects(), (Function1<String, Option<Project>>)(Function1 & Serializable & scala.Serializable)x$31 -> state2.build().getProjectFor((String)x$31));
        if (lookup.missing().nonEmpty()) {
            return Task$.MODULE$.now((Object)this.reportMissing(lookup.missing(), state2));
        }
        List<Project> projects = lookup.found();
        if (cmd.watch()) {
            return this.watch(projects, state2, (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> this.linkTask$1((State)state, (List)projects, cmd));
        }
        return this.linkTask$1(state2, projects, cmd);
    }

    private Task<State> run(Commands.Run cmd, State state2) {
        Interpreter.ProjectLookup lookup = this.lookupProjects(cmd.projects(), (Function1<String, Option<Project>>)(Function1 & Serializable & scala.Serializable)x$36 -> state2.build().getProjectFor((String)x$36));
        if (lookup.missing().nonEmpty()) {
            return Task$.MODULE$.now((Object)this.reportMissing(lookup.missing(), state2));
        }
        List<Project> projects = lookup.found();
        if (cmd.watch()) {
            return this.watch(projects, state2, (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> this.runTask$1((State)state, (List)projects, cmd));
        }
        return this.runTask$1(state2, projects, cmd);
    }

    private State reportMissing(List<String> projectNames, State state) {
        String projects = projectNames.mkString("'", "', '", "'");
        String configDirectory = AbsolutePath$.MODULE$.syntax$extension(state.build().origin());
        return State$XState$.MODULE$.withError$extension0(State$.MODULE$.XState(State$XState$.MODULE$.withError$extension0(State$.MODULE$.XState(state), new StringBuilder(35).append("No projects named ").append(projects).append(" were found in '").append(configDirectory).append("'").toString())), "Use the `projects` command to list all existing projects").mergeStatus(ExitStatus$.MODULE$.InvalidCommandLineOption());
    }

    public Either<State, String> getMainClass(State state, Project project, Option<String> cliMainClass) {
        Option<String> option = cliMainClass;
        if (option instanceof Some) {
            Some some = (Some)option;
            String userMainClass = (String)some.value();
            return package$.MODULE$.Right().apply((Object)userMainClass);
        }
        if (None$.MODULE$.equals(option)) {
            Option<String> option2 = project.platform().userMainClass();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String configMainClass = (String)some.value();
                return package$.MODULE$.Right().apply((Object)configMainClass);
            }
            if (None$.MODULE$.equals(option2)) {
                List<String> list = Tasks$.MODULE$.findMainClasses(state, project);
                if (Nil$.MODULE$.equals(list)) {
                    String msg = Feedback$.MODULE$.missingMainClass(project);
                    return package$.MODULE$.Left().apply((Object)State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState(state), msg, ExitStatus$.MODULE$.InvalidCommandLineOption()));
                }
                Some some = List$.MODULE$.unapplySeq(list);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0) {
                    String mainClass = (String)((LinearSeqOptimized)some.get()).apply(0);
                    return package$.MODULE$.Right().apply((Object)mainClass);
                }
                String msg = Feedback$.MODULE$.XMessageString(Feedback$.MODULE$.expectedDefaultMainClass(project)).suggest(Feedback$.MODULE$.listMainClasses(list));
                return package$.MODULE$.Left().apply((Object)State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState(state), msg, ExitStatus$.MODULE$.InvalidCommandLineOption()));
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$execute$2(State state$1, String x$1) {
        state$1.logger().error(x$1);
    }

    private static final Task execute$1(Action action, Task stateTask) {
        return stateTask.flatMap((Function1 & Serializable & scala.Serializable)state2 -> {
            Commands.Command cmd;
            Commands.Command cmd2;
            ExitStatus exitStatus;
            boolean bl = false;
            Exit exit = null;
            boolean bl2 = false;
            Run run2 = null;
            Action action = action;
            if (action instanceof Exit) {
                ExitStatus exitStatus2;
                bl = true;
                exit = (Exit)action;
                ExitStatus exitStatus3 = exit.exitStatus();
                if (exitStatus3 != null && (exitStatus2 = exitStatus3).isOk()) {
                    return Task$.MODULE$.now((Object)state2.mergeStatus(exitStatus2));
                }
            }
            if (bl && (exitStatus = exit.exitStatus()) != null) {
                ExitStatus exitStatus4 = exitStatus;
                return Task$.MODULE$.now((Object)state2.mergeStatus(exitStatus4));
            }
            if (action instanceof Print) {
                Print print = (Print)action;
                String msg = print.msg();
                Action next = print.next();
                state2.logger().info(msg);
                return Interpreter$.execute$1(next, Task$.MODULE$.now(state2));
            }
            if (action instanceof Run) {
                bl2 = true;
                run2 = (Run)action;
                Commands.Command cmd3 = run2.command();
                if (cmd3 instanceof Commands.Bsp) {
                    Commands.Bsp bsp = (Commands.Bsp)cmd3;
                    String msg = "Internal error: The `bsp` command must be validated before use";
                    Print printAction = new Print(msg, bsp.cliOptions().common(), new Exit(ExitStatus$.MODULE$.UnexpectedError()));
                    return Interpreter$.execute$1(printAction, Task$.MODULE$.now(state2));
                }
            }
            if (bl2) {
                Commands.Command cmd4 = run2.command();
                Action next = run2.next();
                if (cmd4 instanceof Commands.ValidatedBsp) {
                    Commands.ValidatedBsp validatedBsp = (Commands.ValidatedBsp)cmd4;
                    return Interpreter$.execute$1(next, MODULE$.runBsp(validatedBsp, (State)state2));
                }
            }
            if (bl2 && (cmd2 = run2.command()) instanceof Commands.About) {
                Commands.About about = (Commands.About)cmd2;
                return MODULE$.notHandled("about", about.cliOptions(), (State)state2);
            }
            if (bl2 && (cmd = run2.command()) instanceof Commands.Help) {
                Commands.Help help = (Commands.Help)cmd;
                return MODULE$.notHandled("help", help.cliOptions(), (State)state2);
            }
            if (bl2) {
                Commands.Command cmd5 = run2.command();
                Action next = run2.next();
                if (cmd5 != null) {
                    Commands.Command command = cmd5;
                    return Validate$.MODULE$.validateBuildForCLICommands((State)state2, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
                        Interpreter$.$anonfun$execute$2(state2, x$1);
                        return BoxedUnit.UNIT;
                    }).flatMap((Function1 & Serializable & scala.Serializable)state -> {
                        ExitStatus exitStatus = state.status();
                        ExitStatus exitStatus2 = ExitStatus$.MODULE$.BuildDefinitionError();
                        if (!(exitStatus != null ? !((Object)exitStatus).equals(exitStatus2) : exitStatus2 != null)) {
                            return Task$.MODULE$.now(state);
                        }
                        Commands.Command command = command;
                        if (command instanceof Commands.Clean) {
                            Commands.Clean clean = (Commands.Clean)command;
                            return Interpreter$.execute$1(next, MODULE$.clean(clean, (State)state));
                        }
                        if (command instanceof Commands.Compile) {
                            Commands.Compile compile = (Commands.Compile)command;
                            return Interpreter$.execute$1(next, MODULE$.compile(compile, (State)state));
                        }
                        if (command instanceof Commands.Console) {
                            Commands.Console console = (Commands.Console)command;
                            return Interpreter$.execute$1(next, MODULE$.console(console, (State)state));
                        }
                        if (command instanceof Commands.Projects) {
                            Commands.Projects projects = (Commands.Projects)command;
                            return Interpreter$.execute$1(next, MODULE$.showProjects(projects, (State)state));
                        }
                        if (command instanceof Commands.Test) {
                            Commands.Test test = (Commands.Test)command;
                            return Interpreter$.execute$1(next, MODULE$.test(test, (State)state));
                        }
                        if (command instanceof Commands.Run) {
                            Commands.Run run2 = (Commands.Run)command;
                            return Interpreter$.execute$1(next, MODULE$.run(run2, (State)state));
                        }
                        if (command instanceof Commands.Configure) {
                            Commands.Configure configure = (Commands.Configure)command;
                            return Interpreter$.execute$1(next, MODULE$.configure(configure, (State)state));
                        }
                        if (command instanceof Commands.Autocomplete) {
                            Commands.Autocomplete autocomplete = (Commands.Autocomplete)command;
                            return Interpreter$.execute$1(next, MODULE$.autocomplete(autocomplete, (State)state));
                        }
                        if (command instanceof Commands.Link) {
                            Commands.Link link = (Commands.Link)command;
                            return Interpreter$.execute$1(next, MODULE$.link(link, (State)state));
                        }
                        throw new MatchError((Object)command);
                    });
                }
            }
            throw new MatchError((Object)action);
        });
    }

    public static final /* synthetic */ void $anonfun$showProjects$3(State state$6, String x$1) {
        state$6.logger().info(x$1);
    }

    private static final Option findScalaVersion$1(Dag dag2) {
        Dag dag3 = dag2;
        if (dag3 instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)dag3;
            List dags = aggregate.dags();
            return ((TraversableLike)dags.flatMap((Function1 & Serializable & scala.Serializable)dag -> Option$.MODULE$.option2Iterable(Interpreter$.findScalaVersion$1(dag)), List$.MODULE$.canBuildFrom())).headOption();
        }
        if (dag3 instanceof Leaf) {
            Leaf leaf = (Leaf)dag3;
            Project value = (Project)leaf.value();
            return value.scalaInstance().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.version());
        }
        if (dag3 instanceof Parent) {
            Parent parent = (Parent)dag3;
            Project value = (Project)parent.value();
            List children = parent.children();
            List list = (List)children.flatMap((Function1 & Serializable & scala.Serializable)dag -> Option$.MODULE$.option2Iterable(Interpreter$.findScalaVersion$1(dag)), List$.MODULE$.canBuildFrom());
            if (Nil$.MODULE$.equals(list)) {
                return value.scalaInstance().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.version());
            }
            return new Some(list.head());
        }
        throw new MatchError((Object)dag3);
    }

    public static final /* synthetic */ Seq $anonfun$console$8(Path elem) {
        return (Seq)new .colon.colon((Object)"--extra-jars", (List)new .colon.colon((Object)AbsolutePath$.MODULE$.syntax$extension(elem), (List)Nil$.MODULE$));
    }

    private final Task testAllProjects$1(State state2, Commands.Test cmd$5, List projectsToCompile$1, State state$8, List projectsToTest$1) {
        Function1<String, Object> testFilter = TestInternals$.MODULE$.parseFilters(cmd$5.only());
        return this.compileAnd(cmd$5, state2, (List<Project>)projectsToCompile$1, cmd$5.cliOptions().noColor(), "`test`", (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> {
            state$8.logger().debug(new StringBuilder(29).append("Preparing test execution for ").append(projectsToTest$1.mkString(", ")).toString(), (DebugFilter)DebugFilter.Test$.MODULE$);
            LoggingEventHandler handler = new LoggingEventHandler(state.logger());
            return Tasks$.MODULE$.test((State)state, (List<Project>)projectsToTest$1, cmd$5.args(), testFilter, new ScalaTestSuites((List)Nil$.MODULE$, (List)Nil$.MODULE$, (List)Nil$.MODULE$), handler, cmd$5.parallel(), RunMode$Normal$.MODULE$).map((Function1 & Serializable & scala.Serializable)testRuns -> state.mergeStatus(testRuns.status()));
        });
    }

    public static final /* synthetic */ boolean $anonfun$autocomplete$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$autocomplete$5(State state$10, String completion) {
        state$10.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$4(Commands.Autocomplete cmd$6, State state$10, Tuple2 x$23) {
        Tuple2 tuple2 = x$23;
        if (tuple2 != null) {
            Seq name = (Seq)tuple2._1();
            CommandHelp args = (CommandHelp)tuple2._2();
            cmd$6.format().showCommand(name.mkString(" "), args).foreach((Function1 & Serializable & scala.Serializable)completion -> {
                Interpreter$.$anonfun$autocomplete$5(state$10, completion);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$9(State state$10, String completion) {
        state$10.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$8(Commands.Autocomplete cmd$6, State state$10, Tuple2 x$24) {
        Tuple2 tuple2 = x$24;
        if (tuple2 != null) {
            Project project = (Project)tuple2._2();
            cmd$6.format().showProject(project).foreach((Function1 & Serializable & scala.Serializable)completion -> {
                Interpreter$.$anonfun$autocomplete$9(state$10, completion);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$14(State state$10, String completion) {
        state$10.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$13(Commands.Autocomplete cmd$6, String command$1, State state$10, Arg arg) {
        cmd$6.format().showArg(command$1, Case$.MODULE$.kebabizeArg(arg)).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$14(state$10, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$12(Commands.Autocomplete cmd$6, String command$1, State state$10, CommandHelp message) {
        message.args().foreach((Function1 & Serializable & scala.Serializable)arg -> {
            Interpreter$.$anonfun$autocomplete$13(cmd$6, command$1, state$10, arg);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$11(Commands.Autocomplete cmd$6, State state$10, String command) {
        Commands$RawCommand$.MODULE$.help().messages().toMap(Predef$.MODULE$.$conforms()).get((Object)new .colon.colon((Object)command, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)message -> {
            Interpreter$.$anonfun$autocomplete$12(cmd$6, command, state$10, message);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$17(State state$10, String completion) {
        state$10.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$16(Commands.Autocomplete cmd$6, State state$10, ReporterKind reporter) {
        cmd$6.format().showReporter(reporter).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$17(state$10, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$20(State state$10, String completion) {
        state$10.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$19(Commands.Autocomplete cmd$6, State state$10, BspProtocol protocol) {
        cmd$6.format().showProtocol(protocol).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$20(state$10, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$26(State state$10, String completion) {
        state$10.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$25(Commands.Autocomplete cmd$6, State state$10, String main) {
        cmd$6.format().showMainName(main).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$26(state$10, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$24(State stateWithNoopLogger$1, Commands.Autocomplete cmd$6, State state$10, Project project) {
        Tasks$.MODULE$.findMainClasses(stateWithNoopLogger$1, project).foreach((Function1 & Serializable & scala.Serializable)main -> {
            Interpreter$.$anonfun$autocomplete$25(cmd$6, state$10, main);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$23(State state$10, Commands.Autocomplete cmd$6, Tuple2 x$25) {
        Tuple2 tuple2 = x$25;
        if (tuple2 != null) {
            String projectName = (String)tuple2._1();
            State stateWithNoopLogger = (State)tuple2._2();
            state$10.build().getProjectFor(projectName).foreach((Function1 & Serializable & scala.Serializable)project -> {
                Interpreter$.$anonfun$autocomplete$24(stateWithNoopLogger, cmd$6, state$10, project);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$33(State state$10, String completion) {
        state$10.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$32(Commands.Autocomplete cmd$6, State state$10, String testFqcn) {
        cmd$6.format().showTestName(testFqcn).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$33(state$10, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$31(Commands.Autocomplete cmd$6, State state$10, TestFrameworkWithClasses classesWithFramework) {
        classesWithFramework.classes().foreach((Function1 & Serializable & scala.Serializable)testFqcn -> {
            Interpreter$.$anonfun$autocomplete$32(cmd$6, state$10, testFqcn);
            return BoxedUnit.UNIT;
        });
    }

    private final Task doLink$1(Project project, State state2, Commands.Link cmd$8) {
        return this.compileAnd(cmd$8, state2, (List<Project>)new .colon.colon((Object)project, (List)Nil$.MODULE$), cmd$8.cliOptions().noColor(), "`link`", (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> {
            Either<State, String> either = MODULE$.getMainClass((State)state, project, cmd$8.main());
            if (either instanceof Left) {
                Left left = (Left)either;
                State state2 = (State)left.value();
                return Task$.MODULE$.now((Object)state2);
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                String mainClass = (String)right.value();
                Platform platform = project.platform();
                if (platform instanceof Platform.Native) {
                    Platform.Native native_ = (Platform.Native)platform;
                    Config.NativeConfig config = native_.config();
                    Path target = ScalaNativeToolchain$.MODULE$.linkTargetFrom(project, config);
                    return LinkTask$.MODULE$.linkMainWithNative(cmd$8, project, (State)state, mainClass, target, native_);
                }
                if (platform instanceof Platform.Js) {
                    Platform.Js js = (Platform.Js)platform;
                    Config.JsConfig config = js.config();
                    Path target = ScalaJsToolchain$.MODULE$.linkTargetFrom(project, config);
                    return LinkTask$.MODULE$.linkMainWithJs(cmd$8, project, (State)state, mainClass, target, js);
                }
                if (platform instanceof Platform.Jvm) {
                    String msg = Feedback$.MODULE$.noLinkFor(project);
                    return Task$.MODULE$.now((Object)State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState((State)state), msg, ExitStatus$.MODULE$.InvalidCommandLineOption()));
                }
                throw new MatchError((Object)platform);
            }
            throw new MatchError(either);
        });
    }

    private final Task linkTask$1(State state, List projects$5, Commands.Link cmd$8) {
        return (Task)projects$5.foldLeft((Object)Task$.MODULE$.now((Object)state), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Task stateTask = (Task)tuple2._1();
                Project p = (Project)tuple2._2();
                return stateTask.flatMap((Function1 & Serializable & scala.Serializable)x$32 -> this.doLink$1(p, (State)x$32, cmd$8));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final Task doRun$1(Project project, State state, Commands.Run cmd$9) {
        Path cwd = project.workingDirectory();
        return this.compileAnd(cmd$9, state, (List<Project>)new .colon.colon((Object)project, (List)Nil$.MODULE$), cmd$9.cliOptions().noColor(), "`run`", (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state2 -> {
            Either<State, String> either = MODULE$.getMainClass((State)state2, project, cmd$9.main());
            if (either instanceof Left) {
                Left left = (Left)either;
                State failedState = (State)left.value();
                return Task$.MODULE$.now((Object)failedState);
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                String mainClass = (String)right.value();
                Platform platform = project.platform();
                if (platform instanceof Platform.Native) {
                    Platform.Native native_ = (Platform.Native)platform;
                    Config.NativeConfig config = native_.config();
                    Path target = ScalaNativeToolchain$.MODULE$.linkTargetFrom(project, config);
                    return LinkTask$.MODULE$.linkMainWithNative(cmd$9, project, (State)state2, mainClass, target, native_).flatMap((Function1 & Serializable & scala.Serializable)state -> {
                        String string = AbsolutePath$.MODULE$.syntax$extension(target);
                        String[] args = (String[])((TraversableOnce)cmd$9.args().$plus$colon((Object)string, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                        if (!state.status().isOk()) {
                            return Task$.MODULE$.now(state);
                        }
                        return Tasks$.MODULE$.runNativeOrJs((State)state, cwd, args);
                    });
                }
                if (platform instanceof Platform.Js) {
                    Platform.Js js = (Platform.Js)platform;
                    Config.JsConfig config = js.config();
                    Path target = ScalaJsToolchain$.MODULE$.linkTargetFrom(project, config);
                    return LinkTask$.MODULE$.linkMainWithJs(cmd$9, project, (State)state2, mainClass, target, js).flatMap((Function1 & Serializable & scala.Serializable)state -> {
                        String string = "node";
                        String string2 = AbsolutePath$.MODULE$.syntax$extension(target);
                        String[] args = (String[])((TraversableOnce)((List)cmd$9.args().$plus$colon((Object)string2, List$.MODULE$.canBuildFrom())).$plus$colon((Object)string, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                        if (!state.status().isOk()) {
                            return Task$.MODULE$.now(state);
                        }
                        return Tasks$.MODULE$.runNativeOrJs((State)state, cwd, args);
                    });
                }
                if (platform instanceof Platform.Jvm) {
                    Platform.Jvm jvm = (Platform.Jvm)platform;
                    JdkConfig javaEnv = (JdkConfig)project.runtimeJdkConfig().getOrElse((Function0 & Serializable & scala.Serializable)() -> jvm.config());
                    return Tasks$.MODULE$.runJVM((State)state2, project, javaEnv, cwd, mainClass, (String[])cmd$9.args().toArray(ClassTag$.MODULE$.apply(String.class)), cmd$9.skipJargs(), (List<String>)Nil$.MODULE$, (RunMode)RunMode$Normal$.MODULE$);
                }
                throw new MatchError((Object)platform);
            }
            throw new MatchError(either);
        });
    }

    private final Task runTask$1(State state, List projects$6, Commands.Run cmd$9) {
        return (Task)projects$6.foldLeft((Object)Task$.MODULE$.now((Object)state), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Task stateTask = (Task)tuple2._1();
                Project p = (Project)tuple2._2();
                return stateTask.flatMap((Function1 & Serializable & scala.Serializable)x$37 -> this.doRun$1(p, (State)x$37, cmd$9));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Interpreter$() {
        MODULE$ = this;
    }
}

