/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine.tasks;

import bloop.Compiler;
import bloop.cli.CommonOptions;
import bloop.cli.ExitStatus$;
import bloop.config.Config;
import bloop.data.JdkConfig;
import bloop.data.Platform;
import bloop.data.Project;
import bloop.engine.Dag;
import bloop.engine.Feedback$;
import bloop.engine.State;
import bloop.engine.caches.LastSuccessfulResult;
import bloop.engine.tasks.RunMode;
import bloop.engine.tasks.RunMode$Normal$;
import bloop.engine.tasks.TestFrameworkWithClasses;
import bloop.engine.tasks.TestTask;
import bloop.engine.tasks.toolchains.ScalaJsToolchain;
import bloop.engine.tasks.toolchains.ScalaJsToolchain$;
import bloop.exec.JvmProcessForker;
import bloop.exec.JvmProcessForker$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import bloop.task.Task;
import bloop.task.Task$;
import bloop.testing.DiscoveredTestFrameworks;
import bloop.testing.FingerprintInfo;
import bloop.testing.LoggingEventHandler;
import bloop.testing.TestInternals$;
import bloop.util.JavaCompat$;
import ch.epfl.scala.bsp.ScalaTestSuites;
import java.io.Serializable;
import java.nio.file.Path;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBoolean$;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.Analysis$;
import sbt.testing.AnnotatedFingerprint;
import sbt.testing.Framework;
import sbt.testing.Selector;
import sbt.testing.SubclassFingerprint;
import sbt.testing.SuiteSelector;
import sbt.testing.TaskDef;
import sbt.testing.TestSelector;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;
import xsbt.api.Discovered;
import xsbt.api.Discovery$;
import xsbti.api.ClassLike;
import xsbti.api.Definition;
import xsbti.compile.CompileAnalysis;

public final class TestTask$ {
    public static TestTask$ MODULE$;
    private final DebugFilter logContext;

    static {
        new TestTask$();
    }

    private DebugFilter logContext() {
        return this.logContext;
    }

    public boolean isTestProject(Project project) {
        return project.tags().contains((Object)"test") || project.tags().contains((Object)"integration-test");
    }

    public Task<Object> runTestSuites(State state, Project project, Path cwd, List<String> rawTestOptions, Function1<String, Object> testFilter, ScalaTestSuites testClasses, LoggingEventHandler handler, RunMode mode) {
        CompileAnalysis compileAnalysis;
        boolean isTest = this.isTestProject(project);
        Compiler.Result lastCompilerResult = state.results().latestResult(project);
        LastSuccessfulResult lastSuccessful = state.results().lastSuccessfulResultOrEmpty(project);
        CompileAnalysis compileAnalysis2 = compileAnalysis = (CompileAnalysis)JavaCompat$.MODULE$.EnrichOptional(lastSuccessful.previous().analysis()).toOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> Analysis$.MODULE$.Empty());
        Analysis analysis = Analysis$.MODULE$.Empty();
        if (!(compileAnalysis2 != null ? !compileAnalysis2.equals(analysis) : analysis != null)) {
            Compiler.Result result = lastCompilerResult;
            Compiler.Result$.Empty$ empty$ = Compiler.Result$.Empty$.MODULE$;
            if (!(result != null ? !result.equals(empty$) : empty$ != null)) {
                state.logger().warn(new StringBuilder(51).append("Skipping test for ").append(project.name()).append(" because compiler result is empty").toString());
                return Task$.MODULE$.now((Object)BoxesRunTime.boxToInteger((int)0));
            }
            if (isTest) {
                state.logger().error(new StringBuilder(28).append("Missing compilation to test ").append(project.name()).toString());
                return Task$.MODULE$.now((Object)BoxesRunTime.boxToInteger((int)1));
            }
            state.logger().warn(new StringBuilder(28).append("Missing compilation to test ").append(project.name()).toString());
            return Task$.MODULE$.now((Object)BoxesRunTime.boxToInteger((int)0));
        }
        return this.discoverTestFrameworks(project, state, mode).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            Some some = null;
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                return TestTask$.handleEmptyTestFrameworks$1(isTest, state, project);
            }
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                DiscoveredTestFrameworks found = (DiscoveredTestFrameworks)some.value();
                if (found.frameworks().isEmpty()) {
                    return TestTask$.handleEmptyTestFrameworks$1(isTest, state, project);
                }
            }
            if (bl) {
                DiscoveredTestFrameworks found = (DiscoveredTestFrameworks)some.value();
                List<Framework> configuredFrameworks = found.frameworks();
                state.logger().debug(new StringBuilder(23).append("Found test frameworks: ").append(((TraversableOnce)configuredFrameworks.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), List$.MODULE$.canBuildFrom())).mkString(", ")).toString(), MODULE$.logContext());
                scala.collection.immutable.Map<Framework, List<TaskDef>> suites = MODULE$.discoverTestSuites(state, project, configuredFrameworks, compileAnalysis, testFilter, testClasses);
                List discoveredFrameworks = suites.iterator().filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TestTask$.$anonfun$runTestSuites$4(x$2))).map((Function1 & Serializable & scala.Serializable)x$3 -> (Framework)x$3._1()).toList();
                Tuple2 tuple2 = rawTestOptions.partition((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.startsWith("-J")));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                List userJvmOptions = (List)tuple2._1();
                List userTestOptions = (List)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)userJvmOptions, (Object)userTestOptions);
                List userJvmOptions2 = (List)tuple22._1();
                List userTestOptions2 = (List)tuple22._2();
                List jvmOptions = (List)((List)userJvmOptions2.map((Function1 & Serializable & scala.Serializable)x$6 -> new StringOps(Predef$.MODULE$.augmentString(x$6)).stripPrefix("-J"), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)testClasses.jvmOptions(), List$.MODULE$.canBuildFrom());
                List envOptions = testClasses.environmentVariables();
                List<Config.TestArgument> frameworkArgs = MODULE$.considerFrameworkArgs((List<Framework>)discoveredFrameworks, (List<String>)userTestOptions2, state.logger());
                List args = (List)project.testOptions().arguments().$plus$plus(frameworkArgs, List$.MODULE$.canBuildFrom());
                state.logger().debug(new StringBuilder(36).append("Running test suites with arguments: ").append(args).toString(), MODULE$.logContext());
                state.logger().debug(new StringBuilder(32).append("Running ForkMain with jvm opts: ").append(jvmOptions).toString(), MODULE$.logContext());
                state.logger().debug(new StringBuilder(37).append("Running ForkMain with env variables: ").append(envOptions).toString(), MODULE$.logContext());
                DiscoveredTestFrameworks discoveredTestFrameworks = found;
                if (discoveredTestFrameworks instanceof DiscoveredTestFrameworks.Jvm) {
                    DiscoveredTestFrameworks.Jvm jvm = (DiscoveredTestFrameworks.Jvm)discoveredTestFrameworks;
                    JvmProcessForker forker = jvm.forker();
                    ClassLoader loader = jvm.testLoader();
                    CommonOptions opts = state.commonOptions();
                    return TestInternals$.MODULE$.execute(cwd, forker, loader, suites, (List<Config.TestArgument>)args, (List<String>)jvmOptions, (List<String>)envOptions, handler, state.logger(), opts);
                }
                if (discoveredTestFrameworks instanceof DiscoveredTestFrameworks.Js) {
                    DiscoveredTestFrameworks.Js js = (DiscoveredTestFrameworks.Js)discoveredTestFrameworks;
                    Function0<BoxedUnit> closeResources = js.closeResources();
                    AtomicBoolean cancelled = AtomicBoolean$.MODULE$.apply(false);
                    JFunction0.mcZ.sp & Serializable & scala.Serializable checkCancelled = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> cancelled.get();
                    return TestInternals$.MODULE$.runJsTestsInProcess(suites, (List<Config.TestArgument>)args, handler, (Function0<Object>)checkCancelled, state.logger()).materialize().doOnCancel((Function0 & Serializable & scala.Serializable)() -> Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> TestTask$.cancel$1(cancelled, closeResources))).map(arg_0 -> TestTask$.$anonfun$runTestSuites$11(closeResources, (Function0)checkCancelled, state, arg_0)).dematerialize(Predef$.MODULE$.$conforms());
                }
                throw new MatchError((Object)discoveredTestFrameworks);
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Option<DiscoveredTestFrameworks>> discoverTestFrameworks(Project project, State state, RunMode mode) {
        DebugFilter.Test$ logContext = DebugFilter.Test$.MODULE$;
        Platform platform = project.platform();
        if (platform instanceof Platform.Jvm) {
            Platform.Jvm jvm = (Platform.Jvm)platform;
            JdkConfig compileConfig = jvm.config();
            Option<JdkConfig> runtimeConfig = jvm.runtimeConfig();
            JdkConfig env = (JdkConfig)runtimeConfig.getOrElse((Function0 & Serializable & scala.Serializable)() -> compileConfig);
            Dag<Project> dag = state.build().getDagFor(project);
            AbsolutePath[] classpath = project.fullRuntimeClasspath(dag, state.client());
            JvmProcessForker forker = JvmProcessForker$.MODULE$.apply(env, classpath, mode);
            ClassLoader testLoader = forker.newClassLoader((Option<ClassLoader>)new Some((Object)TestInternals$.MODULE$.filteredLoader()));
            List frameworks = (List)project.testFrameworks().flatMap((Function1 & Serializable & scala.Serializable)f -> Option$.MODULE$.option2Iterable(TestInternals$.MODULE$.loadFramework(testLoader, (List<String>)f.names(), state.logger())), List$.MODULE$.canBuildFrom());
            return Task$.MODULE$.now((Object)new Some((Object)new DiscoveredTestFrameworks.Jvm((List<Framework>)frameworks, forker, testLoader)));
        }
        if (platform instanceof Platform.Js) {
            Platform.Js js = (Platform.Js)platform;
            Config.JsConfig config = js.config();
            Option<ScalaJsToolchain> toolchain = js.toolchain();
            Option<String> userMainClass = js.userMainClass();
            Path target = ScalaJsToolchain$.MODULE$.linkTargetFrom(project, config);
            Option<ScalaJsToolchain> option = toolchain;
            if (option instanceof Some) {
                Some some = (Some)option;
                ScalaJsToolchain toolchain2 = (ScalaJsToolchain)some.value();
                Dag<Project> dag = state.build().getDagFor(project);
                Path[] fullClasspath = (Path[])Predef$.MODULE$.genericArrayOps((Object)project.fullRuntimeClasspath(dag, state.client())).map((Function1 & Serializable & scala.Serializable)x$7 -> ((AbsolutePath)x$7).underlying(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)));
                return Task$.MODULE$.deferAction(arg_0 -> TestTask$.$anonfun$discoverTestFrameworks$4(toolchain2, config, project, fullClasspath, userMainClass, target, state, (DebugFilter)logContext, arg_0));
            }
            if (None$.MODULE$.equals(option)) {
                String artifactName = ScalaJsToolchain$.MODULE$.artifactNameFrom(config.version());
                String msg = Feedback$.MODULE$.missingLinkArtifactFor(project, artifactName, ScalaJsToolchain$.MODULE$.name());
                state.logger().error(msg);
                return Task$.MODULE$.now((Object)None$.MODULE$);
            }
            throw new MatchError(option);
        }
        if (platform instanceof Platform.Native) {
            state.logger().warn("Detecting test frameworks in Scala Native projects is not yet supported");
            return Task$.MODULE$.now((Object)None$.MODULE$);
        }
        throw new MatchError((Object)platform);
    }

    public RunMode discoverTestFrameworks$default$3() {
        return RunMode$Normal$.MODULE$;
    }

    public List<Config.TestArgument> considerFrameworkArgs(List<Framework> frameworks, List<String> options, Logger logger) {
        if (options.isEmpty()) {
            return Nil$.MODULE$;
        }
        List cls = (List)frameworks.map((Function1 & Serializable & scala.Serializable)f -> f.getClass().getName(), List$.MODULE$.canBuildFrom());
        List list = (List)frameworks.sortBy((Function1 & Serializable & scala.Serializable)x$9 -> x$9.name(), (Ordering)Ordering.String$.MODULE$);
        if (Nil$.MODULE$.equals(list)) {
            return Nil$.MODULE$;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Framework oneFramework = (Framework)colon2.head();
            List list2 = colon2.tl$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                String cls2 = oneFramework.getClass().getName();
                logger.debug(new StringBuilder(55).append("Test options '").append(options).append("' assigned to the only found framework ").append(cls2).append("'.").toString(), this.logContext());
                return new .colon.colon((Object)new Config.TestArgument(options, (Option)new Some((Object)new Config.TestFramework((List)new .colon.colon((Object)cls2, (List)Nil$.MODULE$)))), (List)Nil$.MODULE$);
            }
        }
        String frameworkNames = ((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.name(), List$.MODULE$.canBuildFrom())).mkString(", ");
        Tuple2 tuple2 = options.partition((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)s.startsWith("-D")));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List sysProperties = (List)tuple2._1();
        List ignoredArgs = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sysProperties, (Object)ignoredArgs);
        List sysProperties2 = (List)tuple22._1();
        List ignoredArgs2 = (List)tuple22._2();
        if (sysProperties2.nonEmpty()) {
            return new .colon.colon((Object)new Config.TestArgument(sysProperties2, (Option)new Some((Object)new Config.TestFramework(cls))), (List)Nil$.MODULE$);
        }
        logger.warn(new StringBuilder(73).append("Ignored CLI test options '").append(ignoredArgs2).append("' can only be applied to one framework, found: ").append(frameworkNames).toString());
        return Nil$.MODULE$;
    }

    public scala.collection.immutable.Map<Framework, List<TaskDef>> discoverTestSuites(State state, Project project, List<Framework> frameworks, CompileAnalysis analysis, Function1<String, Object> testFilter, ScalaTestSuites testClasses) {
        scala.collection.immutable.Map<Framework, List<TaskDef>> tests = this.discoverTests(analysis, frameworks);
        scala.collection.immutable.Set excluded = project.testOptions().excludes().toSet();
        List ungroupedTests = (List)tests.toList().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Framework framework = (Framework)tuple2._1();
                List tasks = (List)tuple2._2();
                return (List)tasks.map((Function1 & Serializable & scala.Serializable)taskDef -> new TestTask.TaskDefWithFramework((TaskDef)taskDef, framework), List$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = ungroupedTests.partition((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TestTask$.$anonfun$discoverTestSuites$3(excluded, testFilter, x0$2)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List includedTests = (List)tuple2._1();
        List excludedTests = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)includedTests, (Object)excludedTests);
        List includedTests2 = (List)tuple22._1();
        List excludedTests2 = (List)tuple22._2();
        if (state.logger().isVerbose()) {
            String allNames = ((TraversableOnce)ungroupedTests.map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.taskDef().fullyQualifiedName(), List$.MODULE$.canBuildFrom())).mkString(", ");
            String includedNames = ((TraversableOnce)includedTests2.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.taskDef().fullyQualifiedName(), List$.MODULE$.canBuildFrom())).mkString(", ");
            String excludedNames = ((TraversableOnce)excludedTests2.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.taskDef().fullyQualifiedName(), List$.MODULE$.canBuildFrom())).mkString(", ");
            state.logger().debug(new StringBuilder(38).append("Bloop found the following tests for ").append(project.name()).append(": ").append(allNames).toString(), this.logContext());
            state.logger().debug(new StringBuilder(49).append("The following tests were included by the filter: ").append(includedNames).toString(), this.logContext());
            state.logger().debug(new StringBuilder(49).append("The following tests were excluded by the filter: ").append(excludedNames).toString(), this.logContext());
        }
        scala.collection.immutable.Map selectedTests = ((TraversableOnce)testClasses.suites().map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.className(), (Object)entry.tests()), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return includedTests2.groupBy((Function1 & Serializable & scala.Serializable)x$16 -> x$16.framework()).mapValues((Function1 & Serializable & scala.Serializable)taskDefs -> (List)taskDefs.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            TestTask.TaskDefWithFramework taskDefWithFramework = x0$3;
            if (taskDefWithFramework != null) {
                TaskDef taskDef = taskDefWithFramework.taskDef();
                List list = (List)selectedTests.get((Object)taskDef.fullyQualifiedName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                if (Nil$.MODULE$.equals(list)) {
                    return taskDef;
                }
                return new TaskDef(taskDef.fullyQualifiedName(), taskDef.fingerprint(), false, (Selector[])((List)list.map((Function1 & Serializable & scala.Serializable)test -> new TestSelector(test), List$.MODULE$.canBuildFrom())).toList().toArray(ClassTag$.MODULE$.apply(Selector.class)));
            }
            throw new MatchError((Object)taskDefWithFramework);
        }, List$.MODULE$.canBuildFrom()));
    }

    public scala.collection.immutable.Map<Framework, List<TaskDef>> discoverTests(CompileAnalysis analysis, List<Framework> frameworks) {
        Tuple2<List<FingerprintInfo<SubclassFingerprint>>, List<FingerprintInfo<AnnotatedFingerprint>>> tuple2 = TestInternals$.MODULE$.getFingerprints((Seq<Framework>)frameworks);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List subclassPrints = (List)tuple2._1();
        List annotatedPrints = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)subclassPrints, (Object)annotatedPrints);
        List subclassPrints2 = (List)tuple22._1();
        List annotatedPrints2 = (List)tuple22._2();
        Seq<ClassLike> definitions = TestInternals$.MODULE$.potentialTests(analysis);
        Seq discovered = Discovery$.MODULE$.apply(((TraversableOnce)subclassPrints2.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.name(), List$.MODULE$.canBuildFrom())).toSet(), ((TraversableOnce)annotatedPrints2.map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.name(), List$.MODULE$.canBuildFrom())).toSet(), definitions);
        Map tasks = Map$.MODULE$.empty();
        Set seen = Set$.MODULE$.empty();
        frameworks.foreach((Function1 & Serializable & scala.Serializable)x$20 -> {
            tasks.update((Object)x$20, (Object)Buffer$.MODULE$.empty());
            return BoxedUnit.UNIT;
        });
        discovered.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TestTask$.$anonfun$discoverTests$4(subclassPrints2, annotatedPrints2, seen, tasks, x0$1);
            return BoxedUnit.UNIT;
        });
        return tasks.mapValues((Function1 & Serializable & scala.Serializable)x$21 -> x$21.toList()).toMap(Predef$.MODULE$.$conforms());
    }

    public Task<List<TestFrameworkWithClasses>> findTestNamesWithFramework(Project project, State state) {
        return this.discoverTestFrameworks(project, state, this.discoverTestFrameworks$default$3()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                return List$.MODULE$.empty();
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                DiscoveredTestFrameworks found = (DiscoveredTestFrameworks)some.value();
                List<Framework> frameworks = found.frameworks();
                LastSuccessfulResult lastCompileResult = state.results().lastSuccessfulResultOrEmpty(project);
                CompileAnalysis analysis = (CompileAnalysis)JavaCompat$.MODULE$.EnrichOptional(lastCompileResult.previous().analysis()).toOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    state.logger().debug(new StringBuilder(57).append("TestsFQCN was triggered, but no compilation detected for ").append(project.name()).toString(), (DebugFilter)DebugFilter.All$.MODULE$);
                    return Analysis$.MODULE$.empty();
                });
                scala.collection.immutable.Map<Framework, List<TaskDef>> tests = MODULE$.discoverTests(analysis, frameworks);
                return ((TraversableOnce)tests.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        Framework framework = (Framework)tuple2._1();
                        List tasks = (List)tuple2._2();
                        return new TestFrameworkWithClasses(framework.name(), (List<String>)((List)tasks.map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.fullyQualifiedName(), List$.MODULE$.canBuildFrom())));
                    }
                    throw new MatchError((Object)tuple2);
                }, Iterable$.MODULE$.canBuildFrom())).toList();
            }
            throw new MatchError((Object)option);
        });
    }

    private static final Task handleEmptyTestFrameworks$1(boolean isTest$1, State state$1, Project project$1) {
        if (isTest$1) {
            state$1.logger().error(new StringBuilder(38).append("Missing configured test frameworks in ").append(project$1.name()).toString());
            return Task$.MODULE$.now((Object)BoxesRunTime.boxToInteger((int)1));
        }
        state$1.logger().warn(new StringBuilder(38).append("Missing configured test frameworks in ").append(project$1.name()).toString());
        return Task$.MODULE$.now((Object)BoxesRunTime.boxToInteger((int)0));
    }

    public static final /* synthetic */ boolean $anonfun$runTestSuites$4(Tuple2 x$2) {
        return ((SeqLike)x$2._2()).isEmpty();
    }

    private static final void cancel$1(AtomicBoolean cancelled$1, Function0 closeResources$1) {
        if (!cancelled$1.getAndSet(true)) {
            closeResources$1.apply$mcV$sp();
            return;
        }
    }

    private static final Try reportTestException$1(Throwable t, State state$1) {
        state$1.logger().error(Feedback$.MODULE$.printException("Unexpected test-related exception", t));
        state$1.logger().trace(t);
        return new Success((Object)BoxesRunTime.boxToInteger((int)ExitStatus$.MODULE$.TestExecutionError().code()));
    }

    public static final /* synthetic */ Try $anonfun$runTestSuites$11(Function0 closeResources$1, Function0 checkCancelled$1, State state$1, Try x0$2) {
        Try try_ = x0$2;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            closeResources$1.apply$mcV$sp();
            return success;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            Throwable throwable = e;
            Option option = NonFatal$.MODULE$.unapply(throwable);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                if (!checkCancelled$1.apply$mcZ$sp()) {
                    closeResources$1.apply$mcV$sp();
                    return TestTask$.reportTestException$1(t, state$1);
                }
                Throwable throwable2 = t.getCause();
                if (throwable2 instanceof IllegalStateException) {
                    state$1.logger().debug("Test server has been successfully closed.", MODULE$.logContext());
                    return new Success((Object)BoxesRunTime.boxToInteger((int)0));
                }
                if (throwable2 instanceof IllegalArgumentException) {
                    state$1.logger().debug("Test server has been successfully closed.", MODULE$.logContext());
                    return new Success((Object)BoxesRunTime.boxToInteger((int)0));
                }
                return TestTask$.reportTestException$1(t, state$1);
            }
            throw new MatchError((Object)throwable);
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ Task $anonfun$discoverTestFrameworks$4(ScalaJsToolchain toolchain$1, Config.JsConfig config$1, Project project$2, Path[] fullClasspath$1, Option userMainClass$1, Path target$1, State state$2, DebugFilter logContext$1, Scheduler s) {
        return toolchain$1.link(config$1, project$2, fullClasspath$1, Predef$.MODULE$.boolean2Boolean(false), (Option<String>)userMainClass$1, target$1, s, state$2.logger()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                state$2.logger().info(new StringBuilder(28).append("Generated JavaScript file '").append(AbsolutePath$.MODULE$.syntax$extension(target$1)).append("'").toString());
                List fnames = (List)project$2.testFrameworks().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.names(), List$.MODULE$.canBuildFrom());
                state$2.logger().debug(new StringBuilder(27).append("Resolving test frameworks: ").append(fnames).toString(), logContext$1);
                scala.collection.immutable.Map<String, String> env = state$2.commonOptions().env().toMap();
                return new Some((Object)toolchain$1.discoverTestFrameworks(project$2, (List<List<String>>)fnames, target$1, state$2.logger(), config$1, env));
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                ex.printStackTrace();
                state$2.logger().trace(ex);
                state$2.logger().error(new StringBuilder(33).append("JavaScript linking failed with '").append(ex.getMessage()).append("'").toString());
                return None$.MODULE$;
            }
            throw new MatchError((Object)try_);
        });
    }

    public static final /* synthetic */ boolean $anonfun$discoverTestSuites$3(scala.collection.immutable.Set excluded$1, Function1 testFilter$2, TestTask.TaskDefWithFramework x0$2) {
        TestTask.TaskDefWithFramework taskDefWithFramework = x0$2;
        if (taskDefWithFramework != null) {
            TaskDef taskDef = taskDefWithFramework.taskDef();
            String fqn = taskDef.fullyQualifiedName();
            return !excluded$1.apply((Object)fqn) && BoxesRunTime.unboxToBoolean((Object)testFilter$2.apply((Object)fqn));
        }
        throw new MatchError((Object)taskDefWithFramework);
    }

    public static final /* synthetic */ void $anonfun$discoverTests$4(List subclassPrints$1, List annotatedPrints$1, Set seen$1, Map tasks$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Definition defn = (Definition)tuple2._1();
            Discovered discovered = (Discovered)tuple2._2();
            TestInternals$.MODULE$.matchingFingerprints((List<FingerprintInfo<SubclassFingerprint>>)subclassPrints$1, (List<FingerprintInfo<AnnotatedFingerprint>>)annotatedPrints$1, discovered).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                FingerprintInfo fingerprintInfo = x0$2;
                if (fingerprintInfo != null) {
                    Framework framework = fingerprintInfo.framework();
                    Object fingerprint = fingerprintInfo.fingerprint();
                    if (seen$1.add((Object)defn.name())) {
                        return ((BufferLike)tasks$1.apply((Object)framework)).$plus$eq((Object)new TaskDef(defn.name(), fingerprint, false, (Selector[])((Object[])new Selector[]{new SuiteSelector()})));
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)fingerprintInfo);
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private TestTask$() {
        MODULE$ = this;
        this.logContext = DebugFilter.Test$.MODULE$;
    }
}

