/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine.caches;

import bloop.CompilerCache;
import bloop.cli.CommonOptions;
import bloop.cli.ExitStatus$;
import bloop.data.ClientInfo;
import bloop.data.LoadedProject;
import bloop.data.WorkspaceSettings;
import bloop.data.WorkspaceSettings$;
import bloop.engine.Build;
import bloop.engine.Build$;
import bloop.engine.Build$ReturnPreviousState$;
import bloop.engine.BuildLoader$;
import bloop.engine.ClientPool;
import bloop.engine.State;
import bloop.engine.State$;
import bloop.engine.caches.ResultsCache;
import bloop.engine.caches.StateCache$;
import bloop.engine.caches.StateCache$CachedState$;
import bloop.io.AbsolutePath;
import bloop.logging.Logger;
import bloop.task.Task;
import bloop.task.Task$;
import bloop.util.Environment$;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tUb\u0001B\u0014)\u0005=B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\u0007\u001b\u0002!\t!a*\t\u000f\u0005-\u0006\u0001\"\u0001\u0002.\"A\u0011q\u001e\u0001\u0005\u00021\n\t\u0010C\u0004\u0002x\u0002!\t!!?\t\u000f\u0005u\b\u0001\"\u0001\u0002\u0000\"9!1\u0001\u0001\u0005\u0002\t\u0015q!\u0002&)\u0011\u0003Ye!B\u0014)\u0011\u0003a\u0005\"B'\n\t\u0003qe!B(\n\u0001&\u0001\u0006\u0002C,\f\u0005+\u0007I\u0011\u0001-\t\u0011u[!\u0011#Q\u0001\neC\u0001BX\u0006\u0003\u0016\u0004%\ta\u0018\u0005\tG.\u0011\t\u0012)A\u0005A\"AAm\u0003BK\u0002\u0013\u0005Q\r\u0003\u0005k\u0017\tE\t\u0015!\u0003g\u0011\u0015i5\u0002\"\u0001l\u0011\u001d\t8\"!A\u0005\u0002IDqA^\u0006\u0012\u0002\u0013\u0005q\u000fC\u0005\u0002\u0006-\t\n\u0011\"\u0001\u0002\b!I\u00111B\u0006\u0012\u0002\u0013\u0005\u0011Q\u0002\u0005\n\u0003#Y\u0011\u0011!C!\u0003'A\u0011\"!\t\f\u0003\u0003%\t!a\t\t\u0013\u0005-2\"!A\u0005\u0002\u00055\u0002\"CA\u001d\u0017\u0005\u0005I\u0011IA\u001e\u0011%\tIeCA\u0001\n\u0003\tY\u0005C\u0005\u0002V-\t\t\u0011\"\u0011\u0002X!I\u0011\u0011L\u0006\u0002\u0002\u0013\u0005\u00131\f\u0005\n\u0003;Z\u0011\u0011!C!\u0003?:\u0001\"a\u0019\n\u0011\u0003I\u0011Q\r\u0004\b\u001f&A\t!CA4\u0011\u0019i\u0005\u0005\"\u0001\u0002j!9\u00111\u000e\u0011\u0005\u0002\u00055\u0004\"CA=A\u0005\u0005I\u0011QA>\u0011%\t\u0019\tIA\u0001\n\u0003\u000b)\tC\u0005\u0002\u0018\u0002\n\t\u0011\"\u0003\u0002\u001a\"9\u0011\u0011U\u0005\u0005\u0002\u0005\r&AC*uCR,7)Y2iK*\u0011\u0011FK\u0001\u0007G\u0006\u001c\u0007.Z:\u000b\u0005-b\u0013AB3oO&tWMC\u0001.\u0003\u0015\u0011Gn\\8q\u0007\u0001\u0019\"\u0001\u0001\u0019\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\r\u0005s\u0017PU3g\u0003\u0015\u0019\u0017m\u00195f!\u0011At(Q$\u000e\u0003eR!AO\u001e\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002={\u0005!Q\u000f^5m\u0015\u0005q\u0014\u0001\u00026bm\u0006L!\u0001Q\u001d\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002C\u000b6\t1I\u0003\u0002EY\u0005\u0011\u0011n\\\u0005\u0003\r\u000e\u0013A\"\u00112t_2,H/\u001a)bi\"\u0004\"\u0001S\u0006\u000f\u0005%CQ\"\u0001\u0015\u0002\u0015M#\u0018\r^3DC\u000eDW\r\u0005\u0002J\u0013M\u0011\u0011\u0002M\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\u00131bQ1dQ\u0016$7\u000b^1uKN!1\u0002M)U!\t\t$+\u0003\u0002Te\t9\u0001K]8ek\u000e$\bCA\u0019V\u0013\t1&G\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003ck&dG-F\u0001Z!\tQ6,D\u0001+\u0013\ta&FA\u0003Ck&dG-\u0001\u0004ck&dG\rI\u0001\be\u0016\u001cX\u000f\u001c;t+\u0005\u0001\u0007CA%b\u0013\t\u0011\u0007F\u0001\u0007SKN,H\u000e^:DC\u000eDW-\u0001\u0005sKN,H\u000e^:!\u00035\u0019w.\u001c9jY\u0016\u00148)Y2iKV\ta\r\u0005\u0002hQ6\tA&\u0003\u0002jY\ti1i\\7qS2,'oQ1dQ\u0016\fabY8na&dWM]\"bG\",\u0007\u0005\u0006\u0003m]>\u0004\bCA7\f\u001b\u0005I\u0001\"B,\u0013\u0001\u0004I\u0006\"\u00020\u0013\u0001\u0004\u0001\u0007\"\u00023\u0013\u0001\u00041\u0017\u0001B2paf$B\u0001\\:uk\"9qk\u0005I\u0001\u0002\u0004I\u0006b\u00020\u0014!\u0003\u0005\r\u0001\u0019\u0005\bIN\u0001\n\u00111\u0001g\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012\u0001\u001f\u0016\u00033f\\\u0013A\u001f\t\u0004w\u0006\u0005Q\"\u0001?\u000b\u0005ut\u0018!C;oG\",7m[3e\u0015\ty('\u0001\u0006b]:|G/\u0019;j_:L1!a\u0001}\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tIA\u000b\u0002as\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA\bU\t1\u00170A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003+\u0001B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037i\u0014\u0001\u00027b]\u001eLA!a\b\u0002\u001a\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\n\u0011\u0007E\n9#C\u0002\u0002*I\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\f\u00026A\u0019\u0011'!\r\n\u0007\u0005M\"GA\u0002B]fD\u0011\"a\u000e\u001a\u0003\u0003\u0005\r!!\n\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u0004\u0005\u0004\u0002@\u0005\u0015\u0013qF\u0007\u0003\u0003\u0003R1!a\u00113\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000f\n\tE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA'\u0003'\u00022!MA(\u0013\r\t\tF\r\u0002\b\u0005>|G.Z1o\u0011%\t9dGA\u0001\u0002\u0004\ty#\u0001\u0005iCND7i\u001c3f)\t\t)#\u0001\u0005u_N#(/\u001b8h)\t\t)\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u001b\n\t\u0007C\u0005\u00028y\t\t\u00111\u0001\u00020\u0005Y1)Y2iK\u0012\u001cF/\u0019;f!\ti\u0007eE\u0002!aQ#\"!!\u001a\u0002\u0013\u0019\u0014x.\\*uCR,Gc\u00017\u0002p!9\u0011\u0011\u000f\u0012A\u0002\u0005M\u0014!B:uCR,\u0007c\u0001.\u0002v%\u0019\u0011q\u000f\u0016\u0003\u000bM#\u0018\r^3\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f1\fi(a \u0002\u0002\")qk\ta\u00013\")al\ta\u0001A\")Am\ta\u0001M\u00069QO\\1qa2LH\u0003BAD\u0003'\u0003R!MAE\u0003\u001bK1!a#3\u0005\u0019y\u0005\u000f^5p]B1\u0011'a$ZA\u001aL1!!%3\u0005\u0019!V\u000f\u001d7fg!A\u0011Q\u0013\u0013\u0002\u0002\u0003\u0007A.A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0014\t\u0005\u0003/\ti*\u0003\u0003\u0002 \u0006e!AB(cU\u0016\u001cG/A\u0003f[B$\u00180\u0006\u0002\u0002&B\u0011\u0011\n\u0001\u000b\u0005\u0003K\u000bI\u000bC\u00037\u0005\u0001\u0007q'A\u0006hKR\u001cF/\u0019;f\r>\u0014H\u0003DAX\u0003c\u000b),!2\u0002P\u0006}\u0007#B\u0019\u0002\n\u0006M\u0004BBAZ\u0007\u0001\u0007\u0011)\u0001\u0003qCRD\u0007bBA\\\u0007\u0001\u0007\u0011\u0011X\u0001\u0007G2LWM\u001c;\u0011\t\u0005m\u0016\u0011Y\u0007\u0003\u0003{S1!a0-\u0003\u0011!\u0017\r^1\n\t\u0005\r\u0017Q\u0018\u0002\u000b\u00072LWM\u001c;J]\u001a|\u0007bBAd\u0007\u0001\u0007\u0011\u0011Z\u0001\u0005a>|G\u000eE\u0002[\u0003\u0017L1!!4+\u0005)\u0019E.[3oiB{w\u000e\u001c\u0005\b\u0003#\u001c\u0001\u0019AAj\u00035\u0019w.\\7p]>\u0003H/[8ogB!\u0011Q[An\u001b\t\t9NC\u0002\u0002Z2\n1a\u00197j\u0013\u0011\ti.a6\u0003\u001b\r{W.\\8o\u001fB$\u0018n\u001c8t\u0011\u001d\t\to\u0001a\u0001\u0003G\fa\u0001\\8hO\u0016\u0014\b\u0003BAs\u0003Wl!!a:\u000b\u0007\u0005%H&A\u0004m_\u001e<\u0017N\\4\n\t\u00055\u0018q\u001d\u0002\u0007\u0019><w-\u001a:\u0002)\u001d,GOU1x\u0007\u0006\u001c\u0007.\u001a3Ck&dGMR8s)\u0011\t\u00190!>\u0011\tE\nI)\u0017\u0005\u0007\u0003g#\u0001\u0019A!\u0002'\u001d,G/\u00169eCR,Gm\u0015;bi\u00164%o\\7\u0015\t\u0005=\u00161 \u0005\b\u0003c*\u0001\u0019AA:\u0003-)\b\u000fZ1uK\n+\u0018\u000e\u001c3\u0015\t\u0005M$\u0011\u0001\u0005\b\u0003c2\u0001\u0019AA:\u0003%aw.\u00193Ti\u0006$X\r\u0006\t\u0003\b\tM!q\u0003B\r\u00057\u0011iBa\b\u0003*A1!\u0011\u0002B\b\u0003gj!Aa\u0003\u000b\u0007\t5A&\u0001\u0003uCN\\\u0017\u0002\u0002B\t\u0005\u0017\u0011A\u0001V1tW\"1!QC\u0004A\u0002\u0005\u000bAA\u001a:p[\"9\u0011qW\u0004A\u0002\u0005e\u0006bBAd\u000f\u0001\u0007\u0011\u0011\u001a\u0005\b\u0003#<\u0001\u0019AAj\u0011\u001d\t\to\u0002a\u0001\u0003GDqA!\t\b\u0001\u0004\u0011\u0019#A\u0006de\u0016\fG/Z*uCR,\u0007CB\u0019\u0003&e\u000b\u0019(C\u0002\u0003(I\u0012\u0011BR;oGRLwN\\\u0019\t\u000f\t-r\u00011\u0001\u0003.\u0005q1\r\\5f]R\u001cV\r\u001e;j]\u001e\u001c\b#B\u0019\u0002\n\n=\u0002\u0003BA^\u0005cIAAa\r\u0002>\n\trk\u001c:lgB\f7-Z*fiRLgnZ:")
public final class StateCache {
    private final ConcurrentHashMap<AbsolutePath, CachedState> cache;

    public static StateCache empty() {
        return StateCache$.MODULE$.empty();
    }

    public Option<State> getStateFor(Path path, ClientInfo client, ClientPool pool, CommonOptions commonOptions, Logger logger) {
        return Option$.MODULE$.apply((Object)this.cache.get(new AbsolutePath(path))).map((Function1 & Serializable & scala.Serializable)cachedState -> State$.MODULE$.apply(cachedState.build(), cachedState.results(), cachedState.compilerCache(), client, pool, commonOptions, ExitStatus$.MODULE$.Ok(), logger));
    }

    public Option<Build> getRawCachedBuildFor(Path path) {
        return Option$.MODULE$.apply((Object)this.cache.get(new AbsolutePath(path))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.build());
    }

    public Option<State> getUpdatedStateFrom(State state) {
        return this.getStateFor(state.build().origin(), state.client(), state.pool(), state.commonOptions(), state.logger());
    }

    public State updateBuild(State state) {
        this.cache.put(new AbsolutePath(state.build().origin()), StateCache$CachedState$.MODULE$.fromState(state));
        return state;
    }

    public Task<State> loadState(Path from, ClientInfo client, ClientPool pool, CommonOptions commonOptions, Logger logger, Function1<Build, State> createState, Option<WorkspaceSettings> clientSettings) {
        Build empty = Build$.MODULE$.apply(from, (List<LoadedProject>)Nil$.MODULE$, (Option<WorkspaceSettings>)None$.MODULE$);
        Path path = from;
        Path path2 = Environment$.MODULE$.defaultBloopDirectory();
        if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
            return Task$.MODULE$.now(createState.apply((Object)empty));
        }
        Option<State> previousState = this.getStateFor(from, client, pool, commonOptions, logger);
        Build build = (Build)previousState.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.build()).getOrElse((Function0 & Serializable & scala.Serializable)() -> empty);
        return build.checkForChange(clientSettings, logger).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Task task;
            Build.ReloadAction reloadAction = x0$1;
            if (Build$ReturnPreviousState$.MODULE$.equals(reloadAction)) {
                task = Task$.MODULE$.now(previousState.getOrElse((Function0 & Serializable & scala.Serializable)() -> (State)createState.apply((Object)empty)));
            } else if (reloadAction instanceof Build.UpdateState) {
                Build.UpdateState updateState = (Build.UpdateState)reloadAction;
                List<Build.ReadConfiguration> created = updateState.created();
                List<Build.ReadConfiguration> modified = updateState.modified();
                List<AbsolutePath> deleted = updateState.deleted();
                List<Build.InvalidatedInMemoryProject> changed = updateState.invalidated();
                Option<WorkspaceSettings> settings2 = updateState.settingsForReload();
                boolean writeSettings = updateState.writeSettingsToDisk();
                if (writeSettings) {
                    settings2.foreach((Function1 & Serializable & scala.Serializable)settings -> {
                        AbsolutePath absolutePath;
                        try {
                            absolutePath = new AbsolutePath(WorkspaceSettings$.MODULE$.writeToFile(from, (WorkspaceSettings)settings, logger));
                        }
                        catch (Throwable e) {
                            logger.displayWarningToUser(new StringBuilder(36).append("Failed to write workspace settings: ").append(e.getMessage()).toString());
                            logger.trace(e);
                            absolutePath = BoxedUnit.UNIT;
                        }
                        return absolutePath;
                    });
                }
                List createdOrModified = (List)created.$plus$plus(modified, List$.MODULE$.canBuildFrom());
                task = BuildLoader$.MODULE$.loadBuildIncrementally(from, (List<Build.ReadConfiguration>)createdOrModified, changed, settings2, logger).map((Function1 & Serializable & scala.Serializable)newProjects -> {
                    State state;
                    Option option = previousState;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        State state2 = (State)some.value();
                        List<LoadedProject> currentProjects = state2.build().loadedProjects();
                        Set toRemove = (Set)deleted.toSet().$plus$plus((GenTraversableOnce)newProjects.map((Function1 & Serializable & scala.Serializable)x$3 -> new AbsolutePath(StateCache.$anonfun$loadState$7(x$3)), List$.MODULE$.canBuildFrom()));
                        List untouched = (List)currentProjects.collect((PartialFunction)new scala.Serializable(null, toRemove){
                            public static final long serialVersionUID = 0L;
                            private final Set toRemove$1;

                            public final <A1 extends LoadedProject, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                Object object = !this.toRemove$1.contains((Object)new AbsolutePath(A1.project().origin().path())) ? A1 : function1.apply(x1);
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(LoadedProject x1) {
                                LoadedProject loadedProject = x1;
                                boolean bl = !this.toRemove$1.contains((Object)new AbsolutePath(loadedProject.project().origin().path()));
                                return bl;
                            }
                            {
                                this.toRemove$1 = toRemove$1;
                            }
                        }, List$.MODULE$.canBuildFrom());
                        List x$1 = (List)untouched.$plus$plus((GenTraversableOnce)newProjects, List$.MODULE$.canBuildFrom());
                        Path x$2 = state2.build().copy$default$1();
                        Option<WorkspaceSettings> x$32 = state2.build().copy$default$3();
                        Build newBuild = state2.build().copy(x$2, (List<LoadedProject>)x$1, x$32);
                        state = state2.copy(newBuild, state2.copy$default$2(), state2.copy$default$3(), state2.copy$default$4(), state2.copy$default$5(), state2.copy$default$6(), state2.copy$default$7(), state2.copy$default$8());
                    } else if (None$.MODULE$.equals(option)) {
                        state = (State)createState.apply((Object)Build$.MODULE$.apply(from, (List<LoadedProject>)newProjects, settings2));
                    } else {
                        throw new MatchError((Object)option);
                    }
                    State newState = state;
                    $this.cache.put(new AbsolutePath(from), StateCache$CachedState$.MODULE$.fromState(newState));
                    return newState;
                });
            } else {
                throw new MatchError((Object)reloadAction);
            }
            return task;
        });
    }

    public static final /* synthetic */ Path $anonfun$loadState$7(LoadedProject x$3) {
        return x$3.project().origin().path();
    }

    public StateCache(ConcurrentHashMap<AbsolutePath, CachedState> cache) {
        this.cache = cache;
    }

    public static class CachedState
    implements Product,
    scala.Serializable {
        private final Build build;
        private final ResultsCache results;
        private final CompilerCache compilerCache;

        public Build build() {
            return this.build;
        }

        public ResultsCache results() {
            return this.results;
        }

        public CompilerCache compilerCache() {
            return this.compilerCache;
        }

        public CachedState copy(Build build, ResultsCache results, CompilerCache compilerCache) {
            return new CachedState(build, results, compilerCache);
        }

        public Build copy$default$1() {
            return this.build();
        }

        public ResultsCache copy$default$2() {
            return this.results();
        }

        public CompilerCache copy$default$3() {
            return this.compilerCache();
        }

        public String productPrefix() {
            return "CachedState";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.build();
                    break;
                }
                case 1: {
                    object = this.results();
                    break;
                }
                case 2: {
                    object = this.compilerCache();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CachedState;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CachedState)) return false;
            boolean bl = true;
            if (!bl) return false;
            CachedState cachedState = (CachedState)x$1;
            Build build = this.build();
            Build build2 = cachedState.build();
            if (build == null) {
                if (build2 != null) {
                    return false;
                }
            } else if (!((Object)build).equals(build2)) return false;
            ResultsCache resultsCache = this.results();
            ResultsCache resultsCache2 = cachedState.results();
            if (resultsCache == null) {
                if (resultsCache2 != null) {
                    return false;
                }
            } else if (!((Object)resultsCache).equals(resultsCache2)) return false;
            CompilerCache compilerCache = this.compilerCache();
            CompilerCache compilerCache2 = cachedState.compilerCache();
            if (compilerCache == null) {
                if (compilerCache2 != null) {
                    return false;
                }
            } else if (!compilerCache.equals(compilerCache2)) return false;
            if (!cachedState.canEqual(this)) return false;
            return true;
        }

        public CachedState(Build build, ResultsCache results, CompilerCache compilerCache) {
            this.build = build;
            this.results = results;
            this.compilerCache = compilerCache;
            Product.$init$((Product)this);
        }
    }
}

