/*
 * Decompiled with CFR 0.152.
 */
package bloop;

import bloop.Cli;
import bloop.Server;
import bloop.logging.BloopLogger;
import bloop.logging.BloopLogger$;
import bloop.logging.Logger;
import bloop.logging.Slf4jAdapter;
import bloop.util.ProxySetup$;
import com.martiansoftware.nailgun.Alias;
import com.martiansoftware.nailgun.AliasManager;
import com.martiansoftware.nailgun.NGContext;
import com.martiansoftware.nailgun.NGListeningAddress;
import com.martiansoftware.nailgun.NGServer;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.concurrent.ForkJoinPool;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class Server$ {
    public static Server$ MODULE$;
    private final int defaultPort;

    static {
        new Server$();
    }

    private int defaultPort() {
        return this.defaultPort;
    }

    public void main(String[] args) {
        this.run(this.instantiateServer(args));
    }

    public NGServer instantiateServer(String[] args) {
        Tuple2 tuple2;
        if (args.length == 0) {
            tuple2 = new Tuple2((Object)InetAddress.getLoopbackAddress(), (Object)BoxesRunTime.boxToInteger((int)Server$.toPortNumber$1("")));
        } else if (args.length == 1) {
            tuple2 = new Tuple2((Object)InetAddress.getLoopbackAddress(), (Object)BoxesRunTime.boxToInteger((int)Server$.toPortNumber$1(args[0])));
        } else if (args.length == 2) {
            InetAddress addr = InetAddress.getByName(args[0]);
            tuple2 = new Tuple2((Object)addr, (Object)BoxesRunTime.boxToInteger((int)Server$.toPortNumber$1(args[1])));
        } else {
            throw new IllegalArgumentException(new StringBuilder(63).append("Invalid arguments to bloop server: ").append(args).append(", expected: [address] [port]").toString());
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        InetAddress addr = (InetAddress)tuple22._1();
        int port = tuple22._2$mcI$sp();
        Tuple2 tuple23 = new Tuple2((Object)addr, (Object)BoxesRunTime.boxToInteger((int)port));
        Tuple2 tuple24 = tuple23;
        InetAddress addr2 = (InetAddress)tuple24._1();
        int port2 = tuple24._2$mcI$sp();
        BloopLogger logger = BloopLogger$.MODULE$.default("bloop-nailgun-main");
        return this.launchServer(System.in, System.out, System.err, addr2, port2, (Logger)logger);
    }

    public NGServer launchServer(InputStream in, PrintStream out, PrintStream err, InetAddress addr, int port, Logger logger) {
        Slf4jAdapter javaLogger = new Slf4jAdapter(logger);
        NGListeningAddress address = new NGListeningAddress(addr, port);
        int poolSize = 2;
        int heartbeatMs = 10000;
        NGServer server = new NGServer(address, poolSize, heartbeatMs, in, out, err, (org.slf4j.Logger)javaLogger);
        this.registerAliases(server);
        ProxySetup$.MODULE$.init();
        return server;
    }

    public void nailMain(NGContext ngContext) {
        NGServer server = ngContext.getNGServer();
        ForkJoinPool.commonPool().submit(new Runnable(server){
            private final NGServer server$1;

            public void run() {
                this.server$1.shutdown(false);
            }
            {
                this.server$1 = server$1;
            }
        });
    }

    private void run(NGServer server) {
        server.run();
    }

    private void registerAliases(NGServer server) {
        AliasManager aliasManager = server.getAliasManager();
        aliasManager.addAlias(new Alias("about", "Show bloop information.", Cli.class));
        aliasManager.addAlias(new Alias("clean", "Clean project(s) in the build.", Cli.class));
        aliasManager.addAlias(new Alias("compile", "Compile project(s) in the build.", Cli.class));
        aliasManager.addAlias(new Alias("test", "Run project(s)' tests in the build.", Cli.class));
        aliasManager.addAlias(new Alias("run", "Run a main entrypoint for project(s) in the build.", Cli.class));
        aliasManager.addAlias(new Alias("bsp", "Spawn a build server protocol instance.", Cli.class));
        aliasManager.addAlias(new Alias("console", "Run the console for project(s) in the build.", Cli.class));
        aliasManager.addAlias(new Alias("projects", "Show projects in the build.", Cli.class));
        aliasManager.addAlias(new Alias("configure", "Configure the bloop server.", Cli.class));
        aliasManager.addAlias(new Alias("help", "Show bloop help message.", Cli.class));
        aliasManager.addAlias(new Alias("exit", "Kill the bloop server.", Server.class));
        server.setDefaultNailClass(Cli.class);
        server.setAllowNailsByClassName(false);
    }

    private static final int toPortNumber$1(String userPort) {
        return BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(userPort)).toInt()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.defaultPort()));
    }

    private Server$() {
        MODULE$ = this;
        this.defaultPort = 8212;
    }
}

