/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine.tasks.compilation;

import bloop.Compiler;
import bloop.UniqueCompileInputs;
import bloop.data.ClientInfo;
import bloop.data.Project;
import bloop.engine.Dag;
import bloop.engine.caches.LastSuccessfulResult;
import bloop.engine.caches.LastSuccessfulResult$;
import bloop.engine.tasks.compilation.CompileDefinitions;
import bloop.engine.tasks.compilation.CompileDependenciesData;
import bloop.engine.tasks.compilation.CompileGatekeeper;
import bloop.engine.tasks.compilation.PartialCompileResult;
import bloop.engine.tasks.compilation.PartialCompileResult$;
import bloop.engine.tasks.compilation.PartialSuccess;
import bloop.engine.tasks.compilation.ResultBundle;
import bloop.engine.tasks.compilation.SuccessfulCompileBundle;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import bloop.logging.LoggerAction;
import bloop.logging.ObservedLogger;
import bloop.reporter.ObservedReporter;
import bloop.reporter.ReporterAction;
import bloop.tracing.BraveTracer;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBoolean$;
import monix.execution.atomic.AtomicInt;
import monix.execution.atomic.AtomicInt$;
import monix.reactive.Observable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.concurrent.Promise;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import xsbti.compile.FileHash;
import xsbti.compile.PreviousResult;

public final class CompileGatekeeper$ {
    public static CompileGatekeeper$ MODULE$;
    private final DebugFilter filter;
    private final ConcurrentHashMap<AbsolutePath, AtomicInt> currentlyUsedClassesDirs;
    private final ConcurrentHashMap<UniqueCompileInputs, CompileGatekeeper.RunningCompilation> runningCompilations;
    private final ConcurrentHashMap<String, LastSuccessfulResult> lastSuccessfulResults;

    static {
        new CompileGatekeeper$();
    }

    private DebugFilter filter() {
        return this.filter;
    }

    private ConcurrentHashMap<AbsolutePath, AtomicInt> currentlyUsedClassesDirs() {
        return this.currentlyUsedClassesDirs;
    }

    private ConcurrentHashMap<UniqueCompileInputs, CompileGatekeeper.RunningCompilation> runningCompilations() {
        return this.runningCompilations;
    }

    private ConcurrentHashMap<String, LastSuccessfulResult> lastSuccessfulResults() {
        return this.lastSuccessfulResults;
    }

    public Tuple2<CompileGatekeeper.RunningCompilation, Object> findRunningCompilationAtomically(CompileDefinitions.BundleInputs inputs, SuccessfulCompileBundle bundle, ClientInfo client, Function1<SuccessfulCompileBundle, Task<Dag<PartialCompileResult>>> compile) {
        BooleanRef deduplicate = BooleanRef.create((boolean)true);
        CompileGatekeeper.RunningCompilation running2 = this.runningCompilations().compute(bundle.uniqueInputs(), (x$1, running) -> {
            CompileGatekeeper.RunningCompilation runningCompilation;
            if (running == null) {
                deduplicate$1.elem = false;
                runningCompilation = MODULE$.scheduleCompilation(inputs, bundle, client, compile);
            } else {
                int update$macro$3;
                int n;
                Path usedClassesDir = running.usedLastSuccessful().classesDir();
                AtomicInt usedClassesDirCounter = running.usedLastSuccessful().counterForClassesDir();
                AtomicInt self$macro$1 = usedClassesDirCounter;
                int current$macro$2 = self$macro$1.get();
                if (current$macro$2 == 0) {
                    deduplicate$1.elem = false;
                    MODULE$.currentlyUsedClassesDirs().remove(new AbsolutePath(usedClassesDir), usedClassesDirCounter);
                    n = current$macro$2;
                } else {
                    n = update$macro$3 = current$macro$2 + 1;
                }
                while (!self$macro$1.compareAndSet(current$macro$2, update$macro$3)) {
                    int n2;
                    current$macro$2 = self$macro$1.get();
                    if (current$macro$2 == 0) {
                        deduplicate$1.elem = false;
                        MODULE$.currentlyUsedClassesDirs().remove(new AbsolutePath(usedClassesDir), usedClassesDirCounter);
                        n2 = current$macro$2;
                    } else {
                        n2 = current$macro$2 + 1;
                    }
                    update$macro$3 = n2;
                }
                runningCompilation = deduplicate$1.elem ? running : MODULE$.scheduleCompilation(inputs, bundle, client, compile);
            }
            return runningCompilation;
        });
        return new Tuple2((Object)running2, (Object)BoxesRunTime.boxToBoolean((boolean)deduplicate.elem));
    }

    public void disconnectDeduplicationFromRunning(UniqueCompileInputs inputs, CompileGatekeeper.RunningCompilation runningCompilation) {
        runningCompilation.isUnsubscribed().compareAndSet(false, true);
        this.runningCompilations().remove(inputs, runningCompilation);
    }

    public CompileGatekeeper.RunningCompilation scheduleCompilation(CompileDefinitions.BundleInputs inputs, SuccessfulCompileBundle bundle, ClientInfo client, Function1<SuccessfulCompileBundle, Task<Dag<PartialCompileResult>>> compile) {
        ObjectRef counterForUsedClassesDir = ObjectRef.create(null);
        bundle.logger().debug(new StringBuilder(30).append("Scheduling compilation for ").append(inputs.project().name()).append("...").toString(), this.filter());
        LastSuccessfulResult mostRecentSuccessful = this.getMostRecentSuccessfulResultAtomically$1(inputs, counterForUsedClassesDir, bundle);
        AtomicBoolean isUnsubscribed = AtomicBoolean$.MODULE$.apply(false);
        LastSuccessfulResult x$1 = mostRecentSuccessful;
        Project x$2 = bundle.copy$default$1();
        Path x$3 = bundle.copy$default$2();
        CompileDependenciesData x$42 = bundle.copy$default$3();
        List<AbsolutePath> x$5 = bundle.copy$default$4();
        List<AbsolutePath> x$6 = bundle.copy$default$5();
        UniqueCompileInputs x$7 = bundle.copy$default$6();
        Promise<BoxedUnit> x$8 = bundle.copy$default$7();
        ObservedReporter x$9 = bundle.copy$default$8();
        ObservedLogger<Logger> x$10 = bundle.copy$default$9();
        Observable<Either<ReporterAction, LoggerAction>> x$11 = bundle.copy$default$10();
        Compiler.Result x$12 = bundle.copy$default$12();
        BraveTracer x$13 = bundle.copy$default$13();
        SuccessfulCompileBundle newBundle = bundle.copy(x$2, x$3, x$42, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$1, x$12, x$13);
        Task compileAndUnsubscribe = ((Task)compile.apply((Object)newBundle)).doOnFinish((Function1 & Serializable & scala.Serializable)x$4 -> Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> bundle.logger().observer().onComplete())).map((Function1 & Serializable & scala.Serializable)result -> MODULE$.processResultAtomically((Dag<PartialCompileResult>)result, inputs.project(), bundle.uniqueInputs(), isUnsubscribed, (Logger)bundle.logger())).memoize();
        return new CompileGatekeeper.RunningCompilation((Task<Dag<PartialCompileResult>>)compileAndUnsubscribe, mostRecentSuccessful, isUnsubscribed, bundle.mirror(), client);
    }

    private Dag<PartialCompileResult> processResultAtomically(Dag<PartialCompileResult> resultDag, Project project, UniqueCompileInputs oinputs, AtomicBoolean isAlreadyUnsubscribed, Logger logger) {
        return PartialCompileResult$.MODULE$.mapEveryResult(resultDag, (Function1<PartialCompileResult, PartialCompileResult>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
            PartialCompileResult partialCompileResult;
            PartialCompileResult partialCompileResult2 = x0$1;
            if (partialCompileResult2 instanceof PartialSuccess) {
                PartialSuccess partialSuccess = (PartialSuccess)partialCompileResult2;
                Task processedResult = partialSuccess.result().map((Function1 & Serializable & scala.Serializable)result -> {
                    Object object;
                    Option<LastSuccessfulResult> option = result.successful();
                    if (None$.MODULE$.equals(option)) {
                        object = this.cleanUpAfterCompilationError$1(result, isAlreadyUnsubscribed, oinputs);
                    } else if (option instanceof Some) {
                        Some some = (Some)option;
                        LastSuccessfulResult res = (LastSuccessfulResult)some.value();
                        MODULE$.unregisterDeduplicationAndRegisterSuccessful(project, oinputs, res, logger);
                        object = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError(option);
                    }
                    return result;
                });
                Task x$1 = processedResult.memoize();
                SuccessfulCompileBundle x$2 = partialSuccess.copy$default$1();
                partialCompileResult = partialSuccess.copy(x$2, (Task<ResultBundle>)x$1);
            } else {
                partialCompileResult = (PartialCompileResult)this.cleanUpAfterCompilationError$1(partialCompileResult2, isAlreadyUnsubscribed, oinputs);
            }
            return partialCompileResult;
        });
    }

    private void unregisterDeduplicationAndRegisterSuccessful(Project project, UniqueCompileInputs oracleInputs, LastSuccessfulResult successful, Logger logger) {
        this.runningCompilations().compute(oracleInputs, (x$5, x$6) -> {
            MODULE$.lastSuccessfulResults().compute(project.uniqueId(), (x$7, x$8) -> successful);
            return null;
        });
        logger.debug(new StringBuilder(59).append("Recording new last successful request for ").append(project.name()).append(" associated with ").append(new AbsolutePath(successful.classesDir())).toString(), this.filter());
    }

    public void clearSuccessfulResults() {
        ConcurrentHashMap<String, LastSuccessfulResult> concurrentHashMap = this.lastSuccessfulResults();
        synchronized (concurrentHashMap) {
            this.lastSuccessfulResults().clear();
        }
    }

    private final LastSuccessfulResult initializeLastSuccessful$1(LastSuccessfulResult previousOrNull, SuccessfulCompileBundle bundle$2, CompileDefinitions.BundleInputs inputs$2) {
        LastSuccessfulResult lastSuccessfulResult;
        LastSuccessfulResult result = (LastSuccessfulResult)Option$.MODULE$.apply((Object)previousOrNull).getOrElse((Function0 & Serializable & scala.Serializable)() -> bundle$2.lastSuccessful());
        if (!AbsolutePath$.MODULE$.exists$extension(result.classesDir())) {
            bundle$2.logger().debug(new StringBuilder(45).append("Ignoring analysis for ").append(inputs$2.project().name()).append(", directory ").append(new AbsolutePath(result.classesDir())).append(" is missing").toString(), this.filter());
            lastSuccessfulResult = LastSuccessfulResult$.MODULE$.empty(inputs$2.project());
        } else {
            Compiler.Result result2 = bundle$2.latestResult();
            Compiler.Result$.Empty$ empty$ = Compiler.Result$.Empty$.MODULE$;
            if (!(result2 != null ? !result2.equals(empty$) : empty$ != null)) {
                bundle$2.logger().debug(new StringBuilder(54).append("Ignoring existing analysis for ").append(inputs$2.project().name()).append(", last result was empty").toString(), this.filter());
                LastSuccessfulResult qual$1 = LastSuccessfulResult$.MODULE$.empty(inputs$2.project());
                Path x$1 = result.classesDir();
                AtomicInt x$2 = result.counterForClassesDir();
                Task<BoxedUnit> x$3 = result.populatingProducts();
                Vector<UniqueCompileInputs.HashedSource> x$4 = qual$1.copy$default$1();
                Vector<FileHash> x$5 = qual$1.copy$default$2();
                PreviousResult x$6 = qual$1.copy$default$3();
                lastSuccessfulResult = qual$1.copy(x$4, x$5, x$6, x$1, x$2, x$3);
            } else {
                bundle$2.logger().debug(new StringBuilder(45).append("Using successful result for ").append(inputs$2.project().name()).append(" associated with ").append(new AbsolutePath(result.classesDir())).toString(), this.filter());
                lastSuccessfulResult = result;
            }
        }
        return lastSuccessfulResult;
    }

    public static final /* synthetic */ AtomicInt $anonfun$scheduleCompilation$3(ObjectRef counterForUsedClassesDir$1, SuccessfulCompileBundle bundle$2, LastSuccessfulResult previousResult$1, Path x$3, AtomicInt counter) {
        AtomicInt atomicInt;
        if (counter == null) {
            AtomicInt initialCounter = AtomicInt$.MODULE$.apply(1);
            counterForUsedClassesDir$1.elem = initialCounter;
            atomicInt = initialCounter;
        } else {
            counterForUsedClassesDir$1.elem = counter;
            int newCount = counter.incrementAndGet(1);
            bundle$2.logger().debug(new StringBuilder(27).append("Increasing counter for ").append(new AbsolutePath(previousResult$1.classesDir())).append(" to ").append(newCount).toString(), MODULE$.filter());
            atomicInt = counter;
        }
        return atomicInt;
    }

    private final LastSuccessfulResult getMostRecentSuccessfulResultAtomically$1(CompileDefinitions.BundleInputs inputs$2, ObjectRef counterForUsedClassesDir$1, SuccessfulCompileBundle bundle$2) {
        return this.lastSuccessfulResults().compute(inputs$2.project().uniqueId(), (x$2, previousResultOrNull) -> {
            LastSuccessfulResult previousResult = this.initializeLastSuccessful$1((LastSuccessfulResult)previousResultOrNull, bundle$2, inputs$2);
            MODULE$.currentlyUsedClassesDirs().compute(new AbsolutePath(previousResult.classesDir()), (x$3, counter) -> CompileGatekeeper$.$anonfun$scheduleCompilation$3(counterForUsedClassesDir$1, bundle$2, previousResult, ((AbsolutePath)x$3).underlying(), counter));
            AtomicInt x$1 = (AtomicInt)counterForUsedClassesDir$1.elem;
            Vector<UniqueCompileInputs.HashedSource> x$22 = previousResult.copy$default$1();
            Vector<FileHash> x$32 = previousResult.copy$default$2();
            PreviousResult x$4 = previousResult.copy$default$3();
            Path x$5 = previousResult.copy$default$4();
            Task<BoxedUnit> x$6 = previousResult.copy$default$6();
            return previousResult.copy(x$22, x$32, x$4, x$5, x$1, x$6);
        });
    }

    private final Object cleanUpAfterCompilationError$1(Object result, AtomicBoolean isAlreadyUnsubscribed$1, UniqueCompileInputs oinputs$1) {
        Object object = !isAlreadyUnsubscribed$1.get() ? this.runningCompilations().remove(oinputs$1) : BoxedUnit.UNIT;
        return result;
    }

    private CompileGatekeeper$() {
        MODULE$ = this;
        this.filter = DebugFilter.Compilation$.MODULE$;
        this.currentlyUsedClassesDirs = new ConcurrentHashMap();
        this.runningCompilations = new ConcurrentHashMap();
        this.lastSuccessfulResults = new ConcurrentHashMap();
    }
}

