/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine.tasks;

import bloop.CompileBackgroundTasks;
import bloop.CompileInputs;
import bloop.CompileOutPaths;
import bloop.CompileOutPaths$;
import bloop.CompileProducts;
import bloop.Compiler;
import bloop.Compiler$;
import bloop.CompilerCache;
import bloop.ScalaInstance;
import bloop.cli.CommonOptions;
import bloop.cli.ExitStatus;
import bloop.cli.ExitStatus$;
import bloop.data.ClientInfo;
import bloop.data.Project;
import bloop.data.WorkspaceSettings$;
import bloop.engine.Build;
import bloop.engine.ClientPool;
import bloop.engine.Dag;
import bloop.engine.Dag$;
import bloop.engine.Dag$PreOrder$;
import bloop.engine.ExecutionContext$;
import bloop.engine.Feedback$;
import bloop.engine.State;
import bloop.engine.caches.LastSuccessfulResult;
import bloop.engine.caches.LastSuccessfulResult$;
import bloop.engine.caches.ResultsCache;
import bloop.engine.caches.SourceGeneratorCache;
import bloop.engine.tasks.CompileTask;
import bloop.engine.tasks.compilation.CompileBundle;
import bloop.engine.tasks.compilation.CompileBundle$;
import bloop.engine.tasks.compilation.CompileClientStore;
import bloop.engine.tasks.compilation.CompileDefinitions;
import bloop.engine.tasks.compilation.CompileGraph;
import bloop.engine.tasks.compilation.CompileGraph$;
import bloop.engine.tasks.compilation.CompileSourcesAndInstance;
import bloop.engine.tasks.compilation.CompilerPluginAllowlist$;
import bloop.engine.tasks.compilation.FinalCompileResult;
import bloop.engine.tasks.compilation.FinalNormalCompileResult;
import bloop.engine.tasks.compilation.FinalNormalCompileResult$HasException$;
import bloop.engine.tasks.compilation.PartialCompileResult;
import bloop.engine.tasks.compilation.PartialCompileResult$;
import bloop.engine.tasks.compilation.ResultBundle;
import bloop.engine.tasks.compilation.SuccessfulCompileBundle;
import bloop.internal.build.BuildInfo$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.ParallelOps;
import bloop.io.ParallelOps$;
import bloop.io.Paths$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import bloop.logging.LoggerAction;
import bloop.logging.ObservedLogger;
import bloop.logging.ObservedLogger$;
import bloop.reporter.ObservedReporter;
import bloop.reporter.Reporter;
import bloop.reporter.ReporterAction;
import bloop.reporter.ReporterInputs;
import bloop.reporter.ZincReporter;
import bloop.task.Task;
import bloop.task.Task$;
import bloop.tracing.BraveTracer;
import bloop.tracing.BraveTracer$;
import bloop.tracing.TraceProperties;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import monix.execution.CancelableFuture;
import monix.execution.CancelableFuture$;
import monix.execution.Scheduler;
import monix.reactive.MulticastStrategy$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import monix.reactive.Observer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class CompileTask$ {
    public static CompileTask$ MODULE$;
    private final DebugFilter logContext;

    static {
        new CompileTask$();
    }

    private DebugFilter logContext() {
        return this.logContext;
    }

    public <UseSiteLogger extends Logger> Task<State> compile(State state, Dag<Project> dag, Function1<ReporterInputs<UseSiteLogger>, Reporter> createReporter, boolean pipeline, Promise<BoxedUnit> cancelCompilation, CompileClientStore store, UseSiteLogger rawLogger) {
        return Task$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> {
            String string;
            Path originUri = state.build().origin();
            Path cwd = AbsolutePath$.MODULE$.getParent$extension(originUri);
            String topLevelTargets = Dag$.MODULE$.directDependencies(new .colon.colon((Object)dag, (List)Nil$.MODULE$)).mkString(", ");
            ClientInfo clientInfo = state.client();
            if (clientInfo instanceof ClientInfo.CliClientInfo) {
                ClientInfo.CliClientInfo cliClientInfo = (ClientInfo.CliClientInfo)clientInfo;
                string = cliClientInfo.id();
            } else if (clientInfo instanceof ClientInfo.BspClientInfo) {
                ClientInfo.BspClientInfo bspClientInfo = (ClientInfo.BspClientInfo)clientInfo;
                string = bspClientInfo.uniqueId();
            } else {
                throw new MatchError((Object)clientInfo);
            }
            String clientName = string;
            TraceProperties traceProperties = WorkspaceSettings$.MODULE$.tracePropertiesFrom(state.build().workspaceSettings());
            BraveTracer rootTracer = BraveTracer$.MODULE$.apply(new StringBuilder(23).append("compile ").append(topLevelTargets).append(" (transitively)").toString(), traceProperties, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bloop.version"), (Object)BuildInfo$.MODULE$.version()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zinc.version"), (Object)BuildInfo$.MODULE$.zincVersion()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"build.uri"), (Object)AbsolutePath$.MODULE$.syntax$extension(originUri)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compile.target"), (Object)topLevelTargets), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client"), (Object)clientName)}));
            BraveTracer bgTracer = rootTracer.toIndependentTracer(new StringBuilder(50).append("background IO work after compiling ").append(topLevelTargets).append(" (transitively)").toString(), traceProperties, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bloop.version"), (Object)BuildInfo$.MODULE$.version()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zinc.version"), (Object)BuildInfo$.MODULE$.zincVersion()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"build.uri"), (Object)AbsolutePath$.MODULE$.syntax$extension(originUri)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compile.target"), (Object)topLevelTargets), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client"), (Object)clientName)}));
            ClientInfo client = state.client();
            return CompileGraph$.MODULE$.traverse(dag, client, store, (Function1<CompileDefinitions.BundleInputs, Task<CompileBundle>>)(Function1 & Serializable & scala.Serializable)x$8 -> CompileTask$.setup$1(x$8, pipeline, state, rootTracer, cancelCompilation, rawLogger, createReporter, cwd), (Function1<CompileGraph.Inputs, Task<ResultBundle>>)(Function1 & Serializable & scala.Serializable)x$9 -> CompileTask$.compile$1(x$9, rootTracer, state, cancelCompilation, bgTracer, rawLogger)).flatMap((Function1 & Serializable & scala.Serializable)pdag -> {
                List partialResults = Dag$.MODULE$.dfs(pdag, Dag$PreOrder$.MODULE$);
                List finalResults = (List)partialResults.map((Function1 & Serializable & scala.Serializable)r -> PartialCompileResult$.MODULE$.toFinalResult((PartialCompileResult)r), List$.MODULE$.canBuildFrom());
                return Task$.MODULE$.gatherUnordered((Iterable)finalResults).map((Function1 & Serializable & scala.Serializable)x$10 -> (List)x$10.flatten((Function1)Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)results -> {
                    State state;
                    List<Task<BoxedUnit>> cleanUpTasksToRunInBackground = MODULE$.markUnusedClassesDirAndCollectCleanUpTasks((List<FinalCompileResult>)results, rawLogger);
                    List failures = (List)results.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        FinalCompileResult finalCompileResult = x0$1;
                        if (finalCompileResult instanceof FinalNormalCompileResult) {
                            Compiler.Result$.Success success;
                            FinalNormalCompileResult finalNormalCompileResult = (FinalNormalCompileResult)finalCompileResult;
                            Project p = finalNormalCompileResult.project();
                            ResultBundle results = finalNormalCompileResult.result();
                            Compiler.Result result = results.fromCompiler();
                            Option option = Compiler.Result$.NotOk$.MODULE$.unapply(result);
                            if (!option.isEmpty()) {
                                return new .colon.colon((Object)p, (List)Nil$.MODULE$);
                            }
                            if (result instanceof Compiler.Result$.Success && (success = (Compiler.Result$.Success)result).reportedFatalWarnings()) {
                                return new .colon.colon((Object)p, (List)Nil$.MODULE$);
                            }
                            return Nil$.MODULE$;
                        }
                        return Nil$.MODULE$;
                    }, List$.MODULE$.canBuildFrom());
                    ResultsCache x$1 = state.results().addFinalResults((List<FinalCompileResult>)results);
                    Build x$2 = state.copy$default$1();
                    CompilerCache x$3 = state.copy$default$3();
                    SourceGeneratorCache x$4 = state.copy$default$4();
                    ClientInfo x$5 = state.copy$default$5();
                    ClientPool x$6 = state.copy$default$6();
                    CommonOptions x$7 = state.copy$default$7();
                    ExitStatus x$8 = state.copy$default$8();
                    Logger x$9 = state.copy$default$9();
                    State stateWithResults = state.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9);
                    if (failures.isEmpty()) {
                        ExitStatus x$10 = ExitStatus$.MODULE$.Ok();
                        Build x$11 = stateWithResults.copy$default$1();
                        ResultsCache x$12 = stateWithResults.copy$default$2();
                        CompilerCache x$132 = stateWithResults.copy$default$3();
                        SourceGeneratorCache x$142 = stateWithResults.copy$default$4();
                        ClientInfo x$15 = stateWithResults.copy$default$5();
                        ClientPool x$16 = stateWithResults.copy$default$6();
                        CommonOptions x$17 = stateWithResults.copy$default$7();
                        Logger x$18 = stateWithResults.copy$default$9();
                        state = stateWithResults.copy(x$11, x$12, x$132, x$142, x$15, x$16, x$17, x$10, x$18);
                    } else {
                        results.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            CompileTask$.$anonfun$compile$23(rawLogger, x0$2);
                            return BoxedUnit.UNIT;
                        });
                        ClientInfo clientInfo = client;
                        if (clientInfo instanceof ClientInfo.CliClientInfo) {
                            List projectsFailedToCompile = ((List)failures.map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(2).append("'").append(p.name()).append("'").toString(), List$.MODULE$.canBuildFrom())).reverse();
                            String failureMessage = failures.size() <= 2 ? projectsFailedToCompile.mkString(",") : new StringBuilder(19).append(projectsFailedToCompile.take(2).mkString(", ")).append(" and ").append(projectsFailedToCompile.size() - 2).append(" more projects").toString();
                            rawLogger.error(new StringBuilder(18).append("Failed to compile ").append(failureMessage).toString());
                        } else if (clientInfo instanceof ClientInfo.BspClientInfo) {
                        } else {
                            throw new MatchError((Object)clientInfo);
                        }
                        ExitStatus x$19 = ExitStatus$.MODULE$.CompilationError();
                        Build x$20 = stateWithResults.copy$default$1();
                        ResultsCache x$21 = stateWithResults.copy$default$2();
                        CompilerCache x$22 = stateWithResults.copy$default$3();
                        SourceGeneratorCache x$23 = stateWithResults.copy$default$4();
                        ClientInfo x$24 = stateWithResults.copy$default$5();
                        ClientPool x$25 = stateWithResults.copy$default$6();
                        CommonOptions x$26 = stateWithResults.copy$default$7();
                        Logger x$27 = stateWithResults.copy$default$9();
                        state = stateWithResults.copy(x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$19, x$27);
                    }
                    State newState = state;
                    MODULE$.runIOTasksInParallel((Traversable)cleanUpTasksToRunInBackground, MODULE$.runIOTasksInParallel$default$2());
                    Task runningTasksRequiredForCorrectness = Task$.MODULE$.sequence((Iterable)results.flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        FinalCompileResult finalCompileResult = x0$3;
                        if (finalCompileResult instanceof FinalNormalCompileResult) {
                            FinalNormalCompileResult finalNormalCompileResult = (FinalNormalCompileResult)finalCompileResult;
                            ResultBundle result = finalNormalCompileResult.result();
                            Task tasksAtEndOfBuildCompilation = Task$.MODULE$.fromFuture(result.runningBackgroundTasks());
                            return new .colon.colon((Object)tasksAtEndOfBuildCompilation, (List)Nil$.MODULE$);
                        }
                        return Nil$.MODULE$;
                    }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
                    return runningTasksRequiredForCorrectness.executeOn(ExecutionContext$.MODULE$.ioScheduler(), runningTasksRequiredForCorrectness.executeOn$default$2()).map((Function1 & Serializable & scala.Serializable)x$13 -> newState).doOnFinish((Function1 & Serializable & scala.Serializable)x$14 -> Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> rootTracer.terminate()));
                });
            });
        });
    }

    private CompileTask.ConfiguredCompilation configureCompilation(Project project) {
        return new CompileTask.ConfiguredCompilation(project.scalacOptions());
    }

    private Task<BoxedUnit> populateNewReadOnlyClassesDir(CompileProducts products, BraveTracer tracer, Logger logger) {
        Path path = products.readOnlyClassesDir();
        Path path2 = products.newClassesDir();
        if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
            logger.warn(new StringBuilder(52).append("Running `populateNewReadOnlyClassesDir` on same dir ").append(products.newClassesDir()).toString());
            return Task$.MODULE$.unit();
        }
        Set denylist = products.invalidatedCompileProducts().iterator().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.toPath()).toSet();
        ParallelOps.CopyConfiguration config = ParallelOps.CopyConfiguration$.MODULE$.apply(5, (ParallelOps.CopyMode)ParallelOps.CopyMode$.NoReplace$.MODULE$, denylist);
        Task task = tracer.traceTaskVerbose("preparing new read-only classes directory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$16 -> ParallelOps$.MODULE$.copyDirectories(config, products.readOnlyClassesDir(), products.newClassesDir(), ExecutionContext$.MODULE$.ioScheduler(), false));
        return task.map((Function1 & Serializable & scala.Serializable)x$17 -> {
            CompileTask$.$anonfun$populateNewReadOnlyClassesDir$3(x$17);
            return BoxedUnit.UNIT;
        }).memoize();
    }

    private List<Task<BoxedUnit>> markUnusedClassesDirAndCollectCleanUpTasks(List<FinalCompileResult> results, Logger logger) {
        ListBuffer cleanUpTasksToSpawnInBackground = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        results.foreach((Function1 & Serializable & scala.Serializable)finalResult -> {
            Task task;
            ResultBundle resultBundle = finalResult.result();
            Option<LastSuccessfulResult> newSuccessful = resultBundle.successful();
            Compiler.Result compilerResult = resultBundle.fromCompiler();
            Task populateNewProductsTask = (Task)newSuccessful.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.populatingProducts()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Task$.MODULE$.unit());
            Option<LastSuccessfulResult> option = resultBundle.previous();
            if (None$.MODULE$.equals(option)) {
                task = populateNewProductsTask;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                LastSuccessfulResult previousSuccessful = (LastSuccessfulResult)some.value();
                task = previousSuccessful.populatingProducts().flatMap((Function1 & Serializable & scala.Serializable)_ -> populateNewProductsTask.flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.cleanUpPreviousResult(previousSuccessful, compilerResult, logger).map((Function1 & Serializable & scala.Serializable)_ -> {
                    CompileTask$.$anonfun$markUnusedClassesDirAndCollectCleanUpTasks$6(_);
                    return BoxedUnit.UNIT;
                })));
            } else {
                throw new MatchError(option);
            }
            Task cleanUpPreviousLastSuccessful = task;
            return cleanUpTasksToSpawnInBackground.$plus$eq((Object)cleanUpPreviousLastSuccessful);
        });
        return cleanUpTasksToSpawnInBackground.toList();
    }

    public <T> void runIOTasksInParallel(Traversable<Task<T>> tasks, int parallelUnits) {
        Task aggregatedTask = Task$.MODULE$.sequence((Iterable)tasks.toList().grouped(parallelUnits).map((Function1 & Serializable & scala.Serializable)group -> Task$.MODULE$.gatherUnordered((Iterable)group)).toList(), List$.MODULE$.canBuildFrom());
        aggregatedTask.map((Function1 & Serializable & scala.Serializable)x$19 -> {
            CompileTask$.$anonfun$runIOTasksInParallel$2(x$19);
            return BoxedUnit.UNIT;
        }).runAsync(ExecutionContext$.MODULE$.ioScheduler());
    }

    public <T> int runIOTasksInParallel$default$2() {
        return Runtime.getRuntime().availableProcessors();
    }

    private Task<BoxedUnit> cleanUpPreviousResult(LastSuccessfulResult previousSuccessful, Compiler.Result compilerResult, Logger logger) {
        None$ previousReadOnlyToDelete;
        None$ none$;
        Path previousClassesDir = previousSuccessful.classesDir();
        int currentlyUsedCounter = previousSuccessful.counterForClassesDir().decrementAndGet(1);
        Compiler.Result result = compilerResult;
        if (result instanceof Compiler.Result$.Success) {
            Compiler.Result$.Success success = (Compiler.Result$.Success)result;
            CompileProducts products = success.products();
            boolean isNoOp = success.isNoOp();
            if (isNoOp) {
                logger.debug(new StringBuilder(48).append("Skipping delete of ").append(new AbsolutePath(previousClassesDir)).append(" associated with no-op result").toString(), this.logContext());
                none$ = None$.MODULE$;
            } else if (CompileOutPaths$.MODULE$.hasEmptyClassesDir(previousClassesDir)) {
                logger.debug(new StringBuilder(37).append("Skipping delete of empty classes dir ").append(new AbsolutePath(previousClassesDir)).toString(), this.logContext());
                none$ = None$.MODULE$;
            } else if (currentlyUsedCounter != 0) {
                logger.debug(new StringBuilder(32).append("Skipping delete of ").append(new AbsolutePath(previousClassesDir)).append(", counter is ").append(currentlyUsedCounter).toString(), this.logContext());
                none$ = None$.MODULE$;
            } else {
                Path newClassesDir = products.newClassesDir();
                logger.debug(new StringBuilder(36).append("Scheduling to delete ").append(new AbsolutePath(previousClassesDir)).append(" superseded by ").append(newClassesDir).toString(), this.logContext());
                none$ = new Some((Object)new AbsolutePath(previousClassesDir));
            }
        } else {
            none$ = None$.MODULE$;
        }
        None$ none$2 = previousReadOnlyToDelete = none$;
        if (None$.MODULE$.equals(none$2)) {
            return Task$.MODULE$.unit();
        }
        if (none$2 instanceof Some) {
            Some some = (Some)none$2;
            Path classesDir = ((AbsolutePath)some.value()).underlying();
            return Task$.MODULE$.eval((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                logger.debug(new StringBuilder(32).append("Deleting contents of orphan dir ").append(new AbsolutePath(classesDir)).toString(), MODULE$.logContext());
                Paths$.MODULE$.delete(classesDir);
            }).asyncBoundary();
        }
        throw new MatchError((Object)none$2);
    }

    public static final /* synthetic */ void $anonfun$compile$2(Project project$1, ObservedLogger logger$1, List missing) {
        Feedback$.MODULE$.detectMissingDependencies(project$1.name(), (List<String>)missing).foreach((Function1 & Serializable & scala.Serializable)msg -> {
            logger$1.warn(msg);
            return BoxedUnit.UNIT;
        });
    }

    private static final CancelableFuture runPostCompilationTasks$1(CompileBackgroundTasks backgroundTasks, Path externalUserClassesDir$1, ObservedReporter reporter$1, BraveTracer compileProjectTracer$1, ObservedLogger logger$1) {
        Task postCompilationTasks = backgroundTasks.trigger(externalUserClassesDir$1, reporter$1.underlying(), compileProjectTracer$1, (Logger)logger$1).doOnFinish((Function1 & Serializable & scala.Serializable)x$4 -> Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> compileProjectTracer$1.terminate()));
        return postCompilationTasks.runAsync(ExecutionContext$.MODULE$.ioScheduler());
    }

    public static final /* synthetic */ void $anonfun$compile$15(BoxedUnit _) {
    }

    private static final Task compile$1(CompileGraph.Inputs graphInputs, BraveTracer rootTracer$1, State state$1, Promise cancelCompilation$1, BraveTracer bgTracer$1, Logger rawLogger$1) {
        Right right;
        CompileSourcesAndInstance compileSourcesAndInstance;
        SuccessfulCompileBundle bundle = graphInputs.bundle();
        Project project = bundle.project();
        ObservedLogger<Logger> logger = bundle.logger();
        ObservedReporter reporter = bundle.reporter();
        Compiler.Result previousResult = bundle.latestResult();
        CompileOutPaths compileOut = bundle.out();
        LastSuccessfulResult lastSuccessful = bundle.lastSuccessful();
        BraveTracer compileProjectTracer = rootTracer$1.startNewChildTracer(new StringBuilder(8).append("compile ").append(project.name()).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compile.target"), (Object)project.name())}));
        Either<ResultBundle, CompileSourcesAndInstance> either = bundle.prepareSourcesAndInstance();
        if (either instanceof Left) {
            Left left = (Left)either;
            ResultBundle earlyResultBundle = (ResultBundle)left.value();
            compileProjectTracer.terminate();
            return Task$.MODULE$.now((Object)earlyResultBundle);
        }
        if (either instanceof Right && (compileSourcesAndInstance = (CompileSourcesAndInstance)(right = (Right)either).value()) != null) {
            List<AbsolutePath> sources = compileSourcesAndInstance.sources();
            ScalaInstance instance = compileSourcesAndInstance.instance();
            Path externalUserClassesDir = bundle.clientClassesDir();
            Path readOnlyClassesDir = lastSuccessful.classesDir();
            Path newClassesDir = compileOut.internalNewClassesDir();
            AbsolutePath[] classpath = bundle.dependenciesData().buildFullCompileClasspathFor(project, readOnlyClassesDir, newClassesDir);
            state$1.build().hasMissingDependencies(project).foreach((Function1 & Serializable & scala.Serializable)missing -> {
                CompileTask$.$anonfun$compile$2(project, logger, missing);
                return BoxedUnit.UNIT;
            });
            CompileTask.ConfiguredCompilation configuration = MODULE$.configureCompilation(project);
            Task<List<String>> newScalacOptions2 = CompilerPluginAllowlist$.MODULE$.enableCachingInScalacOptions(instance.version(), configuration.scalacOptions(), (Logger)logger, compileProjectTracer, 5);
            Task inputs = newScalacOptions2.map((Function1 & Serializable & scala.Serializable)newScalacOptions -> new CompileInputs(instance, state$1.compilerCache(), (AbsolutePath[])sources.toArray(ClassTag$.MODULE$.apply(AbsolutePath.class)), classpath, bundle.uniqueInputs(), compileOut, project.out(), (String[])newScalacOptions.toArray(ClassTag$.MODULE$.apply(String.class)), (String[])project.javacOptions().toArray(ClassTag$.MODULE$.apply(String.class)), project.compileJdkConfig().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.javacBin()), project.compileOrder(), project.classpathOptions(), lastSuccessful.previous(), previousResult, (ZincReporter)reporter, logger, graphInputs.dependentResults(), cancelCompilation$1, compileProjectTracer, ExecutionContext$.MODULE$.ioScheduler(), (Executor)ExecutionContext$.MODULE$.ioExecutor(), bundle.dependenciesData().allInvalidatedClassFiles(), bundle.dependenciesData().allGeneratedClassFilePaths()));
            Task waitOnReadClassesDir = compileProjectTracer.traceTaskVerbose("wait on populating products", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$2 -> lastSuccessful.populatingProducts());
            return waitOnReadClassesDir.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> inputs.flatMap((Function1 & Serializable & scala.Serializable)inputs -> Compiler$.MODULE$.compile(inputs)).map((Function1 & Serializable & scala.Serializable)result -> {
                Compiler.Result result2 = result;
                if (result2 instanceof Compiler.Result$.Success) {
                    Compiler.Result$.Success success = (Compiler.Result$.Success)result2;
                    CancelableFuture runningTasks = CompileTask$.runPostCompilationTasks$1(success.backgroundTasks(), externalUserClassesDir, reporter, compileProjectTracer, logger);
                    Task qual$1 = Task$.MODULE$.fromFuture((Future)runningTasks);
                    Scheduler x$1 = ExecutionContext$.MODULE$.ioScheduler();
                    boolean x$2 = qual$1.executeOn$default$2();
                    Task blockingOnRunningTasks = qual$1.executeOn(x$1, x$2);
                    Task populatingTask = success.isNoOp() ? blockingOnRunningTasks : blockingOnRunningTasks.flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.populateNewReadOnlyClassesDir(success.products(), bgTracer$1, rawLogger$1).doOnFinish((Function1 & Serializable & scala.Serializable)x$5 -> Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> bgTracer$1.terminate())).map((Function1 & Serializable & scala.Serializable)_ -> {
                        CompileTask$.$anonfun$compile$15(_);
                        return BoxedUnit.UNIT;
                    }));
                    LastSuccessfulResult newSuccessful = LastSuccessfulResult$.MODULE$.apply(bundle.uniqueInputs(), success.products(), (Task<BoxedUnit>)populatingTask.memoize());
                    return new ResultBundle((Compiler.Result)success, (Option<LastSuccessfulResult>)new Some((Object)newSuccessful), (Option<LastSuccessfulResult>)new Some((Object)lastSuccessful), (CancelableFuture<BoxedUnit>)runningTasks);
                }
                if (result2 instanceof Compiler.Result.Failed) {
                    Compiler.Result.Failed failed = (Compiler.Result.Failed)result2;
                    CancelableFuture runningTasks = CompileTask$.runPostCompilationTasks$1(failed.backgroundTasks(), externalUserClassesDir, reporter, compileProjectTracer, logger);
                    return new ResultBundle((Compiler.Result)result, (Option<LastSuccessfulResult>)None$.MODULE$, (Option<LastSuccessfulResult>)new Some((Object)lastSuccessful), (CancelableFuture<BoxedUnit>)runningTasks);
                }
                if (result2 instanceof Compiler.Result$.Cancelled) {
                    Compiler.Result$.Cancelled cancelled = (Compiler.Result$.Cancelled)result2;
                    CancelableFuture runningTasks = CompileTask$.runPostCompilationTasks$1(cancelled.backgroundTasks(), externalUserClassesDir, reporter, compileProjectTracer, logger);
                    return new ResultBundle((Compiler.Result)result, (Option<LastSuccessfulResult>)None$.MODULE$, (Option<LastSuccessfulResult>)new Some((Object)lastSuccessful), (CancelableFuture<BoxedUnit>)runningTasks);
                }
                if (result2 instanceof Compiler.Result$.Blocked ? true : (Compiler.Result$.Empty$.MODULE$.equals(result2) ? true : result2 instanceof Compiler.Result$.GlobalError)) {
                    return new ResultBundle((Compiler.Result)result, (Option<LastSuccessfulResult>)None$.MODULE$, (Option<LastSuccessfulResult>)None$.MODULE$, (CancelableFuture<BoxedUnit>)CancelableFuture$.MODULE$.unit());
                }
                throw new MatchError((Object)result2);
            }));
        }
        throw new MatchError(either);
    }

    private static final Task setup$1(CompileDefinitions.BundleInputs inputs, boolean pipeline$1, State state$1, BraveTracer rootTracer$1, Promise cancelCompilation$1, Logger rawLogger$1, Function1 createReporter$1, Path cwd$1) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        Tuple2 tuple23 = Observable$.MODULE$.multicast(MulticastStrategy$.MODULE$.replay(), ExecutionContext$.MODULE$.ioScheduler());
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Observer.Sync observer = (Observer.Sync)tuple23._1();
        Observable obs = (Observable)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)observer, (Object)obs);
        Observer.Sync observer2 = (Observer.Sync)tuple24._1();
        Observable obs2 = (Observable)tuple24._2();
        if (pipeline$1) {
            LastSuccessfulResult emptySuccessful = LastSuccessfulResult$.MODULE$.empty(inputs.project());
            tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Compiler.Result$.Empty$.MODULE$), (Object)emptySuccessful);
        } else {
            Compiler.Result latestResult = state$1.results().latestResult(inputs.project());
            LastSuccessfulResult lastSuccessful = state$1.results().lastSuccessfulResultOrEmpty(inputs.project());
            tuple22 = tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)latestResult), (Object)lastSuccessful);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Compiler.Result prev = (Compiler.Result)tuple2._1();
        LastSuccessfulResult last = (LastSuccessfulResult)tuple2._2();
        Tuple2 tuple25 = new Tuple2((Object)prev, (Object)last);
        Compiler.Result prev2 = (Compiler.Result)tuple25._1();
        LastSuccessfulResult last2 = (LastSuccessfulResult)tuple25._2();
        BraveTracer t = rootTracer$1;
        CommonOptions o = state$1.commonOptions();
        Promise cancel = cancelCompilation$1;
        ObservedLogger logger = ObservedLogger$.MODULE$.apply(rawLogger$1, (Observer)observer2);
        Path dir = state$1.client().getUniqueClassesDirFor(inputs.project(), true);
        Reporter underlying = (Reporter)createReporter$1.apply(new ReporterInputs<Logger>(inputs.project(), cwd$1, rawLogger$1));
        ObservedReporter reporter = new ObservedReporter(logger, underlying);
        SourceGeneratorCache sourceGeneratorCache = state$1.sourceGeneratorCache();
        return CompileBundle$.MODULE$.computeFrom(inputs, sourceGeneratorCache, dir, reporter, last2, prev2, (Promise<BoxedUnit>)cancel, (ObservedLogger<Logger>)logger, (Observable<Either<ReporterAction, LoggerAction>>)obs2, t, o);
    }

    public static final /* synthetic */ void $anonfun$compile$23(Logger rawLogger$1, FinalCompileResult x0$2) {
        FinalNormalCompileResult finalNormalCompileResult;
        Option<Tuple2<Project, Either<String, Throwable>>> option;
        FinalCompileResult finalCompileResult = x0$2;
        if (finalCompileResult instanceof FinalNormalCompileResult && !(option = FinalNormalCompileResult$HasException$.MODULE$.unapply(finalNormalCompileResult = (FinalNormalCompileResult)finalCompileResult)).isEmpty()) {
            Project project = (Project)((Tuple2)option.get())._1();
            Either err = (Either)((Tuple2)option.get())._2();
            String errMsg = (String)err.fold((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x), (Function1 & Serializable & scala.Serializable)x$11 -> x$11.getMessage());
            rawLogger$1.error(new StringBuilder(36).append("Unexpected error when compiling ").append(project.name()).append(": '").append(errMsg).append("'").toString());
            err.foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
                rawLogger$1.trace(x$12);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$populateNewReadOnlyClassesDir$3(ParallelOps.FileWalk x$17) {
    }

    public static final /* synthetic */ void $anonfun$markUnusedClassesDirAndCollectCleanUpTasks$6(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$runIOTasksInParallel$2(List x$19) {
    }

    private CompileTask$() {
        MODULE$ = this;
        this.logContext = DebugFilter.Compilation$.MODULE$;
    }
}

