/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine.caches;

import bloop.CompilerCache;
import bloop.cli.CommonOptions;
import bloop.cli.ExitStatus$;
import bloop.data.ClientInfo;
import bloop.data.LoadedProject;
import bloop.data.WorkspaceSettings;
import bloop.data.WorkspaceSettings$;
import bloop.engine.Build;
import bloop.engine.Build$;
import bloop.engine.Build$ReturnPreviousState$;
import bloop.engine.BuildLoader$;
import bloop.engine.ClientPool;
import bloop.engine.State;
import bloop.engine.State$;
import bloop.engine.caches.ResultsCache;
import bloop.engine.caches.SourceGeneratorCache;
import bloop.engine.caches.StateCache$;
import bloop.engine.caches.StateCache$CachedState$;
import bloop.io.AbsolutePath;
import bloop.logging.Logger;
import bloop.task.Task;
import bloop.task.Task$;
import bloop.util.Environment$;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tMc\u0001\u0002\u0016,\u0005IB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0007!\u0002!\t!!2\t\u000f\u0005%\u0007\u0001\"\u0001\u0002L\"A!Q\u0002\u0001\u0005\u0002=\u0012y\u0001C\u0004\u0003\u0016\u0001!\tAa\u0006\t\u000f\tm\u0001\u0001\"\u0001\u0003\u001e!9!\u0011\u0005\u0001\u0005\u0002\t\rr!B',\u0011\u0003qe!\u0002\u0016,\u0011\u0003y\u0005\"\u0002)\n\t\u0003\tf!\u0002*\n\u0001&\u0019\u0006\u0002\u0003.\f\u0005+\u0007I\u0011A.\t\u0011\u0001\\!\u0011#Q\u0001\nqC\u0001\"Y\u0006\u0003\u0016\u0004%\tA\u0019\u0005\tM.\u0011\t\u0012)A\u0005G\"Aqm\u0003BK\u0002\u0013\u0005\u0001\u000e\u0003\u0005n\u0017\tE\t\u0015!\u0003j\u0011!q7B!f\u0001\n\u0003y\u0007\u0002C:\f\u0005#\u0005\u000b\u0011\u00029\t\u000bA[A\u0011\u0001;\t\u000fm\\\u0011\u0011!C\u0001y\"I\u00111A\u0006\u0012\u0002\u0013\u0005\u0011Q\u0001\u0005\n\u00037Y\u0011\u0013!C\u0001\u0003;A\u0011\"!\t\f#\u0003%\t!a\t\t\u0013\u0005\u001d2\"%A\u0005\u0002\u0005%\u0002\"CA\u0017\u0017\u0005\u0005I\u0011IA\u0018\u0011%\tidCA\u0001\n\u0003\ty\u0004C\u0005\u0002H-\t\t\u0011\"\u0001\u0002J!I\u0011QK\u0006\u0002\u0002\u0013\u0005\u0013q\u000b\u0005\n\u0003KZ\u0011\u0011!C\u0001\u0003OB\u0011\"!\u001d\f\u0003\u0003%\t%a\u001d\t\u0013\u0005U4\"!A\u0005B\u0005]\u0004\"CA=\u0017\u0005\u0005I\u0011IA>\u000f!\ty(\u0003E\u0001\u0013\u0005\u0005ea\u0002*\n\u0011\u0003I\u00111\u0011\u0005\u0007!\u000e\"\t!!\"\t\u000f\u0005\u001d5\u0005\"\u0001\u0002\n\"I\u0011QS\u0012\u0002\u0002\u0013\u0005\u0015q\u0013\u0005\n\u0003C\u001b\u0013\u0011!CA\u0003GC\u0011\"!.$\u0003\u0003%I!a.\t\u000f\u0005}\u0016\u0002\"\u0001\u0002B\nQ1\u000b^1uK\u000e\u000b7\r[3\u000b\u00051j\u0013AB2bG\",7O\u0003\u0002/_\u00051QM\\4j]\u0016T\u0011\u0001M\u0001\u0006E2|w\u000e]\u0002\u0001'\t\u00011\u0007\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATG\u0001\u0004B]f\u0014VMZ\u0001\u0006G\u0006\u001c\u0007.\u001a\t\u0005w\t#%*D\u0001=\u0015\tid(\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u0010!\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0003\u0006!!.\u0019<b\u0013\t\u0019EHA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004\"!\u0012%\u000e\u0003\u0019S!aR\u0018\u0002\u0005%|\u0017BA%G\u00051\t%m]8mkR,\u0007+\u0019;i!\tY5B\u0004\u0002M\u00115\t1&\u0001\u0006Ti\u0006$XmQ1dQ\u0016\u0004\"\u0001T\u0005\u0014\u0005%\u0019\u0014A\u0002\u001fj]&$h\bF\u0001O\u0005-\u0019\u0015m\u00195fIN#\u0018\r^3\u0014\t-\u0019Dk\u0016\t\u0003iUK!AV\u001b\u0003\u000fA\u0013x\u000eZ;diB\u0011A\u0007W\u0005\u00033V\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fQAY;jY\u0012,\u0012\u0001\u0018\t\u0003;zk\u0011!L\u0005\u0003?6\u0012QAQ;jY\u0012\faAY;jY\u0012\u0004\u0013a\u0002:fgVdGo]\u000b\u0002GB\u0011A\nZ\u0005\u0003K.\u0012ABU3tk2$8oQ1dQ\u0016\f\u0001B]3tk2$8\u000fI\u0001\u000eG>l\u0007/\u001b7fe\u000e\u000b7\r[3\u0016\u0003%\u0004\"A[6\u000e\u0003=J!\u0001\\\u0018\u0003\u001b\r{W\u000e]5mKJ\u001c\u0015m\u00195f\u00039\u0019w.\u001c9jY\u0016\u00148)Y2iK\u0002\nAc]8ve\u000e,w)\u001a8fe\u0006$xN]\"bG\",W#\u00019\u0011\u00051\u000b\u0018B\u0001:,\u0005Q\u0019v.\u001e:dK\u001e+g.\u001a:bi>\u00148)Y2iK\u0006)2o\\;sG\u0016<UM\\3sCR|'oQ1dQ\u0016\u0004C#B;xqfT\bC\u0001<\f\u001b\u0005I\u0001\"\u0002.\u0015\u0001\u0004a\u0006\"B1\u0015\u0001\u0004\u0019\u0007\"B4\u0015\u0001\u0004I\u0007\"\u00028\u0015\u0001\u0004\u0001\u0018\u0001B2paf$b!^?\u007f\u007f\u0006\u0005\u0001b\u0002.\u0016!\u0003\u0005\r\u0001\u0018\u0005\bCV\u0001\n\u00111\u0001d\u0011\u001d9W\u0003%AA\u0002%DqA\\\u000b\u0011\u0002\u0003\u0007\u0001/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d!f\u0001/\u0002\n-\u0012\u00111\u0002\t\u0005\u0003\u001b\t9\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0016U\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI\"a\u0004\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005}!fA2\u0002\n\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA\u0013U\rI\u0017\u0011B\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\tYCK\u0002q\u0003\u0013\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0019!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001c\u0001\u0006!A.\u00198h\u0013\u0011\tY$!\u000e\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t\u0005E\u00025\u0003\u0007J1!!\u00126\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tY%!\u0015\u0011\u0007Q\ni%C\u0002\u0002PU\u00121!\u00118z\u0011%\t\u0019\u0006HA\u0001\u0002\u0004\t\t%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00033\u0002b!a\u0017\u0002b\u0005-SBAA/\u0015\r\ty&N\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA2\u0003;\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011NA8!\r!\u00141N\u0005\u0004\u0003[*$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003'r\u0012\u0011!a\u0001\u0003\u0017\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u0003\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003c\ta!Z9vC2\u001cH\u0003BA5\u0003{B\u0011\"a\u0015\"\u0003\u0003\u0005\r!a\u0013\u0002\u0017\r\u000b7\r[3e'R\fG/\u001a\t\u0003m\u000e\u001a2aI\u001aX)\t\t\t)A\u0005ge>l7\u000b^1uKR\u0019Q/a#\t\u000f\u00055U\u00051\u0001\u0002\u0010\u0006)1\u000f^1uKB\u0019Q,!%\n\u0007\u0005MUFA\u0003Ti\u0006$X-A\u0003baBd\u0017\u0010F\u0005v\u00033\u000bY*!(\u0002 \")!L\na\u00019\")\u0011M\na\u0001G\")qM\na\u0001S\")aN\na\u0001a\u00069QO\\1qa2LH\u0003BAS\u0003c\u0003R\u0001NAT\u0003WK1!!+6\u0005\u0019y\u0005\u000f^5p]B9A'!,]G&\u0004\u0018bAAXk\t1A+\u001e9mKRB\u0001\"a-(\u0003\u0003\u0005\r!^\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!/\u0011\t\u0005M\u00121X\u0005\u0005\u0003{\u000b)D\u0001\u0004PE*,7\r^\u0001\u0006K6\u0004H/_\u000b\u0003\u0003\u0007\u0004\"\u0001\u0014\u0001\u0015\t\u0005\r\u0017q\u0019\u0005\u0006s\t\u0001\rAO\u0001\fO\u0016$8\u000b^1uK\u001a{'\u000f\u0006\u0007\u0002N\u0006=\u00171[Ar\u0003[\fi\u0010E\u00035\u0003O\u000by\t\u0003\u0004\u0002R\u000e\u0001\r\u0001R\u0001\u0005a\u0006$\b\u000eC\u0004\u0002V\u000e\u0001\r!a6\u0002\r\rd\u0017.\u001a8u!\u0011\tI.a8\u000e\u0005\u0005m'bAAo_\u0005!A-\u0019;b\u0013\u0011\t\t/a7\u0003\u0015\rc\u0017.\u001a8u\u0013:4w\u000eC\u0004\u0002f\u000e\u0001\r!a:\u0002\tA|w\u000e\u001c\t\u0004;\u0006%\u0018bAAv[\tQ1\t\\5f]R\u0004vn\u001c7\t\u000f\u0005=8\u00011\u0001\u0002r\u0006i1m\\7n_:|\u0005\u000f^5p]N\u0004B!a=\u0002z6\u0011\u0011Q\u001f\u0006\u0004\u0003o|\u0013aA2mS&!\u00111`A{\u00055\u0019u.\\7p]>\u0003H/[8og\"9\u0011q`\u0002A\u0002\t\u0005\u0011A\u00027pO\u001e,'\u000f\u0005\u0003\u0003\u0004\t%QB\u0001B\u0003\u0015\r\u00119aL\u0001\bY><w-\u001b8h\u0013\u0011\u0011YA!\u0002\u0003\r1{wmZ3s\u0003Q9W\r\u001e*bo\u000e\u000b7\r[3e\u0005VLG\u000e\u001a$peR!!\u0011\u0003B\n!\u0011!\u0014q\u0015/\t\r\u0005EG\u00011\u0001E\u0003M9W\r^+qI\u0006$X\rZ*uCR,gI]8n)\u0011\tiM!\u0007\t\u000f\u00055U\u00011\u0001\u0002\u0010\u0006YQ\u000f\u001d3bi\u0016\u0014U/\u001b7e)\u0011\tyIa\b\t\u000f\u00055e\u00011\u0001\u0002\u0010\u0006IAn\\1e'R\fG/\u001a\u000b\u0011\u0005K\u0011\tD!\u000e\u00038\te\"1\bB\u001f\u0005\u000f\u0002bAa\n\u0003.\u0005=UB\u0001B\u0015\u0015\r\u0011YcL\u0001\u0005i\u0006\u001c8.\u0003\u0003\u00030\t%\"\u0001\u0002+bg.DaAa\r\b\u0001\u0004!\u0015\u0001\u00024s_6Dq!!6\b\u0001\u0004\t9\u000eC\u0004\u0002f\u001e\u0001\r!a:\t\u000f\u0005=x\u00011\u0001\u0002r\"9\u0011q`\u0004A\u0002\t\u0005\u0001b\u0002B \u000f\u0001\u0007!\u0011I\u0001\fGJ,\u0017\r^3Ti\u0006$X\r\u0005\u00045\u0005\u0007b\u0016qR\u0005\u0004\u0005\u000b*$!\u0003$v]\u000e$\u0018n\u001c82\u0011\u001d\u0011Ie\u0002a\u0001\u0005\u0017\nab\u00197jK:$8+\u001a;uS:<7\u000fE\u00035\u0003O\u0013i\u0005\u0005\u0003\u0002Z\n=\u0013\u0002\u0002B)\u00037\u0014\u0011cV8sWN\u0004\u0018mY3TKR$\u0018N\\4t\u0001")
public final class StateCache {
    private final ConcurrentHashMap<AbsolutePath, CachedState> cache;

    public static StateCache empty() {
        return StateCache$.MODULE$.empty();
    }

    public Option<State> getStateFor(Path path, ClientInfo client, ClientPool pool, CommonOptions commonOptions, Logger logger) {
        return Option$.MODULE$.apply((Object)this.cache.get(new AbsolutePath(path))).map((Function1 & Serializable & scala.Serializable)cachedState -> State$.MODULE$.apply(cachedState.build(), cachedState.results(), cachedState.compilerCache(), cachedState.sourceGeneratorCache(), client, pool, commonOptions, ExitStatus$.MODULE$.Ok(), logger));
    }

    public Option<Build> getRawCachedBuildFor(Path path) {
        return Option$.MODULE$.apply((Object)this.cache.get(new AbsolutePath(path))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.build());
    }

    public Option<State> getUpdatedStateFrom(State state) {
        return this.getStateFor(state.build().origin(), state.client(), state.pool(), state.commonOptions(), state.logger());
    }

    public State updateBuild(State state) {
        this.cache.put(new AbsolutePath(state.build().origin()), StateCache$CachedState$.MODULE$.fromState(state));
        return state;
    }

    public Task<State> loadState(Path from, ClientInfo client, ClientPool pool, CommonOptions commonOptions, Logger logger, Function1<Build, State> createState, Option<WorkspaceSettings> clientSettings) {
        Build empty = Build$.MODULE$.apply(from, (List<LoadedProject>)Nil$.MODULE$, (Option<WorkspaceSettings>)None$.MODULE$);
        Path path = from;
        Path path2 = Environment$.MODULE$.defaultBloopDirectory();
        if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
            return Task$.MODULE$.now(createState.apply((Object)empty));
        }
        Option<State> previousState = this.getStateFor(from, client, pool, commonOptions, logger);
        Build build = (Build)previousState.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.build()).getOrElse((Function0 & Serializable & scala.Serializable)() -> empty);
        return build.checkForChange(clientSettings, logger).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Build.ReloadAction reloadAction = x0$1;
            if (Build$ReturnPreviousState$.MODULE$.equals(reloadAction)) {
                return Task$.MODULE$.now(previousState.getOrElse((Function0 & Serializable & scala.Serializable)() -> (State)createState.apply((Object)empty)));
            }
            if (reloadAction instanceof Build.UpdateState) {
                Build.UpdateState updateState = (Build.UpdateState)reloadAction;
                List<Build.ReadConfiguration> created = updateState.created();
                List<Build.ReadConfiguration> modified = updateState.modified();
                List<AbsolutePath> deleted = updateState.deleted();
                List<Build.InvalidatedInMemoryProject> changed = updateState.invalidated();
                Option<WorkspaceSettings> settings2 = updateState.settingsForReload();
                boolean writeSettings = updateState.writeSettingsToDisk();
                if (writeSettings) {
                    settings2.foreach((Function1 & Serializable & scala.Serializable)settings -> {
                        AbsolutePath absolutePath;
                        try {
                            absolutePath = new AbsolutePath(WorkspaceSettings$.MODULE$.writeToFile(from, (WorkspaceSettings)settings, logger));
                        }
                        catch (Throwable e) {
                            logger.displayWarningToUser(new StringBuilder(36).append("Failed to write workspace settings: ").append(e.getMessage()).toString());
                            logger.trace(e);
                            absolutePath = BoxedUnit.UNIT;
                        }
                        return absolutePath;
                    });
                }
                List createdOrModified = (List)created.$plus$plus(modified, List$.MODULE$.canBuildFrom());
                return BuildLoader$.MODULE$.loadBuildIncrementally(from, (List<Build.ReadConfiguration>)createdOrModified, changed, settings2, logger).map((Function1 & Serializable & scala.Serializable)newProjects -> {
                    State state;
                    Option option = previousState;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        State state2 = (State)some.value();
                        List<LoadedProject> currentProjects = state2.build().loadedProjects();
                        Set toRemove = (Set)deleted.toSet().$plus$plus((GenTraversableOnce)newProjects.map((Function1 & Serializable & scala.Serializable)x$3 -> new AbsolutePath(StateCache.$anonfun$loadState$7(x$3)), List$.MODULE$.canBuildFrom()));
                        List untouched = (List)currentProjects.collect((PartialFunction)new scala.Serializable(null, toRemove){
                            public static final long serialVersionUID = 0L;
                            private final Set toRemove$1;

                            public final <A1 extends LoadedProject, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                if (!this.toRemove$1.contains((Object)new AbsolutePath(A1.project().origin().path()))) {
                                    return (B1)A1;
                                }
                                return (B1)function1.apply(x1);
                            }

                            public final boolean isDefinedAt(LoadedProject x1) {
                                LoadedProject loadedProject = x1;
                                return !this.toRemove$1.contains((Object)new AbsolutePath(loadedProject.project().origin().path()));
                            }
                            {
                                this.toRemove$1 = toRemove$1;
                            }
                        }, List$.MODULE$.canBuildFrom());
                        List x$1 = (List)untouched.$plus$plus((GenTraversableOnce)newProjects, List$.MODULE$.canBuildFrom());
                        Path x$2 = state2.build().copy$default$1();
                        Option<WorkspaceSettings> x$32 = state2.build().copy$default$3();
                        Build newBuild = state2.build().copy(x$2, (List<LoadedProject>)x$1, x$32);
                        state = state2.copy(newBuild, state2.copy$default$2(), state2.copy$default$3(), state2.copy$default$4(), state2.copy$default$5(), state2.copy$default$6(), state2.copy$default$7(), state2.copy$default$8(), state2.copy$default$9());
                    } else if (None$.MODULE$.equals(option)) {
                        state = (State)createState.apply((Object)Build$.MODULE$.apply(from, (List<LoadedProject>)newProjects, settings2));
                    } else {
                        throw new MatchError((Object)option);
                    }
                    State newState = state;
                    $this.cache.put(new AbsolutePath(from), StateCache$CachedState$.MODULE$.fromState(newState));
                    return newState;
                });
            }
            throw new MatchError((Object)reloadAction);
        });
    }

    public static final /* synthetic */ Path $anonfun$loadState$7(LoadedProject x$3) {
        return x$3.project().origin().path();
    }

    public StateCache(ConcurrentHashMap<AbsolutePath, CachedState> cache) {
        this.cache = cache;
    }

    public static class CachedState
    implements Product,
    scala.Serializable {
        private final Build build;
        private final ResultsCache results;
        private final CompilerCache compilerCache;
        private final SourceGeneratorCache sourceGeneratorCache;

        public Build build() {
            return this.build;
        }

        public ResultsCache results() {
            return this.results;
        }

        public CompilerCache compilerCache() {
            return this.compilerCache;
        }

        public SourceGeneratorCache sourceGeneratorCache() {
            return this.sourceGeneratorCache;
        }

        public CachedState copy(Build build, ResultsCache results, CompilerCache compilerCache, SourceGeneratorCache sourceGeneratorCache) {
            return new CachedState(build, results, compilerCache, sourceGeneratorCache);
        }

        public Build copy$default$1() {
            return this.build();
        }

        public ResultsCache copy$default$2() {
            return this.results();
        }

        public CompilerCache copy$default$3() {
            return this.compilerCache();
        }

        public SourceGeneratorCache copy$default$4() {
            return this.sourceGeneratorCache();
        }

        public String productPrefix() {
            return "CachedState";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.build();
                }
                case 1: {
                    return this.results();
                }
                case 2: {
                    return this.compilerCache();
                }
                case 3: {
                    return this.sourceGeneratorCache();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CachedState;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CachedState)) return false;
            boolean bl = true;
            if (!bl) return false;
            CachedState cachedState = (CachedState)x$1;
            Build build = this.build();
            Build build2 = cachedState.build();
            if (build == null) {
                if (build2 != null) {
                    return false;
                }
            } else if (!((Object)build).equals(build2)) return false;
            ResultsCache resultsCache = this.results();
            ResultsCache resultsCache2 = cachedState.results();
            if (resultsCache == null) {
                if (resultsCache2 != null) {
                    return false;
                }
            } else if (!((Object)resultsCache).equals(resultsCache2)) return false;
            CompilerCache compilerCache = this.compilerCache();
            CompilerCache compilerCache2 = cachedState.compilerCache();
            if (compilerCache == null) {
                if (compilerCache2 != null) {
                    return false;
                }
            } else if (!compilerCache.equals(compilerCache2)) return false;
            SourceGeneratorCache sourceGeneratorCache = this.sourceGeneratorCache();
            SourceGeneratorCache sourceGeneratorCache2 = cachedState.sourceGeneratorCache();
            if (sourceGeneratorCache == null) {
                if (sourceGeneratorCache2 != null) {
                    return false;
                }
            } else if (!sourceGeneratorCache.equals(sourceGeneratorCache2)) return false;
            if (!cachedState.canEqual(this)) return false;
            return true;
        }

        public CachedState(Build build, ResultsCache results, CompilerCache compilerCache, SourceGeneratorCache sourceGeneratorCache) {
            this.build = build;
            this.results = results;
            this.compilerCache = compilerCache;
            this.sourceGeneratorCache = sourceGeneratorCache;
            Product.$init$((Product)this);
        }
    }
}

