/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine.tasks.compilation;

import bloop.engine.ExecutionContext$;
import bloop.engine.tasks.compilation.CompilerPluginAllowlist;
import bloop.engine.tasks.compilation.CompilerPluginAllowlist$WorkItem$2$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import bloop.task.Task;
import bloop.task.Task$;
import bloop.tracing.BraveTracer;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;
import scala.xml.Elem;
import scala.xml.XML$;

public final class CompilerPluginAllowlist$ {
    public static CompilerPluginAllowlist$ MODULE$;
    private final List<String> whitelistedPluginNames;
    private final List<String> disallowedScalaVersions;
    private final DebugFilter.Compilation$ debug;
    private final Map<String, String> emptyMap;
    private final ConcurrentHashMap<String, Promise<Object>> pluginPromises;
    private final ConcurrentHashMap<Path, Tuple2<FileTime, Object>> cachePluginJar;

    static {
        new CompilerPluginAllowlist$();
    }

    public List<String> whitelistedPluginNames() {
        return this.whitelistedPluginNames;
    }

    public List<String> disallowedScalaVersions() {
        return this.disallowedScalaVersions;
    }

    private DebugFilter.Compilation$ debug() {
        return this.debug;
    }

    private Map<String, String> emptyMap() {
        return this.emptyMap;
    }

    public Task<List<String>> enableCachingInScalacOptions(String scalaVersion, List<String> scalacOptions, Logger logger, BraveTracer tracer, int parallelUnits) {
        return Task$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> {
            Task task;
            LazyRef WorkItem$module = new LazyRef();
            Option actualScalaVersion = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(scalaVersion)).split('-'))).headOption();
            Option disallowedVersions = MODULE$.disallowedScalaVersions().find((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)actualScalaVersion.exists((Function1 & Serializable & scala.Serializable)userVersion -> BoxesRunTime.boxToBoolean((boolean)CompilerPluginAllowlist$.$anonfun$enableCachingInScalacOptions$3(v, userVersion)))));
            Option option = disallowedVersions;
            if (option instanceof Some) {
                Some some = (Some)option;
                String disallowedVersion = (String)some.value();
                logger.debug(new StringBuilder(54).append("Disabled compiler plugin classloading, unsupported in ").append(disallowedVersion).toString(), (DebugFilter)MODULE$.debug());
                task = Task$.MODULE$.now((Object)scalacOptions);
            } else if (None$.MODULE$.equals(option)) {
                if (scalacOptions.contains((Object)"-Ycache-plugin-class-loader:none")) {
                    task = Task$.MODULE$.now((Object)scalacOptions);
                } else {
                    String[] pluginCompilerFlags = (String[])scalacOptions.iterator().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("-Xplugin:"))).toArray(ClassTag$.MODULE$.apply(String.class));
                    boolean[] cachePluginResults = new boolean[new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pluginCompilerFlags)).size()];
                    task = tracer.traceTaskVerbose("enabling plugin caching", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)tracer -> {
                        public class Bloop_engine_tasks_compilation_CompilerPluginAllowlist$WorkItem$1
                        implements Product,
                        scala.Serializable {
                            private final String pluginFlag;
                            private final int idx;
                            private final Promise<Object> result;

                            public String pluginFlag() {
                                return this.pluginFlag;
                            }

                            public int idx() {
                                return this.idx;
                            }

                            public Promise<Object> result() {
                                return this.result;
                            }

                            public Bloop_engine_tasks_compilation_CompilerPluginAllowlist$WorkItem$1 copy(String pluginFlag, int idx, Promise<Object> result) {
                                return new Bloop_engine_tasks_compilation_CompilerPluginAllowlist$WorkItem$1(pluginFlag, idx, result);
                            }

                            public String copy$default$1() {
                                return this.pluginFlag();
                            }

                            public int copy$default$2() {
                                return this.idx();
                            }

                            public Promise<Object> copy$default$3() {
                                return this.result();
                            }

                            public String productPrefix() {
                                return "WorkItem";
                            }

                            public int productArity() {
                                return 3;
                            }

                            public Object productElement(int x$1) {
                                int n = x$1;
                                switch (n) {
                                    case 0: {
                                        return this.pluginFlag();
                                    }
                                    case 1: {
                                        return BoxesRunTime.boxToInteger((int)this.idx());
                                    }
                                    case 2: {
                                        return this.result();
                                    }
                                }
                                throw new IndexOutOfBoundsException(Integer.toString(x$1));
                            }

                            public Iterator<Object> productIterator() {
                                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                            }

                            public boolean canEqual(Object x$1) {
                                return x$1 instanceof Bloop_engine_tasks_compilation_CompilerPluginAllowlist$WorkItem$1;
                            }

                            public int hashCode() {
                                int n = -889275714;
                                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pluginFlag()));
                                n = Statics.mix((int)n, (int)this.idx());
                                n = Statics.mix((int)n, (int)Statics.anyHash(this.result()));
                                return Statics.finalizeHash((int)n, (int)3);
                            }

                            public String toString() {
                                return ScalaRunTime$.MODULE$._toString((Product)this);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public boolean equals(Object x$1) {
                                if (this == x$1) return true;
                                Object object = x$1;
                                if (!(object instanceof Bloop_engine_tasks_compilation_CompilerPluginAllowlist$WorkItem$1)) return false;
                                boolean bl = true;
                                if (!bl) return false;
                                Bloop_engine_tasks_compilation_CompilerPluginAllowlist$WorkItem$1 var4_3 = (Bloop_engine_tasks_compilation_CompilerPluginAllowlist$WorkItem$1)x$1;
                                String string = this.pluginFlag();
                                String string2 = var4_3.pluginFlag();
                                if (string == null) {
                                    if (string2 != null) {
                                        return false;
                                    }
                                } else if (!string.equals(string2)) return false;
                                if (this.idx() != var4_3.idx()) return false;
                                Promise<Object> promise = this.result();
                                Promise<Object> promise2 = var4_3.result();
                                if (promise == null) {
                                    if (promise2 != null) {
                                        return false;
                                    }
                                } else if (!promise.equals(promise2)) return false;
                                if (!var4_3.canEqual(this)) return false;
                                return true;
                            }

                            public Bloop_engine_tasks_compilation_CompilerPluginAllowlist$WorkItem$1(String pluginFlag, int idx, Promise<Object> result) {
                                this.pluginFlag = pluginFlag;
                                this.idx = idx;
                                this.result = result;
                                Product.$init$((Product)this);
                            }
                        }
                        ListBuffer acquiredByOtherTasks = new ListBuffer();
                        ListBuffer acquiredByThisInvocation = new ListBuffer();
                        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pluginCompilerFlags)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 != null) {
                                String pluginCompilerFlag = (String)tuple2._1();
                                int idx = tuple2._2$mcI$sp();
                                Promise shouldCachePromise = Promise$.MODULE$.apply();
                                Promise<Object> promise = CompilerPluginAllowlist$.MODULE$.pluginPromises.putIfAbsent(pluginCompilerFlag, (Promise<Object>)shouldCachePromise);
                                if (promise != null) {
                                    return acquiredByOtherTasks.$plus$eq((Object)Task$.MODULE$.fromFuture(promise.future()).map((Function1 & Serializable & scala.Serializable)cache -> {
                                        cachePluginResults[idx] = BoxesRunTime.unboxToBoolean((Object)cache);
                                        return BoxedUnit.UNIT;
                                    }));
                                }
                                return acquiredByThisInvocation.$plus$eq((Object)this.WorkItem$3(WorkItem$module).apply(pluginCompilerFlag, idx, (Promise<Object>)shouldCachePromise));
                            }
                            throw new MatchError((Object)tuple2);
                        });
                        return Task$.MODULE$.parSequenceN(parallelUnits, (Iterable)acquiredByThisInvocation.toList().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            Bloop_engine_tasks_compilation_CompilerPluginAllowlist$WorkItem$1 var5_4 = x0$2;
                            if (var5_4 != null) {
                                String pluginCompilerFlag = var5_4.pluginFlag();
                                int idx = var5_4.idx();
                                Promise<Object> p = var5_4.result();
                                return MODULE$.shouldCachePlugin(pluginCompilerFlag, (BraveTracer)tracer, logger).materialize().map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                                    Try try_ = x0$3;
                                    if (try_ instanceof Success) {
                                        Success success = (Success)try_;
                                        boolean cache = BoxesRunTime.unboxToBoolean((Object)success.value());
                                        p.success((Object)BoxesRunTime.boxToBoolean((boolean)cache));
                                        CompilerPluginAllowlist$.MODULE$.pluginPromises.remove(pluginCompilerFlag);
                                        cachePluginResults$1[idx$2] = cache;
                                        return BoxedUnit.UNIT;
                                    }
                                    if (try_ instanceof Failure) {
                                        Failure failure = (Failure)try_;
                                        Throwable t = failure.exception();
                                        return p.failure(t);
                                    }
                                    throw new MatchError((Object)try_);
                                });
                            }
                            throw new MatchError((Object)var5_4);
                        }, List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
                            Iterator blockingBatches = acquiredByOtherTasks.toList().grouped(parallelUnits).map((Function1 & Serializable & scala.Serializable)group -> Task$.MODULE$.gatherUnordered((Iterable)group));
                            return Task$.MODULE$.sequence((Iterable)blockingBatches.toList(), List$.MODULE$.canBuildFrom()).map((Function1 & Serializable & scala.Serializable)x$3 -> (List)x$3.flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)x$4 -> {
                                boolean enableCacheFlag = new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps(cachePluginResults)).forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CompilerPluginAllowlist$.$anonfun$enableCachingInScalacOptions$14(BoxesRunTime.unboxToBoolean((Object)x$5))));
                                if (!enableCacheFlag) {
                                    return scalacOptions;
                                }
                                String string = "-Ycache-plugin-class-loader:last-modified";
                                return scalacOptions.$colon$colon((Object)string);
                            });
                        });
                    });
                }
            } else {
                throw new MatchError((Object)option);
            }
            Task enableTask = task;
            return enableTask.executeOn(ExecutionContext$.MODULE$.ioScheduler(), enableTask.executeOn$default$2()).materialize().map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Try try_ = x0$4;
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    List options = (List)success.value();
                    return options;
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable f = failure.exception();
                    logger.debug("Enabling the plugin whitelist failed! Disabling it.", (DebugFilter)MODULE$.debug());
                    logger.trace(f);
                    return scalacOptions;
                }
                throw new MatchError((Object)try_);
            });
        });
    }

    private Task<Object> shouldCachePlugin(String pluginCompilerFlag, BraveTracer tracer, Logger logger) {
        return Task$.MODULE$.eval((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String jarList = new StringOps(Predef$.MODULE$.augmentString(pluginCompilerFlag)).stripPrefix("-Xplugin:");
            Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(jarList)).split(File.pathSeparatorChar))).headOption();
            if (option instanceof Some) {
                Some some;
                Tuple2 tuple2;
                Some some2 = (Some)option;
                String mainPluginJar = (String)some2.value();
                Path pluginPath = Paths.get(mainPluginJar, new String[0]);
                if (!Files.exists(pluginPath, new LinkOption[0])) {
                    logger.debug(new StringBuilder(45).append("Disable plugin caching because ").append(pluginPath).append(" doesn't exist").toString(), (DebugFilter)MODULE$.debug());
                    return false;
                }
                BasicFileAttributes attrs = Files.readAttributes(pluginPath, BasicFileAttributes.class, new LinkOption[0]);
                FileTime lastModifiedTime = attrs.lastModifiedTime();
                Option option2 = Option$.MODULE$.apply(CompilerPluginAllowlist$.MODULE$.cachePluginJar.get(pluginPath));
                if (option2 instanceof Some && (tuple2 = (Tuple2)(some = (Some)option2).value()) != null) {
                    FileTime prevLastModifiedTime = (FileTime)tuple2._1();
                    boolean cacheClassloader = tuple2._2$mcZ$sp();
                    FileTime fileTime = prevLastModifiedTime;
                    FileTime fileTime2 = lastModifiedTime;
                    if (!(fileTime != null ? !((Object)fileTime).equals(fileTime2) : fileTime2 != null)) {
                        logger.debug(new StringBuilder(22).append("Cache hit ").append(cacheClassloader).append(" for plugin ").append(pluginPath).toString(), (DebugFilter)MODULE$.debug());
                        return cacheClassloader;
                    }
                }
                return BoxesRunTime.unboxToBoolean((Object)tracer.trace(new StringBuilder(18).append("check whitelisted ").append(pluginPath).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)CompilerPluginAllowlist$.$anonfun$shouldCachePlugin$2(logger, pluginPath, lastModifiedTime, x$7))));
            }
            if (None$.MODULE$.equals(option)) {
                logger.debug(new StringBuilder(32).append("Expecting at least one jar in '").append(pluginCompilerFlag).append("'").toString(), (DebugFilter)MODULE$.debug());
                return false;
            }
            throw new MatchError((Object)option);
        });
    }

    private boolean isPluginWhitelisted(Path pluginPath, Logger logger) {
        boolean bl;
        URI uriZipFile = URI.create(new StringBuilder(9).append("jar:file:").append(pluginPath.toUri().getRawPath()).toString());
        try (FileSystem fs = FileSystems.newFileSystem(uriZipFile, this.emptyMap());){
            Path pluginDeclarationFile = fs.getPath("/scalac-plugin.xml", new String[0]);
            Elem xml = (Elem)XML$.MODULE$.load(Files.newInputStream(pluginDeclarationFile, new OpenOption[0]));
            String pluginName = xml.$bslash("name").text();
            boolean cache = this.whitelistedPluginNames().contains((Object)pluginName);
            if (cache) {
                logger.debug(new StringBuilder(31).append("Compiler plugin ").append(pluginName).append(" is whitelisted").toString(), (DebugFilter)this.debug());
            } else {
                logger.debug(new StringBuilder(52).append("Disabling plugin caching because ").append(pluginName).append(" is not whitelisted").toString(), (DebugFilter)this.debug());
            }
            bl = cache;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                logger.trace(t);
                logger.debug(new StringBuilder(48).append("Disable plugin caching because ").append(pluginPath).append(" couldn't be read").toString(), (DebugFilter)this.debug());
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    private static final /* synthetic */ CompilerPluginAllowlist$WorkItem$2$ WorkItem$lzycompute$1(LazyRef WorkItem$module$1) {
        CompilerPluginAllowlist$WorkItem$2$ compilerPluginAllowlist$WorkItem$2$;
        LazyRef lazyRef = WorkItem$module$1;
        synchronized (lazyRef) {
            compilerPluginAllowlist$WorkItem$2$ = WorkItem$module$1.initialized() ? (CompilerPluginAllowlist$WorkItem$2$)((Object)WorkItem$module$1.value()) : (CompilerPluginAllowlist$WorkItem$2$)((Object)WorkItem$module$1.initialize((Object)new CompilerPluginAllowlist$WorkItem$2$()));
        }
        return compilerPluginAllowlist$WorkItem$2$;
    }

    private final CompilerPluginAllowlist$WorkItem$2$ WorkItem$3(LazyRef WorkItem$module$1) {
        if (WorkItem$module$1.initialized()) {
            return (CompilerPluginAllowlist$WorkItem$2$)((Object)WorkItem$module$1.value());
        }
        return CompilerPluginAllowlist$.WorkItem$lzycompute$1(WorkItem$module$1);
    }

    public static final /* synthetic */ boolean $anonfun$enableCachingInScalacOptions$3(String v$1, String userVersion) {
        if (v$1.endsWith(".")) {
            return userVersion.startsWith(v$1);
        }
        String string = userVersion;
        String string2 = v$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$enableCachingInScalacOptions$14(boolean x$5) {
        return x$5;
    }

    public static final /* synthetic */ boolean $anonfun$shouldCachePlugin$2(Logger logger$2, Path pluginPath$1, FileTime lastModifiedTime$1, BraveTracer x$7) {
        logger$2.debug(new StringBuilder(22).append("Cache miss for plugin ").append(pluginPath$1).toString(), (DebugFilter)MODULE$.debug());
        boolean shouldCache = MODULE$.isPluginWhitelisted(pluginPath$1, logger$2);
        CompilerPluginAllowlist$.MODULE$.cachePluginJar.put(pluginPath$1, (Tuple2<FileTime, Object>)new Tuple2((Object)lastModifiedTime$1, (Object)BoxesRunTime.boxToBoolean((boolean)shouldCache)));
        return shouldCache;
    }

    private CompilerPluginAllowlist$() {
        MODULE$ = this;
        this.whitelistedPluginNames = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bloop-test-plugin", "clippy", "scalajs", "nir", "macro-paradise-plugin", "semanticdb", "wartremover", "silencer", "scapegoat", "acyclic", "scoverage", "kind-projector", "scalac-profiling", "classpath-shrinker", "bm4", "splain", "deriving"}));
        this.disallowedScalaVersions = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2.10.", "2.11.", "2.12.1", "2.12.2", "2.12.3", "2.12.4", "0.", "3."}));
        this.debug = DebugFilter.Compilation$.MODULE$;
        this.emptyMap = Collections.emptyMap();
        this.pluginPromises = new ConcurrentHashMap();
        this.cachePluginJar = new ConcurrentHashMap();
    }
}

