/*
 * Decompiled with CFR 0.152.
 */
package bloop.bsp;

import bloop.bsp.BloopBspServices;
import bloop.bsp.BloopLanguageClient;
import bloop.bsp.BloopLanguageClient$;
import bloop.bsp.BloopLanguageServer;
import bloop.cli.Commands;
import bloop.data.ClientInfo;
import bloop.data.ClientInfo$;
import bloop.data.Project;
import bloop.engine.ExecutionContext$;
import bloop.engine.State;
import bloop.engine.State$;
import bloop.engine.State$XState$;
import bloop.io.AbsolutePath;
import bloop.io.Paths$;
import bloop.io.ServerHandle;
import bloop.io.ServerHandle$Tcp$;
import bloop.logging.BspClientLogger;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import bloop.task.Task;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import jsonrpc4s.LowLevelMessage$;
import jsonrpc4s.Message;
import jsonrpc4s.Response;
import monix.eval.Task$;
import monix.execution.Ack;
import monix.execution.CancelablePromise;
import monix.execution.CancelablePromise$;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.PaddingStrategy;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import monix.reactive.OverflowStrategy;
import monix.reactive.subjects.BehaviorSubject;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class BspServer$ {
    public static BspServer$ MODULE$;
    private final DebugFilter logContext;
    private final ConcurrentHashMap<ClientInfo.BspClientInfo, AbsolutePath> connectedBspClients;

    static {
        new BspServer$();
    }

    private DebugFilter logContext() {
        return this.logContext;
    }

    private Task<ServerSocket> initServer(ServerHandle handle, State state) {
        state.logger().debug(new StringBuilder(31).append("Waiting for a connection at ").append(handle).append("...").toString(), this.logContext());
        ServerSocket openSocket = handle.server();
        return bloop.task.Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> openSocket).doOnCancel((Function0 & Serializable & scala.Serializable)() -> bloop.task.Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> openSocket.close()));
    }

    private final ConcurrentHashMap<ClientInfo.BspClientInfo, AbsolutePath> connectedBspClients() {
        return this.connectedBspClients;
    }

    public Task<State> run(Commands.ValidatedBsp cmd, State state, Path config, Option<Promise<BoxedUnit>> promiseWhenStarted, Option<BehaviorSubject<State>> externalObserver, Scheduler scheduler, Scheduler ioScheduler) {
        ServerHandle serverHandle;
        Commands.ValidatedBsp validatedBsp = cmd;
        if (validatedBsp instanceof Commands.WindowsLocalBsp) {
            Commands.WindowsLocalBsp windowsLocalBsp = (Commands.WindowsLocalBsp)validatedBsp;
            String pipeName = windowsLocalBsp.pipeName();
            serverHandle = new ServerHandle.WindowsLocal(pipeName);
        } else if (validatedBsp instanceof Commands.UnixLocalBsp) {
            Commands.UnixLocalBsp unixLocalBsp = (Commands.UnixLocalBsp)validatedBsp;
            Path socketFile = unixLocalBsp.socket();
            serverHandle = new ServerHandle.UnixLocal(socketFile);
        } else if (validatedBsp instanceof Commands.TcpBsp) {
            Commands.TcpBsp tcpBsp = (Commands.TcpBsp)validatedBsp;
            InetAddress address = tcpBsp.host();
            int portNumber = tcpBsp.port();
            serverHandle = ServerHandle$Tcp$.MODULE$.apply(address, portNumber, 10);
        } else {
            throw new MatchError((Object)validatedBsp);
        }
        ServerHandle.WindowsLocal handle = serverHandle;
        return this.initServer(handle, state).materialize().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Failure failure;
            Throwable t;
            Success success;
            ServerSocket socket;
            Try try_ = x0$1;
            if (try_ instanceof Success && (socket = (ServerSocket)(success = (Success)try_).value()) != null) {
                ServerSocket serverSocket = socket;
                return this.listenToConnection$1(handle, serverSocket, state, promiseWhenStarted, config, externalObserver, scheduler, ioScheduler).onErrorRecover((PartialFunction)new scala.Serializable(state){
                    public static final long serialVersionUID = 0L;
                    private final State state$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        return (B1)State$XState$.MODULE$.withError$extension1(State$.MODULE$.XState(this.state$1), new StringBuilder(24).append("Exiting BSP server with ").append(A1.getMessage()).toString(), A1);
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        return true;
                    }
                    {
                        this.state$1 = state$1;
                    }
                });
            }
            if (try_ instanceof Failure && (t = (failure = (Failure)try_).exception()) != null) {
                Throwable throwable = t;
                promiseWhenStarted.foreach((Function1 & Serializable & scala.Serializable)p -> {
                    if (!p.isCompleted()) {
                        return p.failure(throwable);
                    }
                    return BoxedUnit.UNIT;
                });
                return bloop.task.Task$.MODULE$.now((Object)State$XState$.MODULE$.withError$extension1(State$.MODULE$.XState(state), new StringBuilder(38).append("BSP server failed to open a socket: '").append(throwable.getMessage()).append("'").toString(), throwable));
            }
            throw new MatchError((Object)try_);
        });
    }

    public void closeCommunication(State latestState, Socket socket, ServerSocket serverSocket) {
        block14: {
            try {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            break block14;
                        }
                        throw throwable;
                    }
                }
                finally {
                    try {
                        serverSocket.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable3 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable3);
                        if (!option.isEmpty()) {
                        }
                        throw throwable;
                    }
                }
            }
            finally {
                List deleteExternalDirsTasks = (List)latestState.build().loadedProjects().map((Function1 & Serializable & scala.Serializable)loadedProject -> {
                    Task task;
                    block3: {
                        Project project = loadedProject.project();
                        try {
                            boolean skipDirectoryManagement;
                            Path externalClientClassesDir;
                            Path path = externalClientClassesDir = latestState.client().getUniqueClassesDirFor(project, false);
                            Path path2 = project.genericClassesDir();
                            boolean bl = !(path == null ? path2 != null : !((Object)path).equals(path2)) || latestState.client().hasManagedClassesDirectories() ? true : (skipDirectoryManagement = false);
                            if (skipDirectoryManagement) {
                                task = bloop.task.Task$.MODULE$.now((Object)BoxedUnit.UNIT);
                                break block3;
                            }
                            task = bloop.task.Task$.MODULE$.eval((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Paths$.MODULE$.delete(externalClientClassesDir)).materialize();
                        }
                        catch (NoSuchFileException noSuchFileException) {
                            task = bloop.task.Task$.MODULE$.now((Object)BoxedUnit.UNIT);
                        }
                    }
                    return task;
                }, List$.MODULE$.canBuildFrom());
                Iterator groups = deleteExternalDirsTasks.grouped(4).map((Function1 & Serializable & scala.Serializable)group -> bloop.task.Task$.MODULE$.gatherUnordered((Iterable)group));
                bloop.task.Task$.MODULE$.sequence((Iterable)groups.toList(), List$.MODULE$.canBuildFrom()).map((Function1 & Serializable & scala.Serializable)x$6 -> (List)x$6.flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)x$7 -> {
                    BspServer$.$anonfun$closeCommunication$5(x$7);
                    return BoxedUnit.UNIT;
                }).runAsync(ExecutionContext$.MODULE$.ioScheduler());
            }
        }
    }

    private static final void error$1(String msg, BloopBspServices provider$1) {
        provider$1.stateAfterExecution().logger().error(msg);
    }

    public static final /* synthetic */ void $anonfun$run$6(Ack x$3) {
    }

    public final Set bloop$bsp$BspServer$$askCurrentBspClients$1(Option initializedClientInfo$1) {
        Set clients0 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.connectedBspClients().keySet()).asScala()).toSet();
        Option option = initializedClientInfo$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            ClientInfo.BspClientInfo bspInfo = (ClientInfo.BspClientInfo)some.value();
            return (Set)clients0.$plus((Object)bspInfo);
        }
        if (None$.MODULE$.equals(option)) {
            return clients0;
        }
        throw new MatchError((Object)option);
    }

    private final void stopListeting$1(boolean cancelled, AtomicBoolean isCommunicationActive$1, BloopBspServices provider$1, BloopLanguageServer server$1, Scheduler ioScheduler$1, State state$1, Socket socket$1, ServerSocket serverSocket$1) {
        if (isCommunicationActive$1.getAndSet(false)) {
            State latestState = provider$1.stateAfterExecution();
            Option<ClientInfo.BspClientInfo> initializedClientInfo = provider$1.unregisterClient();
            if (cancelled) {
                BspServer$.error$1("BSP server cancelled, closing socket...", provider$1);
            } else {
                BspServer$.error$1("BSP server stopped", provider$1);
            }
            server$1.cancelAllRequests();
            ioScheduler$1.scheduleOnce(100L, TimeUnit.MILLISECONDS, new Runnable(state$1, initializedClientInfo){
                private final State state$1;
                private final Option initializedClientInfo$1;

                public void run() {
                    PrintStream ngout = this.state$1.commonOptions().ngout();
                    PrintStream ngerr = this.state$1.commonOptions().ngerr();
                    ClientInfo$.MODULE$.deleteOrphanClientBspDirectories((Function0<Traversable<ClientInfo.BspClientInfo>>)(Function0 & Serializable & scala.Serializable)() -> BspServer$.MODULE$.bloop$bsp$BspServer$$askCurrentBspClients$1($this.initializedClientInfo$1), ngout, ngerr);
                }
                {
                    this.state$1 = state$1;
                    this.initializedClientInfo$1 = initializedClientInfo$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$7(bloop.bsp.BspServer$$anon$1 )}, serializedLambda);
                }
            });
            this.closeCommunication(latestState, socket$1, serverSocket$1);
            return;
        }
    }

    private final Task listenToConnection$1(ServerHandle handle, ServerSocket serverSocket, State state$1, Option promiseWhenStarted$1, Path config$1, Option externalObserver$1, Scheduler scheduler$1, Scheduler ioScheduler$1) {
        AtomicBoolean isCommunicationActive = AtomicBuilder.AtomicBooleanBuilder$.MODULE$.buildInstance(true, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
        String connectionURI = handle.uri();
        state$1.logger().info(new StringBuilder(55).append("The server is listening for incoming connections at ").append(connectionURI).append("...").toString());
        promiseWhenStarted$1.foreach((Function1 & Serializable & scala.Serializable)x$1 -> x$1.success((Object)BoxedUnit.UNIT));
        Socket socket = serverSocket.accept();
        state$1.logger().info(new StringBuilder(43).append("Accepted incoming BSP client connection at ").append(connectionURI).toString());
        InputStream in = socket.getInputStream();
        OutputStream out = socket.getOutputStream();
        BspClientLogger<Logger> bspLogger = new BspClientLogger<Logger>(state$1.logger());
        CancelablePromise stopBspConnection = CancelablePromise$.MODULE$.apply(CancelablePromise$.MODULE$.apply$default$1());
        BloopLanguageClient client = BloopLanguageClient$.MODULE$.fromOutputStream(out, bspLogger);
        BloopBspServices provider = new BloopBspServices(state$1, client, config$1, (CancelablePromise<BoxedUnit>)stopBspConnection, (Option<BehaviorSubject<State>>)externalObserver$1, isCommunicationActive, this.connectedBspClients(), scheduler$1, ioScheduler$1);
        BloopLanguageServer server = new BloopLanguageServer((Observable<Message>)Observable$.MODULE$.never(), client, provider.services(), ioScheduler$1, bspLogger);
        CancelablePromise inputExit = CancelablePromise$.MODULE$.apply(CancelablePromise$.MODULE$.apply$default$1());
        Observable qual$1 = LowLevelMessage$.MODULE$.fromInputStream(in, bspLogger).guaranteeCase((Function1 & Serializable & scala.Serializable)x$2 -> Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> inputExit.success((Object)BoxedUnit.UNIT))).asyncBoundary((OverflowStrategy)OverflowStrategy.Unbounded$.MODULE$);
        int x$12 = 4;
        Function1 & Serializable & scala.Serializable x$22 = (Function1 & Serializable & scala.Serializable)bytes -> {
            Message msg2 = LowLevelMessage$.MODULE$.toMsg(bytes);
            return server.handleValidMessage(msg2).flatMap((Function1 & Serializable & scala.Serializable)msg -> bloop.task.Task$.MODULE$.fromFuture(client.serverRespond((Response)msg)).map((Function1 & Serializable & scala.Serializable)x$3 -> {
                BspServer$.$anonfun$run$6(x$3);
                return BoxedUnit.UNIT;
            })).onErrorRecover((PartialFunction)new scala.Serializable(bspLogger){
                public static final long serialVersionUID = 0L;
                private final BspClientLogger bspLogger$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Option option = NonFatal$.MODULE$.unapply(A1);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        this.bspLogger$1.error("Unhandled error", e);
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    Option option = NonFatal$.MODULE$.unapply(throwable);
                    return !option.isEmpty();
                }
                {
                    this.bspLogger$1 = bspLogger$1;
                }
            }).toMonixTask(ioScheduler$1);
        };
        OverflowStrategy x$3 = qual$1.mapParallelOrdered$default$3(x$12, (Function1)x$22);
        Observable mesages = qual$1.mapParallelOrdered(x$12, (Function1)x$22, x$3).executeOn(ioScheduler$1, true);
        Task process = bloop.task.Task$.MODULE$.raceMany((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Task[]{bloop.task.Task$.MODULE$.liftMonixTaskUncancellable(mesages.completedL()), bloop.task.Task$.MODULE$.fromFuture((Future)inputExit.future()), bloop.task.Task$.MODULE$.fromFuture((Future)stopBspConnection.future())}));
        return process.doOnCancel((Function0 & Serializable & scala.Serializable)() -> bloop.task.Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.stopListeting$1(true, isCommunicationActive, provider, server, ioScheduler$1, state$1, socket, serverSocket))).doOnFinish((Function1 & Serializable & scala.Serializable)x$4 -> bloop.task.Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.stopListeting$1(false, isCommunicationActive, provider, server, ioScheduler$1, state$1, socket, serverSocket))).map((Function1 & Serializable & scala.Serializable)x$5 -> provider.stateAfterExecution());
    }

    public static final /* synthetic */ void $anonfun$closeCommunication$5(List x$7) {
    }

    private BspServer$() {
        MODULE$ = this;
        this.logContext = DebugFilter.Bsp$.MODULE$;
        this.connectedBspClients = new ConcurrentHashMap();
    }
}

