/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine;

import bloop.CompileMode;
import bloop.bsp.BspServer$;
import bloop.cli.BspProtocol;
import bloop.cli.BspProtocol$;
import bloop.cli.CliParsers$;
import bloop.cli.Commands;
import bloop.cli.Commands$;
import bloop.cli.ExitStatus;
import bloop.cli.ExitStatus$;
import bloop.cli.OptimizerConfig;
import bloop.cli.OptimizerConfig$Debug$;
import bloop.cli.OptimizerConfig$Release$;
import bloop.cli.ReporterKind;
import bloop.cli.ReporterKind$;
import bloop.cli.completion.Case$;
import bloop.cli.completion.Mode;
import bloop.cli.completion.Mode$Commands$;
import bloop.cli.completion.Mode$Flags$;
import bloop.cli.completion.Mode$MainsFQCN$;
import bloop.cli.completion.Mode$ProjectBoundCommands$;
import bloop.cli.completion.Mode$Projects$;
import bloop.cli.completion.Mode$Protocols$;
import bloop.cli.completion.Mode$Reporters$;
import bloop.cli.completion.Mode$TestsFQCN$;
import bloop.config.Config;
import bloop.data.Project;
import bloop.engine.Action;
import bloop.engine.Build;
import bloop.engine.Dag$;
import bloop.engine.ExecutionContext$;
import bloop.engine.Exit;
import bloop.engine.Feedback$;
import bloop.engine.Print;
import bloop.engine.Run;
import bloop.engine.State;
import bloop.engine.State$;
import bloop.engine.State$XState$;
import bloop.engine.tasks.CompilationTask$;
import bloop.engine.tasks.ScalaJsToolchain;
import bloop.engine.tasks.ScalaJsToolchain$;
import bloop.engine.tasks.ScalaNativeToolchain;
import bloop.engine.tasks.ScalaNativeToolchain$;
import bloop.engine.tasks.Tasks$;
import bloop.internal.build.BuildInfo$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.RelativePath$;
import bloop.io.SourceWatcher;
import bloop.io.SourceWatcher$;
import bloop.reporter.ReporterConfig;
import bloop.testing.LoggingEventHandler;
import bloop.testing.TestInternals$;
import caseapp.core.Arg;
import caseapp.core.CommandMessages;
import java.io.Serializable;
import java.nio.file.Path;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

public final class Interpreter$ {
    public static Interpreter$ MODULE$;
    private final String line;

    static {
        new Interpreter$();
    }

    public Task<State> execute(Action action, Task<State> stateTask) {
        return Interpreter$.execute$1(action, stateTask, false);
    }

    private final String t() {
        return "    ";
    }

    private final String line() {
        return this.line;
    }

    private Task<State> printAbout(State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String bloopName = BuildInfo$.MODULE$.name();
            String bloopVersion = BuildInfo$.MODULE$.version();
            String scalaVersion = BuildInfo$.MODULE$.scalaVersion();
            String zincVersion = BuildInfo$.MODULE$.zincVersion();
            String developers = BuildInfo$.MODULE$.developers().mkString(", ");
            String header = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(366).append("|").append("    ").append("   _____            __         ______           __\n          |").append("    ").append("  / ___/_________ _/ /___ _   / ____/__  ____  / /____  _____\n          |").append("    ").append("  \\__ \\/ ___/ __ `/ / __ `/  / /   / _ \\/ __ \\/ __/ _ \\/ ___/\n          |").append("    ").append(" ___/ / /__/ /_/ / / /_/ /  / /___/ /__/ / / / /_/ /__/ /\n          |").append("    ").append("/____/\\___/\\__,_/_/\\__,_/   \\____/\\___/_/ /_/\\__/\\___/_/\n          |").toString())).stripMargin();
            String versions = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(136).append("\n                      |").append("    ").append(new StringOps(Predef$.MODULE$.augmentString(bloopName)).capitalize()).append(" version    `").append(bloopVersion).append("`\n                      |").append("    ").append("Zinc version     `").append(zincVersion).append("`\n                      |").append("    ").append("Scala version    `").append(scalaVersion).append("`").toString())).stripMargin();
            state.logger().info(new StringBuilder(0).append(header).append(MODULE$.line()).toString());
            state.logger().info(new StringBuilder(45).append("    ").append(bloopName).append(" is made with love at the Scala Center <3").append(MODULE$.line()).toString());
            state.logger().info(new StringBuilder(0).append(versions).append(MODULE$.line()).append(MODULE$.line()).toString());
            state.logger().info(new StringBuilder(25).append("    ").append("It is maintained by ").append(developers).append(".").toString());
            return state.mergeStatus(ExitStatus$.MODULE$.Ok());
        });
    }

    private Task<State> runBsp(Commands.ValidatedBsp cmd, State state) {
        Scheduler scheduler = ExecutionContext$.MODULE$.bspScheduler();
        return BspServer$.MODULE$.run(cmd, state, RelativePath$.MODULE$.apply(".bloop"), scheduler);
    }

    public Task<State> watch(Project project, State state, Function1<State, Task<State>> f) {
        Function1 & Serializable & scala.Serializable fg;
        SourceWatcher watcher;
        block0: {
            List<Project> reachable = Dag$.MODULE$.dfs(state.build().getDagFor(project));
            Iterator allSources = reachable.iterator().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.sources().toList()).map((Function1 & Serializable & scala.Serializable)x$2 -> ((AbsolutePath)x$2).underlying());
            watcher = SourceWatcher$.MODULE$.apply(project, (Seq<Path>)allSources.toList(), state.logger());
            fg = (Function1 & Serializable & scala.Serializable)state2 -> ((Task)f.apply(state2)).map((Function1 & Serializable & scala.Serializable)state -> {
                watcher.notifyWatch();
                return State$.MODULE$.stateCache().updateBuild((State)state);
            });
            if (BspServer$.MODULE$.isWindows()) break block0;
            state.logger().info("\u001b[H\u001b[2J");
        }
        return ((Task)fg.apply((Object)state)).flatMap((Function1 & Serializable & scala.Serializable)newState -> watcher.watch((State)newState, (Function1<State, Task<State>>)fg));
    }

    private Task<State> runCompile(Commands.CompilingCommand cmd, State state0, Project project, boolean deduplicateFailures, boolean excludeRoot) {
        Task<State> state = cmd.incremental() ? Task$.MODULE$.now((Object)state0) : Tasks$.MODULE$.clean(state0, state0.build().projects(), true);
        CompileMode.Sequential$ compilerMode = CompileMode.Sequential$.MODULE$;
        Task compileTask = state.flatMap(arg_0 -> Interpreter$.$anonfun$runCompile$1(cmd, project, deduplicateFailures, excludeRoot, (CompileMode.ConfigurableMode)compilerMode, arg_0));
        return compileTask.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.mergeStatus(ExitStatus$.MODULE$.Ok()));
    }

    private Task<State> compile(Commands.Compile cmd, State state, boolean deduplicateFailures) {
        Task<State> task;
        Option<Project> option = state.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            task = !cmd.watch() ? this.runCompile(cmd, state, project, deduplicateFailures, this.runCompile$default$5()) : this.watch(project, state, (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.runCompile(cmd, (State)x$4, project, deduplicateFailures, MODULE$.runCompile$default$5()));
        } else if (None$.MODULE$.equals(option)) {
            String string = cmd.project();
            task = Task$.MODULE$.now((Object)this.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state));
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private Task<State> showProjects(Commands.Projects cmd, State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            if (cmd.dotGraph()) {
                String contents = Dag$.MODULE$.toDotGraph(state.build().dags());
                state.logger().info(contents);
            } else {
                String configDirectory = AbsolutePath$.MODULE$.syntax$extension(state.build().origin());
                state.logger().debug(new StringBuilder(24).append("Projects loaded from '").append(configDirectory).append("':").toString());
                ((List)((SeqLike)state.build().projects().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name(), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    Interpreter$.$anonfun$showProjects$3(state, x$1);
                    return BoxedUnit.UNIT;
                });
            }
            return state.mergeStatus(ExitStatus$.MODULE$.Ok());
        });
    }

    private <C extends Commands.CompilingCommand> Task<State> compileAnd(C cmd, State state, Project project, boolean excludeRoot, boolean deduplicateFailures, String nextAction, Function1<State, Task<State>> next) {
        return this.runCompile(cmd, state, project, deduplicateFailures, excludeRoot).flatMap((Function1 & Serializable & scala.Serializable)compiled -> {
            ExitStatus exitStatus = compiled.status();
            ExitStatus exitStatus2 = ExitStatus$.MODULE$.CompilationError();
            return (exitStatus == null ? exitStatus2 != null : !((Object)exitStatus).equals(exitStatus2)) ? (Task)next.apply(compiled) : Task$.MODULE$.now((Object)State$XState$.MODULE$.withDebug$extension(State$.MODULE$.XState(state), new StringBuilder(37).append("Failed compilation for ").append(project).append(". Skipping ").append(nextAction).append("...").toString()));
        });
    }

    private Task<State> console(Commands.Console cmd, State state2, boolean sequential) {
        Task<State> task;
        Option<Project> option = state2.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            task = this.compileAnd(cmd, state2, project, cmd.excludeRoot(), sequential, "`console`", (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> Tasks$.MODULE$.console((State)state, project, cmd.excludeRoot()));
        } else if (None$.MODULE$.equals(option)) {
            String string = cmd.project();
            task = Task$.MODULE$.now((Object)this.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state2));
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private Task<State> test(Commands.Test cmd, State state2, boolean sequential) {
        Task<State> task;
        Option<Project> option = Tasks$.MODULE$.pickTestProject(cmd.project(), state2);
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            task = cmd.watch() ? this.watch(project, state2, (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> this.doTest$1((State)state, cmd, sequential, project)) : this.doTest$1(state2, cmd, sequential, project);
        } else if (None$.MODULE$.equals(option)) {
            String string = cmd.project();
            task = Task$.MODULE$.now((Object)this.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state2));
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private Tuple2<List<Project>, List<String>> lookupProjects(List<String> names, State state) {
        Build build = state.build();
        Tuple2 result = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Nil$.MODULE$), (Object)Nil$.MODULE$);
        return (Tuple2)names.foldLeft((Object)result, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = new Tuple2(x0$1, x1$1);
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Tuple2 tuple23 = (Tuple2)tuple22._1();
            String name = (String)tuple22._2();
            if (tuple23 == null) throw new MatchError((Object)tuple22);
            List projects = (List)tuple23._1();
            List missing = (List)tuple23._2();
            Option<Project> option = build.getProjectFor(name);
            if (option instanceof Some) {
                Project project;
                Some some = (Some)option;
                Project project2 = project = (Project)some.value();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)projects.$colon$colon((Object)project2)), (Object)missing);
                return tuple2;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                String string = name;
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)projects), (Object)missing.$colon$colon((Object)string));
            }
            return tuple2;
        });
    }

    private Task<State> autocomplete(Commands.Autocomplete cmd, State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Mode mode = cmd.mode();
            if (Mode$ProjectBoundCommands$.MODULE$.equals(mode)) {
                state.logger().info(Commands$.MODULE$.projectBound());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$Commands$.MODULE$.equals(mode)) {
                CliParsers$.MODULE$.CommandsMessages().messages().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Interpreter$.$anonfun$autocomplete$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                    Interpreter$.$anonfun$autocomplete$3(cmd, state, x$11);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$Projects$.MODULE$.equals(mode)) {
                state.build().projects().foreach((Function1 & Serializable & scala.Serializable)project -> {
                    Interpreter$.$anonfun$autocomplete$5(cmd, state, project);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$Flags$.MODULE$.equals(mode)) {
                cmd.command().foreach((Function1 & Serializable & scala.Serializable)command -> {
                    Interpreter$.$anonfun$autocomplete$7(cmd, state, command);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$Reporters$.MODULE$.equals(mode)) {
                ReporterKind$.MODULE$.reporters().foreach((Function1 & Serializable & scala.Serializable)reporter -> {
                    Interpreter$.$anonfun$autocomplete$11(cmd, state, reporter);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$Protocols$.MODULE$.equals(mode)) {
                BspProtocol$.MODULE$.protocols().foreach((Function1 & Serializable & scala.Serializable)protocol -> {
                    Interpreter$.$anonfun$autocomplete$13(cmd, state, protocol);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$MainsFQCN$.MODULE$.equals(mode)) {
                cmd.project().foreach((Function1 & Serializable & scala.Serializable)projectName -> {
                    Interpreter$.$anonfun$autocomplete$15(cmd, state, projectName);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Mode$TestsFQCN$.MODULE$.equals(mode)) {
                cmd.project().foreach((Function1 & Serializable & scala.Serializable)projectName -> {
                    Interpreter$.$anonfun$autocomplete$19(cmd, state, projectName);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)mode);
            }
            return state;
        });
    }

    private Task<State> configure(Commands.Configure cmd, State state) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> cmd.threads() == 0 ? state : State$XState$.MODULE$.withWarn$extension(State$.MODULE$.XState(state), "Dynamic thread configuration has been deprecated and is a no-op."));
    }

    private Task<State> clean(Commands.Clean cmd, State state) {
        Task task;
        if (cmd.project().isEmpty()) {
            task = Tasks$.MODULE$.clean(state, state.build().projects(), cmd.includeDependencies()).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.mergeStatus(ExitStatus$.MODULE$.Ok()));
        } else {
            Tuple2<List<Project>, List<String>> tuple2 = this.lookupProjects(cmd.project(), state);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            List projects = (List)tuple2._1();
            List missing = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)projects, (Object)missing);
            Tuple2 tuple23 = tuple22;
            List projects2 = (List)tuple23._1();
            List missing2 = (List)tuple23._2();
            task = missing2.isEmpty() ? Tasks$.MODULE$.clean(state, (List<Project>)projects2, cmd.includeDependencies()).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.mergeStatus(ExitStatus$.MODULE$.Ok())) : Task$.MODULE$.now((Object)this.reportMissing((List<String>)missing2, state));
        }
        return task;
    }

    public Task<State> linkWithScalaJs(Commands.LinkingCommand cmd, Project project, State state, String mainClass, Path target, Config.JsConfig config0) {
        Task task;
        Option<ScalaJsToolchain> option = project.jsToolchain();
        if (option instanceof Some) {
            Task task2;
            Some some = (Some)option;
            ScalaJsToolchain toolchain = (ScalaJsToolchain)some.value();
            Option option2 = config0.output().flatMap((Function1 & Serializable & scala.Serializable)x$15 -> Tasks$.MODULE$.reasonOfInvalidPath((Path)x$15, ".js"));
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String msg = (String)some2.value();
                task2 = Task$.MODULE$.now((Object)State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState(state), msg, ExitStatus$.MODULE$.LinkingError()));
            } else if (None$.MODULE$.equals(option2)) {
                Config.LinkerMode x$22 = this.getOptimizerMode(cmd.optimize(), config0.mode());
                String x$23 = config0.copy$default$1();
                Config.ModuleKindJS x$24 = config0.copy$default$3();
                boolean x$25 = config0.copy$default$4();
                Option x$26 = config0.copy$default$5();
                List x$27 = config0.copy$default$6();
                Config.JsConfig config = config0.copy(x$23, x$22, x$24, x$25, x$26, x$27);
                task2 = toolchain.link(config, project, mainClass, target, state.logger()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    State state;
                    Try try_ = x0$2;
                    if (try_ instanceof Success) {
                        state = State$XState$.MODULE$.withInfo$extension(State$.MODULE$.XState(state), new StringBuilder(28).append("Generated JavaScript file '").append(AbsolutePath$.MODULE$.syntax$extension(target)).append("'").toString());
                    } else if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable t = failure.exception();
                        String msg = Feedback$.MODULE$.failedToLink(project, ScalaJsToolchain$.MODULE$.name(), t);
                        state = State$XState$.MODULE$.withTrace$extension(State$.MODULE$.XState(State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState(state), msg, ExitStatus$.MODULE$.LinkingError())), t);
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    return state;
                });
            } else {
                throw new MatchError((Object)option2);
            }
            task = task2;
        } else if (None$.MODULE$.equals(option)) {
            String artifactName = ScalaJsToolchain$.MODULE$.artifactNameFrom(config0.version());
            String msg = Feedback$.MODULE$.missingLinkArtifactFor(project, artifactName, ScalaJsToolchain$.MODULE$.name());
            task = Task$.MODULE$.now((Object)State$XState$.MODULE$.withError$extension0(State$.MODULE$.XState(state), msg));
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    public Task<State> linkWithScalaNative(Commands.LinkingCommand cmd, Project project, State state, String mainClass, Path target, Config.NativeConfig config0) {
        Task task;
        Option<ScalaNativeToolchain> option = project.nativeToolchain();
        if (option instanceof Some) {
            Task task2;
            Some some = (Some)option;
            ScalaNativeToolchain toolchain = (ScalaNativeToolchain)some.value();
            Option option2 = config0.output().flatMap((Function1 & Serializable & scala.Serializable)x$16 -> Tasks$.MODULE$.reasonOfInvalidPath((Path)x$16));
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String msg = (String)some2.value();
                task2 = Task$.MODULE$.now((Object)State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState(state), msg, ExitStatus$.MODULE$.LinkingError()));
            } else if (None$.MODULE$.equals(option2)) {
                Config.LinkerMode x$28 = this.getOptimizerMode(cmd.optimize(), config0.mode());
                String x$29 = config0.copy$default$1();
                String x$30 = config0.copy$default$3();
                String x$31 = config0.copy$default$4();
                Path x$32 = config0.copy$default$5();
                Path x$33 = config0.copy$default$6();
                Path x$34 = config0.copy$default$7();
                List x$35 = config0.copy$default$8();
                Config.NativeOptions x$36 = config0.copy$default$9();
                boolean x$37 = config0.copy$default$10();
                Option x$38 = config0.copy$default$11();
                Config.NativeConfig config = config0.copy(x$29, x$28, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38);
                task2 = toolchain.link(config, project, mainClass, target, state.logger()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    State state;
                    Try try_ = x0$3;
                    if (try_ instanceof Success) {
                        state = State$XState$.MODULE$.withInfo$extension(State$.MODULE$.XState(state), new StringBuilder(26).append("Generated native binary '").append(AbsolutePath$.MODULE$.syntax$extension(target)).append("'").toString());
                    } else if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable t = failure.exception();
                        String msg = Feedback$.MODULE$.failedToLink(project, ScalaNativeToolchain$.MODULE$.name(), t);
                        state = State$XState$.MODULE$.withTrace$extension(State$.MODULE$.XState(State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState(state), msg, ExitStatus$.MODULE$.LinkingError())), t);
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    return state;
                });
            } else {
                throw new MatchError((Object)option2);
            }
            task = task2;
        } else if (None$.MODULE$.equals(option)) {
            String artifactName = ScalaNativeToolchain$.MODULE$.artifactNameFrom(config0.version());
            String msg = Feedback$.MODULE$.missingLinkArtifactFor(project, artifactName, ScalaNativeToolchain$.MODULE$.name());
            task = Task$.MODULE$.now((Object)State$XState$.MODULE$.withError$extension0(State$.MODULE$.XState(state), msg));
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Config.LinkerMode getOptimizerMode(Option<OptimizerConfig> config, Config.LinkerMode fallbackMode) {
        OptimizerConfig optimizerConfig;
        boolean bl = false;
        Some some = null;
        Option<OptimizerConfig> option = config;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            OptimizerConfig optimizerConfig2 = (OptimizerConfig)some.value();
            if (OptimizerConfig$Debug$.MODULE$.equals(optimizerConfig2)) {
                return Config.LinkerMode$.Debug$.MODULE$;
            }
        }
        if (bl && OptimizerConfig$Release$.MODULE$.equals(optimizerConfig = (OptimizerConfig)some.value())) {
            return Config.LinkerMode$.Release$.MODULE$;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        return fallbackMode;
    }

    public Task<State> link(Commands.Link cmd, State state2, boolean sequential) {
        Task<State> task;
        Option<Project> option = state2.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            Function1 & Serializable & scala.Serializable linkTask = (Function1 & Serializable & scala.Serializable)state -> this.doLink$1(project, (State)state, cmd, sequential);
            task = cmd.watch() ? this.watch(project, state2, (Function1<State, Task<State>>)linkTask) : (Task<State>)linkTask.apply((Object)state2);
        } else if (None$.MODULE$.equals(option)) {
            String string = cmd.project();
            task = Task$.MODULE$.now((Object)this.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state2));
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private Task<State> run(Commands.Run cmd, State state2, boolean sequential) {
        Task<State> task;
        Path cwd = cmd.cliOptions().common().workingPath();
        Option<Project> option = state2.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            Function1 & Serializable & scala.Serializable runTask = (Function1 & Serializable & scala.Serializable)state -> this.doRun$1(project, (State)state, cmd, sequential, cwd);
            task = cmd.watch() ? this.watch(project, state2, (Function1<State, Task<State>>)runTask) : (Task<State>)runTask.apply((Object)state2);
        } else if (None$.MODULE$.equals(option)) {
            String string = cmd.project();
            task = Task$.MODULE$.now((Object)this.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state2));
        } else {
            throw new MatchError(option);
        }
        return task;
    }

    private boolean runCompile$default$5() {
        return false;
    }

    private State reportMissing(List<String> projectNames, State state) {
        String projects = projectNames.mkString("'", "', '", "'");
        String configDirectory = AbsolutePath$.MODULE$.syntax$extension(state.build().origin());
        return State$XState$.MODULE$.withError$extension0(State$.MODULE$.XState(State$XState$.MODULE$.withError$extension0(State$.MODULE$.XState(state), new StringBuilder(35).append("No projects named ").append(projects).append(" were found in '").append(configDirectory).append("'").toString())), "Use the `projects` command to list all existing projects").mergeStatus(ExitStatus$.MODULE$.InvalidCommandLineOption());
    }

    /*
     * Unable to fully structure code
     */
    public Either<State, String> getMainClass(State state, Project project, Option<String> cliMainClass) {
        block7: {
            block10: {
                block12: {
                    block11: {
                        block9: {
                            block8: {
                                block6: {
                                    var7_4 = Tasks$.MODULE$.findMainClasses(state, project);
                                    if (!Nil$.MODULE$.equals(var7_4)) break block6;
                                    var4_5 = package$.MODULE$.Left().apply((Object)State$XState$.MODULE$.withError$extension0(State$.MODULE$.XState(state), Feedback$.MODULE$.missingMainClass(project, Feedback$.MODULE$.missingMainClass$default$2())));
                                    break block7;
                                }
                                var8_6 = List$.MODULE$.unapplySeq(var7_4);
                                if (var8_6.isEmpty() || var8_6.get() == null || ((LinearSeqOptimized)var8_6.get()).lengthCompare(1) != 0) break block8;
                                main = (String)((LinearSeqOptimized)var8_6.get()).apply(0);
                                var4_5 = package$.MODULE$.Right().apply((Object)main);
                                break block7;
                            }
                            configMainClass = project.platform().mainClass();
                            var11_9 = false;
                            var12_10 = null;
                            var13_11 = cliMainClass;
                            if (!(var13_11 instanceof Some)) break block9;
                            var11_9 = true;
                            var12_10 = (Some)var13_11;
                            userMainClass = (String)var12_10.value();
                            if (!var7_4.contains((Object)userMainClass)) break block9;
                            var5_13 = package$.MODULE$.Right().apply((Object)userMainClass);
                            break block10;
                        }
                        if (!var11_9) break block11;
                        userMainClass = (String)var12_10.value();
                        var5_13 = package$.MODULE$.Left().apply((Object)State$XState$.MODULE$.withError$extension0(State$.MODULE$.XState(state), Interpreter$.withS$1(Feedback$.MODULE$.missingMainClass(project, userMainClass), var7_4)));
                        break block10;
                    }
                    if (!None$.MODULE$.equals(var13_11)) break block12;
                    var16_15 = false;
                    var17_16 = null;
                    var18_17 = configMainClass;
                    if (!(var18_17 instanceof Some)) ** GOTO lbl-1000
                    var16_15 = true;
                    var17_16 = (Some)var18_17;
                    configMainClass = (String)var17_16.value();
                    if (var7_4.contains((Object)configMainClass)) {
                        var6_19 = package$.MODULE$.Right().apply((Object)configMainClass);
                    } else if (var16_15) {
                        configMainClass = (String)var17_16.value();
                        msg = Interpreter$.withS$1(Feedback$.MODULE$.missingDefaultMainClass(project, configMainClass), var7_4);
                        var6_19 = package$.MODULE$.Left().apply((Object)State$XState$.MODULE$.withError$extension0(State$.MODULE$.XState(state), msg));
                    } else if (None$.MODULE$.equals(var18_17)) {
                        msg = Interpreter$.withS$1(Feedback$.MODULE$.expectedMainClass(project), var7_4);
                        var6_19 = package$.MODULE$.Left().apply((Object)State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState(state), msg, ExitStatus$.MODULE$.InvalidCommandLineOption()));
                    } else {
                        throw new MatchError((Object)var18_17);
                    }
                    var5_13 = var6_19;
                    break block10;
                }
                throw new MatchError(var13_11);
            }
            var4_5 = var5_13;
        }
        return var4_5;
    }

    private static final Task execute$1(Action action, Task stateTask, boolean inRecursion) {
        return stateTask.flatMap((Function1 & Serializable & scala.Serializable)state -> {
            Commands.Command cmd;
            ExitStatus exitStatus;
            boolean bl = false;
            Exit exit = null;
            boolean bl2 = false;
            Run run2 = null;
            Action action = action;
            if (action instanceof Exit) {
                ExitStatus exitStatus2;
                bl = true;
                exit = (Exit)action;
                ExitStatus exitStatus3 = exit.exitStatus();
                if (exitStatus3 != null && (exitStatus2 = exitStatus3).isOk()) {
                    return Task$.MODULE$.now((Object)state.mergeStatus(exitStatus2));
                }
            }
            if (bl && (exitStatus = exit.exitStatus()) != null) {
                ExitStatus exitStatus4 = exitStatus;
                return Task$.MODULE$.now((Object)state.mergeStatus(exitStatus4));
            }
            if (action instanceof Print) {
                Print print = (Print)action;
                String msg = print.msg();
                Action next = print.next();
                state.logger().info(msg);
                return Interpreter$.execute$1(next, Task$.MODULE$.now(state), true);
            }
            if (action instanceof Run) {
                bl2 = true;
                run2 = (Run)action;
                Commands.Command command = run2.command();
                Action next = run2.next();
                if (command instanceof Commands.About) {
                    return Interpreter$.execute$1(next, MODULE$.printAbout((State)state), true);
                }
            }
            if (bl2) {
                Commands.Command cmd2 = run2.command();
                Action next = run2.next();
                if (cmd2 instanceof Commands.ValidatedBsp) {
                    Commands.ValidatedBsp validatedBsp = (Commands.ValidatedBsp)cmd2;
                    return Interpreter$.execute$1(next, MODULE$.runBsp(validatedBsp, (State)state), true);
                }
            }
            if (bl2) {
                Commands.Command cmd3 = run2.command();
                Action next = run2.next();
                if (cmd3 instanceof Commands.Clean) {
                    Commands.Clean clean = (Commands.Clean)cmd3;
                    return Interpreter$.execute$1(next, MODULE$.clean(clean, (State)state), true);
                }
            }
            if (bl2) {
                Commands.Command cmd4 = run2.command();
                Action next = run2.next();
                if (cmd4 instanceof Commands.Compile) {
                    Commands.Compile compile = (Commands.Compile)cmd4;
                    return Interpreter$.execute$1(next, MODULE$.compile(compile, (State)state, inRecursion), true);
                }
            }
            if (bl2) {
                Commands.Command cmd5 = run2.command();
                Action next = run2.next();
                if (cmd5 instanceof Commands.Console) {
                    Commands.Console console = (Commands.Console)cmd5;
                    return Interpreter$.execute$1(next, MODULE$.console(console, (State)state, inRecursion), true);
                }
            }
            if (bl2) {
                Commands.Command cmd6 = run2.command();
                Action next = run2.next();
                if (cmd6 instanceof Commands.Projects) {
                    Commands.Projects projects = (Commands.Projects)cmd6;
                    return Interpreter$.execute$1(next, MODULE$.showProjects(projects, (State)state), true);
                }
            }
            if (bl2) {
                Commands.Command cmd7 = run2.command();
                Action next = run2.next();
                if (cmd7 instanceof Commands.Test) {
                    Commands.Test test = (Commands.Test)cmd7;
                    return Interpreter$.execute$1(next, MODULE$.test(test, (State)state, inRecursion), true);
                }
            }
            if (bl2) {
                Commands.Command cmd8 = run2.command();
                Action next = run2.next();
                if (cmd8 instanceof Commands.Run) {
                    Commands.Run run3 = (Commands.Run)cmd8;
                    return Interpreter$.execute$1(next, MODULE$.run(run3, (State)state, inRecursion), true);
                }
            }
            if (bl2) {
                Commands.Command cmd9 = run2.command();
                Action next = run2.next();
                if (cmd9 instanceof Commands.Configure) {
                    Commands.Configure configure = (Commands.Configure)cmd9;
                    return Interpreter$.execute$1(next, MODULE$.configure(configure, (State)state), true);
                }
            }
            if (bl2) {
                Commands.Command cmd10 = run2.command();
                Action next = run2.next();
                if (cmd10 instanceof Commands.Autocomplete) {
                    Commands.Autocomplete autocomplete = (Commands.Autocomplete)cmd10;
                    return Interpreter$.execute$1(next, MODULE$.autocomplete(autocomplete, (State)state), true);
                }
            }
            if (bl2) {
                Commands.Command cmd11 = run2.command();
                Action next = run2.next();
                if (cmd11 instanceof Commands.Link) {
                    Commands.Link link = (Commands.Link)cmd11;
                    return Interpreter$.execute$1(next, MODULE$.link(link, (State)state, inRecursion), true);
                }
            }
            if (bl2 && (cmd = run2.command()) instanceof Commands.Help) {
                Commands.Help help = (Commands.Help)cmd;
                String msg = "The handling of `help` does not happen in the `Interpreter`";
                Print printAction = new Print(msg, help.cliOptions().common(), new Exit(ExitStatus$.MODULE$.UnexpectedError()));
                return Interpreter$.execute$1(printAction, Task$.MODULE$.now(state), true);
            }
            if (!bl2) throw new MatchError((Object)action);
            Commands.Command cmd12 = run2.command();
            if (!(cmd12 instanceof Commands.Bsp)) throw new MatchError((Object)action);
            Commands.Bsp bsp = (Commands.Bsp)cmd12;
            String msg = "Internal error: The `bsp` command must be validated before use";
            Print printAction = new Print(msg, bsp.cliOptions().common(), new Exit(ExitStatus$.MODULE$.UnexpectedError()));
            return Interpreter$.execute$1(printAction, Task$.MODULE$.now(state), true);
        });
    }

    public static final /* synthetic */ Task $anonfun$runCompile$1(Commands.CompilingCommand cmd$9, Project project$3, boolean deduplicateFailures$2, boolean excludeRoot$1, CompileMode.ConfigurableMode compilerMode$1, State state) {
        ReporterConfig config = ReporterKind$.MODULE$.toReporterConfig(cmd$9.reporter());
        return CompilationTask$.MODULE$.compile(state, project$3, config, deduplicateFailures$2, compilerMode$1, cmd$9.pipeline(), excludeRoot$1);
    }

    public static final /* synthetic */ void $anonfun$showProjects$3(State state$4, String x$1) {
        state$4.logger().info(x$1);
    }

    private final Task doTest$1(State state2, Commands.Test cmd$4, boolean sequential$1, Project project$7) {
        Function1<String, Object> testFilter = TestInternals$.MODULE$.parseFilters(cmd$4.only());
        Path cwd = cmd$4.cliOptions().common().workingPath();
        return this.compileAnd(cmd$4, state2, project$7, false, sequential$1, "`test`", (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> {
            LoggingEventHandler handler = new LoggingEventHandler(state.logger());
            return Tasks$.MODULE$.test((State)state, project$7, cwd, cmd$4.includeDependencies(), cmd$4.args(), testFilter, handler);
        });
    }

    public static final /* synthetic */ boolean $anonfun$autocomplete$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$autocomplete$4(State state$6, String completion) {
        state$6.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$3(Commands.Autocomplete cmd$7, State state$6, Tuple2 x$11) {
        Tuple2 tuple2 = x$11;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        CommandMessages args = (CommandMessages)tuple2._2();
        cmd$7.format().showCommand(name, args).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$4(state$6, completion);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$autocomplete$6(State state$6, String completion) {
        state$6.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$5(Commands.Autocomplete cmd$7, State state$6, Project project) {
        cmd$7.format().showProject(project).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$6(state$6, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$10(State state$6, String completion) {
        state$6.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$9(Commands.Autocomplete cmd$7, State state$6, String command$1, Arg arg) {
        cmd$7.format().showArg(command$1, Case$.MODULE$.kebabizeArg(arg)).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$10(state$6, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$8(Commands.Autocomplete cmd$7, State state$6, String command$1, CommandMessages message) {
        message.args().foreach((Function1 & Serializable & scala.Serializable)arg -> {
            Interpreter$.$anonfun$autocomplete$9(cmd$7, state$6, command$1, arg);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$7(Commands.Autocomplete cmd$7, State state$6, String command) {
        CliParsers$.MODULE$.CommandsMessages().messages().toMap(Predef$.MODULE$.$conforms()).get((Object)command).foreach((Function1 & Serializable & scala.Serializable)message -> {
            Interpreter$.$anonfun$autocomplete$8(cmd$7, state$6, command, message);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$12(State state$6, String completion) {
        state$6.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$11(Commands.Autocomplete cmd$7, State state$6, ReporterKind reporter) {
        cmd$7.format().showReporter(reporter).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$12(state$6, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$14(State state$6, String completion) {
        state$6.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$13(Commands.Autocomplete cmd$7, State state$6, BspProtocol protocol) {
        cmd$7.format().showProtocol(protocol).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$14(state$6, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$18(State state$6, String completion) {
        state$6.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$17(Commands.Autocomplete cmd$7, State state$6, String main) {
        cmd$7.format().showMainName(main).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$18(state$6, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$16(Commands.Autocomplete cmd$7, State state$6, Project project) {
        Tasks$.MODULE$.findMainClasses(state$6, project).foreach((Function1 & Serializable & scala.Serializable)main -> {
            Interpreter$.$anonfun$autocomplete$17(cmd$7, state$6, main);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$15(Commands.Autocomplete cmd$7, State state$6, String projectName) {
        state$6.build().getProjectFor(projectName).foreach((Function1 & Serializable & scala.Serializable)project -> {
            Interpreter$.$anonfun$autocomplete$16(cmd$7, state$6, project);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$21(State state$6, String completion) {
        state$6.logger().info(completion);
    }

    public static final /* synthetic */ void $anonfun$autocomplete$20(Commands.Autocomplete cmd$7, State state$6, String placeholder) {
        cmd$7.format().showTestName(placeholder).foreach((Function1 & Serializable & scala.Serializable)completion -> {
            Interpreter$.$anonfun$autocomplete$21(state$6, completion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$autocomplete$19(Commands.Autocomplete cmd$7, State state$6, String projectName) {
        List$.MODULE$.empty().foreach((Function1 & Serializable & scala.Serializable)placeholder -> {
            Interpreter$.$anonfun$autocomplete$20(cmd$7, state$6, placeholder);
            return BoxedUnit.UNIT;
        });
    }

    private final Task doLink$1(Project project, State state2, Commands.Link cmd$8, boolean sequential$3) {
        return this.compileAnd(cmd$8, state2, project, false, sequential$3, "`link`", (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state -> {
            Task task;
            Either<State, String> either = MODULE$.getMainClass((State)state, project, cmd$8.main());
            if (either instanceof Left) {
                Left left = (Left)either;
                State state2 = (State)left.value();
                task = Task$.MODULE$.now((Object)state2);
            } else if (either instanceof Right) {
                Task<State> task2;
                Right right = (Right)either;
                String mainClass = (String)right.value();
                Config.Platform platform = project.platform();
                if (platform instanceof Config.Platform$.Native) {
                    Config.Platform$.Native native_ = (Config.Platform$.Native)platform;
                    Config.NativeConfig config = native_.config();
                    Path target = ScalaNativeToolchain$.MODULE$.linkTargetFrom(config, project.out());
                    task2 = MODULE$.linkWithScalaNative(cmd$8, project, (State)state, mainClass, target, config);
                } else if (platform instanceof Config.Platform$.Js) {
                    Config.Platform$.Js js = (Config.Platform$.Js)platform;
                    Config.JsConfig config = js.config();
                    Path target = ScalaJsToolchain$.MODULE$.linkTargetFrom(config, project.out());
                    task2 = MODULE$.linkWithScalaJs(cmd$8, project, (State)state, mainClass, target, config);
                } else if (platform instanceof Config.Platform$.Jvm) {
                    String msg = Feedback$.MODULE$.noLinkFor(project);
                    task2 = Task$.MODULE$.now((Object)State$XState$.MODULE$.withError$extension2(State$.MODULE$.XState((State)state), msg, ExitStatus$.MODULE$.InvalidCommandLineOption()));
                } else {
                    throw new MatchError((Object)platform);
                }
                task = task2;
            } else {
                throw new MatchError(either);
            }
            return task;
        });
    }

    private final Task doRun$1(Project project, State state, Commands.Run cmd$5, boolean sequential$2, Path cwd$2) {
        return this.compileAnd(cmd$5, state, project, false, sequential$2, "`run`", (Function1<State, Task<State>>)(Function1 & Serializable & scala.Serializable)state2 -> {
            Task task;
            Either<State, String> either = MODULE$.getMainClass((State)state2, project, cmd$5.main());
            if (either instanceof Left) {
                Left left = (Left)either;
                State state3 = (State)left.value();
                task = Task$.MODULE$.now((Object)state3);
            } else if (either instanceof Right) {
                Task task2;
                Right right = (Right)either;
                String mainClass = (String)right.value();
                Config.Platform platform = project.platform();
                if (platform instanceof Config.Platform$.Native) {
                    Config.Platform$.Native native_ = (Config.Platform$.Native)platform;
                    Config.NativeConfig config = native_.config();
                    Path target = ScalaNativeToolchain$.MODULE$.linkTargetFrom(config, project.out());
                    task2 = MODULE$.linkWithScalaNative(cmd$5, project, (State)state2, mainClass, target, config).flatMap((Function1 & Serializable & scala.Serializable)state -> {
                        String string = AbsolutePath$.MODULE$.syntax$extension(target);
                        String[] args = (String[])((TraversableOnce)cmd$5.args().$plus$colon((Object)string, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                        return !state.status().isOk() ? Task$.MODULE$.now(state) : Tasks$.MODULE$.runNativeOrJs((State)state, project, cwd$2, mainClass, args);
                    });
                } else if (platform instanceof Config.Platform$.Js) {
                    Config.Platform$.Js js = (Config.Platform$.Js)platform;
                    Config.JsConfig config = js.config();
                    Path target = ScalaJsToolchain$.MODULE$.linkTargetFrom(config, project.out());
                    task2 = MODULE$.linkWithScalaJs(cmd$5, project, (State)state2, mainClass, target, config).flatMap((Function1 & Serializable & scala.Serializable)state -> {
                        String string = "node";
                        String string2 = AbsolutePath$.MODULE$.syntax$extension(target);
                        String[] args = (String[])((TraversableOnce)((List)cmd$5.args().$plus$colon((Object)string2, List$.MODULE$.canBuildFrom())).$plus$colon((Object)string, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                        return !state.status().isOk() ? Task$.MODULE$.now(state) : Tasks$.MODULE$.runNativeOrJs((State)state, project, cwd$2, mainClass, args);
                    });
                } else if (platform instanceof Config.Platform$.Jvm) {
                    task2 = Tasks$.MODULE$.runJVM((State)state2, project, cwd$2, mainClass, (String[])cmd$5.args().toArray(ClassTag$.MODULE$.apply(String.class)));
                } else {
                    throw new MatchError((Object)platform);
                }
                task = task2;
            } else {
                throw new MatchError(either);
            }
            return task;
        });
    }

    private static final String withS$1(String msg, List x1$2) {
        return Feedback$.MODULE$.XMessageString(msg).suggest(Feedback$.MODULE$.listMainClasses((List<String>)x1$2));
    }

    private Interpreter$() {
        MODULE$ = this;
        this.line = System.lineSeparator();
    }
}

