/*
 * Decompiled with CFR 0.152.
 */
package bloop.data;

import bloop.data.ClientInfo;
import bloop.data.ClientInfo$CliClientInfo$;
import bloop.data.Project;
import bloop.io.AbsolutePath;
import bloop.io.Paths$;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Traversable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class ClientInfo$ {
    public static ClientInfo$ MODULE$;
    private final Regex internalClassesNameFormat;

    static {
        new ClientInfo$();
    }

    public Regex internalClassesNameFormat() {
        return this.internalClassesNameFormat;
    }

    public Option<String> toGenericClassesDir(Path internalClassesDir) {
        String internalDirName;
        String string = internalDirName = ((Object)internalClassesDir.getFileName()).toString();
        Option option = this.internalClassesNameFormat().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String genericClassesName = (String)((LinearSeqOptimized)option.get()).apply(0);
            return new Some((Object)genericClassesName);
        }
        return None$.MODULE$;
    }

    public String activeSinceMillis(long startMs) {
        Instant start = Instant.ofEpochMilli(startMs);
        Instant now = Instant.ofEpochMilli(System.currentTimeMillis());
        Duration duration = Duration.between(start, now);
        return duration.toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase();
    }

    public void deleteOrphanClientBspDirectories(Function0<Traversable<ClientInfo.BspClientInfo>> currentBspClients, PrintStream out, PrintStream err) {
        Instant deletionThresholdInstant = Instant.now().minusSeconds(45L);
        Traversable currentBspConnectedClients = (Traversable)currentBspClients.apply();
        ListBuffer connectedBspClientIds = new ListBuffer();
        HashMap projectsToVisit = new HashMap();
        currentBspConnectedClients.foreach((Function1 & Serializable & scala.Serializable)client -> {
            ClientInfo$.$anonfun$deleteOrphanClientBspDirectories$1(connectedBspClientIds, projectsToVisit, client);
            return BoxedUnit.UNIT;
        });
        projectsToVisit.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientInfo$.$anonfun$deleteOrphanClientBspDirectories$3(deletionThresholdInstant, connectedBspClientIds, out, err, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$deleteOrphanClientBspDirectories$1(ListBuffer connectedBspClientIds$1, HashMap projectsToVisit$1, ClientInfo.BspClientInfo client) {
        Object object = client.hasAnActiveConnection() ? connectedBspClientIds$1.$plus$eq((Object)client.uniqueId()) : BoxedUnit.UNIT;
        ((GenSetLike)JavaConverters$.MODULE$.asScalaSetConverter(client.uniqueDirs().keySet()).asScala()).iterator().foreach((Function1 & Serializable & scala.Serializable)project -> projectsToVisit$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(project), (Object)client)));
    }

    public static final /* synthetic */ void $anonfun$deleteOrphanClientBspDirectories$4(Instant deletionThresholdInstant$1, ListBuffer connectedBspClientIds$1, PrintStream out$1, PrintStream err$1, Path clientDir) {
        try {
            boolean isAllowed;
            String dirName = ((Object)clientDir.getFileName()).toString();
            BasicFileAttributes attrs = Files.readAttributes(clientDir, BasicFileAttributes.class, new LinkOption[0]);
            boolean isOldDir = attrs.creationTime().toInstant().isBefore(deletionThresholdInstant$1);
            boolean bl = isAllowed = ClientInfo$CliClientInfo$.MODULE$.isStableDirName(dirName) || connectedBspClientIds$1.exists((Function1 & Serializable & scala.Serializable)clientId -> BoxesRunTime.boxToBoolean((boolean)dirName.endsWith(new StringBuilder(1).append("-").append(clientId).toString())));
            if (!isAllowed && isOldDir) {
                out$1.println(new StringBuilder(26).append("Deleting orphan directory ").append(new AbsolutePath(clientDir)).toString());
                Paths$.MODULE$.delete(clientDir);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof NoSuchFileException) {
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                err$1.println(new StringBuilder(41).append("Failed to delete unused client directory ").append(new AbsolutePath(clientDir)).toString());
                t.printStackTrace(err$1);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final /* synthetic */ void $anonfun$deleteOrphanClientBspDirectories$3(Instant deletionThresholdInstant$1, ListBuffer connectedBspClientIds$1, PrintStream out$1, PrintStream err$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Project project = (Project)tuple2._1();
        ClientInfo.BspClientInfo client = (ClientInfo.BspClientInfo)tuple2._2();
        boolean bl = false;
        Some some = null;
        Option<Either<AbsolutePath, AbsolutePath>> option = client.parentForClientClassesDirectories(project);
        if (None$.MODULE$.equals(option)) {
            return;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Either either = (Either)some.value();
            if (either instanceof Left) {
                return;
            }
        }
        if (!bl) throw new MatchError(option);
        Either either = (Either)some.value();
        if (!(either instanceof Right)) throw new MatchError(option);
        Right right = (Right)either;
        Path bspClientClassesDir = ((AbsolutePath)right.value()).underlying();
        try {
            Paths$.MODULE$.list(bspClientClassesDir).foreach((Function1 & Serializable & scala.Serializable)clientDir -> {
                ClientInfo$.$anonfun$deleteOrphanClientBspDirectories$4(deletionThresholdInstant$1, connectedBspClientIds$1, out$1, err$1, ((AbsolutePath)clientDir).underlying());
                return BoxedUnit.UNIT;
            });
            boxedUnit = BoxedUnit.UNIT;
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof NoSuchFileException) {
            } else {
                Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                if (option2.isEmpty()) throw throwable;
                Throwable t = (Throwable)option2.get();
                err$1.println(new StringBuilder(44).append("Couldn't prune orphan classes directory for ").append(project.name()).toString());
                t.printStackTrace(err$1);
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private ClientInfo$() {
        MODULE$ = this;
        this.internalClassesNameFormat = new StringOps(Predef$.MODULE$.augmentString("(.*)-[^-]*-[^-]*-[^-]*$")).r();
    }
}

