/*
 * Decompiled with CFR 0.152.
 */
package bloop;

import bloop.BloopServer;
import bloop.Cli;
import bloop.io.Paths$;
import bloop.util.ProxySetup$;
import com.martiansoftware.nailgun.Alias;
import com.martiansoftware.nailgun.AliasManager;
import com.martiansoftware.nailgun.NGContext;
import com.martiansoftware.nailgun.NGListeningAddress;
import com.martiansoftware.nailgun.NGServer;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.channels.Channel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import libdaemonjvm.LockFiles;
import libdaemonjvm.LockFiles$;
import libdaemonjvm.SocketPaths;
import libdaemonjvm.Util$;
import libdaemonjvm.internal.LockProcess$;
import libdaemonjvm.internal.SocketHandler$;
import libdaemonjvm.server.Lock$;
import libdaemonjvm.server.LockError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;
import scala.util.Try$;
import sun.misc.Signal;

public final class BloopServer$ {
    public static BloopServer$ MODULE$;
    private final int defaultPort;

    static {
        new BloopServer$();
    }

    private void ensureSafeDirectoryExists(Path dir) {
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
            if (!Properties$.MODULE$.isWin()) {
                Files.setPosixFilePermissions(dir, PosixFilePermissions.fromString("rwx------"));
                return;
            }
            return;
        }
    }

    private int defaultPort() {
        return this.defaultPort;
    }

    public void main(String[] args) {
        Right right;
        String[] stringArray = args;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(0) == 0) {
            Path dir = Paths$.MODULE$.daemonDir();
            right = package$.MODULE$.Right().apply((Object)dir);
        } else {
            String daemonArg;
            Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0 && (daemonArg = (String)((SeqLike)option2.get()).apply(0)).startsWith("daemon:")) {
                Path dir = Paths.get(new StringOps(Predef$.MODULE$.augmentString(daemonArg)).stripPrefix("daemon:"), new String[0]);
                right = package$.MODULE$.Right().apply((Object)dir);
            } else {
                Option option3 = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (!option3.isEmpty() && option3.get() != null && ((SeqLike)option3.get()).lengthCompare(1) == 0) {
                    String arg = (String)((SeqLike)option3.get()).apply(0);
                    right = package$.MODULE$.Left().apply((Object)new Tuple2((Object)InetAddress.getLoopbackAddress(), (Object)BoxesRunTime.boxToInteger((int)BloopServer$.toPortNumber$1(arg))));
                } else {
                    Option option4 = Array$.MODULE$.unapplySeq((Object)stringArray);
                    if (!option4.isEmpty() && option4.get() != null && ((SeqLike)option4.get()).lengthCompare(2) == 0) {
                        String host = (String)((SeqLike)option4.get()).apply(0);
                        String portStr = (String)((SeqLike)option4.get()).apply(1);
                        InetAddress addr = InetAddress.getByName(host);
                        right = package$.MODULE$.Left().apply((Object)new Tuple2((Object)addr, (Object)BoxesRunTime.boxToInteger((int)BloopServer$.toPortNumber$1(portStr))));
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(81).append("Invalid arguments to bloop server: ").append(args).append(", expected: ([address] [port] | [daemon:path])").toString());
                    }
                }
            }
        }
        Right lockFilesDirOrHostPort = right;
        long pid = ProcessHandle.current().pid();
        System.err.println(new StringBuilder(18).append("Bloop server PID: ").append(pid).toString());
        if (Boolean.getBoolean("bloop.ignore-sig-int")) {
            System.err.println("Ignoring SIGINT");
            this.ignoreSigint();
        }
        scala.sys.package$.MODULE$.props().get("bloop.truncate-output-file-periodically").foreach((Function1 & Serializable & scala.Serializable)value -> {
            BloopServer$.$anonfun$main$3(value);
            return BoxedUnit.UNIT;
        });
        Right right2 = lockFilesDirOrHostPort;
        if (right2 instanceof Left) {
            Left left = (Left)right2;
            Tuple2 hostPort = (Tuple2)left.value();
            this.startServer((Either<Tuple2<InetAddress, Object>, SocketPaths>)package$.MODULE$.Left().apply((Object)hostPort));
            return;
        }
        if (right2 instanceof Right) {
            Right right3 = right2;
            Path lockFilesDir = (Path)right3.value();
            FiniteDuration period = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).second();
            int attempts = 10;
            this.loop$1(attempts, lockFilesDir, period);
            return;
        }
        throw new MatchError((Object)right2);
    }

    private void ignoreSigint() {
        Signal.handle(new Signal("INT"), x$1 -> System.err.println("Ignoring Ctrl+C interruption"));
    }

    private void truncateFilePeriodically(Path file) {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){
            private final AtomicInteger count;

            private AtomicInteger count() {
                return this.count;
            }

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, new StringBuilder(14).append("truncate-file-").append(this.count().incrementAndGet()).toString());
                t.setDaemon(true);
                return t;
            }
            {
                this.count = new AtomicInteger();
            }
        });
        FiniteDuration period = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).minutes();
        int maxSize = 0x100000;
        Runnable runnable = () -> {
            block6: {
                try {
                    long size;
                    if (!Files.exists(file, new LinkOption[0]) || (size = Files.size(file)) <= (long)maxSize) break block6;
                    try (Channel bc = null;){
                        bc = Files.newByteChannel(file, StandardOpenOption.WRITE);
                        bc.truncate(0L);
                    }
                    PrintStream ps = new PrintStream(Files.newOutputStream(file, new OpenOption[0]));
                    PrintStream formerOut = System.out;
                    PrintStream formerErr = System.err;
                    System.setOut(ps);
                    System.setErr(ps);
                    formerOut.close();
                    formerErr.close();
                    System.err.println(new StringBuilder(28).append("Truncated ").append(file).append(" (former size: ").append(size).append(" B)").toString());
                }
                catch (Throwable t) {
                    System.err.println(new StringBuilder(61).append("Caught ").append(t).append(" while checking if ").append(file).append(" needs to be truncated, ignoring it").toString());
                    t.printStackTrace(System.err);
                }
            }
        };
        scheduler.scheduleAtFixedRate(runnable, period.length(), period.length(), period.unit());
    }

    public void startServer(Either<Tuple2<InetAddress, Object>, SocketPaths> socketPathsOrHostPort) {
        Either socketAndPathOrHostPort = socketPathsOrHostPort.map((Function1 & Serializable & scala.Serializable)socketPaths -> {
            ServerSocket socket = Util$.MODULE$.serverSocketFromChannel(SocketHandler$.MODULE$.server(socketPaths));
            return new Tuple2((Object)socket, (Object)socketPaths.path());
        });
        NGServer server = this.instantiateServer((Either<Tuple2<InetAddress, Object>, Tuple2<ServerSocket, String>>)socketAndPathOrHostPort.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ServerSocket sock = (ServerSocket)tuple2._1();
                Path path = (Path)tuple2._2();
                return new Tuple2((Object)sock, (Object)((Object)path).toString());
            }
            throw new MatchError((Object)tuple2);
        }));
        Runnable runServer = () -> {
            try {
                server.run();
            }
            finally {
                socketAndPathOrHostPort.toOption().map((Function1 & Serializable & scala.Serializable)x$2 -> (Path)x$2._2()).foreach((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)BloopServer$.$anonfun$startServer$5(path)));
            }
        };
        new Thread(runServer, "bloop-server").start();
    }

    public NGServer instantiateServer(Either<Tuple2<InetAddress, Object>, Tuple2<ServerSocket, String>> socketAndPathOrHostPort) {
        Right right;
        Tuple2 tuple2;
        Left left;
        Tuple2 tuple22;
        Either<Tuple2<InetAddress, Object>, Tuple2<ServerSocket, String>> either = socketAndPathOrHostPort;
        if (either instanceof Left && (tuple22 = (Tuple2)(left = (Left)either).value()) != null) {
            InetAddress addr = (InetAddress)tuple22._1();
            int port = tuple22._2$mcI$sp();
            NGListeningAddress tcpAddress = new NGListeningAddress(addr, port);
            return this.launchServer(System.in, System.out, System.err, tcpAddress, (Option<ServerSocket>)None$.MODULE$);
        }
        if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
            ServerSocket socket = (ServerSocket)tuple2._1();
            String socketPath = (String)tuple2._2();
            NGListeningAddress socketAddress = new NGListeningAddress(socketPath);
            return this.launchServer(System.in, System.out, System.err, socketAddress, (Option<ServerSocket>)new Some((Object)socket));
        }
        throw new MatchError(either);
    }

    public NGServer launchServer(InputStream in, PrintStream out, PrintStream err, NGListeningAddress address, Option<ServerSocket> serverSocketOpt) {
        Logger javaLogger = LoggerFactory.getLogger(NGServer.class);
        int poolSize = 2;
        int heartbeatMs = 10000;
        NGServer.DomainSocketProvider domainSocketProvider = () -> (ServerSocket)serverSocketOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error("Shouldn't be called"));
        NGServer server = new NGServer(address, poolSize, heartbeatMs, in, out, err, javaLogger, domainSocketProvider, false);
        this.registerAliases(server);
        ProxySetup$.MODULE$.init();
        return server;
    }

    public void nailMain(NGContext ngContext) {
        NGServer server = ngContext.getNGServer();
        boolean soft = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ngContext.getArgs())).contains((Object)"--soft");
        server.shutdown(!soft);
    }

    private void registerAliases(NGServer server) {
        AliasManager aliasManager = server.getAliasManager();
        aliasManager.addAlias(new Alias("about", "Show bloop information.", Cli.class));
        aliasManager.addAlias(new Alias("clean", "Clean project(s) in the build.", Cli.class));
        aliasManager.addAlias(new Alias("compile", "Compile project(s) in the build.", Cli.class));
        aliasManager.addAlias(new Alias("test", "Run project(s)' tests in the build.", Cli.class));
        aliasManager.addAlias(new Alias("run", "Run a main entrypoint for project(s) in the build.", Cli.class));
        aliasManager.addAlias(new Alias("bsp", "Spawn a build server protocol instance.", Cli.class));
        aliasManager.addAlias(new Alias("console", "Run the console for project(s) in the build.", Cli.class));
        aliasManager.addAlias(new Alias("projects", "Show projects in the build.", Cli.class));
        aliasManager.addAlias(new Alias("configure", "Configure the bloop server.", Cli.class));
        aliasManager.addAlias(new Alias("help", "Show bloop help message.", Cli.class));
        aliasManager.addAlias(new Alias("exit", "Kill the bloop server.", BloopServer.class));
        aliasManager.addAlias(new Alias("ng-stop", "Kill the bloop server.", BloopServer.class));
        server.setDefaultNailClass(Cli.class);
        server.setAllowNailsByClassName(false);
    }

    private static final int toPortNumber$1(String userPort) {
        return BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(userPort)).toInt()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.defaultPort()));
    }

    public static final /* synthetic */ void $anonfun$main$3(String value) {
        System.err.println(new StringBuilder(42).append("Will truncate output file ").append(value).append(" every 5 minutes").toString());
        MODULE$.truncateFilePeriodically(Paths.get(value, new String[0]));
    }

    private final void loop$1(int remainingAttempts, Path lockFilesDir$1, FiniteDuration period$1) {
        block10: {
            Either either;
            block9: {
                LockError err;
                Left left;
                boolean bl;
                block8: {
                    LockError.RecoverableError recoverableError;
                    while (true) {
                        LockError err2;
                        this.ensureSafeDirectoryExists(lockFilesDir$1);
                        LockFiles lockFiles = LockFiles$.MODULE$.under(lockFilesDir$1);
                        Either res = Lock$.MODULE$.tryAcquire(lockFiles, LockProcess$.MODULE$.default(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.startServer((Either<Tuple2<InetAddress, Object>, SocketPaths>)package$.MODULE$.Right().apply((Object)lockFiles.socketPaths())));
                        bl = false;
                        left = null;
                        either = res;
                        if (either instanceof Left) {
                            bl = true;
                            left = (Left)either;
                            if (left.value() instanceof LockError.ZombieFound) {
                                System.err.println(new StringBuilder(40).append("Found zombie process, removing files in ").append(lockFilesDir$1).toString());
                                Files.delete(lockFiles.pidFile());
                                Files.delete(lockFiles.lockFile());
                                Files.delete(lockFiles.socketPaths().path());
                                --remainingAttempts;
                                continue;
                            }
                        }
                        if (!bl || !((err2 = (LockError)left.value()) instanceof LockError.RecoverableError)) break block8;
                        recoverableError = (LockError.RecoverableError)err2;
                        if (remainingAttempts <= 0) break;
                        System.err.println(new StringBuilder(25).append("Caught ").append(recoverableError).append(", trying again in ").append(period$1).toString());
                        Thread.sleep(period$1.toMillis());
                        --remainingAttempts;
                    }
                    throw new Exception((Throwable)recoverableError);
                }
                if (bl && left.value() instanceof LockError.AlreadyRunning) {
                    throw scala.sys.package$.MODULE$.exit(222);
                }
                if (bl && (err = (LockError)left.value()) instanceof LockError.FatalError) {
                    LockError.FatalError fatalError = (LockError.FatalError)err;
                    throw new Exception((Throwable)fatalError);
                }
                if (!(either instanceof Right)) break block9;
                Right right = (Right)either;
                BoxedUnit boxedUnit = (BoxedUnit)right.value();
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                BoxedUnit boxedUnit3 = boxedUnit;
                if (!(boxedUnit2 != null ? !boxedUnit2.equals(boxedUnit3) : boxedUnit3 != null)) break block10;
            }
            throw new MatchError((Object)either);
        }
    }

    public static final /* synthetic */ boolean $anonfun$startServer$5(Path path) {
        return Files.deleteIfExists(path);
    }

    private BloopServer$() {
        MODULE$ = this;
        this.defaultPort = 8212;
    }
}

