/*
 * Decompiled with CFR 0.152.
 */
package bloop;

import bloop.Cli;
import bloop.CompilerCache;
import bloop.cli.BspProtocol;
import bloop.cli.CliOptions;
import bloop.cli.CliOptions$;
import bloop.cli.Commands;
import bloop.cli.Commands$RawCommand$;
import bloop.cli.CommonOptions;
import bloop.cli.CommonOptions$;
import bloop.cli.CommonOptions$PrettyProperties$;
import bloop.cli.ExitStatus;
import bloop.cli.ExitStatus$;
import bloop.cli.OptimizerConfig;
import bloop.cli.ReplKind;
import bloop.cli.ReporterKind;
import bloop.cli.Validate$;
import bloop.data.ClientInfo;
import bloop.engine.Action;
import bloop.engine.Build;
import bloop.engine.ClientPool;
import bloop.engine.CloseEvent;
import bloop.engine.ExecutionContext$;
import bloop.engine.Exit;
import bloop.engine.Interpreter$;
import bloop.engine.NailgunPool;
import bloop.engine.NoPool$;
import bloop.engine.Print;
import bloop.engine.Run;
import bloop.engine.State;
import bloop.engine.State$;
import bloop.engine.caches.ResultsCache;
import bloop.engine.caches.SourceGeneratorCache;
import bloop.internal.build.BuildInfo$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.Paths$;
import bloop.logging.BloopLogger$;
import bloop.logging.DebugFilter;
import bloop.logging.DebugFilter$;
import bloop.logging.Logger;
import bloop.task.Task;
import bloop.task.Task$;
import bloop.util.Java8Compat;
import bloop.util.Java8Compat$;
import bloop.util.JavaRuntime$;
import bloop.util.ProxySetup$;
import caseapp.core.Arg;
import caseapp.core.Error;
import caseapp.core.RemainingArgs;
import caseapp.core.help.CommandHelp;
import caseapp.core.help.Help;
import caseapp.core.help.Help$;
import caseapp.core.help.WithHelp;
import com.martiansoftware.nailgun.NGContext;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import monix.execution.CancelableFuture;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBoolean$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class Cli$ {
    public static Cli$ MODULE$;
    private final DebugFilter.All$ filter;
    private final Seq<String> commands;
    private final Help<BoxedUnit> beforeCommandMessages;
    private final String progName;
    private final Try<BoxedUnit> _;
    private final CompletableFuture<Boolean> FalseCancellation;
    private final ConcurrentHashMap<Path, List<Cli.CliSession>> activeCliSessions;

    static {
        new Cli$();
    }

    private DebugFilter.All$ filter() {
        return this.filter;
    }

    public void main(String[] args) {
        Action action = this.parse(args, CommonOptions$.MODULE$.default());
        ExitStatus exitStatus = this.run(action, NoPool$.MODULE$);
        throw package$.MODULE$.exit(exitStatus.code());
    }

    public int reflectMain(String[] args, Path cwd, InputStream in, PrintStream out, PrintStream err, Properties props, CompletableFuture<Boolean> cancel) {
        CommonOptions.PrettyProperties env = CommonOptions$PrettyProperties$.MODULE$.from(props);
        InputStream x$1 = in;
        PrintStream x$2 = out;
        PrintStream x$3 = err;
        PrintStream x$4 = out;
        PrintStream x$5 = err;
        String x$6 = ((Object)cwd.toAbsolutePath()).toString();
        CommonOptions.PrettyProperties x$7 = env;
        CommonOptions nailgunOptions = new CommonOptions(x$6, x$2, x$1, x$3, x$4, x$5, x$7);
        Action cmd = this.parse(args, nailgunOptions);
        ExitStatus exitStatus = this.run(cmd, NoPool$.MODULE$, cancel);
        return exitStatus.code();
    }

    public void nailMain(NGContext ngContext) {
        String[] stringArray;
        String command;
        CommonOptions.PrettyProperties env = CommonOptions$PrettyProperties$.MODULE$.from(ngContext.getEnv());
        InputStream x$1 = ngContext.in;
        PrintStream x$2 = ngContext.out;
        PrintStream x$3 = ngContext.err;
        PrintStream x$4 = ngContext.out;
        PrintStream x$5 = ngContext.err;
        String x$6 = ngContext.getWorkingDirectory();
        CommonOptions.PrettyProperties x$7 = env;
        CommonOptions nailgunOptions = new CommonOptions(x$6, x$2, x$1, x$3, x$4, x$5, x$7);
        String string = command = ngContext.getCommand();
        String string2 = "bloop.Cli";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            stringArray = ngContext.getArgs();
        } else {
            String string3 = command;
            stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ngContext.getArgs())).$plus$colon((Object)string3, ClassTag$.MODULE$.apply(String.class));
        }
        String[] args = stringArray;
        String string4 = command;
        String string5 = "bloop";
        Action cmd = !(string4 != null ? !string4.equals(string5) : string5 != null) ? this.printErrorAndExit(this.helpAsked(), nailgunOptions) : this.parse(args, nailgunOptions);
        Predef$.MODULE$.println((Object)nailgunOptions.workingDirectory());
        Predef$.MODULE$.println((Object)new AbsolutePath(nailgunOptions.workingPath()));
        try {
            ExitStatus exitStatus = this.run(cmd, new NailgunPool(ngContext));
            ngContext.exit(exitStatus.code());
        }
        catch (ExecutionException x) {
            x.getCause().printStackTrace(ngContext.out);
            ngContext.exit(ExitStatus$.MODULE$.UnexpectedError().code());
        }
    }

    public Seq<String> commands() {
        return this.commands;
    }

    public Help<BoxedUnit> beforeCommandMessages() {
        return this.beforeCommandMessages;
    }

    private String progName() {
        return this.progName;
    }

    private String helpAsked() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append(this.beforeCommandMessages().help()).append("\n       |Available commands: ").append(this.commands().mkString(", ")).append("\n       |Type `").append(this.progName()).append(" 'command' --help` for help on an individual command\n     ").toString())).stripMargin();
    }

    private String commandHelpAsked(String command) {
        CommandHelp messages = (CommandHelp)Commands$RawCommand$.MODULE$.help().messagesMap().apply((Object)new .colon.colon((Object)command, (List)Nil$.MODULE$));
        None$ argsName = messages.args().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Cli$.$anonfun$commandHelpAsked$1(x$3))) ? new Some((Object)"project") : None$.MODULE$;
        return messages.withArgsNameOption((Option)argsName).helpMessage(this.beforeCommandMessages().progName(), (Seq)new .colon.colon((Object)command, (List)Nil$.MODULE$));
    }

    private String usageAsked() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(104).append(this.beforeCommandMessages().usage()).append("\n       |Available commands: ").append(this.commands().mkString(", ")).append("\n       |Type `").append(this.progName()).append(" 'command' --usage` for usage of an individual command\n     ").toString())).stripMargin();
    }

    private String aboutAsked() {
        String bloopName = BuildInfo$.MODULE$.bloopName();
        String bloopVersion = BuildInfo$.MODULE$.version();
        String scalaVersion = BuildInfo$.MODULE$.scalaVersion();
        String zincVersion = BuildInfo$.MODULE$.zincVersion();
        String javaVersion = JavaRuntime$.MODULE$.version();
        Path javaHome = JavaRuntime$.MODULE$.home();
        String jdiStatus = JavaRuntime$.MODULE$.loadJavaDebugInterface().isSuccess() ? "Supports debugging user code, Java Debug Interface (JDI) is available." : "Doesn't support debugging user code, runtime doesn't implement Java Debug Interface (JDI).";
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(155).append(bloopName).append(" v").append(bloopVersion).append("\n       |\n       |Using Scala v").append(scalaVersion).append(" and Zinc v").append(zincVersion).append("\n       |Running on Java ").append(JavaRuntime$.MODULE$.current()).append(" v").append(javaVersion).append(" (").append(new AbsolutePath(javaHome)).append(")\n       |  -> ").append(jdiStatus).append("\n       |Maintained by the Scala Center and the community.\n       |").toString())).stripMargin();
    }

    private String commandUsageAsked(String command) {
        return ((CommandHelp)Commands$RawCommand$.MODULE$.help().messagesMap().apply((Object)new .colon.colon((Object)command, (List)Nil$.MODULE$))).usageMessage(this.beforeCommandMessages().progName(), (Seq)new .colon.colon((Object)command, (List)Nil$.MODULE$));
    }

    private Print printErrorAndExit(String msg, CommonOptions commonOptions) {
        return new Print(msg, commonOptions, new Exit(ExitStatus$.MODULE$.InvalidCommandLineOption()));
    }

    private Action withNonEmptyProjects(List<String> currentProjects, String commandName, Seq<String> remainingArgs, CommonOptions commonOptions, Function1<List<String>, Action> f) {
        List potentialProjects = (List)currentProjects.$plus$plus(remainingArgs, List$.MODULE$.canBuildFrom());
        if (potentialProjects.nonEmpty()) {
            return (Action)f.apply((Object)potentialProjects);
        }
        return this.printErrorAndExit(new StringBuilder(43).append("Required project name not specified for '").append(commandName).append("'.").toString(), commonOptions);
    }

    private Action withProjectsOrAll(List<String> currentProjects, Seq<String> remainingArgs, Function1<List<String>, Action> f) {
        List potentialProjects = (List)currentProjects.$plus$plus(remainingArgs, List$.MODULE$.canBuildFrom());
        if (potentialProjects.nonEmpty()) {
            return (Action)f.apply((Object)potentialProjects);
        }
        return (Action)f.apply((Object)List$.MODULE$.empty());
    }

    public Action parse(String[] args, CommonOptions commonOptions) {
        Tuple3 tuple3;
        boolean bl;
        WithHelp withHelp;
        Tuple3 tuple32;
        boolean bl2 = false;
        Right right = null;
        Either either = Commands$RawCommand$.MODULE$.parser().withHelp().detailedParse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), CliOptions$.MODULE$.parser().withHelp());
        if (either instanceof Left) {
            Left left = (Left)either;
            Error err = (Error)left.value();
            return this.printErrorAndExit(err.message(), commonOptions);
        }
        if (either instanceof Right) {
            boolean bl3;
            WithHelp withHelp2;
            bl2 = true;
            right = (Right)either;
            Tuple3 tuple33 = (Tuple3)right.value();
            if (tuple33 != null && (withHelp2 = (WithHelp)tuple33._1()) != null && (bl3 = withHelp2.help())) {
                return new Print(this.helpAsked(), commonOptions, new Exit(ExitStatus$.MODULE$.Ok()));
            }
        }
        if (bl2 && (tuple32 = (Tuple3)right.value()) != null && (withHelp = (WithHelp)tuple32._1()) != null && (bl = withHelp.usage())) {
            return new Print(this.usageAsked(), commonOptions, new Exit(ExitStatus$.MODULE$.Ok()));
        }
        if (bl2 && (tuple3 = (Tuple3)right.value()) != null) {
            WithHelp withHelp3 = (WithHelp)tuple3._1();
            Option commandOpt = (Option)tuple3._3();
            if (withHelp3 != null) {
                Either userOptions = withHelp3.baseOrError();
                Option newAction = commandOpt.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple3 tuple3;
                    Tuple3 tuple32;
                    boolean bl = false;
                    Right right = null;
                    Either either = x0$1;
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        Error err = (Error)left.value();
                        return MODULE$.printErrorAndExit(err.message(), commonOptions);
                    }
                    if (either instanceof Right) {
                        bl = true;
                        right = (Right)either;
                        Tuple3 tuple33 = (Tuple3)right.value();
                        if (tuple33 != null) {
                            boolean bl2;
                            Seq commandName = (Seq)tuple33._1();
                            WithHelp withHelp = (WithHelp)tuple33._2();
                            if (withHelp != null && (bl2 = withHelp.help())) {
                                return new Print(MODULE$.commandHelpAsked(commandName.mkString(" ")), commonOptions, new Exit(ExitStatus$.MODULE$.Ok()));
                            }
                        }
                    }
                    if (bl && (tuple32 = (Tuple3)right.value()) != null) {
                        boolean bl3;
                        Seq commandName = (Seq)tuple32._1();
                        WithHelp withHelp = (WithHelp)tuple32._2();
                        if (withHelp != null && (bl3 = withHelp.usage())) {
                            return new Print(MODULE$.commandUsageAsked(commandName.mkString(" ")), commonOptions, new Exit(ExitStatus$.MODULE$.Ok()));
                        }
                    }
                    if (bl && (tuple3 = (Tuple3)right.value()) != null) {
                        Seq commandName = (Seq)tuple3._1();
                        WithHelp withHelp = (WithHelp)tuple3._2();
                        RemainingArgs remainingArgs = (RemainingArgs)tuple3._3();
                        if (withHelp != null) {
                            Commands.RawCommand c;
                            Commands.RawCommand c2;
                            Commands.RawCommand c3;
                            Commands.RawCommand c4;
                            Commands.RawCommand c5;
                            Commands.RawCommand c6;
                            Commands.RawCommand c7;
                            Commands.RawCommand c8;
                            Commands.RawCommand c9;
                            Commands.RawCommand c10;
                            Either command = withHelp.baseOrError();
                            boolean bl4 = false;
                            Right right2 = null;
                            Either either2 = command;
                            if (either2 instanceof Left) {
                                Left left = (Left)either2;
                                Error err = (Error)left.value();
                                return MODULE$.printErrorAndExit(err.message(), commonOptions);
                            }
                            if (either2 instanceof Right) {
                                bl4 = true;
                                right2 = (Right)either2;
                                if (right2.value() instanceof Commands.Help) {
                                    return new Print(MODULE$.helpAsked(), commonOptions, new Exit(ExitStatus$.MODULE$.Ok()));
                                }
                            }
                            if (bl4 && right2.value() instanceof Commands.About) {
                                return new Print(MODULE$.aboutAsked(), commonOptions, new Exit(ExitStatus$.MODULE$.Ok()));
                            }
                            if (bl4 && (c10 = (Commands.RawCommand)right2.value()) instanceof Commands.Bsp) {
                                Commands.Bsp bsp = (Commands.Bsp)c10;
                                CommonOptions x$1 = commonOptions;
                                Option<Path> x$2 = bsp.cliOptions().copy$default$1();
                                boolean x$3 = bsp.cliOptions().copy$default$2();
                                boolean x$4 = bsp.cliOptions().copy$default$3();
                                boolean x$5 = bsp.cliOptions().copy$default$4();
                                List<DebugFilter> x$6 = bsp.cliOptions().copy$default$5();
                                CliOptions x$7 = bsp.cliOptions().copy(x$2, x$3, x$4, x$5, x$6, x$1);
                                BspProtocol x$8 = bsp.copy$default$1();
                                String x$9 = bsp.copy$default$2();
                                int x$10 = bsp.copy$default$3();
                                Option<Path> x$11 = bsp.copy$default$4();
                                Option<String> x$12 = bsp.copy$default$5();
                                Commands.Bsp newCommand = bsp.copy(x$8, x$9, x$10, x$11, x$12, x$7);
                                return Validate$.MODULE$.bsp(newCommand);
                            }
                            if (bl4 && (c9 = (Commands.RawCommand)right2.value()) instanceof Commands.Compile) {
                                Commands.Compile compile = (Commands.Compile)c9;
                                CommonOptions x$13 = commonOptions;
                                Option<Path> x$14 = compile.cliOptions().copy$default$1();
                                boolean x$15 = compile.cliOptions().copy$default$2();
                                boolean x$16 = compile.cliOptions().copy$default$3();
                                boolean x$17 = compile.cliOptions().copy$default$4();
                                List<DebugFilter> x$18 = compile.cliOptions().copy$default$5();
                                CliOptions x$19 = compile.cliOptions().copy(x$14, x$15, x$16, x$17, x$18, x$13);
                                List<String> x$20 = compile.copy$default$1();
                                boolean x$21 = compile.copy$default$2();
                                boolean x$22 = compile.copy$default$3();
                                ReporterKind x$23 = compile.copy$default$4();
                                boolean x$24 = compile.copy$default$5();
                                boolean x$25 = compile.copy$default$6();
                                Commands.Compile newCommand = compile.copy(x$20, x$21, x$22, x$23, x$24, x$25, x$19);
                                return MODULE$.withProjectsOrAll(compile.projects(), (Seq<String>)remainingArgs.all(), (Function1<List<String>, Action>)(Function1 & Serializable & scala.Serializable)ps -> Cli$.run$1(newCommand.copy((List<String>)ps, newCommand.copy$default$2(), newCommand.copy$default$3(), newCommand.copy$default$4(), newCommand.copy$default$5(), newCommand.copy$default$6(), newCommand.copy$default$7()), newCommand.cliOptions()));
                            }
                            if (bl4 && (c8 = (Commands.RawCommand)right2.value()) instanceof Commands.Autocomplete) {
                                Commands.Autocomplete autocomplete = (Commands.Autocomplete)c8;
                                CommonOptions x$26 = commonOptions;
                                Option<Path> x$27 = autocomplete.cliOptions().copy$default$1();
                                boolean x$28 = autocomplete.cliOptions().copy$default$2();
                                boolean x$29 = autocomplete.cliOptions().copy$default$3();
                                boolean x$30 = autocomplete.cliOptions().copy$default$4();
                                List<DebugFilter> x$31 = autocomplete.cliOptions().copy$default$5();
                                Commands.Autocomplete newCommand = autocomplete.copy(autocomplete.cliOptions().copy(x$27, x$28, x$29, x$30, x$31, x$26), autocomplete.copy$default$2(), autocomplete.copy$default$3(), autocomplete.copy$default$4(), autocomplete.copy$default$5());
                                return Cli$.run$1(newCommand, newCommand.cliOptions());
                            }
                            if (bl4 && (c7 = (Commands.RawCommand)right2.value()) instanceof Commands.Console) {
                                Commands.Console console = (Commands.Console)c7;
                                CommonOptions x$32 = commonOptions;
                                Option<Path> x$33 = console.cliOptions().copy$default$1();
                                boolean x$34 = console.cliOptions().copy$default$2();
                                boolean x$35 = console.cliOptions().copy$default$3();
                                boolean x$36 = console.cliOptions().copy$default$4();
                                List<DebugFilter> x$37 = console.cliOptions().copy$default$5();
                                CliOptions x$38 = console.cliOptions().copy(x$33, x$34, x$35, x$36, x$37, x$32);
                                List<String> x$39 = console.copy$default$1();
                                boolean x$40 = console.copy$default$2();
                                boolean x$41 = console.copy$default$3();
                                ReporterKind x$42 = console.copy$default$4();
                                boolean x$43 = console.copy$default$5();
                                ReplKind x$44 = console.copy$default$6();
                                List<String> x$45 = console.copy$default$7();
                                Option<String> x$46 = console.copy$default$8();
                                Option<Path> x$47 = console.copy$default$9();
                                Commands.Console newCommand = console.copy(x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$38);
                                return MODULE$.withNonEmptyProjects(console.projects(), commandName.mkString(" "), (Seq<String>)remainingArgs.remaining(), commonOptions, (Function1<List<String>, Action>)(Function1 & Serializable & scala.Serializable)ps -> {
                                    List x$48 = ps;
                                    List x$49 = (List)console.args().$plus$plus((GenTraversableOnce)remainingArgs.unparsed(), List$.MODULE$.canBuildFrom());
                                    boolean x$50 = newCommand.copy$default$2();
                                    boolean x$51 = newCommand.copy$default$3();
                                    ReporterKind x$52 = newCommand.copy$default$4();
                                    boolean x$53 = newCommand.copy$default$5();
                                    ReplKind x$54 = newCommand.copy$default$6();
                                    Option<String> x$55 = newCommand.copy$default$8();
                                    Option<Path> x$56 = newCommand.copy$default$9();
                                    CliOptions x$57 = newCommand.copy$default$10();
                                    return Cli$.run$1(newCommand.copy((List<String>)x$48, x$50, x$51, x$52, x$53, x$54, (List<String>)x$49, x$55, x$56, x$57), newCommand.cliOptions());
                                });
                            }
                            if (bl4 && (c6 = (Commands.RawCommand)right2.value()) instanceof Commands.Test) {
                                Commands.Test test = (Commands.Test)c6;
                                CommonOptions x$58 = commonOptions;
                                Option<Path> x$59 = test.cliOptions().copy$default$1();
                                boolean x$60 = test.cliOptions().copy$default$2();
                                boolean x$61 = test.cliOptions().copy$default$3();
                                boolean x$62 = test.cliOptions().copy$default$4();
                                List<DebugFilter> x$63 = test.cliOptions().copy$default$5();
                                CliOptions x$64 = test.cliOptions().copy(x$59, x$60, x$61, x$62, x$63, x$58);
                                List<String> x$65 = test.copy$default$1();
                                boolean x$66 = test.copy$default$2();
                                boolean x$67 = test.copy$default$3();
                                boolean x$68 = test.copy$default$4();
                                boolean x$69 = test.copy$default$5();
                                List<String> x$70 = test.copy$default$6();
                                List<String> x$71 = test.copy$default$7();
                                ReporterKind x$72 = test.copy$default$8();
                                boolean x$73 = test.copy$default$9();
                                boolean x$74 = test.copy$default$11();
                                Commands.Test newCommand = test.copy(x$65, x$66, x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$64, x$74);
                                return MODULE$.withProjectsOrAll(test.projects(), (Seq<String>)remainingArgs.remaining(), (Function1<List<String>, Action>)(Function1 & Serializable & scala.Serializable)ps -> {
                                    List x$75 = ps;
                                    List x$76 = (List)test.args().$plus$plus((GenTraversableOnce)remainingArgs.unparsed(), List$.MODULE$.canBuildFrom());
                                    boolean x$77 = newCommand.copy$default$2();
                                    boolean x$78 = newCommand.copy$default$3();
                                    boolean x$79 = newCommand.copy$default$4();
                                    boolean x$80 = newCommand.copy$default$5();
                                    List<String> x$81 = newCommand.copy$default$6();
                                    ReporterKind x$82 = newCommand.copy$default$8();
                                    boolean x$83 = newCommand.copy$default$9();
                                    CliOptions x$84 = newCommand.copy$default$10();
                                    boolean x$85 = newCommand.copy$default$11();
                                    return Cli$.run$1(newCommand.copy((List<String>)x$75, x$77, x$78, x$79, x$80, x$81, (List<String>)x$76, x$82, x$83, x$84, x$85), newCommand.cliOptions());
                                });
                            }
                            if (bl4 && (c5 = (Commands.RawCommand)right2.value()) instanceof Commands.Run) {
                                Commands.Run run2 = (Commands.Run)c5;
                                CommonOptions x$86 = commonOptions;
                                Option<Path> x$87 = run2.cliOptions().copy$default$1();
                                boolean x$88 = run2.cliOptions().copy$default$2();
                                boolean x$89 = run2.cliOptions().copy$default$3();
                                boolean x$90 = run2.cliOptions().copy$default$4();
                                List<DebugFilter> x$91 = run2.cliOptions().copy$default$5();
                                CliOptions x$92 = run2.cliOptions().copy(x$87, x$88, x$89, x$90, x$91, x$86);
                                List<String> x$93 = run2.copy$default$1();
                                Option<String> x$94 = run2.copy$default$2();
                                boolean x$95 = run2.copy$default$3();
                                boolean x$96 = run2.copy$default$4();
                                ReporterKind x$97 = run2.copy$default$5();
                                List<String> x$98 = run2.copy$default$6();
                                boolean x$99 = run2.copy$default$7();
                                boolean x$100 = run2.copy$default$8();
                                Option<OptimizerConfig> x$101 = run2.copy$default$9();
                                Commands.Run newCommand = run2.copy(x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100, x$101, x$92);
                                return MODULE$.withNonEmptyProjects(run2.projects(), commandName.mkString(" "), (Seq<String>)remainingArgs.remaining(), commonOptions, (Function1<List<String>, Action>)(Function1 & Serializable & scala.Serializable)ps -> {
                                    List x$102 = ps;
                                    List x$103 = (List)run2.args().$plus$plus((GenTraversableOnce)remainingArgs.unparsed(), List$.MODULE$.canBuildFrom());
                                    Option<String> x$104 = newCommand.copy$default$2();
                                    boolean x$105 = newCommand.copy$default$3();
                                    boolean x$106 = newCommand.copy$default$4();
                                    ReporterKind x$107 = newCommand.copy$default$5();
                                    boolean x$108 = newCommand.copy$default$7();
                                    boolean x$109 = newCommand.copy$default$8();
                                    Option<OptimizerConfig> x$110 = newCommand.copy$default$9();
                                    CliOptions x$111 = newCommand.copy$default$10();
                                    return Cli$.run$1(newCommand.copy((List<String>)x$102, x$104, x$105, x$106, x$107, (List<String>)x$103, x$108, x$109, x$110, x$111), newCommand.cliOptions());
                                });
                            }
                            if (bl4 && (c4 = (Commands.RawCommand)right2.value()) instanceof Commands.Clean) {
                                Commands.Clean clean = (Commands.Clean)c4;
                                List potentialProjects = (List)clean.projects().$plus$plus((GenTraversableOnce)remainingArgs.remaining(), List$.MODULE$.canBuildFrom());
                                CommonOptions x$112 = commonOptions;
                                Option<Path> x$113 = clean.cliOptions().copy$default$1();
                                boolean x$114 = clean.cliOptions().copy$default$2();
                                boolean x$115 = clean.cliOptions().copy$default$3();
                                boolean x$116 = clean.cliOptions().copy$default$4();
                                List<DebugFilter> x$117 = clean.cliOptions().copy$default$5();
                                CliOptions cliOptions = clean.cliOptions().copy(x$113, x$114, x$115, x$116, x$117, x$112);
                                List x$118 = potentialProjects;
                                CliOptions x$119 = cliOptions;
                                boolean x$120 = clean.copy$default$2();
                                boolean x$121 = clean.copy$default$3();
                                return Cli$.run$1(clean.copy((List<String>)x$118, x$120, x$121, x$119), clean.cliOptions());
                            }
                            if (bl4 && (c3 = (Commands.RawCommand)right2.value()) instanceof Commands.Projects) {
                                Commands.Projects projects = (Commands.Projects)c3;
                                CommonOptions x$122 = commonOptions;
                                Option<Path> x$123 = projects.cliOptions().copy$default$1();
                                boolean x$124 = projects.cliOptions().copy$default$2();
                                boolean x$125 = projects.cliOptions().copy$default$3();
                                boolean x$126 = projects.cliOptions().copy$default$4();
                                List<DebugFilter> x$127 = projects.cliOptions().copy$default$5();
                                CliOptions x$128 = projects.cliOptions().copy(x$123, x$124, x$125, x$126, x$127, x$122);
                                boolean x$129 = projects.copy$default$1();
                                Commands.Projects newCommand = projects.copy(x$129, x$128);
                                return Cli$.run$1(newCommand, newCommand.cliOptions());
                            }
                            if (bl4 && (c2 = (Commands.RawCommand)right2.value()) instanceof Commands.Configure) {
                                Commands.Configure configure = (Commands.Configure)c2;
                                CommonOptions x$130 = commonOptions;
                                Option<Path> x$131 = configure.cliOptions().copy$default$1();
                                boolean x$132 = configure.cliOptions().copy$default$2();
                                boolean x$133 = configure.cliOptions().copy$default$3();
                                boolean x$134 = configure.cliOptions().copy$default$4();
                                List<DebugFilter> x$135 = configure.cliOptions().copy$default$5();
                                CliOptions x$136 = configure.cliOptions().copy(x$131, x$132, x$133, x$134, x$135, x$130);
                                int x$137 = configure.copy$default$1();
                                Commands.Configure newCommand = configure.copy(x$137, x$136);
                                return Cli$.run$1(newCommand, newCommand.cliOptions());
                            }
                            if (bl4 && (c = (Commands.RawCommand)right2.value()) instanceof Commands.Link) {
                                Commands.Link link = (Commands.Link)c;
                                CommonOptions x$138 = commonOptions;
                                Option<Path> x$139 = link.cliOptions().copy$default$1();
                                boolean x$140 = link.cliOptions().copy$default$2();
                                boolean x$141 = link.cliOptions().copy$default$3();
                                boolean x$142 = link.cliOptions().copy$default$4();
                                List<DebugFilter> x$143 = link.cliOptions().copy$default$5();
                                CliOptions x$144 = link.cliOptions().copy(x$139, x$140, x$141, x$142, x$143, x$138);
                                List<String> x$145 = link.copy$default$1();
                                Option<String> x$146 = link.copy$default$2();
                                boolean x$147 = link.copy$default$3();
                                boolean x$148 = link.copy$default$4();
                                ReporterKind x$149 = link.copy$default$5();
                                boolean x$150 = link.copy$default$6();
                                Option<OptimizerConfig> x$151 = link.copy$default$7();
                                Commands.Link newCommand = link.copy(x$145, x$146, x$147, x$148, x$149, x$150, x$151, x$144);
                                return MODULE$.withNonEmptyProjects(link.projects(), commandName.mkString(" "), (Seq<String>)remainingArgs.remaining(), commonOptions, (Function1<List<String>, Action>)(Function1 & Serializable & scala.Serializable)ps -> Cli$.run$1(newCommand.copy((List<String>)ps, newCommand.copy$default$2(), newCommand.copy$default$3(), newCommand.copy$default$4(), newCommand.copy$default$5(), newCommand.copy$default$6(), newCommand.copy$default$7(), newCommand.copy$default$8()), newCommand.cliOptions()));
                            }
                            throw new MatchError((Object)either2);
                        }
                    }
                    throw new MatchError((Object)either);
                });
                return (Action)newAction.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    Either either = userOptions;
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        Error err = (Error)left.value();
                        return MODULE$.printErrorAndExit(err.message(), commonOptions);
                    }
                    if (either instanceof Right) {
                        List<DebugFilter> x$157;
                        boolean x$156;
                        boolean x$155;
                        boolean x$154;
                        Right right = (Right)either;
                        CliOptions cliOptions0 = (CliOptions)right.value();
                        CommonOptions x$152 = commonOptions;
                        Option<Path> x$153 = cliOptions0.copy$default$1();
                        CliOptions cliOptions = cliOptions0.copy(x$153, x$154 = cliOptions0.copy$default$2(), x$155 = cliOptions0.copy$default$3(), x$156 = cliOptions0.copy$default$4(), x$157 = cliOptions0.copy$default$5(), x$152);
                        if (cliOptions.version()) {
                            return new Run(new Commands.About(cliOptions), new Exit(ExitStatus$.MODULE$.Ok()));
                        }
                        String msg = "These flags can only go together with commands!";
                        return new Print(msg, commonOptions, new Exit(ExitStatus$.MODULE$.InvalidCommandLineOption()));
                    }
                    throw new MatchError((Object)either);
                });
            }
        }
        throw new MatchError((Object)either);
    }

    public ExitStatus run(Action action, ClientPool pool) {
        return this.run(action, pool, this.FalseCancellation());
    }

    private Try<BoxedUnit> _() {
        return this._;
    }

    /*
     * Unable to fully structure code
     */
    private ExitStatus run(Action action, ClientPool pool, CompletableFuture<Boolean> cancel) {
        var7_4 = action;
        if (var7_4 instanceof Run) {
            var8_5 = (Run)var7_4;
            v0 = var8_5.command().cliOptions();
        } else if (var7_4 instanceof Exit) {
            v0 = CliOptions$.MODULE$.default();
        } else if (var7_4 instanceof Print) {
            var9_6 = (Print)var7_4;
            x$1 = var9_6.commonOptions();
            x$2 = CliOptions$.MODULE$.default().copy$default$1();
            x$3 = CliOptions$.MODULE$.default().copy$default$2();
            x$4 = CliOptions$.MODULE$.default().copy$default$3();
            x$5 = CliOptions$.MODULE$.default().copy$default$4();
            x$6 = CliOptions$.MODULE$.default().copy$default$5();
            v0 = CliOptions$.MODULE$.default().copy(x$2, x$3, x$4, x$5, x$6, x$1);
        } else {
            throw new MatchError((Object)var7_4);
        }
        cliOptions = v0;
        commonOpts = cliOptions.common();
        configDirectory = Cli$.getConfigDir$1(cliOptions);
        debugFilter = DebugFilter$.MODULE$.toUniqueFilter(cliOptions.debug());
        if (cliOptions.verbose()) ** GOTO lbl-1000
        v1 = debugFilter;
        var20_17 = DebugFilter.All$.MODULE$;
        if (v1 == null ? var20_17 != null : v1.equals(var20_17) == false) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        isVerbose = v2;
        logger = BloopLogger$.MODULE$.at(AbsolutePath$.MODULE$.syntax$extension(configDirectory), commonOpts.out(), commonOpts.err(), isVerbose, cliOptions.noColor() == false && commonOpts.env().containsKey("NO_COLOR") == false, debugFilter);
        var22_20 = action;
        if (var22_20 instanceof Print) {
            var23_21 = (Print)var22_20;
            msg = var23_21.msg();
            var25_23 = var23_21.next();
            if (var25_23 instanceof Exit) {
                var26_24 = (Exit)var25_23;
                exitStatus = var26_24.exitStatus();
                logger.info(msg);
                return exitStatus;
            }
        }
        return this.runWithState(action, pool, cancel, configDirectory, cliOptions, commonOpts, (Logger)logger);
    }

    private ExitStatus runWithState(Action action, ClientPool pool, CompletableFuture<Boolean> cancel, Path configDirectory, CliOptions cliOptions, CommonOptions commonOpts, Logger logger) {
        ProxySetup$.MODULE$.updateProxySettings(commonOpts.env().toMap(), logger);
        Path configDir = configDirectory;
        Function1 & Serializable & scala.Serializable taskToInterpret = (Function1 & Serializable & scala.Serializable)cli -> {
            Task<State> state = State$.MODULE$.loadActiveStateFor(configDirectory, (ClientInfo)cli, pool, cliOptions.common(), logger, State$.MODULE$.loadActiveStateFor$default$6());
            return Interpreter$.MODULE$.execute(action, state).map((Function1 & Serializable & scala.Serializable)newState -> {
                Run run2;
                Action action = action;
                if (action instanceof Run && (run2 = (Run)action).command() instanceof Commands.ValidatedBsp) {
                } else {
                    ExitStatus x$1 = ExitStatus$.MODULE$.Ok();
                    Build x$2 = newState.copy$default$1();
                    ResultsCache x$3 = newState.copy$default$2();
                    CompilerCache x$4 = newState.copy$default$3();
                    SourceGeneratorCache x$5 = newState.copy$default$4();
                    ClientInfo x$6 = newState.copy$default$5();
                    ClientPool x$7 = newState.copy$default$6();
                    CommonOptions x$8 = newState.copy$default$7();
                    Logger x$9 = newState.copy$default$9();
                    State$.MODULE$.stateCache().updateBuild(newState.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9));
                }
                return newState;
            });
        };
        Cli.CliSession session = this.runTaskWithCliClient(configDirectory, action, (Function1<ClientInfo.CliClientInfo, Task<State>>)taskToInterpret, pool, logger);
        Task exitSession = Task$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> MODULE$.cleanUpNonStableCliDirectories(session.client(), logger).map((Function1 & Serializable & scala.Serializable)x$5 -> {
            Cli$.$anonfun$runWithState$4(configDirectory, session, x$5);
            return BoxedUnit.UNIT;
        }));
        return this.waitUntilEndOfWorld(cliOptions, pool, configDir, logger, cancel, (Task<ExitStatus>)session.task().doOnCancel((Function0 & Serializable & scala.Serializable)() -> exitSession).doOnFinish((Function1 & Serializable & scala.Serializable)x$8 -> exitSession));
    }

    private final CompletableFuture<Boolean> FalseCancellation() {
        return this.FalseCancellation;
    }

    private ConcurrentHashMap<Path, List<Cli.CliSession>> activeCliSessions() {
        return this.activeCliSessions;
    }

    public Cli.CliSession runTaskWithCliClient(Path configDir, Action action, Function1<ClientInfo.CliClientInfo, Task<State>> processCliTask, ClientPool pool, Logger logger) {
        AtomicBoolean isClientConnected = AtomicBoolean$.MODULE$.apply(true);
        pool.addListener((Function1<CloseEvent, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$9 -> {
            isClientConnected.set(false);
            return BoxedUnit.UNIT;
        });
        ClientInfo.CliClientInfo defaultClient = new ClientInfo.CliClientInfo(true, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> isClientConnected.get());
        Cli.CliSession defaultClientSession = Cli$.sessionFor$1(defaultClient, processCliTask);
        boolean bl = false;
        Run run2 = null;
        Action action2 = action;
        if (action2 instanceof Exit) {
            return defaultClientSession;
        }
        if (action2 instanceof Run) {
            bl = true;
            run2 = (Run)action2;
            if (run2.command() instanceof Commands.About) {
                return defaultClientSession;
            }
        }
        if (bl && run2.command() instanceof Commands.Projects) {
            return defaultClientSession;
        }
        if (bl && run2.command() instanceof Commands.Autocomplete) {
            return defaultClientSession;
        }
        if (bl && run2.command() instanceof Commands.Bsp) {
            return defaultClientSession;
        }
        if (bl && run2.command() instanceof Commands.ValidatedBsp) {
            return defaultClientSession;
        }
        List activeSessions = this.activeCliSessions().compute(configDir, (x$11, sessions) -> {
            Cli.CliSession newClientSession;
            if (sessions == null || sessions.isEmpty()) {
                return new .colon.colon((Object)defaultClientSession, (List)Nil$.MODULE$);
            }
            logger.debug("Detected connected cli clients, starting CLI with unique dirs...", (DebugFilter)MODULE$.filter());
            ClientInfo.CliClientInfo newClient = new ClientInfo.CliClientInfo(false, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> isClientConnected.get());
            Cli.CliSession cliSession = newClientSession = Cli$.sessionFor$1(newClient, processCliTask);
            return sessions.$colon$colon((Object)cliSession);
        });
        return (Cli.CliSession)activeSessions.head();
    }

    public Task<BoxedUnit> cleanUpNonStableCliDirectories(ClientInfo.CliClientInfo client, Logger logger) {
        if (client.useStableCliDirs()) {
            return Task$.MODULE$.unit();
        }
        logger.debug(new StringBuilder(39).append("Cleaning up non-stable CLI directories ").append(client.getCreatedCliDirectories().mkString(",")).toString(), (DebugFilter)this.filter());
        List deleteTasks = (List)client.getCreatedCliDirectories().map((Function1 & Serializable & scala.Serializable)freshDir -> Cli$.$anonfun$cleanUpNonStableCliDirectories$1(((AbsolutePath)freshDir).underlying()), List$.MODULE$.canBuildFrom());
        List groups = deleteTasks.grouped(4).map((Function1 & Serializable & scala.Serializable)group -> Task$.MODULE$.gatherUnordered((Iterable)group).map((Function1 & Serializable & scala.Serializable)x$13 -> {
            Cli$.$anonfun$cleanUpNonStableCliDirectories$4(x$13);
            return BoxedUnit.UNIT;
        })).toList();
        Task qual$1 = Task$.MODULE$.sequence((Iterable)groups, List$.MODULE$.canBuildFrom()).map((Function1 & Serializable & scala.Serializable)x$14 -> {
            Cli$.$anonfun$cleanUpNonStableCliDirectories$5(x$14);
            return BoxedUnit.UNIT;
        });
        Scheduler x$1 = ExecutionContext$.MODULE$.ioScheduler();
        boolean x$2 = qual$1.executeOn$default$2();
        return qual$1.executeOn(x$1, x$2);
    }

    public ExitStatus waitUntilEndOfWorld(CliOptions cliOptions, ClientPool pool, Path configDirectory, Logger logger, CompletableFuture<Boolean> cancel2, Task<ExitStatus> task) {
        ExitStatus exitStatus;
        PrintStream ngout = cliOptions.common().ngout();
        CancelableFuture handle = Task$.MODULE$.now((Object)BoxesRunTime.boxToLong((long)System.nanoTime())).flatMap((Function1 & Serializable & scala.Serializable)start -> Cli$.$anonfun$waitUntilEndOfWorld$1(task, BoxesRunTime.unboxToLong((Object)start))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Try state = (Try)tuple2._1();
                long start = tuple2._2$mcJ$sp();
                Cli$.logElapsed$1(start, logger);
                return state;
            }
            throw new MatchError((Object)tuple2);
        }).dematerialize(Predef$.MODULE$.$conforms()).runAsync(ExecutionContext$.MODULE$.scheduler());
        Object object = !cancel2.isDone() ? Task$.MODULE$.deferFutureAction((Function1 & Serializable & scala.Serializable)x$15 -> Java8Compat.JavaCompletableFutureUtils$.MODULE$.asScala$extension(Java8Compat$.MODULE$.JavaCompletableFutureUtils(cancel2), (ExecutionContext)x$15)).map((Function1 & Serializable & scala.Serializable)cancel -> {
            Cli$.$anonfun$waitUntilEndOfWorld$5(cliOptions, configDirectory, handle, cancel);
            return BoxedUnit.UNIT;
        }).runAsync(ExecutionContext$.MODULE$.ioScheduler()) : BoxedUnit.UNIT;
        try {
            pool.addListener((Function1<CloseEvent, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x0$2 -> {
                Cli$.$anonfun$waitUntilEndOfWorld$6(handle, ngout, configDirectory, cancel2, x0$2);
                return BoxedUnit.UNIT;
            });
            exitStatus = (ExitStatus)Await$.MODULE$.result((Awaitable)handle, (Duration)Duration$.MODULE$.Inf());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InterruptedException) {
                InterruptedException interruptedException = (InterruptedException)throwable2;
                exitStatus = Cli$.handleException$1(interruptedException, handle, cancel2, logger);
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                exitStatus = Cli$.handleException$1(t, handle, cancel2, logger);
            }
            throw throwable;
        }
        return exitStatus;
    }

    public CompletableFuture<Boolean> waitUntilEndOfWorld$default$5() {
        return this.FalseCancellation();
    }

    public static final /* synthetic */ boolean $anonfun$commandHelpAsked$1(Arg x$3) {
        return x$3.name().name().startsWith("project");
    }

    private static final Run run$1(Commands.RawCommand command, CliOptions cliOptions) {
        if (!cliOptions.version()) {
            return new Run(command, new Exit(ExitStatus$.MODULE$.Ok()));
        }
        return new Run(new Commands.About(cliOptions), new Run(command, new Exit(ExitStatus$.MODULE$.Ok())));
    }

    private static final Path getConfigDir$1(CliOptions cliOptions) {
        Path cwd = AbsolutePath$.MODULE$.apply(cliOptions.common().workingDirectory(), AbsolutePath$.MODULE$.workingDirectory());
        return ((AbsolutePath)cliOptions.configDir().map((Function1 & Serializable & scala.Serializable)x$4 -> new AbsolutePath(AbsolutePath$.MODULE$.apply(x$4, cwd))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new AbsolutePath(AbsolutePath$.MODULE$.resolve$extension1(cliOptions.common().workingPath(), ".bloop")))).underlying();
    }

    public static final /* synthetic */ boolean $anonfun$runWithState$6(Cli.CliSession session$1, Cli.CliSession x$7) {
        Cli.CliSession cliSession = x$7;
        Cli.CliSession cliSession2 = session$1;
        return !(cliSession != null ? !((Object)cliSession).equals(cliSession2) : cliSession2 != null);
    }

    public static final /* synthetic */ void $anonfun$runWithState$4(Path configDirectory$1, Cli.CliSession session$1, BoxedUnit x$5) {
        MODULE$.activeCliSessions().compute(configDirectory$1, (x$6, sessions) -> (List)sessions.filterNot((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)Cli$.$anonfun$runWithState$6(session$1, x$7))));
    }

    private static final Cli.CliSession sessionFor$1(ClientInfo.CliClientInfo client, Function1 processCliTask$1) {
        Task cliTask = ((Task)processCliTask$1.apply((Object)client)).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.status());
        return new Cli.CliSession(client, (Task<ExitStatus>)cliTask);
    }

    public static final /* synthetic */ Task $anonfun$cleanUpNonStableCliDirectories$1(Path freshDir) {
        if (!AbsolutePath$.MODULE$.exists$extension(freshDir)) {
            return Task$.MODULE$.unit();
        }
        return Task$.MODULE$.eval((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Paths$.MODULE$.delete(freshDir)).asyncBoundary();
    }

    public static final /* synthetic */ void $anonfun$cleanUpNonStableCliDirectories$4(List x$13) {
    }

    public static final /* synthetic */ void $anonfun$cleanUpNonStableCliDirectories$5(List x$14) {
    }

    private static final void logElapsed$1(long since, Logger logger$3) {
        double elapsed = (double)(System.nanoTime() - since) / 1000000.0;
        logger$3.debug(new StringBuilder(12).append("Elapsed: ").append(elapsed).append(" ms").toString(), (DebugFilter)DebugFilter.All$.MODULE$);
    }

    public static final /* synthetic */ Task $anonfun$waitUntilEndOfWorld$1(Task task$1, long start) {
        return task$1.materialize().map((Function1 & Serializable & scala.Serializable)s -> new Tuple2(s, (Object)BoxesRunTime.boxToLong((long)start)));
    }

    public static final /* synthetic */ void $anonfun$waitUntilEndOfWorld$5(CliOptions cliOptions$3, Path configDirectory$2, CancelableFuture handle$1, Boolean cancel) {
        if (Predef$.MODULE$.Boolean2boolean(cancel)) {
            cliOptions$3.common().out().println(new StringBuilder(54).append("Client in ").append(configDirectory$2).append(" triggered cancellation. Cancelling tasks...").toString());
            handle$1.cancel();
            return;
        }
    }

    private static final ExitStatus handleException$1(Throwable t, CancelableFuture handle$1, CompletableFuture cancel$1, Logger logger$3) {
        handle$1.cancel();
        Object object = !cancel$1.isDone() ? BoxesRunTime.boxToBoolean((boolean)cancel$1.complete(Predef$.MODULE$.boolean2Boolean(false))) : BoxedUnit.UNIT;
        logger$3.error(new StringBuilder(7).append("Caught ").append(t).toString());
        logger$3.trace(t);
        return ExitStatus$.MODULE$.UnexpectedError();
    }

    public static final /* synthetic */ void $anonfun$waitUntilEndOfWorld$6(CancelableFuture handle$1, PrintStream ngout$1, Path configDirectory$2, CompletableFuture cancel$1, CloseEvent x0$2) {
        CloseEvent closeEvent = x0$2;
        if (closeEvent != null) {
            CloseEvent closeEvent2 = closeEvent;
            if (!handle$1.isCompleted()) {
                ngout$1.println(new StringBuilder(60).append("Client in ").append(configDirectory$2).append(" disconnected with a '").append(closeEvent2).append("' event. Cancelling tasks...").toString());
                handle$1.cancel();
                Object object = !cancel$1.isDone() ? BoxesRunTime.boxToBoolean((boolean)cancel$1.complete(Predef$.MODULE$.boolean2Boolean(false))) : BoxedUnit.UNIT;
                return;
            }
            return;
        }
        throw new MatchError((Object)closeEvent);
    }

    private Cli$() {
        MODULE$ = this;
        this.filter = DebugFilter.All$.MODULE$;
        this.commands = (Seq)Commands$RawCommand$.MODULE$.help().messages().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(((TraversableLike)x$2._1()).headOption()).toSeq(), Seq$.MODULE$.canBuildFrom());
        this.beforeCommandMessages = Help$.MODULE$.apply((Seq)Nil$.MODULE$, "bloop", BuildInfo$.MODULE$.version(), "bloop", (Option)None$.MODULE$).withOptionsDesc("[options] [command] [command-options]");
        this.progName = this.beforeCommandMessages().progName();
        this._ = JavaRuntime$.MODULE$.loadJavaDebugInterface();
        this.FalseCancellation = CompletableFuture.completedFuture(Predef$.MODULE$.boolean2Boolean(false));
        this.activeCliSessions = new ConcurrentHashMap();
    }
}

