/*
 * Decompiled with CFR 0.152.
 */
package bloop.dap;

import bloop.config.Config;
import bloop.dap.AttachRemoteDebugAdapter;
import bloop.dap.MainClassDebugAdapter;
import bloop.dap.TestSuiteDebugAdapter;
import bloop.data.ClientInfo;
import bloop.data.JdkConfig;
import bloop.data.Platform;
import bloop.data.Project;
import bloop.engine.Dag;
import bloop.engine.Dag$;
import bloop.engine.Dag$PreOrder$;
import bloop.engine.State;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.RelativePath$;
import ch.epfl.scala.bsp.ScalaMainClass;
import ch.epfl.scala.bsp.ScalaTestSuites;
import ch.epfl.scala.debugadapter.Debuggee;
import ch.epfl.scala.debugadapter.JavaRuntime;
import ch.epfl.scala.debugadapter.JavaRuntime$;
import ch.epfl.scala.debugadapter.Library;
import ch.epfl.scala.debugadapter.ManagedEntry;
import ch.epfl.scala.debugadapter.Module;
import ch.epfl.scala.debugadapter.ScalaVersion;
import ch.epfl.scala.debugadapter.SourceDirectory;
import ch.epfl.scala.debugadapter.SourceJar;
import ch.epfl.scala.debugadapter.StandaloneSourceFile;
import ch.epfl.scala.debugadapter.UnmanagedEntry;
import java.io.Serializable;
import java.nio.file.Path;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import monix.reactive.OverflowStrategy;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class BloopDebuggeeRunner$ {
    public static BloopDebuggeeRunner$ MODULE$;

    static {
        new BloopDebuggeeRunner$();
    }

    public Either<String, Debuggee> forMainClass(Seq<Project> projects, ScalaMainClass mainClass, State state, Scheduler ioScheduler) {
        Seq<Project> seq = projects;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
            return package$.MODULE$.Left().apply((Object)new StringBuilder(40).append("No projects specified for main class: [").append(mainClass).append("]").toString());
        }
        Some some2 = Seq$.MODULE$.unapplySeq(seq);
        if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0) {
            Project project = (Project)((SeqLike)some2.get()).apply(0);
            Platform platform = project.platform();
            if (platform instanceof Platform.Jvm) {
                Platform.Jvm jvm = (Platform.Jvm)platform;
                Tuple4<Seq<Module>, Seq<Library>, Seq<UnmanagedEntry>, Observable<Seq<String>>> tuple4 = this.getEntriesAndClassUpdates(project, state);
                if (tuple4 == null) {
                    throw new MatchError(tuple4);
                }
                Seq modules = (Seq)tuple4._1();
                Seq libraries = (Seq)tuple4._2();
                Seq unmanagedEntries = (Seq)tuple4._3();
                Observable classUpdates = (Observable)tuple4._4();
                Tuple4 tuple42 = new Tuple4((Object)modules, (Object)libraries, (Object)unmanagedEntries, (Object)classUpdates);
                Seq modules2 = (Seq)tuple42._1();
                Seq libraries2 = (Seq)tuple42._2();
                Seq unmanagedEntries2 = (Seq)tuple42._3();
                Observable classUpdates2 = (Observable)tuple42._4();
                return package$.MODULE$.Right().apply((Object)new MainClassDebugAdapter(project, mainClass, (Seq<Module>)modules2, (Seq<Library>)libraries2, (Seq<UnmanagedEntry>)unmanagedEntries2, (Observable<Seq<String>>)classUpdates2, (JdkConfig)jvm.runtimeConfig().getOrElse((Function0 & Serializable & scala.Serializable)() -> jvm.config()), state, ioScheduler));
            }
            return package$.MODULE$.Left().apply((Object)new StringBuilder(22).append("Unsupported platform: ").append(platform.getClass().getSimpleName()).toString());
        }
        return package$.MODULE$.Left().apply((Object)new StringBuilder(47).append("Multiple projects specified for main class [").append(mainClass).append("]: ").append(seq).toString());
    }

    public Either<String, Debuggee> forTestSuite(Seq<Project> projects, ScalaTestSuites testClasses, State state, Scheduler ioScheduler) {
        Project project;
        Seq<Project> seq = projects;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
            return package$.MODULE$.Left().apply((Object)new StringBuilder(45).append("No projects specified for the test suites: [").append(((SeqLike)testClasses.suites().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.className(), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).append("]").toString());
        }
        Some some2 = Seq$.MODULE$.unapplySeq(seq);
        if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0 && (project = (Project)((SeqLike)some2.get()).apply(0)).platform() instanceof Platform.Jvm) {
            Tuple4<Seq<Module>, Seq<Library>, Seq<UnmanagedEntry>, Observable<Seq<String>>> tuple4 = this.getEntriesAndClassUpdates(project, state);
            if (tuple4 == null) {
                throw new MatchError(tuple4);
            }
            Seq modules = (Seq)tuple4._1();
            Seq libraries = (Seq)tuple4._2();
            Seq unmanagedEntries = (Seq)tuple4._3();
            Observable classUpdates = (Observable)tuple4._4();
            Tuple4 tuple42 = new Tuple4((Object)modules, (Object)libraries, (Object)unmanagedEntries, (Object)classUpdates);
            Seq modules2 = (Seq)tuple42._1();
            Seq libraries2 = (Seq)tuple42._2();
            Seq unmanagedEntries2 = (Seq)tuple42._3();
            Observable classUpdates2 = (Observable)tuple42._4();
            Platform platform = project.platform();
            if (!(platform instanceof Platform.Jvm)) {
                throw new MatchError((Object)platform);
            }
            Platform.Jvm jvm = (Platform.Jvm)platform;
            JdkConfig config = jvm.config();
            Option<JdkConfig> runtimeConfig = jvm.runtimeConfig();
            Tuple2 tuple2 = new Tuple2((Object)config, runtimeConfig);
            JdkConfig config2 = (JdkConfig)tuple2._1();
            Option runtimeConfig2 = (Option)tuple2._2();
            Option javaRuntime = JavaRuntime$.MODULE$.apply(((JdkConfig)runtimeConfig2.getOrElse((Function0 & Serializable & scala.Serializable)() -> config2)).javaHome());
            return package$.MODULE$.Right().apply((Object)new TestSuiteDebugAdapter(projects, testClasses, (Seq<Module>)modules2, (Seq<Library>)libraries2, (Seq<UnmanagedEntry>)unmanagedEntries2, (Option<JavaRuntime>)javaRuntime, (Observable<Seq<String>>)classUpdates2, state, ioScheduler));
        }
        return package$.MODULE$.Right().apply((Object)new TestSuiteDebugAdapter(projects, testClasses, (Seq<Module>)((Seq)Nil$.MODULE$), (Seq<Library>)((Seq)Nil$.MODULE$), (Seq<UnmanagedEntry>)((Seq)Nil$.MODULE$), (Option<JavaRuntime>)None$.MODULE$, (Observable<Seq<String>>)Observable$.MODULE$.empty(), state, ioScheduler));
    }

    public Debuggee forAttachRemote(Seq<Project> projects, State state, Scheduler ioScheduler) {
        Project project;
        Seq<Project> seq = projects;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (project = (Project)((SeqLike)some.get()).apply(0)).platform() instanceof Platform.Jvm) {
            Tuple4<Seq<Module>, Seq<Library>, Seq<UnmanagedEntry>, Observable<Seq<String>>> tuple4 = this.getEntriesAndClassUpdates(project, state);
            if (tuple4 == null) {
                throw new MatchError(tuple4);
            }
            Seq modules = (Seq)tuple4._1();
            Seq libraries = (Seq)tuple4._2();
            Seq unmanagedEntries = (Seq)tuple4._3();
            Observable classUpdates = (Observable)tuple4._4();
            Tuple4 tuple42 = new Tuple4((Object)modules, (Object)libraries, (Object)unmanagedEntries, (Object)classUpdates);
            Seq modules2 = (Seq)tuple42._1();
            Seq libraries2 = (Seq)tuple42._2();
            Seq unmanagedEntries2 = (Seq)tuple42._3();
            Observable classUpdates2 = (Observable)tuple42._4();
            Platform platform = project.platform();
            if (!(platform instanceof Platform.Jvm)) {
                throw new MatchError((Object)platform);
            }
            Platform.Jvm jvm = (Platform.Jvm)platform;
            JdkConfig config = jvm.config();
            Option<JdkConfig> runtimeConfig = jvm.runtimeConfig();
            Tuple2 tuple2 = new Tuple2((Object)config, runtimeConfig);
            JdkConfig config2 = (JdkConfig)tuple2._1();
            Option runtimeConfig2 = (Option)tuple2._2();
            Option javaRuntime = JavaRuntime$.MODULE$.apply(((JdkConfig)runtimeConfig2.getOrElse((Function0 & Serializable & scala.Serializable)() -> config2)).javaHome());
            return new AttachRemoteDebugAdapter((Seq<Project>)((Seq)new .colon.colon((Object)project, (List)Nil$.MODULE$)), (Seq<Module>)modules2, (Seq<Library>)libraries2, (Seq<UnmanagedEntry>)unmanagedEntries2, (Option<JavaRuntime>)javaRuntime, (Observable<Seq<String>>)classUpdates2, state, ioScheduler);
        }
        return new AttachRemoteDebugAdapter(seq, (Seq<Module>)((Seq)Nil$.MODULE$), (Seq<Library>)((Seq)Nil$.MODULE$), (Seq<UnmanagedEntry>)((Seq)Nil$.MODULE$), (Option<JavaRuntime>)None$.MODULE$, (Observable<Seq<String>>)Observable$.MODULE$.empty(), state, ioScheduler);
    }

    private Tuple4<Seq<Module>, Seq<Library>, Seq<UnmanagedEntry>, Observable<Seq<String>>> getEntriesAndClassUpdates(Project project, State state) {
        Dag<Project> dag = state.build().getDagFor(project);
        List<Project> projects = Dag$.MODULE$.dfs(dag, Dag$PreOrder$.MODULE$);
        Seq<Module> modules = this.getModules((Seq<Project>)projects, state.client());
        Seq<Library> libraries = this.getLibraries((Seq<Project>)projects);
        AbsolutePath[] fullClasspath = project.fullClasspath(dag, state.client());
        Seq<UnmanagedEntry> unmanagedEntries = this.getUnmanagedEntries((Seq<AbsolutePath>)Predef$.MODULE$.genericWrapArray((Object)fullClasspath), (Seq<ManagedEntry>)((Seq)modules.$plus$plus(libraries, Seq$.MODULE$.canBuildFrom())));
        List allClassUpdates = (List)projects.map((Function1 & Serializable & scala.Serializable)x$18 -> state.client().getClassesObserverFor((Project)x$18).observable(), List$.MODULE$.canBuildFrom());
        Observable qual$1 = Observable$.MODULE$.fromIterable((Iterable)allClassUpdates);
        Predef.$less$colon$less x$1 = Predef$.MODULE$.$conforms();
        OverflowStrategy x$2 = qual$1.merge$default$2();
        Observable mergedClassUpdates = qual$1.merge(x$1, x$2);
        return new Tuple4(modules, libraries, unmanagedEntries, (Object)mergedClassUpdates);
    }

    private Seq<Library> getLibraries(Seq<Project> projects) {
        return (Seq)((SeqLike)((TraversableLike)((SeqLike)((TraversableLike)projects.flatMap((Function1 & Serializable & scala.Serializable)x$19 -> Option$.MODULE$.option2Iterable(x$19.resolution()), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$20 -> x$20.modules(), Seq$.MODULE$.canBuildFrom())).distinct()).flatMap((Function1 & Serializable & scala.Serializable)module -> Option$.MODULE$.option2Iterable(module.artifacts().find((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)BloopDebuggeeRunner$.$anonfun$getLibraries$4(x$21))).flatMap((Function1 & Serializable & scala.Serializable)classJar -> module.artifacts().find((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)BloopDebuggeeRunner$.$anonfun$getLibraries$6(x$22))).map((Function1 & Serializable & scala.Serializable)sourceJar -> {
            SourceJar sourceEntry = new SourceJar(sourceJar.path());
            return new Library(module.name(), module.version(), classJar.path(), (Seq)new .colon.colon((Object)sourceEntry, (List)Nil$.MODULE$));
        }))), Seq$.MODULE$.canBuildFrom())).distinct();
    }

    private Seq<UnmanagedEntry> getUnmanagedEntries(Seq<AbsolutePath> fullClasspath, Seq<ManagedEntry> managedEntries) {
        Set managedPaths = ((TraversableOnce)managedEntries.map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.absolutePath(), Seq$.MODULE$.canBuildFrom())).toSet();
        return (Seq)fullClasspath.collect((PartialFunction)new scala.Serializable(managedPaths){
            public static final long serialVersionUID = 0L;
            private final Set managedPaths$1;

            public final <A1 extends AbsolutePath, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (!this.managedPaths$1.contains(A1)) {
                    return (B1)new UnmanagedEntry(A1);
                }
                return (B1)function1.apply((Object)new AbsolutePath(x1));
            }

            public final boolean isDefinedAt(Path x1) {
                Path path = x1;
                return !this.managedPaths$1.contains((Object)path);
            }
            {
                this.managedPaths$1 = managedPaths$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Module> getModules(Seq<Project> projects, ClientInfo client) {
        return (Seq)projects.map((Function1 & Serializable & scala.Serializable)project -> {
            Buffer sourceBuffer = (Buffer)Buffer$.MODULE$.empty();
            project.sources().foreach((Function1 & Serializable & scala.Serializable)sourcePath -> BloopDebuggeeRunner$.$anonfun$getModules$2(sourceBuffer, ((AbsolutePath)sourcePath).underlying()));
            project.sourcesGlobs().foreach((Function1 & Serializable & scala.Serializable)glob -> {
                glob.walkThrough((Function1<AbsolutePath, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
                    sourceBuffer$1.$plus$eq((Object)new StandaloneSourceFile(((AbsolutePath)file).underlying(), RelativePath$.MODULE$.toString$extension(AbsolutePath$.MODULE$.toRelative$extension(((AbsolutePath)file).underlying(), glob.directory()))));
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            Path classDir = client.getUniqueClassesDirFor((Project)project, true);
            String projectName = project.bspUri().toString();
            Option scalaVersion = project.scalaInstance().map((Function1 & Serializable & scala.Serializable)si -> new ScalaVersion(si.version()));
            return new Module(projectName, scalaVersion, project.scalacOptions(), classDir, (Seq)sourceBuffer);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$getLibraries$4(Config.Artifact x$21) {
        return x$21.classifier().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getLibraries$6(Config.Artifact x$22) {
        return x$22.classifier().contains((Object)"sources");
    }

    public static final /* synthetic */ Buffer $anonfun$getModules$2(Buffer sourceBuffer$1, Path sourcePath) {
        if (AbsolutePath$.MODULE$.isDirectory$extension(sourcePath)) {
            return sourceBuffer$1.$plus$eq((Object)new SourceDirectory(sourcePath));
        }
        return sourceBuffer$1.$plus$eq((Object)new StandaloneSourceFile(sourcePath, ((Object)sourcePath.getFileName()).toString()));
    }

    private BloopDebuggeeRunner$() {
        MODULE$ = this;
    }
}

