/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine.caches;

import bloop.DependencyResolution;
import bloop.DependencyResolution$;
import bloop.SemanticDBCacheLock$;
import bloop.engine.ExecutionContext$;
import bloop.internal.build.BuildInfo$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.Paths$;
import bloop.logging.Logger;
import coursierapi.Complete;
import coursierapi.error.CoursierError;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import sbt.internal.inc.BloopComponentCompiler$;
import sbt.internal.inc.BloopComponentManager;
import sbt.internal.inc.IfMissing;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import xsbti.ComponentProvider;
import xsbti.GlobalLock;

public final class SemanticDBCache$ {
    public static SemanticDBCache$ MODULE$;
    private final ConcurrentHashMap<String, String> supportedFallbackSemanticdbVersions;
    private volatile Path latestResolvedScalaSemanticDB;
    private volatile Path latestResolvedJavaSemanticDB;

    static {
        new SemanticDBCache$();
    }

    private ConcurrentHashMap<String, String> supportedFallbackSemanticdbVersions() {
        return this.supportedFallbackSemanticdbVersions;
    }

    private Either<String, AbsolutePath> fetchPlugin(DependencyResolution.Artifact artifact, Logger logger) {
        String semanticDBId;
        String string = artifact.version();
        String string2 = "latest.release";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return SemanticDBCache$.attemptResolution$1(artifact, logger);
        }
        ComponentProvider provider = BloopComponentCompiler$.MODULE$.getComponentProvider(Paths$.MODULE$.getCacheDirectory("semanticdb"));
        BloopComponentManager manager = new BloopComponentManager((GlobalLock)SemanticDBCacheLock$.MODULE$, provider, (Option)None$.MODULE$);
        Try try_ = Try$.MODULE$.apply(() -> SemanticDBCache$.$anonfun$fetchPlugin$3(manager, semanticDBId = new StringBuilder(2).append(artifact.organization()).append(".").append(artifact.module()).append(".").append(artifact.version()).toString()));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            File pluginPath = (File)success.value();
            return package$.MODULE$.Right().apply((Object)new AbsolutePath(AbsolutePath$.MODULE$.apply(pluginPath, AbsolutePath$.MODULE$.workingDirectory())));
        }
        if (try_ instanceof Failure) {
            Either resolvedPlugin = SemanticDBCache$.attemptResolution$1(artifact, logger);
            resolvedPlugin.foreach((Function1 & Serializable & scala.Serializable)plugin -> {
                manager.define(semanticDBId, (Iterable)new .colon.colon((Object)AbsolutePath$.MODULE$.toFile$extension(((AbsolutePath)plugin).underlying()), (List)Nil$.MODULE$));
                return BoxedUnit.UNIT;
            });
            return resolvedPlugin;
        }
        throw new MatchError((Object)try_);
    }

    private Either<String, AbsolutePath> fallbackSemanticdbFetch(String scalaVersion, DependencyResolution.Artifact artifact, Logger logger) {
        Option option = Option$.MODULE$.apply((Object)this.supportedFallbackSemanticdbVersions().get(scalaVersion)).orElse((Function0 & Serializable & scala.Serializable)() -> SemanticDBCache$.version$1(scalaVersion)).orElse((Function0 & Serializable & scala.Serializable)() -> BuildInfo$.MODULE$.lastSupportedSemanticdb().get((Object)scalaVersion));
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)new StringBuilder(67).append("After retry no existing semanticdb version found for scala version ").append(scalaVersion).toString());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String semanticdbVersion = (String)some.value();
            this.supportedFallbackSemanticdbVersions().put(scalaVersion, semanticdbVersion);
            String x$1 = semanticdbVersion;
            String x$2 = artifact.copy$default$1();
            String x$3 = artifact.copy$default$2();
            return this.fetchPlugin(artifact.copy(x$2, x$3, x$1), logger);
        }
        throw new MatchError((Object)option);
    }

    private Path latestResolvedScalaSemanticDB() {
        return this.latestResolvedScalaSemanticDB;
    }

    private void latestResolvedScalaSemanticDB_$eq(Path x$1) {
        this.latestResolvedScalaSemanticDB = x$1;
    }

    public Either<String, AbsolutePath> fetchScalaPlugin(String scalaVersion, String version, Logger logger) {
        String organization = "org.scalameta";
        String module = new StringBuilder(18).append("semanticdb-scalac_").append(scalaVersion).toString();
        DependencyResolution.Artifact artifact = new DependencyResolution.Artifact(organization, module, version);
        String string = artifact.version();
        String string2 = "latest.release";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Right right;
            Path path = this.latestResolvedScalaSemanticDB();
            synchronized (path) {
                Right right2;
                if (this.latestResolvedScalaSemanticDB() != null) {
                    right2 = package$.MODULE$.Right().apply((Object)new AbsolutePath(AbsolutePath$.MODULE$.apply(this.latestResolvedScalaSemanticDB(), AbsolutePath$.MODULE$.workingDirectory())));
                } else {
                    Right latestResolvedPlugin = this.fetchPlugin(artifact, logger);
                    latestResolvedPlugin.foreach((Function1 & Serializable & scala.Serializable)plugin -> {
                        SemanticDBCache$.MODULE$.latestResolvedScalaSemanticDB_$eq(((AbsolutePath)plugin).underlying());
                        return BoxedUnit.UNIT;
                    });
                    right2 = latestResolvedPlugin;
                }
                right = right2;
            }
            return right;
        }
        Either<String, AbsolutePath> either = this.fetchPlugin(artifact, logger);
        if (either instanceof Right) {
            Right right = (Right)either;
            Path plugin2 = ((AbsolutePath)right.value()).underlying();
            return package$.MODULE$.Right().apply((Object)new AbsolutePath(plugin2));
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            String error = (String)left.value();
            Either<String, AbsolutePath> either2 = this.fallbackSemanticdbFetch(scalaVersion, artifact, logger);
            if (either2 instanceof Left) {
                Left left2 = (Left)either2;
                String newError = (String)left2.value();
                return package$.MODULE$.Left().apply((Object)new StringBuilder(1).append(error).append("\n").append(newError).toString());
            }
            if (either2 instanceof Right) {
                Right right = (Right)either2;
                Path plugin3 = ((AbsolutePath)right.value()).underlying();
                return package$.MODULE$.Right().apply((Object)new AbsolutePath(plugin3));
            }
            throw new MatchError(either2);
        }
        throw new MatchError(either);
    }

    private Path latestResolvedJavaSemanticDB() {
        return this.latestResolvedJavaSemanticDB;
    }

    private void latestResolvedJavaSemanticDB_$eq(Path x$1) {
        this.latestResolvedJavaSemanticDB = x$1;
    }

    public Either<String, AbsolutePath> fetchJavaPlugin(String version, Logger logger) {
        String organization = "com.sourcegraph";
        String module = "semanticdb-javac";
        DependencyResolution.Artifact artifact = new DependencyResolution.Artifact(organization, module, version);
        String string = artifact.version();
        String string2 = "latest.release";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Right right;
            Path path = this.latestResolvedJavaSemanticDB();
            synchronized (path) {
                Right right2;
                if (this.latestResolvedJavaSemanticDB() != null) {
                    right2 = package$.MODULE$.Right().apply((Object)new AbsolutePath(AbsolutePath$.MODULE$.apply(this.latestResolvedJavaSemanticDB(), AbsolutePath$.MODULE$.workingDirectory())));
                } else {
                    Right latestResolvedPlugin = this.fetchPlugin(artifact, logger);
                    latestResolvedPlugin.foreach((Function1 & Serializable & scala.Serializable)plugin -> {
                        SemanticDBCache$.MODULE$.latestResolvedJavaSemanticDB_$eq(((AbsolutePath)plugin).underlying());
                        return BoxedUnit.UNIT;
                    });
                    right2 = latestResolvedPlugin;
                }
                right = right2;
            }
            return right;
        }
        return this.fetchPlugin(artifact, logger);
    }

    public static final /* synthetic */ boolean $anonfun$fetchPlugin$1(DependencyResolution.Artifact artifact$1, Path x$1) {
        return AbsolutePath$.MODULE$.syntax$extension(x$1).contains(artifact$1.module());
    }

    private static final Either attemptResolution$1(DependencyResolution.Artifact artifact$1, Logger logger$1) {
        Either either = DependencyResolution$.MODULE$.resolveWithErrors((List)new .colon.colon((Object)artifact$1, (List)Nil$.MODULE$), logger$1, DependencyResolution$.MODULE$.resolveWithErrors$default$3(), DependencyResolution$.MODULE$.resolveWithErrors$default$4());
        if (either instanceof Left) {
            Left left = (Left)either;
            CoursierError error = (CoursierError)left.value();
            return package$.MODULE$.Left().apply((Object)error.getMessage());
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            AbsolutePath[] paths = (AbsolutePath[])right.value();
            Option option = Predef$.MODULE$.genericArrayOps((Object)paths).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SemanticDBCache$.$anonfun$fetchPlugin$1(artifact$1, ((AbsolutePath)x$1).underlying())));
            if (option instanceof Some) {
                Some some = (Some)option;
                Path pluginPath = ((AbsolutePath)some.value()).underlying();
                return package$.MODULE$.Right().apply((Object)new AbsolutePath(pluginPath));
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)new StringBuilder(33).append("Missing ").append(artifact$1.module()).append(" plugin in resolved jars ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)paths).map((Function1 & Serializable & scala.Serializable)x$2 -> AbsolutePath$.MODULE$.syntax$extension(((AbsolutePath)x$2).underlying()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",")).toString());
            }
            throw new MatchError((Object)option);
        }
        throw new MatchError((Object)either);
    }

    public static final /* synthetic */ File $anonfun$fetchPlugin$3(BloopComponentManager manager$1, String semanticDBId$1) {
        return manager$1.file(semanticDBId$1, (IfMissing)IfMissing.Fail$.MODULE$);
    }

    private static final Future versionFuture$1(String scalaVersion$1) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(Complete.create().withScalaVersion(scalaVersion$1).withScalaBinaryVersion(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(scalaVersion$1)).split('.'))).take(2))).mkString(".")).withInput(new StringBuilder(33).append("org.scalameta:semanticdb-scalac_").append(scalaVersion$1).append(":").toString()).complete().getCompletions()).asScala()).lastOption(), (ExecutionContext)ExecutionContext$.MODULE$.ioScheduler());
    }

    private static final Option version$1(String scalaVersion$1) {
        None$ none$;
        try {
            none$ = (Option)Await$.MODULE$.result((Awaitable)SemanticDBCache$.versionFuture$1(scalaVersion$1), (Duration)FiniteDuration$.MODULE$.apply(10L, "s"));
        }
        catch (Throwable throwable) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private SemanticDBCache$() {
        MODULE$ = this;
        this.supportedFallbackSemanticdbVersions = new ConcurrentHashMap();
        this.latestResolvedScalaSemanticDB = null;
        this.latestResolvedJavaSemanticDB = null;
    }
}

