/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine.tasks.compilation;

import bloop.ClientClassesObserver;
import bloop.Compiler;
import bloop.UniqueCompileInputs;
import bloop.data.ClientInfo;
import bloop.data.Project;
import bloop.engine.Dag;
import bloop.engine.caches.LastSuccessfulResult;
import bloop.engine.caches.LastSuccessfulResult$;
import bloop.engine.tasks.compilation.CompileDefinitions;
import bloop.engine.tasks.compilation.CompileDependenciesData;
import bloop.engine.tasks.compilation.CompileGatekeeper;
import bloop.engine.tasks.compilation.PartialCompileResult;
import bloop.engine.tasks.compilation.PartialCompileResult$;
import bloop.engine.tasks.compilation.PartialSuccess;
import bloop.engine.tasks.compilation.ResultBundle;
import bloop.engine.tasks.compilation.SuccessfulCompileBundle;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import bloop.logging.LoggerAction;
import bloop.logging.ObservedLogger;
import bloop.reporter.ObservedReporter;
import bloop.reporter.ReporterAction;
import bloop.task.Task;
import bloop.task.Task$;
import bloop.tracing.BraveTracer;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBoolean$;
import monix.execution.atomic.AtomicInt;
import monix.execution.atomic.AtomicInt$;
import monix.reactive.Observable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.concurrent.Promise;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import xsbti.compile.PreviousResult;

public final class CompileGatekeeper$ {
    public static CompileGatekeeper$ MODULE$;
    private final DebugFilter filter;
    private final ConcurrentHashMap<AbsolutePath, AtomicInt> currentlyUsedClassesDirs;
    private final ConcurrentHashMap<UniqueCompileInputs, CompileGatekeeper.RunningCompilation> runningCompilations;
    private final ConcurrentHashMap<String, LastSuccessfulResult> lastSuccessfulResults;

    static {
        new CompileGatekeeper$();
    }

    private DebugFilter filter() {
        return this.filter;
    }

    private ConcurrentHashMap<AbsolutePath, AtomicInt> currentlyUsedClassesDirs() {
        return this.currentlyUsedClassesDirs;
    }

    private ConcurrentHashMap<UniqueCompileInputs, CompileGatekeeper.RunningCompilation> runningCompilations() {
        return this.runningCompilations;
    }

    private ConcurrentHashMap<String, LastSuccessfulResult> lastSuccessfulResults() {
        return this.lastSuccessfulResults;
    }

    public Tuple2<CompileGatekeeper.RunningCompilation, Object> findRunningCompilationAtomically(CompileDefinitions.BundleInputs inputs, SuccessfulCompileBundle bundle, ClientInfo client, Function1<SuccessfulCompileBundle, Task<Dag<PartialCompileResult>>> compile, BraveTracer tracer2) {
        return (Tuple2)tracer2.trace("Finding compilation atomically.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)tracer -> {
            BooleanRef deduplicate = BooleanRef.create((boolean)true);
            CompileGatekeeper.RunningCompilation running2 = MODULE$.runningCompilations().compute(bundle.uniqueInputs(), (x$1, running) -> {
                if (running == null) {
                    return (CompileGatekeeper.RunningCompilation)tracer.trace("no running compilation found starting new one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"uniqueInputs", (Object)bundle.uniqueInputs().toString())}), (Function1 & Serializable & scala.Serializable)tracer -> {
                        bundle.logger().debug(new StringBuilder(46).append("no running compilation found starting new one:").append(bundle.uniqueInputs()).toString(), MODULE$.filter());
                        deduplicate$1.elem = false;
                        return MODULE$.scheduleCompilation(inputs, bundle, client, compile, (BraveTracer)tracer);
                    });
                }
                return (CompileGatekeeper.RunningCompilation)tracer.trace("Found matching compilation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"uniqueInputs", (Object)bundle.uniqueInputs().toString())}), (Function1 & Serializable & scala.Serializable)tracer2 -> {
                    int update$macro$3;
                    AtomicInt usedClassesDirCounter;
                    Path usedClassesDir = running.usedLastSuccessful().classesDir();
                    AtomicInt self$macro$1 = usedClassesDirCounter = running.usedLastSuccessful().counterForClassesDir();
                    IntRef current$macro$2 = IntRef.create((int)self$macro$1.get());
                    int n = update$macro$3 = current$macro$2.elem == 0 ? BoxesRunTime.unboxToInt((Object)tracer2.trace("Aborting deduplication", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"uniqueInputs", (Object)bundle.uniqueInputs().toString())}), (Function1 & Serializable & scala.Serializable)tracer -> BoxesRunTime.boxToInteger((int)CompileGatekeeper$.$anonfun$findRunningCompilationAtomically$5(bundle, deduplicate, usedClassesDir, usedClassesDirCounter, current$macro$2, tracer)))) : BoxesRunTime.unboxToInt((Object)tracer2.trace("Increasing compilation counter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"uniqueInputs", (Object)bundle.uniqueInputs().toString())}), (Function1 & Serializable & scala.Serializable)tracer -> BoxesRunTime.boxToInteger((int)CompileGatekeeper$.$anonfun$findRunningCompilationAtomically$6(bundle, current$macro$2, tracer))));
                    while (!self$macro$1.compareAndSet(current$macro$2.elem, update$macro$3)) {
                        current$macro$2.elem = self$macro$1.get();
                        update$macro$3 = current$macro$2.elem == 0 ? BoxesRunTime.unboxToInt((Object)tracer2.trace("Aborting deduplication", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"uniqueInputs", (Object)bundle.uniqueInputs().toString())}), (Function1 & Serializable & scala.Serializable)tracer -> BoxesRunTime.boxToInteger((int)CompileGatekeeper$.$anonfun$findRunningCompilationAtomically$7(bundle, deduplicate, usedClassesDir, usedClassesDirCounter, current$macro$2, tracer)))) : BoxesRunTime.unboxToInt((Object)tracer2.trace("Increasing compilation counter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"uniqueInputs", (Object)bundle.uniqueInputs().toString())}), (Function1 & Serializable & scala.Serializable)tracer -> BoxesRunTime.boxToInteger((int)CompileGatekeeper$.$anonfun$findRunningCompilationAtomically$8(bundle, current$macro$2, tracer))));
                    }
                    int cfr_ignored_0 = current$macro$2.elem;
                    if (deduplicate$1.elem) {
                        return running;
                    }
                    return MODULE$.scheduleCompilation(inputs, bundle, client, compile, (BraveTracer)tracer2);
                });
            });
            return new Tuple2((Object)running2, (Object)BoxesRunTime.boxToBoolean((boolean)deduplicate.elem));
        });
    }

    public void disconnectDeduplicationFromRunning(UniqueCompileInputs inputs, CompileGatekeeper.RunningCompilation runningCompilation, Logger logger, BraveTracer tracer) {
        tracer.trace("disconnectDeduplicationFromRunning", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"uniqueInputs", (Object)inputs.toString())}), (Function1 & Serializable & scala.Serializable)x$2 -> {
            CompileGatekeeper$.$anonfun$disconnectDeduplicationFromRunning$1(logger, inputs, runningCompilation, x$2);
            return BoxedUnit.UNIT;
        });
    }

    private CompileGatekeeper.RunningCompilation scheduleCompilation(CompileDefinitions.BundleInputs inputs, SuccessfulCompileBundle bundle, ClientInfo client, Function1<SuccessfulCompileBundle, Task<Dag<PartialCompileResult>>> compile, BraveTracer tracer) {
        return (CompileGatekeeper.RunningCompilation)tracer.trace("schedule compilation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$3 -> {
            ObjectRef counterForUsedClassesDir = ObjectRef.create(null);
            bundle.logger().debug(new StringBuilder(30).append("Scheduling compilation for ").append(inputs.project().name()).append("...").toString(), MODULE$.filter());
            LastSuccessfulResult mostRecentSuccessful = CompileGatekeeper$.getMostRecentSuccessfulResultAtomically$1(tracer, inputs, bundle, counterForUsedClassesDir);
            AtomicBoolean isUnsubscribed = AtomicBoolean$.MODULE$.apply(false);
            LastSuccessfulResult x$1 = mostRecentSuccessful;
            Project x$2 = bundle.copy$default$1();
            ClientClassesObserver x$32 = bundle.copy$default$2();
            CompileDependenciesData x$4 = bundle.copy$default$3();
            List<AbsolutePath> x$5 = bundle.copy$default$4();
            List<AbsolutePath> x$6 = bundle.copy$default$5();
            UniqueCompileInputs x$7 = bundle.copy$default$6();
            Promise<BoxedUnit> x$82 = bundle.copy$default$7();
            ObservedReporter x$9 = bundle.copy$default$8();
            ObservedLogger<Logger> x$10 = bundle.copy$default$9();
            Observable<Either<ReporterAction, LoggerAction>> x$11 = bundle.copy$default$10();
            Compiler.Result x$12 = bundle.copy$default$12();
            BraveTracer x$13 = bundle.copy$default$13();
            SuccessfulCompileBundle newBundle = bundle.copy(x$2, x$32, x$4, x$5, x$6, x$7, x$82, x$9, x$10, x$11, x$1, x$12, x$13);
            Task compileAndUnsubscribe = (Task)tracer.trace("compile and unsubscribe", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$8 -> ((Task)compile.apply((Object)newBundle)).doOnFinish((Function1 & Serializable & scala.Serializable)x$9 -> Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> bundle.logger().observer().onComplete())).map((Function1 & Serializable & scala.Serializable)result -> (Dag)tracer.trace("process result atomically", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$10 -> MODULE$.processResultAtomically((Dag<PartialCompileResult>)result, inputs.project(), bundle.uniqueInputs(), isUnsubscribed, (Logger)bundle.logger(), tracer))).memoize());
            return new CompileGatekeeper.RunningCompilation((Task<Dag<PartialCompileResult>>)compileAndUnsubscribe, mostRecentSuccessful, isUnsubscribed, bundle.mirror(), client);
        });
    }

    private Dag<PartialCompileResult> processResultAtomically(Dag<PartialCompileResult> resultDag, Project project, UniqueCompileInputs oinputs, AtomicBoolean isAlreadyUnsubscribed, Logger logger, BraveTracer tracer) {
        return PartialCompileResult$.MODULE$.mapEveryResult(resultDag, (Function1<PartialCompileResult, PartialCompileResult>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
            PartialCompileResult partialCompileResult = x0$1;
            if (partialCompileResult instanceof PartialSuccess) {
                PartialSuccess partialSuccess = (PartialSuccess)partialCompileResult;
                Task processedResult = partialSuccess.result().map((Function1 & Serializable & scala.Serializable)result -> {
                    Option<LastSuccessfulResult> option = result.successful();
                    if (None$.MODULE$.equals(option)) {
                        tracer.trace("cleaning after compilation error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$12 -> (ResultBundle)CompileGatekeeper$.cleanUpAfterCompilationError$1(result, tracer, isAlreadyUnsubscribed, logger, oinputs));
                    } else if (option instanceof Some) {
                        Some some = (Some)option;
                        LastSuccessfulResult res = (LastSuccessfulResult)some.value();
                        tracer.trace("unregister deduplication and register successful", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$13 -> {
                            CompileGatekeeper$.MODULE$.unregisterDeduplicationAndRegisterSuccessful(project, oinputs, res, logger);
                            return BoxedUnit.UNIT;
                        });
                    } else {
                        throw new MatchError(option);
                    }
                    return result;
                });
                Task x$1 = processedResult.memoize();
                SuccessfulCompileBundle x$2 = partialSuccess.copy$default$1();
                return partialSuccess.copy(x$2, (Task<ResultBundle>)x$1);
            }
            return (PartialCompileResult)tracer.trace("cleaning after compilation error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$14 -> (PartialCompileResult)CompileGatekeeper$.cleanUpAfterCompilationError$1(partialCompileResult, tracer, isAlreadyUnsubscribed, logger, oinputs));
        });
    }

    private void unregisterDeduplicationAndRegisterSuccessful(Project project, UniqueCompileInputs oracleInputs, LastSuccessfulResult successful, Logger logger) {
        this.runningCompilations().compute(oracleInputs, (x$15, x$16) -> {
            logger.debug("Unregister deduplication and registered successfully", MODULE$.filter());
            MODULE$.lastSuccessfulResults().compute(project.uniqueId(), (x$17, x$18) -> successful);
            return null;
        });
        logger.debug(new StringBuilder(59).append("Recording new last successful request for ").append(project.name()).append(" associated with ").append(new AbsolutePath(successful.classesDir())).toString(), this.filter());
    }

    public void clearSuccessfulResults() {
        ConcurrentHashMap<String, LastSuccessfulResult> concurrentHashMap = this.lastSuccessfulResults();
        synchronized (concurrentHashMap) {
            this.lastSuccessfulResults().clear();
        }
    }

    public static final /* synthetic */ int $anonfun$findRunningCompilationAtomically$5(SuccessfulCompileBundle bundle$1, BooleanRef deduplicate$1, Path usedClassesDir$1, AtomicInt usedClassesDirCounter$1, IntRef current$macro$2$1, BraveTracer tracer) {
        bundle$1.logger().debug(new StringBuilder(66).append("Abort deduplication, dir is scheduled to be deleted in background:").append(bundle$1.uniqueInputs()).toString(), MODULE$.filter());
        deduplicate$1.elem = false;
        MODULE$.currentlyUsedClassesDirs().remove(new AbsolutePath(usedClassesDir$1), usedClassesDirCounter$1);
        return current$macro$2$1.elem;
    }

    public static final /* synthetic */ int $anonfun$findRunningCompilationAtomically$6(SuccessfulCompileBundle bundle$1, IntRef current$macro$2$1, BraveTracer tracer) {
        bundle$1.logger().debug(new StringBuilder(66).append("Increase count to prevent other compiles to schedule its deletion:").append(bundle$1.uniqueInputs()).toString(), MODULE$.filter());
        return current$macro$2$1.elem + 1;
    }

    public static final /* synthetic */ int $anonfun$findRunningCompilationAtomically$7(SuccessfulCompileBundle bundle$1, BooleanRef deduplicate$1, Path usedClassesDir$1, AtomicInt usedClassesDirCounter$1, IntRef current$macro$2$1, BraveTracer tracer) {
        bundle$1.logger().debug(new StringBuilder(66).append("Abort deduplication, dir is scheduled to be deleted in background:").append(bundle$1.uniqueInputs()).toString(), MODULE$.filter());
        deduplicate$1.elem = false;
        MODULE$.currentlyUsedClassesDirs().remove(new AbsolutePath(usedClassesDir$1), usedClassesDirCounter$1);
        return current$macro$2$1.elem;
    }

    public static final /* synthetic */ int $anonfun$findRunningCompilationAtomically$8(SuccessfulCompileBundle bundle$1, IntRef current$macro$2$1, BraveTracer tracer) {
        bundle$1.logger().debug(new StringBuilder(66).append("Increase count to prevent other compiles to schedule its deletion:").append(bundle$1.uniqueInputs()).toString(), MODULE$.filter());
        return current$macro$2$1.elem + 1;
    }

    public static final /* synthetic */ void $anonfun$disconnectDeduplicationFromRunning$1(Logger logger$1, UniqueCompileInputs inputs$2, CompileGatekeeper.RunningCompilation runningCompilation$1, BraveTracer x$2) {
        logger$1.debug(new StringBuilder(52).append("Disconnected deduplication from running compilation:").append(inputs$2).toString(), MODULE$.filter());
        runningCompilation$1.isUnsubscribed().compareAndSet(false, true);
        MODULE$.runningCompilations().remove(inputs$2, runningCompilation$1);
    }

    private static final LastSuccessfulResult initializeLastSuccessful$1(LastSuccessfulResult previousOrNull, BraveTracer tracer$2, SuccessfulCompileBundle bundle$2, CompileDefinitions.BundleInputs inputs$3) {
        return (LastSuccessfulResult)tracer$2.trace("initialize last successful", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$4 -> {
            LastSuccessfulResult result = (LastSuccessfulResult)Option$.MODULE$.apply((Object)previousOrNull).getOrElse((Function0 & Serializable & scala.Serializable)() -> bundle$2.lastSuccessful());
            if (!AbsolutePath$.MODULE$.exists$extension(result.classesDir())) {
                bundle$2.logger().debug(new StringBuilder(45).append("Ignoring analysis for ").append(inputs$3.project().name()).append(", directory ").append(new AbsolutePath(result.classesDir())).append(" is missing").toString(), MODULE$.filter());
                return LastSuccessfulResult$.MODULE$.empty(inputs$3.project());
            }
            Compiler.Result result2 = bundle$2.latestResult();
            Compiler.Result$.Empty$ empty$ = Compiler.Result$.Empty$.MODULE$;
            if (!(result2 != null ? !result2.equals(empty$) : empty$ != null)) {
                bundle$2.logger().debug(new StringBuilder(54).append("Ignoring existing analysis for ").append(inputs$3.project().name()).append(", last result was empty").toString(), MODULE$.filter());
                LastSuccessfulResult qual$1 = LastSuccessfulResult$.MODULE$.empty(inputs$3.project());
                Path x$1 = result.classesDir();
                AtomicInt x$2 = result.counterForClassesDir();
                Task<BoxedUnit> x$3 = result.populatingProducts();
                boolean x$42 = qual$1.copy$default$1();
                PreviousResult x$5 = qual$1.copy$default$2();
                return qual$1.copy(x$42, x$5, x$1, x$2, x$3);
            }
            bundle$2.logger().debug(new StringBuilder(45).append("Using successful result for ").append(inputs$3.project().name()).append(" associated with ").append(new AbsolutePath(result.classesDir())).toString(), MODULE$.filter());
            return result;
        });
    }

    public static final /* synthetic */ AtomicInt $anonfun$scheduleCompilation$6(SuccessfulCompileBundle bundle$2, LastSuccessfulResult previousResult$1, ObjectRef counterForUsedClassesDir$1, Path x$7, AtomicInt counter) {
        bundle$2.logger().debug(new StringBuilder(59).append("Set counter for used classes dir when init or incrementing:").append(new AbsolutePath(previousResult$1.classesDir())).toString(), MODULE$.filter());
        if (counter == null) {
            bundle$2.logger().debug(new StringBuilder(19).append("Create new counter:").append(new AbsolutePath(previousResult$1.classesDir())).toString(), MODULE$.filter());
            AtomicInt initialCounter = AtomicInt$.MODULE$.apply(1);
            counterForUsedClassesDir$1.elem = initialCounter;
            return initialCounter;
        }
        counterForUsedClassesDir$1.elem = counter;
        int newCount = counter.incrementAndGet(1);
        bundle$2.logger().debug(new StringBuilder(27).append("Increasing counter for ").append(new AbsolutePath(previousResult$1.classesDir())).append(" to ").append(newCount).toString(), MODULE$.filter());
        return counter;
    }

    private static final LastSuccessfulResult getMostRecentSuccessfulResultAtomically$1(BraveTracer tracer$2, CompileDefinitions.BundleInputs inputs$3, SuccessfulCompileBundle bundle$2, ObjectRef counterForUsedClassesDir$1) {
        return (LastSuccessfulResult)tracer$2.trace("get most recent successful result atomically", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.lastSuccessfulResults().compute(inputs$3.project().uniqueId(), (x$6, previousResultOrNull) -> {
            bundle$2.logger().debug(new StringBuilder(77).append("Return previous result or the initial last successful coming from the bundle:").append(inputs$3.project().uniqueId()).toString(), MODULE$.filter());
            LastSuccessfulResult previousResult = CompileGatekeeper$.initializeLastSuccessful$1(previousResultOrNull, tracer$2, bundle$2, inputs$3);
            MODULE$.currentlyUsedClassesDirs().compute(new AbsolutePath(previousResult.classesDir()), (x$7, counter) -> CompileGatekeeper$.$anonfun$scheduleCompilation$6(bundle$2, previousResult, counterForUsedClassesDir$1, ((AbsolutePath)x$7).underlying(), counter));
            AtomicInt x$1 = (AtomicInt)counterForUsedClassesDir$1.elem;
            boolean x$2 = previousResult.copy$default$1();
            PreviousResult x$3 = previousResult.copy$default$2();
            Path x$4 = previousResult.copy$default$3();
            Task<BoxedUnit> x$5 = previousResult.copy$default$5();
            return previousResult.copy(x$2, x$3, x$4, x$1, x$5);
        }));
    }

    private static final Object cleanUpAfterCompilationError$1(Object result, BraveTracer tracer$3, AtomicBoolean isAlreadyUnsubscribed$1, Logger logger$2, UniqueCompileInputs oinputs$1) {
        return tracer$3.trace("cleaning after compilation error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$11 -> {
            Object object;
            if (!isAlreadyUnsubscribed$1.get()) {
                logger$2.debug(new StringBuilder(88).append("Remove running compilation if host compilation hasn't unsubscribed (maybe it's blocked):").append(oinputs$1).toString(), MODULE$.filter());
                object = MODULE$.runningCompilations().remove(oinputs$1);
            } else {
                object = BoxedUnit.UNIT;
            }
            return result;
        });
    }

    private CompileGatekeeper$() {
        MODULE$ = this;
        this.filter = DebugFilter.Compilation$.MODULE$;
        this.currentlyUsedClassesDirs = new ConcurrentHashMap();
        this.runningCompilations = new ConcurrentHashMap();
        this.lastSuccessfulResults = new ConcurrentHashMap();
    }
}

