/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine;

import bloop.CompilerCache;
import bloop.Project;
import bloop.cli.CliOptions;
import bloop.cli.Commands;
import bloop.cli.CommonOptions;
import bloop.cli.ExitStatus;
import bloop.cli.ExitStatus$;
import bloop.engine.Action;
import bloop.engine.Build;
import bloop.engine.Dag$;
import bloop.engine.ExecutionContext$;
import bloop.engine.Exit;
import bloop.engine.Print;
import bloop.engine.Run;
import bloop.engine.State;
import bloop.engine.State$;
import bloop.engine.caches.ResultsCache;
import bloop.engine.tasks.CompileTasks$;
import bloop.engine.tasks.TestTasks$;
import bloop.internal.build.BuildInfo$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.SourceWatcher;
import bloop.io.Timer$;
import bloop.logging.BloopLogger;
import bloop.logging.BloopLogger$;
import bloop.logging.Logger;
import bloop.reporter.ReporterConfig;
import bloop.reporter.ReporterConfig$;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;

public final class Interpreter$ {
    public static Interpreter$ MODULE$;
    private final String line;

    static {
        new Interpreter$();
    }

    public State execute(Action action, State state0) {
        State state;
        block17: {
            Action action2;
            while (true) {
                boolean bl = false;
                Exit exit = null;
                boolean bl2 = false;
                Run run = null;
                action2 = action;
                if (action2 instanceof Exit) {
                    bl = true;
                    exit = (Exit)action2;
                    ExitStatus exitStatus = exit.exitStatus();
                    if (state0.status().isOk()) {
                        state = state0.mergeStatus(exitStatus);
                        break block17;
                    }
                }
                if (bl) {
                    state = state0;
                    break block17;
                }
                if (action2 instanceof Print) {
                    Print print = (Print)action2;
                    String msg = print.msg();
                    CommonOptions commonOptions = print.commonOptions();
                    Action next = print.next();
                    State state2 = Interpreter$.updateState$1(state0, commonOptions);
                    state2.logger().info(msg);
                    state0 = state2;
                    action = next;
                    continue;
                }
                if (action2 instanceof Run) {
                    bl2 = true;
                    run = (Run)action2;
                    Commands.Command command = run.command();
                    Action next = run.next();
                    if (command instanceof Commands.About) {
                        Commands.About about = (Commands.About)command;
                        CliOptions cliOptions = about.cliOptions();
                        State state3 = Interpreter$.updateState$1(state0, cliOptions.common());
                        ExitStatus status = (ExitStatus)Interpreter$.logAndTime$1(state3, cliOptions, (Function0 & Serializable & scala.Serializable)() -> MODULE$.printAbout(state3));
                        state0 = state3.mergeStatus(status);
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd = run.command();
                    Action next = run.next();
                    if (cmd instanceof Commands.Clean) {
                        Commands.Clean clean = (Commands.Clean)cmd;
                        State state4 = Interpreter$.updateState$1(state0, clean.cliOptions().common());
                        state0 = (State)Interpreter$.logAndTime$1(state4, clean.cliOptions(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.clean(clean, state4));
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd = run.command();
                    Action next = run.next();
                    if (cmd instanceof Commands.Compile) {
                        Commands.Compile compile = (Commands.Compile)cmd;
                        State state5 = Interpreter$.updateState$1(state0, compile.cliOptions().common());
                        state0 = (State)Interpreter$.logAndTime$1(state5, compile.cliOptions(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.compile(compile, state5));
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd = run.command();
                    Action next = run.next();
                    if (cmd instanceof Commands.Console) {
                        Commands.Console console = (Commands.Console)cmd;
                        State state6 = Interpreter$.updateState$1(state0, console.cliOptions().common());
                        state0 = (State)Interpreter$.logAndTime$1(state6, console.cliOptions(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.console(console, state6));
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd = run.command();
                    Action next = run.next();
                    if (cmd instanceof Commands.Projects) {
                        Commands.Projects projects = (Commands.Projects)cmd;
                        State state7 = Interpreter$.updateState$1(state0, projects.cliOptions().common());
                        state0 = (State)Interpreter$.logAndTime$1(state7, projects.cliOptions(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.showProjects(projects, state7));
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd = run.command();
                    Action next = run.next();
                    if (cmd instanceof Commands.Test) {
                        Commands.Test test = (Commands.Test)cmd;
                        State state8 = Interpreter$.updateState$1(state0, test.cliOptions().common());
                        state0 = (State)Interpreter$.logAndTime$1(state8, test.cliOptions(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.test(test, state8));
                        action = next;
                        continue;
                    }
                }
                if (!bl2) break;
                Commands.Command cmd = run.command();
                Action next = run.next();
                if (!(cmd instanceof Commands.Configure)) break;
                Commands.Configure configure = (Commands.Configure)cmd;
                State state9 = Interpreter$.updateState$1(state0, configure.cliOptions().common());
                state0 = (State)Interpreter$.logAndTime$1(state9, configure.cliOptions(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.configure(configure, state9));
                action = next;
            }
            throw new MatchError((Object)action2);
        }
        return state;
    }

    private final String t() {
        return "    ";
    }

    private final String line() {
        return this.line;
    }

    private ExitStatus printAbout(State state) {
        String bloopName = BuildInfo$.MODULE$.name();
        String bloopVersion = BuildInfo$.MODULE$.version();
        String scalaVersion = BuildInfo$.MODULE$.scalaVersion();
        String zincVersion = BuildInfo$.MODULE$.zincVersion();
        String developers = BuildInfo$.MODULE$.developers().mkString(", ");
        String header = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|", "   _____            __         ______           __\n          |", "  / ___/_________ _/ /___ _   / ____/__  ____  / /____  _____\n          |", "  \\\\__ \\\\/ ___/ __ `/ / __ `/  / /   / _ \\\\/ __ \\\\/ __/ _ \\\\/ ___/\n          |", " ___/ / /__/ /_/ / / /_/ /  / /___/ /__/ / / / /_/ /__/ /\n          |", "/____/\\\\___/\\\\__,_/_/\\\\__,_/   \\\\____/\\\\___/_/ /_/\\\\__/\\\\___/_/\n          |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"    ", "    ", "    ", "    ", "    "})))).stripMargin();
        String versions = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                      |", "", " version    `", "`\n                      |", "Zinc version     `", "`\n                      |", "Scala version    `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"    ", new StringOps(Predef$.MODULE$.augmentString(bloopName)).capitalize(), bloopVersion, "    ", zincVersion, "    ", scalaVersion})))).stripMargin();
        state.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{header, this.line()})));
        state.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", " is made with love at the Scala Center <3", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"    ", bloopName, this.line()})));
        state.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{versions, this.line(), this.line()})));
        state.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "It is maintained by ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"    ", developers})));
        return ExitStatus$.MODULE$.Ok();
    }

    private State watch(Project project, State state, Function1<State, State> f) {
        List<Project> reachable = Dag$.MODULE$.dfs(state.build().getDagFor(project));
        Iterator allSourceDirs = reachable.iterator().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Predef$.MODULE$.genericArrayOps((Object)x$1.sourceDirectories()).toList()).map((Function1 & Serializable & scala.Serializable)x$2 -> ((AbsolutePath)x$2).underlying());
        SourceWatcher watcher = new SourceWatcher((Seq<Path>)allSourceDirs.toList(), state.logger());
        return watcher.watch((State)f.apply((Object)state), f);
    }

    private State compile(Commands.Compile cmd, State state) {
        State state2;
        ReporterConfig reporterConfig = ReporterConfig$.MODULE$.getDefault(cmd.scalacstyle());
        Option<Project> option = state.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            state2 = this.runCompile$1(project, cmd, state, reporterConfig);
        } else if (None$.MODULE$.equals(option)) {
            String string = cmd.project();
            state2 = this.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state);
        } else {
            throw new MatchError(option);
        }
        return state2;
    }

    private State showProjects(Commands.Projects cmd, State state) {
        if (cmd.dotGraph()) {
            String contents = Dag$.MODULE$.toDotGraph(state.build().dags());
            state.logger().info(contents);
        } else {
            String configDirectory = AbsolutePath$.MODULE$.syntax$extension(state.build().origin());
            state.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Projects loaded from '", "':"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configDirectory})));
            ((List)((SeqLike)state.build().projects().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)projectName -> {
                Interpreter$.$anonfun$showProjects$2(state, projectName);
                return BoxedUnit.UNIT;
            });
        }
        return state.mergeStatus(ExitStatus$.MODULE$.Ok());
    }

    private State console(Commands.Console cmd, State state) {
        State state2;
        ReporterConfig reporterConfig = ReporterConfig$.MODULE$.getDefault(cmd.scalacstyle());
        Option<Project> option = state.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            state2 = Interpreter$.runConsole$1(project, cmd, state, reporterConfig).mergeStatus(ExitStatus$.MODULE$.Ok());
        } else if (None$.MODULE$.equals(option)) {
            String string = cmd.project();
            state2 = this.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state);
        } else {
            throw new MatchError(option);
        }
        return state2;
    }

    private State test(Commands.Test cmd, State state) {
        State state2;
        Option<Project> projectToTest = TestTasks$.MODULE$.pickTestProject(cmd.project(), state);
        Option<Project> option = projectToTest;
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            state2 = this.compileAndTest$1(state, project, cmd);
        } else if (None$.MODULE$.equals(option)) {
            String string = cmd.project();
            state2 = this.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state);
        } else {
            throw new MatchError(option);
        }
        return state2;
    }

    private Tuple2<List<Project>, List<String>> lookupProjects(List<String> names, State state) {
        Build build = state.build();
        Tuple2 result = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Nil$.MODULE$), (Object)Nil$.MODULE$);
        return (Tuple2)names.foldLeft((Object)result, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = new Tuple2(x0$1, x1$1);
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Tuple2 tuple23 = (Tuple2)tuple22._1();
            String name = (String)tuple22._2();
            if (tuple23 == null) throw new MatchError((Object)tuple22);
            List projects = (List)tuple23._1();
            List missing = (List)tuple23._2();
            Option<Project> option = build.getProjectFor(name);
            if (option instanceof Some) {
                Project project;
                Some some = (Some)option;
                Project project2 = project = (Project)some.value();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)projects.$colon$colon((Object)project2)), (Object)missing);
                return tuple2;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                String string = name;
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)projects), (Object)missing.$colon$colon((Object)string));
            }
            return tuple2;
        });
    }

    private State configure(Commands.Configure cmd, State state) {
        return cmd.threads() != ExecutionContext$.MODULE$.executor().getCorePoolSize() ? State$.MODULE$.setCores(state, cmd.threads()) : state;
    }

    private State clean(Commands.Clean cmd, State state) {
        Tuple2<List<Project>, List<String>> tuple2 = this.lookupProjects(cmd.projects(), state);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List projects = (List)tuple2._1();
        List missing = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)projects, (Object)missing);
        Tuple2 tuple23 = tuple22;
        List projects2 = (List)tuple23._1();
        List missing2 = (List)tuple23._2();
        return missing2.isEmpty() ? CompileTasks$.MODULE$.clean(state, (List<Project>)projects2).mergeStatus(ExitStatus$.MODULE$.Ok()) : this.reportMissing((List<String>)missing2, state);
    }

    private State reportMissing(List<String> projectNames, State state) {
        String projects = projectNames.mkString("'", "', '", "'");
        String configDirectory = AbsolutePath$.MODULE$.syntax$extension(state.build().origin());
        state.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No projects named ", " found in '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{projects, configDirectory})));
        state.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Use the `projects` command to list existing projects."})).s((Seq)Nil$.MODULE$));
        return state.mergeStatus(ExitStatus$.MODULE$.InvalidCommandLineOption());
    }

    private static final Object logAndTime$1(State state, CliOptions cliOptions, Function0 action) {
        return state.logger().verboseIf(cliOptions.verbose(), (Function0 & Serializable & scala.Serializable)() -> Timer$.MODULE$.timed(state.logger(), action));
    }

    private static final State updateState$1(State state, CommonOptions commonOptions) {
        State$.MODULE$.updateLogger(state.logger(), commonOptions);
        BloopLogger logger = BloopLogger$.MODULE$.apply(state.logger().name());
        CommonOptions x$10 = commonOptions;
        BloopLogger x$11 = logger;
        Build x$12 = state.copy$default$1();
        ResultsCache x$13 = state.copy$default$2();
        CompilerCache x$14 = state.copy$default$3();
        ExitStatus x$15 = state.copy$default$5();
        return state.copy(x$12, x$13, x$14, x$10, x$15, (Logger)x$11);
    }

    private static final State doCompile$1(State state, ReporterConfig reporterConfig$1, Project project$1) {
        return CompileTasks$.MODULE$.compile(state, project$1, reporterConfig$1, CompileTasks$.MODULE$.compile$default$4()).mergeStatus(ExitStatus$.MODULE$.Ok());
    }

    private final State runCompile$1(Project project, Commands.Compile cmd$1, State state$5, ReporterConfig reporterConfig$1) {
        State state2;
        if (cmd$1.incremental()) {
            state2 = !cmd$1.watch() ? Interpreter$.doCompile$1(state$5, reporterConfig$1, project) : this.watch(project, state$5, (Function1<State, State>)(Function1 & Serializable & scala.Serializable)state -> Interpreter$.doCompile$1(state, reporterConfig$1, project));
        } else {
            State newState = CompileTasks$.MODULE$.clean(state$5, state$5.build().projects());
            state2 = !cmd$1.watch() ? Interpreter$.doCompile$1(newState, reporterConfig$1, project) : this.watch(project, newState, (Function1<State, State>)(Function1 & Serializable & scala.Serializable)state -> Interpreter$.doCompile$1(state, reporterConfig$1, project));
        }
        return state2;
    }

    public static final /* synthetic */ void $anonfun$showProjects$2(State state$9, String projectName) {
        state$9.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" * ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{projectName})));
    }

    private static final State runConsole$1(Project project, Commands.Console cmd$2, State state$7, ReporterConfig reporterConfig$2) {
        return CompileTasks$.MODULE$.console(state$7, project, reporterConfig$2, cmd$2.excludeRoot());
    }

    private static final State run$1(State state, Commands.Test cmd$3, Project project$2) {
        ReporterConfig reporter = ReporterConfig$.MODULE$.getDefault(cmd$3.scalacstyle());
        State state1 = CompileTasks$.MODULE$.compile(state, project$2, reporter, CompileTasks$.MODULE$.compile$default$4());
        return TestTasks$.MODULE$.test(state1, project$2, cmd$3.aggregate());
    }

    private final State compileAndTest$1(State state2, Project project, Commands.Test cmd$3) {
        return !cmd$3.watch() ? Interpreter$.run$1(state2, cmd$3, project) : this.watch(project, state2, (Function1<State, State>)(Function1 & Serializable & scala.Serializable)state -> Interpreter$.run$1(state, cmd$3, project));
    }

    private Interpreter$() {
        MODULE$ = this;
        this.line = System.lineSeparator();
    }
}

