/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine;

import bloop.Project;
import bloop.cli.CliOptions;
import bloop.cli.Commands;
import bloop.cli.ExitStatus;
import bloop.cli.ExitStatus$;
import bloop.engine.Action;
import bloop.engine.Build;
import bloop.engine.Dag$;
import bloop.engine.ExecutionContext$;
import bloop.engine.Exit;
import bloop.engine.Print;
import bloop.engine.Run;
import bloop.engine.State;
import bloop.engine.State$;
import bloop.engine.tasks.Tasks$;
import bloop.internal.build.BuildInfo$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.SourceWatcher;
import bloop.io.Timer$;
import bloop.reporter.ReporterConfig;
import bloop.reporter.ReporterConfig$;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class Interpreter$ {
    public static Interpreter$ MODULE$;
    private final String line;

    static {
        new Interpreter$();
    }

    public State execute(Action action, State state) {
        State state2;
        block19: {
            Action action2;
            while (true) {
                boolean bl = false;
                Exit exit = null;
                boolean bl2 = false;
                Run run = null;
                action2 = action;
                if (action2 instanceof Exit) {
                    bl = true;
                    exit = (Exit)action2;
                    ExitStatus exitStatus = exit.exitStatus();
                    if (state.status().isOk()) {
                        state2 = state.mergeStatus(exitStatus);
                        break block19;
                    }
                }
                if (bl) {
                    state2 = state;
                    break block19;
                }
                if (action2 instanceof Print) {
                    Print print = (Print)action2;
                    String msg = print.msg();
                    Action next = print.next();
                    state.logger().info(msg);
                    action = next;
                    continue;
                }
                if (action2 instanceof Run) {
                    bl2 = true;
                    run = (Run)action2;
                    Commands.Command command = run.command();
                    Action next = run.next();
                    if (command instanceof Commands.About) {
                        Commands.About about = (Commands.About)command;
                        CliOptions cliOptions = about.cliOptions();
                        ExitStatus status = (ExitStatus)Interpreter$.logAndTime$1(state, cliOptions, (Function0 & Serializable & scala.Serializable)() -> MODULE$.printAbout(state));
                        state = state.mergeStatus(status);
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd = run.command();
                    Action next = run.next();
                    if (cmd instanceof Commands.Clean) {
                        Commands.Clean clean = (Commands.Clean)cmd;
                        state = (State)Interpreter$.logAndTime$1(state, clean.cliOptions(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.clean(clean, state));
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd = run.command();
                    Action next = run.next();
                    if (cmd instanceof Commands.Compile) {
                        Commands.Compile compile = (Commands.Compile)cmd;
                        state = (State)Interpreter$.logAndTime$1(state, compile.cliOptions(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.compile(compile, state));
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd = run.command();
                    Action next = run.next();
                    if (cmd instanceof Commands.Console) {
                        Commands.Console console = (Commands.Console)cmd;
                        state = (State)Interpreter$.logAndTime$1(state, console.cliOptions(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.console(console, state));
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd = run.command();
                    Action next = run.next();
                    if (cmd instanceof Commands.Projects) {
                        Commands.Projects projects = (Commands.Projects)cmd;
                        state = (State)Interpreter$.logAndTime$1(state, projects.cliOptions(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.showProjects(projects, state));
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd = run.command();
                    Action next = run.next();
                    if (cmd instanceof Commands.Test) {
                        Commands.Test test = (Commands.Test)cmd;
                        state = (State)Interpreter$.logAndTime$1(state, test.cliOptions(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.test(test, state));
                        action = next;
                        continue;
                    }
                }
                if (bl2) {
                    Commands.Command cmd = run.command();
                    Action next = run.next();
                    if (cmd instanceof Commands.Run) {
                        Commands.Run run2 = (Commands.Run)cmd;
                        state = (State)Interpreter$.logAndTime$1(state, run2.cliOptions(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.run(run2, state));
                        action = next;
                        continue;
                    }
                }
                if (!bl2) break;
                Commands.Command cmd = run.command();
                Action next = run.next();
                if (!(cmd instanceof Commands.Configure)) break;
                Commands.Configure configure = (Commands.Configure)cmd;
                state = (State)Interpreter$.logAndTime$1(state, configure.cliOptions(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.configure(configure, state));
                action = next;
            }
            throw new MatchError((Object)action2);
        }
        return state2;
    }

    private final String t() {
        return "    ";
    }

    private final String line() {
        return this.line;
    }

    private ExitStatus printAbout(State state) {
        String bloopName = BuildInfo$.MODULE$.name();
        String bloopVersion = BuildInfo$.MODULE$.version();
        String scalaVersion = BuildInfo$.MODULE$.scalaVersion();
        String zincVersion = BuildInfo$.MODULE$.zincVersion();
        String developers = BuildInfo$.MODULE$.developers().mkString(", ");
        String header = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|", "   _____            __         ______           __\n          |", "  / ___/_________ _/ /___ _   / ____/__  ____  / /____  _____\n          |", "  \\\\__ \\\\/ ___/ __ `/ / __ `/  / /   / _ \\\\/ __ \\\\/ __/ _ \\\\/ ___/\n          |", " ___/ / /__/ /_/ / / /_/ /  / /___/ /__/ / / / /_/ /__/ /\n          |", "/____/\\\\___/\\\\__,_/_/\\\\__,_/   \\\\____/\\\\___/_/ /_/\\\\__/\\\\___/_/\n          |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"    ", "    ", "    ", "    ", "    "})))).stripMargin();
        String versions = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                      |", "", " version    `", "`\n                      |", "Zinc version     `", "`\n                      |", "Scala version    `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"    ", new StringOps(Predef$.MODULE$.augmentString(bloopName)).capitalize(), bloopVersion, "    ", zincVersion, "    ", scalaVersion})))).stripMargin();
        state.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{header, this.line()})));
        state.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", " is made with love at the Scala Center <3", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"    ", bloopName, this.line()})));
        state.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{versions, this.line(), this.line()})));
        state.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "It is maintained by ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"    ", developers})));
        return ExitStatus$.MODULE$.Ok();
    }

    private State watch(Project project, State state, Function1<State, State> f) {
        List<Project> reachable = Dag$.MODULE$.dfs(state.build().getDagFor(project));
        Iterator allSourceDirs = reachable.iterator().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Predef$.MODULE$.genericArrayOps((Object)x$1.sourceDirectories()).toList()).map((Function1 & Serializable & scala.Serializable)x$2 -> ((AbsolutePath)x$2).underlying());
        SourceWatcher watcher = new SourceWatcher((Seq<Path>)allSourceDirs.toList(), state.logger());
        return watcher.watch((State)f.apply((Object)state), f);
    }

    private State compile(Commands.Compile cmd, State state) {
        State state2;
        ReporterConfig reporterConfig = ReporterConfig$.MODULE$.toFormat(cmd.reporter());
        Option<Project> option = state.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            state2 = this.runCompile$1(project, cmd, state, reporterConfig);
        } else if (None$.MODULE$.equals(option)) {
            String string = cmd.project();
            state2 = this.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state);
        } else {
            throw new MatchError(option);
        }
        return state2;
    }

    private State showProjects(Commands.Projects cmd, State state) {
        if (cmd.dotGraph()) {
            String contents = Dag$.MODULE$.toDotGraph(state.build().dags());
            state.logger().info(contents);
        } else {
            String configDirectory = AbsolutePath$.MODULE$.syntax$extension(state.build().origin());
            state.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Projects loaded from '", "':"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configDirectory})));
            ((List)((SeqLike)state.build().projects().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)projectName -> {
                Interpreter$.$anonfun$showProjects$2(state, projectName);
                return BoxedUnit.UNIT;
            });
        }
        return state.mergeStatus(ExitStatus$.MODULE$.Ok());
    }

    private State console(Commands.Console cmd, State state) {
        State state2;
        ReporterConfig reporterConfig = ReporterConfig$.MODULE$.toFormat(cmd.reporter());
        Option<Project> option = state.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            state2 = Interpreter$.runConsole$1(project, cmd, state, reporterConfig).mergeStatus(ExitStatus$.MODULE$.Ok());
        } else if (None$.MODULE$.equals(option)) {
            String string = cmd.project();
            state2 = this.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state);
        } else {
            throw new MatchError(option);
        }
        return state2;
    }

    private State test(Commands.Test cmd, State state) {
        State state2;
        Option<Project> projectToTest = Tasks$.MODULE$.pickTestProject(cmd.project(), state);
        Option<Project> option = projectToTest;
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            state2 = this.compileAndTest$1(state, project, cmd);
        } else if (None$.MODULE$.equals(option)) {
            String string = cmd.project();
            state2 = this.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state);
        } else {
            throw new MatchError(option);
        }
        return state2;
    }

    private Tuple2<List<Project>, List<String>> lookupProjects(List<String> names, State state) {
        Build build = state.build();
        Tuple2 result = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Nil$.MODULE$), (Object)Nil$.MODULE$);
        return (Tuple2)names.foldLeft((Object)result, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = new Tuple2(x0$1, x1$1);
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Tuple2 tuple23 = (Tuple2)tuple22._1();
            String name = (String)tuple22._2();
            if (tuple23 == null) throw new MatchError((Object)tuple22);
            List projects = (List)tuple23._1();
            List missing = (List)tuple23._2();
            Option<Project> option = build.getProjectFor(name);
            if (option instanceof Some) {
                Project project;
                Some some = (Some)option;
                Project project2 = project = (Project)some.value();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)projects.$colon$colon((Object)project2)), (Object)missing);
                return tuple2;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                String string = name;
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)projects), (Object)missing.$colon$colon((Object)string));
            }
            return tuple2;
        });
    }

    private State configure(Commands.Configure cmd, State state) {
        return cmd.threads() != ExecutionContext$.MODULE$.executor().getCorePoolSize() ? State$.MODULE$.setCores(state, cmd.threads()) : state;
    }

    private State clean(Commands.Clean cmd, State state) {
        Tuple2<List<Project>, List<String>> tuple2 = this.lookupProjects(cmd.projects(), state);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List projects = (List)tuple2._1();
        List missing = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)projects, (Object)missing);
        Tuple2 tuple23 = tuple22;
        List projects2 = (List)tuple23._1();
        List missing2 = (List)tuple23._2();
        return missing2.isEmpty() ? Tasks$.MODULE$.clean(state, (List<Project>)projects2).mergeStatus(ExitStatus$.MODULE$.Ok()) : this.reportMissing((List<String>)missing2, state);
    }

    private State run(Commands.Run cmd, State state) {
        State state2;
        ReporterConfig reporter = ReporterConfig$.MODULE$.toFormat(cmd.reporter());
        Option<Project> option = state.build().getProjectFor(cmd.project());
        if (option instanceof Some) {
            Some some = (Some)option;
            Project project = (Project)some.value();
            state2 = this.run$2(project, cmd, state, reporter);
        } else if (None$.MODULE$.equals(option)) {
            String string = cmd.project();
            state2 = this.reportMissing((List<String>)Nil$.MODULE$.$colon$colon((Object)string), state);
        } else {
            throw new MatchError(option);
        }
        return state2;
    }

    private State reportMissing(List<String> projectNames, State state) {
        String projects = projectNames.mkString("'", "', '", "'");
        String configDirectory = AbsolutePath$.MODULE$.syntax$extension(state.build().origin());
        state.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No projects named ", " found in '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{projects, configDirectory})));
        state.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Use the `projects` command to list existing projects."})).s((Seq)Nil$.MODULE$));
        return state.mergeStatus(ExitStatus$.MODULE$.InvalidCommandLineOption());
    }

    private static final Object logAndTime$1(State state, CliOptions cliOptions, Function0 action) {
        return state.logger().verboseIf(cliOptions.verbose(), (Function0 & Serializable & scala.Serializable)() -> Timer$.MODULE$.timed(state.logger(), action));
    }

    private static final State doCompile$1(State state, ReporterConfig reporterConfig$1, Project project$1) {
        return Tasks$.MODULE$.compile(state, project$1, reporterConfig$1, Tasks$.MODULE$.compile$default$4()).mergeStatus(ExitStatus$.MODULE$.Ok());
    }

    private final State runCompile$1(Project project, Commands.Compile cmd$1, State state$3, ReporterConfig reporterConfig$1) {
        State state2;
        if (cmd$1.incremental()) {
            state2 = !cmd$1.watch() ? Interpreter$.doCompile$1(state$3, reporterConfig$1, project) : this.watch(project, state$3, (Function1<State, State>)(Function1 & Serializable & scala.Serializable)state -> Interpreter$.doCompile$1(state, reporterConfig$1, project));
        } else {
            State newState = Tasks$.MODULE$.clean(state$3, state$3.build().projects());
            state2 = !cmd$1.watch() ? Interpreter$.doCompile$1(newState, reporterConfig$1, project) : this.watch(project, newState, (Function1<State, State>)(Function1 & Serializable & scala.Serializable)state -> Interpreter$.doCompile$1(state, reporterConfig$1, project));
        }
        return state2;
    }

    public static final /* synthetic */ void $anonfun$showProjects$2(State state$5, String projectName) {
        state$5.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" * ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{projectName})));
    }

    private static final State runConsole$1(Project project, Commands.Console cmd$2, State state$4, ReporterConfig reporterConfig$2) {
        return Tasks$.MODULE$.console(state$4, project, reporterConfig$2, cmd$2.excludeRoot());
    }

    private static final State run$1(State state, Commands.Test cmd$3, Project project$2) {
        ReporterConfig reporter = ReporterConfig$.MODULE$.toFormat(cmd$3.reporter());
        State state1 = Tasks$.MODULE$.compile(state, project$2, reporter, Tasks$.MODULE$.compile$default$4());
        return Tasks$.MODULE$.test(state1, project$2, cmd$3.aggregate());
    }

    private final State compileAndTest$1(State state2, Project project, Commands.Test cmd$3) {
        return !cmd$3.watch() ? Interpreter$.run$1(state2, cmd$3, project) : this.watch(project, state2, (Function1<State, State>)(Function1 & Serializable & scala.Serializable)state -> Interpreter$.run$1(state, cmd$3, project));
    }

    private static final Option getMainClass$1(State state, Project project) {
        Some some;
        String[] stringArray = Tasks$.MODULE$.findMainClasses(state, project);
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(0) == 0) {
            state.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No main classes found in project '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project.name()})));
            some = None$.MODULE$;
        } else {
            Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0) {
                String main = (String)((SeqLike)option2.get()).apply(0);
                some = new Some((Object)main);
            } else {
                String eol = System.lineSeparator();
                String message = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Several main classes were found, specify which one:\n                           |", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).mkString(" * ", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " * "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eol})), "")})))).stripMargin();
                state.logger().error(message);
                some = None$.MODULE$;
            }
        }
        return some;
    }

    private static final State doRun$1(State state, Commands.Run cmd$4, ReporterConfig reporter$1, Project project$3) {
        State compiledState = Tasks$.MODULE$.compile(state, project$3, reporter$1, Tasks$.MODULE$.compile$default$4());
        Option selectedMainClass = cmd$4.main().orElse((Function0 & Serializable & scala.Serializable)() -> Interpreter$.getMainClass$1(compiledState, project$3));
        return (State)selectedMainClass.map((Function1 & Serializable & scala.Serializable)main -> {
            String[] args = (String[])cmd$4.args().toArray(ClassTag$.MODULE$.apply(String.class));
            return Tasks$.MODULE$.run(compiledState, project$3, (String)main, args);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> compiledState.mergeStatus(ExitStatus$.MODULE$.UnexpectedError()));
    }

    private final State run$2(Project project, Commands.Run cmd$4, State state$6, ReporterConfig reporter$1) {
        return !cmd$4.watch() ? Interpreter$.doRun$1(state$6, cmd$4, reporter$1, project) : this.watch(project, state$6, (Function1<State, State>)(Function1 & Serializable & scala.Serializable)state -> Interpreter$.doRun$1(state, cmd$4, reporter$1, project));
    }

    private Interpreter$() {
        MODULE$ = this;
        this.line = System.lineSeparator();
    }
}

