/*
 * Decompiled with CFR 0.152.
 */
package bloop.exec;

import bloop.exec.IdentifiedThread;
import bloop.exec.IdentifiedThread$;
import bloop.exec.MultiplexedStreams;
import bloop.logging.Logger;
import bloop.logging.ProcessLogger$;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class MultiplexedStreams$ {
    public static MultiplexedStreams$ MODULE$;
    private final ConcurrentHashMap<UUID, MultiplexedStreams.Streams> streams;
    private final MultiplexedStreams.Streams defaultStreams;
    private final ExecutorService executor;
    private final PrintStream stdout;
    private final PrintStream stderr;

    static {
        new MultiplexedStreams$();
    }

    private ConcurrentHashMap<UUID, MultiplexedStreams.Streams> streams() {
        return this.streams;
    }

    private MultiplexedStreams.Streams defaultStreams() {
        return this.defaultStreams;
    }

    private ExecutorService executor() {
        return this.executor;
    }

    public PrintStream stdout() {
        return this.stdout;
    }

    public PrintStream stderr() {
        return this.stderr;
    }

    public <T> Option<T> withLoggerAsStreams(Logger logger, Function0<T> op) {
        ObjectRef result = ObjectRef.create((Object)None$.MODULE$);
        IdentifiedThread thread = new IdentifiedThread(logger, op, result){
            private final Logger logger$1;
            private final Function0 op$1;
            private final ObjectRef result$1;

            public void work() {
                Some some;
                MultiplexedStreams$.MODULE$.bloop$exec$MultiplexedStreams$$registerStreams(this.id(), this.logger$1);
                try {
                    some = new Some(this.op$1.apply());
                }
                finally {
                    MultiplexedStreams$.MODULE$.bloop$exec$MultiplexedStreams$$flushStreams();
                    MultiplexedStreams$.MODULE$.bloop$exec$MultiplexedStreams$$removeStreams(this.id());
                }
                this.result$1.elem = some;
            }
            {
                this.logger$1 = logger$1;
                this.op$1 = op$1;
                this.result$1 = result$1;
            }
        };
        Future<?> future = this.executor().submit(thread);
        try {
            future.get();
        }
        catch (ExecutionException ex) {
            throw ex.getCause();
        }
        return (Option)result.elem;
    }

    private void initialize() {
        System.setOut(this.stdout());
        System.setErr(this.stderr());
    }

    public void bloop$exec$MultiplexedStreams$$registerStreams(UUID id, Logger logger) {
        PrintStream out = ProcessLogger$.MODULE$.toPrintStream((Function1 & Serializable & scala.Serializable)x$1 -> {
            logger.info(x$1);
            return BoxedUnit.UNIT;
        });
        PrintStream err = ProcessLogger$.MODULE$.toPrintStream((Function1 & Serializable & scala.Serializable)x$1 -> {
            logger.error(x$1);
            return BoxedUnit.UNIT;
        });
        MultiplexedStreams.Streams _ = this.streams().put(id, new MultiplexedStreams.Streams(out, err));
    }

    public void bloop$exec$MultiplexedStreams$$removeStreams(UUID id) {
        MultiplexedStreams.Streams streams = this.streams().remove(id);
    }

    private MultiplexedStreams.Streams getStreams() {
        return (MultiplexedStreams.Streams)Option$.MODULE$.apply(IdentifiedThread$.MODULE$.id().get()).flatMap((Function1 & Serializable & scala.Serializable)id -> Option$.MODULE$.apply((Object)MODULE$.streams().get(id))).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.defaultStreams());
    }

    public void bloop$exec$MultiplexedStreams$$flushStreams() {
        MultiplexedStreams.Streams streams = this.getStreams();
        if (streams == null) {
            throw new MatchError((Object)streams);
        }
        PrintStream out = streams.out();
        PrintStream err = streams.err();
        Tuple2 tuple2 = new Tuple2((Object)out, (Object)err);
        Tuple2 tuple22 = tuple2;
        PrintStream out2 = (PrintStream)tuple22._1();
        PrintStream err2 = (PrintStream)tuple22._2();
        out2.flush();
        err2.flush();
    }

    public static final /* synthetic */ void bloop$exec$MultiplexedStreams$$$anonfun$stdout$1(int b) {
        MODULE$.getStreams().out().write(b);
    }

    public static final /* synthetic */ void bloop$exec$MultiplexedStreams$$$anonfun$stderr$1(int b) {
        MODULE$.getStreams().err().write(b);
    }

    private MultiplexedStreams$() {
        MODULE$ = this;
        this.streams = new ConcurrentHashMap();
        this.defaultStreams = new MultiplexedStreams.Streams(System.out, System.err);
        this.executor = Executors.newCachedThreadPool();
        OutputStream stream = new OutputStream(){

            public final void write(int x$1) {
                MultiplexedStreams$.bloop$exec$MultiplexedStreams$$$anonfun$stdout$1(x$1);
            }
        };
        this.stdout = new PrintStream(stream);
        OutputStream stream2 = new OutputStream(){

            public final void write(int x$1) {
                MultiplexedStreams$.bloop$exec$MultiplexedStreams$$$anonfun$stderr$1(x$1);
            }
        };
        this.stderr = new PrintStream(stream2);
        this.initialize();
    }
}

