/*
 * Decompiled with CFR 0.152.
 */
package bloop.data;

import bloop.ScalaInstance;
import bloop.ScalaInstance$;
import bloop.config.Config;
import bloop.config.ConfigEncoderDecoders$;
import bloop.data.Origin;
import bloop.data.Project;
import bloop.engine.tasks.ScalaJsToolchain;
import bloop.engine.tasks.ScalaJsToolchain$;
import bloop.engine.tasks.ScalaNativeToolchain;
import bloop.engine.tasks.ScalaNativeToolchain$;
import bloop.exec.JavaEnv;
import bloop.exec.JavaEnv$;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.logging.Logger;
import io.circe.DecodingFailure;
import io.circe.Json;
import io.circe.ParsingFailure;
import io.circe.parser.package$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple21;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scalaz.Cord;
import scalaz.Show;
import scalaz.syntax.ShowSyntax;

public final class Project$
implements scala.Serializable {
    public static Project$ MODULE$;
    private final Show<Project> ps;

    static {
        new Project$();
    }

    public final Show<Project> ps() {
        return this.ps;
    }

    public Project fromConfig(Config.File file, Origin origin, Logger logger) {
        JavaEnv javaEnv;
        Config.Platform$.Jvm jvm;
        Config.JvmConfig jvmConfig;
        Some some;
        Config.Platform platform2;
        Config.Project project = file.project();
        Option scala2 = project.scala();
        Option instance = scala2.flatMap((Function1 & Serializable & scala.Serializable)scala -> {
            None$ none$;
            if (scala.jars().isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                List scalaJars = (List)scala.jars().map((Function1 & Serializable & scala.Serializable)path -> new AbsolutePath(AbsolutePath$.MODULE$.apply(path, AbsolutePath$.MODULE$.workingDirectory())), List$.MODULE$.canBuildFrom());
                none$ = new Some((Object)ScalaInstance$.MODULE$.apply(scala.organization(), scala.name(), scala.version(), (Seq)scalaJars, logger));
            }
            return none$;
        }).orElse((Function0 & Serializable & scala.Serializable)() -> ScalaInstance$.MODULE$.scalaInstanceFromBloop(logger));
        Config.CompileSetup setup = (Config.CompileSetup)project.scala().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.setup()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Config.CompileSetup$.MODULE$.empty());
        Option jsToolchain = project.platform().flatMap((Function1 & Serializable & scala.Serializable)platform -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (ScalaJsToolchain)ScalaJsToolchain$.MODULE$.resolveToolchain((Config.Platform)platform, logger)).toOption());
        Option nativeToolchain = project.platform().flatMap((Function1 & Serializable & scala.Serializable)platform -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (ScalaNativeToolchain)ScalaNativeToolchain$.MODULE$.resolveToolchain((Config.Platform)platform, logger)).toOption());
        Option option = project.platform();
        if (option instanceof Some && (platform2 = (Config.Platform)(some = (Some)option).value()) instanceof Config.Platform$.Jvm && (jvmConfig = (jvm = (Config.Platform$.Jvm)platform2).config()) != null) {
            Option home = jvmConfig.home();
            List jvmOptions = jvmConfig.options();
            Path jvmHome = ((AbsolutePath)home.map((Function1 & Serializable & scala.Serializable)path -> new AbsolutePath(AbsolutePath$.MODULE$.apply(path, AbsolutePath$.MODULE$.workingDirectory()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new AbsolutePath(JavaEnv$.MODULE$.DefaultJavaHome()))).underlying();
            javaEnv = new JavaEnv(jvmHome, (String[])jvmOptions.toArray(ClassTag$.MODULE$.apply(String.class)));
        } else {
            javaEnv = JavaEnv$.MODULE$.default();
        }
        JavaEnv javaEnv2 = javaEnv;
        Option sbt = project.sbt();
        Option resolution = project.resolution();
        Path out = AbsolutePath$.MODULE$.apply(project.out(), AbsolutePath$.MODULE$.workingDirectory());
        Path analysisOut = ((AbsolutePath)scala2.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.analysis().map((Function1 & Serializable & scala.Serializable)path -> new AbsolutePath(AbsolutePath$.MODULE$.apply(path, AbsolutePath$.MODULE$.workingDirectory())))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new AbsolutePath(AbsolutePath$.MODULE$.resolve$extension1(out, Config.Project$.MODULE$.analysisFileName(project.name()))))).underlying();
        return new Project(project.name(), AbsolutePath$.MODULE$.apply(project.directory(), AbsolutePath$.MODULE$.workingDirectory()), (List<String>)project.dependencies(), (Option<ScalaInstance>)instance, (List<Path>)((List)project.classpath().map((Function1 & Serializable & scala.Serializable)path -> new AbsolutePath(AbsolutePath$.MODULE$.apply(path, AbsolutePath$.MODULE$.workingDirectory())), List$.MODULE$.canBuildFrom())), setup, AbsolutePath$.MODULE$.apply(project.classesDir(), AbsolutePath$.MODULE$.workingDirectory()), (List<String>)((List)scala2.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.options()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)), (List<String>)((List)project.java().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.options()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)), (List<Path>)((List)project.sources().map((Function1 & Serializable & scala.Serializable)path -> new AbsolutePath(AbsolutePath$.MODULE$.apply(path, AbsolutePath$.MODULE$.workingDirectory())), List$.MODULE$.canBuildFrom())), (List<Config.TestFramework>)((List)project.test().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.frameworks()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)), (Config.TestOptions)project.test().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.options()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Config.TestOptions$.MODULE$.empty()), javaEnv2, AbsolutePath$.MODULE$.apply(project.out(), AbsolutePath$.MODULE$.workingDirectory()), analysisOut, (Config.Platform)project.platform().getOrElse((Function0 & Serializable & scala.Serializable)() -> Config.Platform$.MODULE$.default()), (Option<ScalaJsToolchain>)jsToolchain, (Option<ScalaNativeToolchain>)nativeToolchain, (Option<Config.Sbt>)sbt, (Option<Config.Resolution>)resolution, origin);
    }

    public Project fromBytesAndOrigin(byte[] bytes, Origin origin, Logger logger) {
        Project project;
        logger.debug(new StringBuilder(23).append("Loading project from '").append(new AbsolutePath(origin.path())).append("'").toString());
        String contents = new String(bytes, StandardCharsets.UTF_8);
        Either either = package$.MODULE$.parse(contents);
        if (either instanceof Left) {
            Left left = (Left)either;
            ParsingFailure failure = (ParsingFailure)left.value();
            throw failure;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Json json = (Json)right.value();
            Either either2 = ConfigEncoderDecoders$.MODULE$.allDecoder().decodeJson(json);
            if (!(either2 instanceof Right)) {
                if (either2 instanceof Left) {
                    Left left = (Left)either2;
                    DecodingFailure failure = (DecodingFailure)left.value();
                    throw failure;
                }
                throw new MatchError((Object)either2);
            }
            Right right2 = (Right)either2;
            Config.File file = (Config.File)right2.value();
            project = this.fromConfig(file, origin, logger);
        } else {
            throw new MatchError((Object)either);
        }
        Project project2 = project;
        return project2;
    }

    public Project apply(String name, Path baseDirectory, List<String> dependencies, Option<ScalaInstance> scalaInstance, List<Path> rawClasspath, Config.CompileSetup compileSetup, Path classesDir, List<String> scalacOptions, List<String> javacOptions, List<Path> sources, List<Config.TestFramework> testFrameworks, Config.TestOptions testOptions, JavaEnv javaEnv, Path out, Path analysisOut, Config.Platform platform, Option<ScalaJsToolchain> jsToolchain, Option<ScalaNativeToolchain> nativeToolchain, Option<Config.Sbt> sbt, Option<Config.Resolution> resolution, Origin origin) {
        return new Project(name, baseDirectory, dependencies, scalaInstance, rawClasspath, compileSetup, classesDir, scalacOptions, javacOptions, sources, testFrameworks, testOptions, javaEnv, out, analysisOut, platform, jsToolchain, nativeToolchain, sbt, resolution, origin);
    }

    public Option<Tuple21<String, Path, List<String>, Option<ScalaInstance>, List<Path>, Config.CompileSetup, Path, List<String>, List<String>, List<Path>, List<Config.TestFramework>, Config.TestOptions, JavaEnv, Path, Path, Config.Platform, Option<ScalaJsToolchain>, Option<ScalaNativeToolchain>, Option<Config.Sbt>, Option<Config.Resolution>, Origin>> unapply(Project x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple21((Object)x$0.name(), (Object)new AbsolutePath(x$0.baseDirectory()), x$0.dependencies(), x$0.scalaInstance(), x$0.rawClasspath(), (Object)x$0.compileSetup(), (Object)new AbsolutePath(x$0.classesDir()), x$0.scalacOptions(), x$0.javacOptions(), x$0.sources(), x$0.testFrameworks(), (Object)x$0.testOptions(), (Object)x$0.javaEnv(), (Object)new AbsolutePath(x$0.out()), (Object)new AbsolutePath(x$0.analysisOut()), (Object)x$0.platform(), x$0.jsToolchain(), x$0.nativeToolchain(), x$0.sbt(), x$0.resolution(), (Object)x$0.origin()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Project$() {
        MODULE$ = this;
        this.ps = new Show<Project>(){
            private final ShowSyntax<Project> showSyntax;

            public Cord show(Object f) {
                return Show.show$((Show)this, (Object)f);
            }

            public ShowSyntax<Project> showSyntax() {
                return this.showSyntax;
            }

            public void scalaz$Show$_setter_$showSyntax_$eq(ShowSyntax<Project> x$1) {
                this.showSyntax = x$1;
            }

            public String shows(Project f) {
                return f.name();
            }
            {
                Show.$init$((Show)this);
            }
        };
    }
}

