/*
 * Decompiled with CFR 0.152.
 */
package bloop.scalajs.jsenv;

import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import bloop.scalajs.jsenv.NodeJSConfig;
import bloop.scalajs.jsenv.NodeJsHandler;
import com.google.common.jimfs.Jimfs;
import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessBuilder;
import com.zaxxer.nuprocess.NuProcessHandler;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBoolean$;
import org.scalajs.jsenv.ExternalJSRun$;
import org.scalajs.jsenv.Input;
import org.scalajs.jsenv.JSRun;
import org.scalajs.jsenv.JSUtils$;
import org.scalajs.jsenv.RunConfig;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class NodeJSEnv$ {
    public static NodeJSEnv$ MODULE$;
    private FileSystem fs;
    private RunConfig.Validator bloop$scalajs$jsenv$NodeJSEnv$$validator;
    private Path bloop$scalajs$jsenv$NodeJSEnv$$installSourceMapIfAvailable;
    private Path bloop$scalajs$jsenv$NodeJSEnv$$installSourceMap;
    private final DebugFilter debugFilter;
    private final Regex tmpSuffixRE;
    private volatile byte bitmap$0;

    static {
        new NodeJSEnv$();
    }

    private FileSystem fs$lzycompute() {
        NodeJSEnv$ nodeJSEnv$ = this;
        synchronized (nodeJSEnv$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.fs = Jimfs.newFileSystem();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.fs;
    }

    private FileSystem fs() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.fs$lzycompute() : this.fs;
    }

    public DebugFilter debugFilter() {
        return this.debugFilter;
    }

    private RunConfig.Validator validator$lzycompute() {
        NodeJSEnv$ nodeJSEnv$ = this;
        synchronized (nodeJSEnv$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.bloop$scalajs$jsenv$NodeJSEnv$$validator = ExternalJSRun$.MODULE$.supports(RunConfig.Validator$.MODULE$.apply());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.bloop$scalajs$jsenv$NodeJSEnv$$validator;
    }

    public RunConfig.Validator bloop$scalajs$jsenv$NodeJSEnv$$validator() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.validator$lzycompute() : this.bloop$scalajs$jsenv$NodeJSEnv$$validator;
    }

    private Path installSourceMapIfAvailable$lzycompute() {
        NodeJSEnv$ nodeJSEnv$ = this;
        synchronized (nodeJSEnv$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.bloop$scalajs$jsenv$NodeJSEnv$$installSourceMapIfAvailable = Files.write(this.fs().getPath("optionalSourceMapSupport.js", new String[0]), new StringOps(Predef$.MODULE$.augmentString("\n        |try {\n        |  require('source-map-support').install();\n        |} catch (e) {\n        |};\n        ")).stripMargin().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.bloop$scalajs$jsenv$NodeJSEnv$$installSourceMapIfAvailable;
    }

    public Path bloop$scalajs$jsenv$NodeJSEnv$$installSourceMapIfAvailable() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.installSourceMapIfAvailable$lzycompute() : this.bloop$scalajs$jsenv$NodeJSEnv$$installSourceMapIfAvailable;
    }

    private Path installSourceMap$lzycompute() {
        NodeJSEnv$ nodeJSEnv$ = this;
        synchronized (nodeJSEnv$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.bloop$scalajs$jsenv$NodeJSEnv$$installSourceMap = Files.write(this.fs().getPath("sourceMapSupport.js", new String[0]), "require('source-map-support').install();".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.bloop$scalajs$jsenv$NodeJSEnv$$installSourceMap;
    }

    public Path bloop$scalajs$jsenv$NodeJSEnv$$installSourceMap() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.installSourceMap$lzycompute() : this.bloop$scalajs$jsenv$NodeJSEnv$$installSourceMap;
    }

    public void write(Seq<Input> input, ByteBuffer out) {
        try {
            if (!input.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)NodeJSEnv$.$anonfun$write$1(x$4)))) {
                input.foreach((Function1 & Serializable & scala.Serializable)item -> {
                    NodeJSEnv$.println$1(new StringBuilder(1).append(this.execInputExpr$1(item)).append(";").toString(), out);
                    return BoxedUnit.UNIT;
                });
            } else {
                String importChain = (String)input.foldLeft((Object)"Promise.resolve()", (Function2 & Serializable & scala.Serializable)(prev, item) -> new StringBuilder(10).append((String)prev).append(".\n  then(").append(this.execInputExpr$1((Input)item)).append(")").toString());
                String importerFileContent = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(124).append("\n             |").append(importChain).append(".catch(e => {\n             |  console.error(e);\n             |  process.exit(1);\n             |});\n          ").toString())).stripMargin();
                File f = this.createTmpFile("importer.js");
                Files.write(f.toPath(), importerFileContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                NodeJSEnv$.println$1(new StringBuilder(12).append("require(\"").append(JSUtils$.MODULE$.escapeJS(f.getAbsolutePath())).append("\");").toString(), out);
            }
        }
        finally {
            out.flip();
        }
    }

    /*
     * WARNING - void declaration
     */
    private File toFile(Path path) {
        File file;
        try {
            file = path.toFile();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            void var2_2;
            File f = this.createTmpFile(((Object)path).toString());
            Files.copy(path, f.toPath(), StandardCopyOption.REPLACE_EXISTING);
            file = var2_2;
        }
        return file;
    }

    private Regex tmpSuffixRE() {
        return this.tmpSuffixRE;
    }

    /*
     * WARNING - void declaration
     */
    private File createTmpFile(String path) {
        void var3_3;
        String suffix = (String)this.tmpSuffixRE().findFirstIn((CharSequence)path).orNull(Predef$.MODULE$.$conforms());
        File f = File.createTempFile("tmp-", suffix);
        f.deleteOnExit();
        return var3_3;
    }

    public JSRun internalStart(Logger logger, NodeJSConfig config, scala.collection.immutable.Map<String, String> env, Function1<ByteBuffer, BoxedUnit> write, RunConfig runConfig) {
        String string = config.executable();
        List command = config.args().$colon$colon((Object)string);
        logger.debug(new StringBuilder(20).append("Starting process ").append(command.mkString(" ")).append("...").toString(), this.debugFilter());
        logger.debug(new StringBuilder(27).append("Current working directory: ").append(config.cwd()).toString(), this.debugFilter());
        logger.debug(new StringBuilder(21).append("Current environment: ").append(config.env()).toString(), this.debugFilter());
        Promise executionPromise = Promise$.MODULE$.apply();
        NuProcessBuilder builder = new NuProcessBuilder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)command).asJava(), (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(env).asJava());
        NodeJsHandler handler = new NodeJsHandler(logger, (Promise<BoxedUnit>)executionPromise, write);
        builder.setProcessListener((NuProcessHandler)handler);
        config.cwd().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            builder.setCwd(x$1);
            return BoxedUnit.UNIT;
        });
        Map processEnvironment = builder.environment();
        processEnvironment.clear();
        processEnvironment.putAll((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(config.env()).asJava());
        NuProcess process = builder.start();
        process.wantWrite();
        return new JSRun(executionPromise, logger, process, handler){
            private final AtomicBoolean isClosed;
            private final Promise executionPromise$1;
            private final Logger logger$1;
            private final NuProcess process$1;
            private final NodeJsHandler handler$1;

            private AtomicBoolean isClosed() {
                return this.isClosed;
            }

            public Future<BoxedUnit> future() {
                return this.executionPromise$1.future();
            }

            public void close() {
                block0: {
                    if (this.isClosed().getAndSet(true)) break block0;
                    this.logger$1.debug("Destroying process...", NodeJSEnv$.MODULE$.debugFilter());
                    this.process$1.destroy(false);
                    this.process$1.waitFor(400L, TimeUnit.MILLISECONDS);
                    this.process$1.destroy(true);
                    this.handler$1.cancel();
                }
            }
            {
                this.executionPromise$1 = executionPromise$1;
                this.logger$1 = logger$1;
                this.process$1 = process$1;
                this.handler$1 = handler$1;
                this.isClosed = AtomicBoolean$.MODULE$.apply(false);
            }
        };
    }

    private static final String runScript$1(Path path) {
        String string;
        try {
            File f = path.toFile();
            String pathJS = new StringBuilder(2).append("\"").append(JSUtils$.MODULE$.escapeJS(f.getAbsolutePath())).append("\"").toString();
            string = new StringBuilder(176).append("\n          require('vm').runInThisContext(\n            require('fs').readFileSync(").append(pathJS).append(", { encoding: \"utf-8\" }),\n            { filename: ").append(pathJS).append(", displayErrors: true }\n          )\n        ").toString();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            String code = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
            String codeJS = new StringBuilder(2).append("\"").append(JSUtils$.MODULE$.escapeJS(code)).append("\"").toString();
            String pathJS = new StringBuilder(2).append("\"").append(JSUtils$.MODULE$.escapeJS(((Object)path).toString())).append("\"").toString();
            string = new StringBuilder(135).append("\n            require('vm').runInThisContext(\n              ").append(codeJS).append(",\n              { filename: ").append(pathJS).append(", displayErrors: true }\n            )\n          ").toString();
        }
        return string;
    }

    private final String requireCommonJSModule$1(Path module) {
        return new StringBuilder(11).append("require(\"").append(JSUtils$.MODULE$.escapeJS(this.toFile(module).getAbsolutePath())).append("\")").toString();
    }

    private final String importESModule$1(Path module) {
        return new StringBuilder(10).append("import(\"").append(JSUtils$.MODULE$.escapeJS(this.toFile(module).toURI().toASCIIString())).append("\")").toString();
    }

    private final String execInputExpr$1(Input input) {
        String string;
        Input input2 = input;
        if (input2 instanceof Input.Script) {
            Input.Script script = (Input.Script)input2;
            Path script2 = script.script();
            string = NodeJSEnv$.runScript$1(script2);
        } else if (input2 instanceof Input.CommonJSModule) {
            Input.CommonJSModule commonJSModule = (Input.CommonJSModule)input2;
            Path module = commonJSModule.module();
            string = this.requireCommonJSModule$1(module);
        } else if (input2 instanceof Input.ESModule) {
            Input.ESModule eSModule = (Input.ESModule)input2;
            Path module = eSModule.module();
            string = this.importESModule$1(module);
        } else {
            throw new MatchError((Object)input2);
        }
        return string;
    }

    private static final void println$1(String str, ByteBuffer out$1) {
        out$1.put(new StringBuilder(1).append(str).append("\n").toString().getBytes("UTF-8"));
    }

    public static final /* synthetic */ boolean $anonfun$write$1(Input x$4) {
        return x$4 instanceof Input.ESModule;
    }

    private NodeJSEnv$() {
        MODULE$ = this;
        this.debugFilter = DebugFilter.Test$.MODULE$;
        this.tmpSuffixRE = new StringOps(Predef$.MODULE$.augmentString("[a-zA-Z0-9-_.]*$")).r();
    }
}

