/*
 * Decompiled with CFR 0.152.
 */
package bloop.shaded.coursierapi.shaded.coursier.paths;

import bloop.shaded.coursierapi.shaded.coursier.jniutils.WindowsEnvironmentVariables;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.regex.Pattern;

public class Util {
    private static final Pattern propertyRegex = Pattern.compile(Pattern.quote("${") + "[^" + Pattern.quote("{[()]}") + "]*" + Pattern.quote("}"));
    private static volatile Boolean useColorOutput0 = null;
    private static volatile Boolean useAnsiOutput0 = null;
    private static Boolean useJni0 = null;

    public static void createDirectories(Path path) throws IOException {
        block2: {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                if (Files.isDirectory(path, new LinkOption[0])) break block2;
                throw fileAlreadyExistsException;
            }
        }
    }

    private static boolean computeUseAnsiOutput() {
        boolean bl;
        if (System.console() == null) {
            return false;
        }
        if (System.getenv("INSIDE_EMACS") != null) {
            return false;
        }
        if (System.getenv("CI") != null) {
            return false;
        }
        String string = System.getenv("COURSIER_PROGRESS");
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("enable") || string.equalsIgnoreCase("1"))) {
            bl = false;
        } else if (string != null && (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("disable") || string.equalsIgnoreCase("0"))) {
            bl = true;
        } else {
            boolean bl2 = bl = System.getenv("COURSIER_NO_TERM") != null;
        }
        return !bl;
    }

    public static boolean useAnsiOutput() {
        if (useAnsiOutput0 == null) {
            useAnsiOutput0 = Util.computeUseAnsiOutput();
        }
        return useAnsiOutput0;
    }

    public static boolean useJni() {
        return Util.useJni(() -> {});
    }

    public static boolean useJni(Runnable runnable) {
        boolean bl;
        if (useJni0 != null) {
            return useJni0;
        }
        boolean bl2 = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows");
        if (!bl2) {
            useJni0 = false;
            return useJni0;
        }
        String string = System.getenv("COURSIER_JNI");
        if (string == null || string.isEmpty()) {
            string = System.getProperty("bloop.shaded.coursierapi.shaded.coursier.jni", "");
        }
        if (bl = string.equalsIgnoreCase("force")) {
            runnable.run();
            useJni0 = true;
            return useJni0;
        }
        boolean bl3 = string.equalsIgnoreCase("false");
        if (bl3) {
            useJni0 = false;
            return useJni0;
        }
        try {
            runnable.run();
            WindowsEnvironmentVariables.get("PATH");
            useJni0 = true;
        }
        catch (Throwable throwable) {
            if (System.getProperty("bloop.shaded.coursierapi.shaded.coursier.jni.check.throw", "").equalsIgnoreCase("true")) {
                throw new RuntimeException(throwable);
            }
            useJni0 = false;
        }
        return useJni0;
    }
}

