/*
 * Decompiled with CFR 0.152.
 */
package bloop.shaded.coursierapi;

import bloop.shaded.coursierapi.Credentials;
import java.util.Objects;

public final class Artifact {
    private final String url;
    private final boolean changing;
    private final boolean optional;
    private final Credentials credentials;

    public static Artifact of(String string) {
        return new Artifact(string, false, false, null);
    }

    public static Artifact of(String string, boolean bl) {
        return new Artifact(string, false, bl, null);
    }

    public static Artifact of(String string, boolean bl, boolean bl2) {
        return new Artifact(string, bl, bl2, null);
    }

    public static Artifact of(String string, boolean bl, boolean bl2, Credentials credentials) {
        return new Artifact(string, bl, bl2, credentials);
    }

    private Artifact(String string, boolean bl, boolean bl2, Credentials credentials) {
        this.url = string;
        this.changing = bl;
        this.optional = bl2;
        this.credentials = credentials;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Artifact) {
            Artifact artifact = (Artifact)object;
            return this.url.equals(artifact.url) && this.changing == artifact.changing && this.optional == artifact.optional && Objects.equals(this.credentials, artifact.credentials);
        }
        return false;
    }

    public int hashCode() {
        return 37 * (37 * (37 * (17 + this.url.hashCode()) + Boolean.hashCode(this.changing)) + Boolean.hashCode(this.optional)) + Objects.hashCode(this.credentials);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Artifact(");
        stringBuilder.append(this.url);
        stringBuilder.append(", optional = ");
        stringBuilder.append(this.optional);
        stringBuilder.append(", changing = ");
        stringBuilder.append(this.changing);
        if (this.credentials != null) {
            stringBuilder.append(", ");
            stringBuilder.append(this.credentials.toString());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isChanging() {
        return this.changing;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }
}

