/*
 * Decompiled with CFR 0.152.
 */
package bloop.shaded.coursierapi;

import bloop.shaded.coursierapi.Cache;
import bloop.shaded.coursierapi.CompleteResult;
import bloop.shaded.coursierapi.Repository;
import bloop.shaded.coursierapi.error.CoursierError;
import bloop.shaded.coursierapi.shaded.coursier.internal.api.ApiHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class Complete {
    private final List<Repository> repositories = new ArrayList<Repository>(Arrays.asList(ApiHelper.defaultRepositories()));
    private Cache cache = Cache.create();
    private String input = "";
    private String scalaVersion = null;
    private String scalaBinaryVersion = null;

    private Complete() {
    }

    public static Complete create() {
        return new Complete();
    }

    public boolean equals(Object object) {
        if (object instanceof Complete) {
            Complete complete = (Complete)object;
            return this.repositories.equals(complete.repositories) && this.cache.equals(complete.cache) && this.input.equals(complete.input) && Objects.equals(this.scalaVersion, complete.scalaVersion) && Objects.equals(this.scalaBinaryVersion, complete.scalaBinaryVersion);
        }
        return false;
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (17 + "bloop.shaded.coursierapi.Complete".hashCode()) + this.repositories.hashCode()) + this.cache.hashCode()) + this.input.hashCode()) + Objects.hashCode(this.scalaVersion)) + Objects.hashCode(this.scalaBinaryVersion);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Complete(repositories=[");
        for (Repository repository : this.repositories) {
            stringBuilder.append(repository.toString());
            stringBuilder.append(", ");
        }
        stringBuilder.append("], cache=");
        stringBuilder.append(this.cache.toString());
        stringBuilder.append("], input=");
        stringBuilder.append(this.input);
        if (this.scalaVersion != null) {
            stringBuilder.append("], scalaVersion=");
            stringBuilder.append(this.scalaVersion);
        }
        if (this.scalaBinaryVersion != null) {
            stringBuilder.append("], scalaBinaryVersion=");
            stringBuilder.append(this.scalaBinaryVersion);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public Complete addRepositories(Repository ... repositoryArray) {
        this.repositories.addAll(Arrays.asList(repositoryArray));
        return this;
    }

    public Complete withRepositories(Repository ... repositoryArray) {
        this.repositories.clear();
        this.repositories.addAll(Arrays.asList(repositoryArray));
        return this;
    }

    public Complete withCache(Cache cache) {
        this.cache = cache;
        return this;
    }

    public Complete withInput(String string) {
        this.input = string;
        return this;
    }

    public Complete withScalaVersion(String string) {
        this.scalaVersion = string;
        return this;
    }

    public Complete withScalaBinaryVersion(String string) {
        this.scalaBinaryVersion = string;
        return this;
    }

    public List<Repository> getRepositories() {
        return Collections.unmodifiableList(this.repositories);
    }

    public Cache getCache() {
        return this.cache;
    }

    public String getInput() {
        return this.input;
    }

    public String getScalaVersion() {
        return this.scalaVersion;
    }

    public String getScalaBinaryVersion() {
        return this.scalaBinaryVersion;
    }

    public CompleteResult complete() throws CoursierError {
        return ApiHelper.doComplete(this);
    }
}

