/*
 * Decompiled with CFR 0.152.
 */
package bloop.shaded.coursierapi;

import bloop.shaded.coursierapi.Repository;
import bloop.shaded.coursierapi.VersionListing;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class VersionsResult {
    private final List<Map.Entry<Repository, String>> errors;
    private final List<Map.Entry<Repository, VersionListing>> listings;
    private final VersionListing mergedListings;

    private VersionsResult(List<Map.Entry<Repository, String>> list, List<Map.Entry<Repository, VersionListing>> list2, VersionListing versionListing) {
        this.errors = Collections.unmodifiableList(new ArrayList<Map.Entry<Repository, String>>(list));
        this.listings = Collections.unmodifiableList(new ArrayList<Map.Entry<Repository, VersionListing>>(list2));
        this.mergedListings = versionListing;
    }

    public static VersionsResult of(List<Map.Entry<Repository, String>> list, List<Map.Entry<Repository, VersionListing>> list2, VersionListing versionListing) {
        return new VersionsResult(list, list2, versionListing);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof VersionsResult) {
            VersionsResult versionsResult = (VersionsResult)object;
            return this.errors.equals(versionsResult.errors) && this.listings.equals(versionsResult.listings) && this.mergedListings.equals(versionsResult.mergedListings);
        }
        return false;
    }

    public int hashCode() {
        return 37 * (37 * (37 * (17 + this.errors.hashCode()) + this.listings.hashCode()) + this.mergedListings.hashCode());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("VersionsResult(errors=[");
        boolean bl = true;
        for (Map.Entry<Repository, String> entry : this.errors) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append(": ");
            stringBuilder.append(entry.getValue());
        }
        stringBuilder.append(", listings=[");
        for (Map.Entry<Repository, Object> entry : this.listings) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append(": ");
            stringBuilder.append(entry.getValue());
        }
        stringBuilder.append("], mergedListings=");
        stringBuilder.append(this.mergedListings);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public List<Map.Entry<Repository, String>> getErrors() {
        return this.errors;
    }

    public List<Map.Entry<Repository, VersionListing>> getListings() {
        return this.listings;
    }

    public VersionListing getMergedListings() {
        return this.mergedListings;
    }
}

