/*
 * Decompiled with CFR 0.152.
 */
package bloop.shaded.org.zeroturnaround.exec.stream;

import bloop.shaded.org.slf4j.Logger;
import bloop.shaded.org.slf4j.LoggerFactory;
import java.io.InputStream;
import java.io.OutputStream;

public class InputStreamPumper
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(InputStreamPumper.class);
    public static final int SLEEPING_TIME = 100;
    private final InputStream is;
    private final OutputStream os;
    private volatile boolean stop;

    public InputStreamPumper(InputStream is, OutputStream os) {
        this.is = is;
        this.os = os;
        this.stop = false;
    }

    @Override
    public void run() {
        try {
            while (!this.stop) {
                while (this.is.available() > 0 && !this.stop) {
                    this.os.write(this.is.read());
                }
                this.os.flush();
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            log.error("Got exception while reading/writing the stream", e);
        }
    }

    public void stopProcessing() {
        this.stop = true;
    }
}

