/*
 * Decompiled with CFR 0.152.
 */
package bloop.io;

import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.Paths;
import bloop.io.Paths$AttributedPath$;
import dev.dirs.ProjectDirectories;
import dev.dirs.jni.WindowsJni;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.function.Supplier;
import java.util.stream.Stream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Properties$;
import xsbti.Logger;

public final class Paths$ {
    public static Paths$ MODULE$;
    private Path bloopCacheDir;
    private Path bloopDataDir;
    private Path daemonDir;
    private final ProjectDirectories projDirs;
    private volatile byte bitmap$0;

    static {
        new Paths$();
    }

    private Path createDirFor(String filepath) {
        return AbsolutePath$.MODULE$.apply(Files.createDirectories(Paths.get(filepath, new String[0]), new FileAttribute[0]), AbsolutePath$.MODULE$.workingDirectory());
    }

    public ProjectDirectories projDirs() {
        return this.projDirs;
    }

    private Path bloopCacheDir$lzycompute() {
        Paths$ paths$ = this;
        synchronized (paths$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.bloopCacheDir = this.createDirFor(this.projDirs().cacheDir);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.bloopCacheDir;
    }

    private Path bloopCacheDir() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.bloopCacheDir$lzycompute();
        }
        return this.bloopCacheDir;
    }

    private Path bloopDataDir$lzycompute() {
        Paths$ paths$ = this;
        synchronized (paths$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.bloopDataDir = this.createDirFor(this.projDirs().dataDir);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.bloopDataDir;
    }

    private Path bloopDataDir() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.bloopDataDir$lzycompute();
        }
        return this.bloopDataDir;
    }

    private Path daemonDir$lzycompute() {
        Paths$ paths$ = this;
        synchronized (paths$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Object object;
                Path path;
                Option option = Option$.MODULE$.apply((Object)System.getenv("BLOOP_DAEMON_DIR")).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Paths$.$anonfun$daemonDir$1(x$1)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String dirStr = (String)some.value();
                    path = Paths.get(dirStr, new String[0]);
                } else if (None$.MODULE$.equals(option)) {
                    path = this.defaultDir$1();
                } else {
                    throw new MatchError((Object)option);
                }
                Path dir = path;
                if (!Files.exists(dir, new LinkOption[0])) {
                    Files.createDirectories(dir, new FileAttribute[0]);
                    object = !Properties$.MODULE$.isWin() ? Files.setPosixFilePermissions(dir, PosixFilePermissions.fromString("rwx------")) : BoxedUnit.UNIT;
                } else {
                    object = BoxedUnit.UNIT;
                }
                this.daemonDir = AbsolutePath$.MODULE$.apply(dir, AbsolutePath$.MODULE$.workingDirectory());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.daemonDir;
    }

    public Path daemonDir() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.daemonDir$lzycompute();
        }
        return this.daemonDir;
    }

    public Path getCacheDirectory(String dirName) {
        Path path;
        Path dir = AbsolutePath$.MODULE$.resolve$extension1(this.bloopCacheDir(), dirName);
        Path dirPath = dir;
        if (!Files.exists(dirPath, new LinkOption[0])) {
            path = Files.createDirectories(dirPath, new FileAttribute[0]);
        } else {
            Predef$.MODULE$.require(Files.isDirectory(dirPath, new LinkOption[0]), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("File '").append(AbsolutePath$.MODULE$.syntax$extension(dir)).append("' is not a directory.").toString());
            path = BoxedUnit.UNIT;
        }
        return dir;
    }

    public List<AbsolutePath> pathFilesUnder(Path base, String pattern, int maxDepth) {
        ListBuffer out = (ListBuffer)ListBuffer$.MODULE$.empty();
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(pattern);
        FileVisitor<Path> visitor = new FileVisitor<Path>(matcher, out){
            private final PathMatcher matcher$1;
            private final ListBuffer out$1;

            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                Object object = this.matcher$1.matches(file) ? this.out$1.$plus$eq((Object)new AbsolutePath(AbsolutePath$.MODULE$.apply(file, AbsolutePath$.MODULE$.workingDirectory()))) : BoxedUnit.UNIT;
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFileFailed(Path t, IOException e) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attributes) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path directory, IOException exception) {
                return FileVisitResult.CONTINUE;
            }
            {
                this.matcher$1 = matcher$1;
                this.out$1 = out$1;
            }
        };
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Files.walkFileTree(base, opts, maxDepth, (FileVisitor<? super Path>)visitor);
        return out.toList();
    }

    public int pathFilesUnder$default$3() {
        return Integer.MAX_VALUE;
    }

    public List<Paths.AttributedPath> attributedPathFilesUnder(Path base, String pattern, Logger logger, int maxDepth, boolean ignoreVisitErrors) {
        ListBuffer out = (ListBuffer)ListBuffer$.MODULE$.empty();
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(pattern);
        FileVisitor<Path> visitor = new FileVisitor<Path>(matcher, out, ignoreVisitErrors, logger){
            private final PathMatcher matcher$2;
            private final ListBuffer out$2;
            private final boolean ignoreVisitErrors$1;
            private final Logger logger$1;

            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                Object object = this.matcher$2.matches(file) ? this.out$2.$plus$eq((Object)Paths$AttributedPath$.MODULE$.of(AbsolutePath$.MODULE$.apply(file, AbsolutePath$.MODULE$.workingDirectory()), FileTime.fromMillis(attributes.lastModifiedTime().toMillis()), attributes.size())) : BoxedUnit.UNIT;
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFileFailed(Path t, IOException e) {
                block0: {
                    if (this.ignoreVisitErrors$1) break block0;
                    this.logger$1.error(() -> new StringBuilder(37).append("Unexpected failure when visiting ").append(t).append(": '").append(e.getMessage()).append("'").toString());
                    this.logger$1.trace(() -> e);
                }
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attributes) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path directory, IOException exception) {
                return FileVisitResult.CONTINUE;
            }
            {
                this.matcher$2 = matcher$2;
                this.out$2 = out$2;
                this.ignoreVisitErrors$1 = ignoreVisitErrors$1;
                this.logger$1 = logger$1;
            }
        };
        if (!AbsolutePath$.MODULE$.exists$extension(base)) {
            return Nil$.MODULE$;
        }
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Files.walkFileTree(base, opts, maxDepth, (FileVisitor<? super Path>)visitor);
        return out.toList();
    }

    public int attributedPathFilesUnder$default$4() {
        return Integer.MAX_VALUE;
    }

    public boolean attributedPathFilesUnder$default$5() {
        return false;
    }

    public void delete(Path path) {
        Object object;
        try {
            object = Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    try {
                        Files.delete(dir);
                    }
                    catch (DirectoryNotEmptyException directoryNotEmptyException) {}
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            object = BoxedUnit.UNIT;
        }
    }

    public boolean isDirectoryEmpty(Path path, boolean excludeDirs) {
        Object object;
        BooleanRef isEmpty = BooleanRef.create((boolean)true);
        try {
            object = Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(isEmpty, excludeDirs, path){
                private final BooleanRef isEmpty$1;
                private final boolean excludeDirs$1;
                private final Path path$2;

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    this.isEmpty$1.elem = false;
                    return FileVisitResult.TERMINATE;
                }

                public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attributes) {
                    block3: {
                        block2: {
                            if (this.excludeDirs$1) break block2;
                            Path path = this.path$2;
                            Path path2 = directory;
                            if (path != null ? !((Object)path).equals(path2) : path2 != null) break block3;
                        }
                        return FileVisitResult.CONTINUE;
                    }
                    this.isEmpty$1.elem = false;
                    return FileVisitResult.TERMINATE;
                }
                {
                    this.isEmpty$1 = isEmpty$1;
                    this.excludeDirs$1 = excludeDirs$1;
                    this.path$2 = path$2;
                }
            });
        }
        catch (NoSuchFileException noSuchFileException) {
            isEmpty.elem = true;
            object = BoxedUnit.UNIT;
        }
        return isEmpty.elem;
    }

    public List<AbsolutePath> list(Path path2) {
        ListBuffer topLevelChildren = new ListBuffer();
        try (Stream<Path> pathStream = Files.list(path2);){
            try {
                pathStream.forEach(path -> topLevelChildren.$plus$eq((Object)new AbsolutePath(AbsolutePath$.MODULE$.apply((Path)path, AbsolutePath$.MODULE$.workingDirectory()))));
            }
            catch (NoSuchFileException noSuchFileException) {}
        }
        return topLevelChildren.toList();
    }

    private final Path defaultDir$1() {
        Path baseDir = Properties$.MODULE$.isMac() ? this.bloopCacheDir() : this.bloopDataDir();
        return baseDir.resolve("daemon");
    }

    public static final /* synthetic */ boolean $anonfun$daemonDir$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1.trim())).nonEmpty();
    }

    private Paths$() {
        MODULE$ = this;
        this.projDirs = ProjectDirectories.from(null, null, (String)"bloop", (Supplier)WindowsJni.getJdkAwareSupplier());
    }
}

