/*
 * Decompiled with CFR 0.152.
 */
package bloop.shaded.io.github.soc.directories;

import bloop.shaded.io.github.soc.directories.UnsupportedOperatingSystemException;
import bloop.shaded.io.github.soc.directories.Util;

public final class ProjectDirectories {
    public final String projectPath;
    public final String cacheDir;
    public final String configDir;
    public final String dataDir;
    public final String dataLocalDir;
    public final String runtimeDir;

    private ProjectDirectories(String string, String string2, String string3, String string4, String string5, String string6) {
        Util.requireNonNull(string);
        this.projectPath = string;
        this.cacheDir = string2;
        this.configDir = string3;
        this.dataDir = string4;
        this.dataLocalDir = string5;
        this.runtimeDir = string6;
    }

    public static ProjectDirectories fromPath(String string) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6 = null;
        switch (Util.operatingSystem) {
            case 'b': 
            case 'l': {
                String string7 = System.getProperty("user.home");
                string5 = Util.defaultIfNullOrEmptyExtended(System.getenv("XDG_CACHE_HOME"), string, string7 + "/.cache/", string);
                string4 = Util.defaultIfNullOrEmptyExtended(System.getenv("XDG_CONFIG_HOME"), string, string7 + "/.config/", string);
                string2 = string3 = Util.defaultIfNullOrEmptyExtended(System.getenv("XDG_DATA_HOME"), string, string7 + "/.local/share/", string);
                string6 = Util.linuxRuntimeDir(string);
                break;
            }
            case 'm': {
                String string8 = System.getProperty("user.home");
                string5 = string8 + "/Library/Caches/" + string;
                string4 = string8 + "/Library/Preferences/" + string;
                string2 = string3 = string8 + "/Library/Application Support/" + string;
                break;
            }
            case 'w': {
                String[] stringArray = Util.getWinDirs("3EB685DB-65F9-4CF6-A03A-E3EF65729F3D", "F1B32785-6FBA-4FCF-9D55-7B8E7F157091");
                String string9 = stringArray[0] + '\\' + string;
                String string10 = stringArray[1] + '\\' + string;
                string3 = string9 + "\\data";
                string2 = string10 + "\\data";
                string4 = string9 + "\\config";
                string5 = string10 + "\\cache";
                break;
            }
            default: {
                throw new UnsupportedOperatingSystemException("Project directories are not supported on " + Util.operatingSystemName);
            }
        }
        return new ProjectDirectories(string, string5, string4, string3, string2, string6);
    }

    public static ProjectDirectories from(String string, String string2, String string3) {
        String string4;
        if (Util.isNullOrEmpty(string2) && Util.isNullOrEmpty(string3)) {
            throw new UnsupportedOperationException("organization and application arguments cannot both be null/empty");
        }
        switch (Util.operatingSystem) {
            case 'b': 
            case 'l': {
                string4 = Util.trimLowercaseReplaceWhitespace(string3, "", true);
                break;
            }
            case 'm': {
                string4 = Util.macOSApplicationPath(string, string2, string3);
                break;
            }
            case 'w': {
                string4 = Util.windowsApplicationPath(string, string2, string3);
                break;
            }
            default: {
                throw new UnsupportedOperatingSystemException("Base directories are not supported on " + Util.operatingSystemName);
            }
        }
        return ProjectDirectories.fromPath(string4);
    }

    public String toString() {
        return "ProjectDirectories (" + Util.operatingSystemName + "):\n  projectPath  = '" + this.projectPath + "'\n  cacheDir     = '" + this.cacheDir + "'\n  configDir    = '" + this.configDir + "'\n  dataDir      = '" + this.dataDir + "'\n  dataLocalDir = '" + this.dataLocalDir + "'\n  runtimeDir   = '" + this.runtimeDir + "'\n";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ProjectDirectories projectDirectories = (ProjectDirectories)object;
        if (!this.projectPath.equals(projectDirectories.projectPath)) {
            return false;
        }
        if (this.cacheDir != null ? !this.cacheDir.equals(projectDirectories.cacheDir) : projectDirectories.cacheDir != null) {
            return false;
        }
        if (this.configDir != null ? !this.configDir.equals(projectDirectories.configDir) : projectDirectories.configDir != null) {
            return false;
        }
        if (this.dataDir != null ? !this.dataDir.equals(projectDirectories.dataDir) : projectDirectories.dataDir != null) {
            return false;
        }
        if (this.dataLocalDir != null ? !this.dataLocalDir.equals(projectDirectories.dataLocalDir) : projectDirectories.dataLocalDir != null) {
            return false;
        }
        return !(this.runtimeDir != null ? !this.runtimeDir.equals(projectDirectories.runtimeDir) : projectDirectories.runtimeDir != null);
    }

    public int hashCode() {
        int n = this.projectPath.hashCode();
        n = 31 * n + (this.cacheDir != null ? this.cacheDir.hashCode() : 0);
        n = 31 * n + (this.configDir != null ? this.configDir.hashCode() : 0);
        n = 31 * n + (this.dataDir != null ? this.dataDir.hashCode() : 0);
        n = 31 * n + (this.dataLocalDir != null ? this.dataLocalDir.hashCode() : 0);
        n = 31 * n + (this.runtimeDir != null ? this.runtimeDir.hashCode() : 0);
        return n;
    }
}

