/*
 * Decompiled with CFR 0.152.
 */
package bloop.shaded.coursier.util.shaded.org.jsoup.helper;

import bloop.shaded.coursier.util.shaded.org.jsoup.helper.Validate;
import bloop.shaded.coursier.util.shaded.org.jsoup.internal.StringUtil;
import bloop.shaded.coursier.util.shaded.org.jsoup.nodes.Attribute;
import bloop.shaded.coursier.util.shaded.org.jsoup.nodes.Attributes;
import bloop.shaded.coursier.util.shaded.org.jsoup.nodes.DataNode;
import bloop.shaded.coursier.util.shaded.org.jsoup.nodes.Node;
import bloop.shaded.coursier.util.shaded.org.jsoup.nodes.TextNode;
import bloop.shaded.coursier.util.shaded.org.jsoup.select.NodeTraversor;
import bloop.shaded.coursier.util.shaded.org.jsoup.select.NodeVisitor;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class W3CDom {
    protected DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public Document fromJsoup(bloop.shaded.coursier.util.shaded.org.jsoup.nodes.Document in) {
        Validate.notNull(in);
        try {
            this.factory.setNamespaceAware(true);
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            Document out = builder.newDocument();
            this.convert(in, out);
            return out;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    public void convert(bloop.shaded.coursier.util.shaded.org.jsoup.nodes.Document in, Document out) {
        if (!StringUtil.isBlank(in.location())) {
            out.setDocumentURI(in.location());
        }
        bloop.shaded.coursier.util.shaded.org.jsoup.nodes.Element rootEl = in.child(0);
        NodeTraversor.traverse((NodeVisitor)new W3CBuilder(out), rootEl);
    }

    public String asString(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static class W3CBuilder
    implements NodeVisitor {
        private static final String xmlnsKey = "xmlns";
        private static final String xmlnsPrefix = "xmlns:";
        private final Document doc;
        private final Stack<HashMap<String, String>> namespacesStack = new Stack();
        private Element dest;

        public W3CBuilder(Document doc) {
            this.doc = doc;
            this.namespacesStack.push(new HashMap());
        }

        @Override
        public void head(Node source, int depth) {
            this.namespacesStack.push(new HashMap(this.namespacesStack.peek()));
            if (source instanceof bloop.shaded.coursier.util.shaded.org.jsoup.nodes.Element) {
                bloop.shaded.coursier.util.shaded.org.jsoup.nodes.Element sourceEl = (bloop.shaded.coursier.util.shaded.org.jsoup.nodes.Element)source;
                String prefix = this.updateNamespaces(sourceEl);
                String namespace = this.namespacesStack.peek().get(prefix);
                String tagName = sourceEl.tagName();
                Element el = namespace == null && tagName.contains(":") ? this.doc.createElementNS("", tagName) : this.doc.createElementNS(namespace, tagName);
                this.copyAttributes(sourceEl, el);
                if (this.dest == null) {
                    this.doc.appendChild(el);
                } else {
                    this.dest.appendChild(el);
                }
                this.dest = el;
            } else if (source instanceof TextNode) {
                TextNode sourceText = (TextNode)source;
                Text text2 = this.doc.createTextNode(sourceText.getWholeText());
                this.dest.appendChild(text2);
            } else if (source instanceof bloop.shaded.coursier.util.shaded.org.jsoup.nodes.Comment) {
                bloop.shaded.coursier.util.shaded.org.jsoup.nodes.Comment sourceComment = (bloop.shaded.coursier.util.shaded.org.jsoup.nodes.Comment)source;
                Comment comment = this.doc.createComment(sourceComment.getData());
                this.dest.appendChild(comment);
            } else if (source instanceof DataNode) {
                DataNode sourceData = (DataNode)source;
                Text node = this.doc.createTextNode(sourceData.getWholeData());
                this.dest.appendChild(node);
            }
        }

        @Override
        public void tail(Node source, int depth) {
            if (source instanceof bloop.shaded.coursier.util.shaded.org.jsoup.nodes.Element && this.dest.getParentNode() instanceof Element) {
                this.dest = (Element)this.dest.getParentNode();
            }
            this.namespacesStack.pop();
        }

        private void copyAttributes(Node source, Element el) {
            for (Attribute attribute : source.attributes()) {
                String key = attribute.getKey().replaceAll("[^-a-zA-Z0-9_:.]", "");
                if (!key.matches("[a-zA-Z_:][-a-zA-Z0-9_:.]*")) continue;
                el.setAttribute(key, attribute.getValue());
            }
        }

        private String updateNamespaces(bloop.shaded.coursier.util.shaded.org.jsoup.nodes.Element el) {
            Attributes attributes = el.attributes();
            for (Attribute attr : attributes) {
                String prefix;
                String key = attr.getKey();
                if (key.equals(xmlnsKey)) {
                    prefix = "";
                } else {
                    if (!key.startsWith(xmlnsPrefix)) continue;
                    prefix = key.substring(xmlnsPrefix.length());
                }
                this.namespacesStack.peek().put(prefix, attr.getValue());
            }
            int pos = el.tagName().indexOf(":");
            return pos > 0 ? el.tagName().substring(0, pos) : "";
        }
    }
}

