/*
 * Decompiled with CFR 0.152.
 */
package bloop.shaded.coursier.util.shaded.org.jsoup.parser;

import bloop.shaded.coursier.util.shaded.org.jsoup.helper.Validate;
import bloop.shaded.coursier.util.shaded.org.jsoup.internal.Normalizer;
import bloop.shaded.coursier.util.shaded.org.jsoup.parser.ParseSettings;
import java.util.HashMap;
import java.util.Map;

public class Tag {
    private static final Map<String, Tag> tags;
    private String tagName;
    private String normalName;
    private boolean isBlock = true;
    private boolean formatAsBlock = true;
    private boolean canContainInline = true;
    private boolean empty = false;
    private boolean selfClosing = false;
    private boolean preserveWhitespace = false;
    private boolean formList = false;
    private boolean formSubmit = false;
    private static final String[] blockTags;
    private static final String[] inlineTags;
    private static final String[] emptyTags;
    private static final String[] formatAsInlineTags;
    private static final String[] preserveWhitespaceTags;
    private static final String[] formListedTags;
    private static final String[] formSubmitTags;

    private Tag(String tagName) {
        this.tagName = tagName;
        this.normalName = Normalizer.lowerCase(tagName);
    }

    public String getName() {
        return this.tagName;
    }

    public String normalName() {
        return this.normalName;
    }

    public static Tag valueOf(String tagName, ParseSettings settings) {
        Validate.notNull(tagName);
        Tag tag2 = tags.get(tagName);
        if (tag2 == null) {
            tagName = settings.normalizeTag(tagName);
            Validate.notEmpty(tagName);
            tag2 = tags.get(tagName);
            if (tag2 == null) {
                tag2 = new Tag(tagName);
                tag2.isBlock = false;
            }
        }
        return tag2;
    }

    public static Tag valueOf(String tagName) {
        return Tag.valueOf(tagName, ParseSettings.preserveCase);
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    public boolean formatAsBlock() {
        return this.formatAsBlock;
    }

    public boolean canContainBlock() {
        return this.isBlock;
    }

    public boolean isInline() {
        return !this.isBlock;
    }

    public boolean isData() {
        return !this.canContainInline && !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isSelfClosing() {
        return this.empty || this.selfClosing;
    }

    public boolean isKnownTag() {
        return tags.containsKey(this.tagName);
    }

    public static boolean isKnownTag(String tagName) {
        return tags.containsKey(tagName);
    }

    public boolean preserveWhitespace() {
        return this.preserveWhitespace;
    }

    public boolean isFormListed() {
        return this.formList;
    }

    public boolean isFormSubmittable() {
        return this.formSubmit;
    }

    Tag setSelfClosing() {
        this.selfClosing = true;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tag)) {
            return false;
        }
        Tag tag2 = (Tag)o;
        if (!this.tagName.equals(tag2.tagName)) {
            return false;
        }
        if (this.canContainInline != tag2.canContainInline) {
            return false;
        }
        if (this.empty != tag2.empty) {
            return false;
        }
        if (this.formatAsBlock != tag2.formatAsBlock) {
            return false;
        }
        if (this.isBlock != tag2.isBlock) {
            return false;
        }
        if (this.preserveWhitespace != tag2.preserveWhitespace) {
            return false;
        }
        if (this.selfClosing != tag2.selfClosing) {
            return false;
        }
        if (this.formList != tag2.formList) {
            return false;
        }
        return this.formSubmit == tag2.formSubmit;
    }

    public int hashCode() {
        int result = this.tagName.hashCode();
        result = 31 * result + (this.isBlock ? 1 : 0);
        result = 31 * result + (this.formatAsBlock ? 1 : 0);
        result = 31 * result + (this.canContainInline ? 1 : 0);
        result = 31 * result + (this.empty ? 1 : 0);
        result = 31 * result + (this.selfClosing ? 1 : 0);
        result = 31 * result + (this.preserveWhitespace ? 1 : 0);
        result = 31 * result + (this.formList ? 1 : 0);
        result = 31 * result + (this.formSubmit ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.tagName;
    }

    private static void register(Tag tag2) {
        tags.put(tag2.tagName, tag2);
    }

    static {
        Tag tag2;
        tags = new HashMap<String, Tag>();
        blockTags = new String[]{"html", "head", "body", "frameset", "script", "noscript", "style", "meta", "link", "title", "frame", "noframes", "section", "nav", "aside", "hgroup", "header", "footer", "p", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "pre", "div", "blockquote", "hr", "address", "figure", "figcaption", "form", "fieldset", "ins", "del", "dl", "dt", "dd", "li", "table", "caption", "thead", "tfoot", "tbody", "colgroup", "col", "tr", "th", "td", "video", "audio", "canvas", "details", "menu", "plaintext", "template", "article", "main", "svg", "math", "center"};
        inlineTags = new String[]{"object", "base", "font", "tt", "i", "b", "u", "big", "small", "em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "time", "acronym", "mark", "ruby", "rt", "rp", "a", "img", "br", "wbr", "map", "q", "sub", "sup", "bdo", "iframe", "embed", "span", "input", "select", "textarea", "label", "button", "optgroup", "option", "legend", "datalist", "keygen", "output", "progress", "meter", "area", "param", "source", "track", "summary", "command", "device", "area", "basefont", "bgsound", "menuitem", "param", "source", "track", "data", "bdi", "s"};
        emptyTags = new String[]{"meta", "link", "base", "frame", "img", "br", "wbr", "embed", "hr", "input", "keygen", "col", "command", "device", "area", "basefont", "bgsound", "menuitem", "param", "source", "track"};
        formatAsInlineTags = new String[]{"title", "a", "p", "h1", "h2", "h3", "h4", "h5", "h6", "pre", "address", "li", "th", "td", "script", "style", "ins", "del", "s"};
        preserveWhitespaceTags = new String[]{"pre", "plaintext", "title", "textarea"};
        formListedTags = new String[]{"button", "fieldset", "input", "keygen", "object", "output", "select", "textarea"};
        formSubmitTags = new String[]{"input", "keygen", "object", "select", "textarea"};
        for (String tagName : blockTags) {
            tag2 = new Tag(tagName);
            Tag.register(tag2);
        }
        for (String tagName : inlineTags) {
            tag2 = new Tag(tagName);
            tag2.isBlock = false;
            tag2.formatAsBlock = false;
            Tag.register(tag2);
        }
        for (String tagName : emptyTags) {
            tag2 = tags.get(tagName);
            Validate.notNull(tag2);
            tag2.canContainInline = false;
            tag2.empty = true;
        }
        for (String tagName : formatAsInlineTags) {
            tag2 = tags.get(tagName);
            Validate.notNull(tag2);
            tag2.formatAsBlock = false;
        }
        for (String tagName : preserveWhitespaceTags) {
            tag2 = tags.get(tagName);
            Validate.notNull(tag2);
            tag2.preserveWhitespace = true;
        }
        for (String tagName : formListedTags) {
            tag2 = tags.get(tagName);
            Validate.notNull(tag2);
            tag2.formList = true;
        }
        for (String tagName : formSubmitTags) {
            tag2 = tags.get(tagName);
            Validate.notNull(tag2);
            tag2.formSubmit = true;
        }
    }
}

