/*
 * Decompiled with CFR 0.152.
 */
package bloop.shaded.coursierapi.shaded.scala.collection.mutable;

import bloop.shaded.coursierapi.shaded.scala.MatchError;
import bloop.shaded.coursierapi.shaded.scala.None$;
import bloop.shaded.coursierapi.shaded.scala.Option;
import bloop.shaded.coursierapi.shaded.scala.Some;
import bloop.shaded.coursierapi.shaded.scala.Tuple2;
import bloop.shaded.coursierapi.shaded.scala.collection.AbstractIterator;
import bloop.shaded.coursierapi.shaded.scala.collection.mutable.RedBlackTree$;
import bloop.shaded.coursierapi.shaded.scala.math.Ordering;
import java.util.NoSuchElementException;

public final class RedBlackTree {

    public static final class EntriesIterator<A, B>
    extends TreeIterator<A, B, Tuple2<A, B>> {
        @Override
        public Tuple2<A, B> nextResult(Node<A, B> node) {
            return new Tuple2<A, B>(node.key(), node.value());
        }

        public EntriesIterator(Tree<A, B> tree, Option<A> start, Option<A> end, Ordering<A> evidence$6) {
            super(tree, start, end, evidence$6);
        }
    }

    public static final class KeysIterator<A, B>
    extends TreeIterator<A, B, A> {
        @Override
        public A nextResult(Node<A, B> node) {
            return node.key();
        }

        public KeysIterator(Tree<A, B> tree, Option<A> start, Option<A> end, Ordering<A> evidence$7) {
            super(tree, start, end, evidence$7);
        }
    }

    public static final class Node<A, B> {
        private A key;
        private B value;
        private boolean red;
        private Node<A, B> left;
        private Node<A, B> right;
        private Node<A, B> parent;

        public A key() {
            return this.key;
        }

        public B value() {
            return this.value;
        }

        public void value_$eq(B x$1) {
            this.value = x$1;
        }

        public boolean red() {
            return this.red;
        }

        public void red_$eq(boolean x$1) {
            this.red = x$1;
        }

        public Node<A, B> left() {
            return this.left;
        }

        public void left_$eq(Node<A, B> x$1) {
            this.left = x$1;
        }

        public Node<A, B> right() {
            return this.right;
        }

        public void right_$eq(Node<A, B> x$1) {
            this.right = x$1;
        }

        public Node<A, B> parent() {
            return this.parent;
        }

        public void parent_$eq(Node<A, B> x$1) {
            this.parent = x$1;
        }

        public String toString() {
            return new StringBuilder(14).append("Node(").append(this.key()).append(", ").append(this.value()).append(", ").append(this.red()).append(", ").append(this.left()).append(", ").append(this.right()).append(")").toString();
        }

        public Node(A key, B value, boolean red, Node<A, B> left, Node<A, B> right, Node<A, B> parent) {
            this.key = key;
            this.value = value;
            this.red = red;
            this.left = left;
            this.right = right;
            this.parent = parent;
        }
    }

    public static final class Tree<A, B> {
        private Node<A, B> root;
        private int size;

        public Node<A, B> root() {
            return this.root;
        }

        public void root_$eq(Node<A, B> x$1) {
            this.root = x$1;
        }

        public int size() {
            return this.size;
        }

        public void size_$eq(int x$1) {
            this.size = x$1;
        }

        public Tree<A, B> treeCopy() {
            return new Tree<A, B>(RedBlackTree$.MODULE$.copyTree(this.root()), this.size());
        }

        public Tree(Node<A, B> root, int size) {
            this.root = root;
            this.size = size;
        }
    }

    public static abstract class TreeIterator<A, B, R>
    extends AbstractIterator<R> {
        private final Option<A> end;
        private final Ordering<A> ord;
        private Node<A, B> nextNode;

        public abstract R nextResult(Node<A, B> var1);

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public R next() throws NoSuchElementException {
            Node<A, B> node = this.nextNode;
            if (node == null) {
                throw new NoSuchElementException("next on empty iterator");
            }
            this.nextNode = RedBlackTree$.MODULE$.scala$collection$mutable$RedBlackTree$$successor(node);
            this.setNullIfAfterEnd();
            return this.nextResult(node);
        }

        private void setNullIfAfterEnd() {
            if (this.end.isDefined() && this.nextNode != null && this.ord.compare(this.nextNode.key(), this.end.get()) >= 0) {
                this.nextNode = null;
            }
        }

        public TreeIterator(Tree<A, B> tree, Option<A> start, Option<A> end, Ordering<A> ord) {
            Node<A, B> node;
            this.end = end;
            this.ord = ord;
            if (None$.MODULE$.equals(start)) {
                node = RedBlackTree$.MODULE$.scala$collection$mutable$RedBlackTree$$minNode(tree.root());
            } else if (start instanceof Some) {
                Object from = ((Some)start).value();
                node = RedBlackTree$.MODULE$.scala$collection$mutable$RedBlackTree$$minNodeAfter(tree.root(), from, ord);
            } else {
                throw new MatchError(start);
            }
            this.nextNode = node;
            this.setNullIfAfterEnd();
        }
    }

    public static final class ValuesIterator<A, B>
    extends TreeIterator<A, B, B> {
        @Override
        public B nextResult(Node<A, B> node) {
            return node.value();
        }

        public ValuesIterator(Tree<A, B> tree, Option<A> start, Option<A> end, Ordering<A> evidence$8) {
            super(tree, start, end, evidence$8);
        }
    }
}

