/*
 * Decompiled with CFR 0.152.
 */
package bloop.shaded.coursierapi.shaded.coursier.cache.internal;

import bloop.shaded.coursierapi.shaded.coursier.cache.ArtifactError;
import bloop.shaded.coursierapi.shaded.coursier.cache.ArtifactError$NotFound$;
import bloop.shaded.coursierapi.shaded.coursier.cache.CacheLocks$;
import bloop.shaded.coursierapi.shaded.coursier.cache.CacheLogger;
import bloop.shaded.coursierapi.shaded.coursier.cache.CachePolicy;
import bloop.shaded.coursierapi.shaded.coursier.cache.CacheUrl$;
import bloop.shaded.coursierapi.shaded.coursier.cache.ConnectionBuilder$;
import bloop.shaded.coursierapi.shaded.coursier.cache.internal.Downloader;
import bloop.shaded.coursierapi.shaded.coursier.core.Authentication;
import bloop.shaded.coursierapi.shaded.coursier.credentials.DirectCredentials;
import bloop.shaded.coursierapi.shaded.coursier.util.Artifact;
import bloop.shaded.coursierapi.shaded.coursier.util.Sync;
import bloop.shaded.coursierapi.shaded.scala.Array$;
import bloop.shaded.coursierapi.shaded.scala.Function0;
import bloop.shaded.coursierapi.shaded.scala.Function1;
import bloop.shaded.coursierapi.shaded.scala.MatchError;
import bloop.shaded.coursierapi.shaded.scala.None$;
import bloop.shaded.coursierapi.shaded.scala.Option;
import bloop.shaded.coursierapi.shaded.scala.Option$;
import bloop.shaded.coursierapi.shaded.scala.Some;
import bloop.shaded.coursierapi.shaded.scala.collection.immutable.$colon$colon;
import bloop.shaded.coursierapi.shaded.scala.collection.immutable.List;
import bloop.shaded.coursierapi.shaded.scala.collection.immutable.Nil$;
import bloop.shaded.coursierapi.shaded.scala.collection.immutable.Seq;
import bloop.shaded.coursierapi.shaded.scala.concurrent.duration.Duration;
import bloop.shaded.coursierapi.shaded.scala.package$;
import bloop.shaded.coursierapi.shaded.scala.reflect.ClassTag$;
import bloop.shaded.coursierapi.shaded.scala.runtime.BoxesRunTime;
import bloop.shaded.coursierapi.shaded.scala.runtime.Nothing$;
import bloop.shaded.coursierapi.shaded.scala.util.Either;
import bloop.shaded.coursierapi.shaded.scala.util.Left;
import bloop.shaded.coursierapi.shaded.scala.util.Right;
import bloop.shaded.coursierapi.shaded.scala.util.control.NonFatal$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;

public final class Downloader$
implements Serializable {
    public static final Downloader$ MODULE$ = new Downloader$();
    private static final Seq<String> coursier$cache$internal$Downloader$$checksumHeader = new $colon$colon<Nothing$>((Nothing$)((Object)"MD5"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"SHA1"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"SHA256"), Nil$.MODULE$)));

    public Seq<String> coursier$cache$internal$Downloader$$checksumHeader() {
        return coursier$cache$internal$Downloader$$checksumHeader;
    }

    public void coursier$cache$internal$Downloader$$readFullyTo(InputStream in, OutputStream out, CacheLogger logger, String url, long alreadyDownloaded, int bufferSize) {
        byte[] b = (byte[])Array$.MODULE$.fill(bufferSize, () -> 0, ClassTag$.MODULE$.Byte());
        this.helper$1(alreadyDownloaded, in, b, out, logger, url);
    }

    public <T> Either<ArtifactError, T> coursier$cache$internal$Downloader$$downloading(String url, File file, int sslRetry, Function0<Either<ArtifactError, T>> f) {
        return this.helper$2(sslRetry, url, f);
    }

    public Either<ArtifactError, Option<Object>> coursier$cache$internal$Downloader$$contentLength(String url, Option<Authentication> authentication, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Seq<DirectCredentials> credentials, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, CacheLogger logger, Option<Object> maxRedirectionsOpt) {
        Left<ArtifactError, Option<Object>> left;
        block10: {
            URLConnection conn = null;
            try {
                Either either;
                URLConnection uRLConnection = conn = ConnectionBuilder$.MODULE$.apply(url).withAuthentication(authentication).withFollowHttpToHttpsRedirections(followHttpToHttpsRedirections).withFollowHttpsToHttpRedirections(followHttpsToHttpRedirections).withAutoCredentials(credentials).withSslSocketFactoryOpt(sslSocketFactoryOpt).withHostnameVerifierOpt(hostnameVerifierOpt).withMethod("HEAD").withMaxRedirectionsOpt(maxRedirectionsOpt).connection();
                if (uRLConnection instanceof HttpURLConnection) {
                    Right right;
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    logger.gettingLength(url);
                    boolean success = false;
                    try {
                        Option<Object> len = new Some<Long>(BoxesRunTime.boxToLong(httpURLConnection.getContentLengthLong())).filter(x$26 -> x$26 >= 0L);
                        success = true;
                        logger.gettingLengthResult(url, len);
                        right = package$.MODULE$.Right().apply(len);
                    }
                    finally {
                        if (!success) {
                            logger.gettingLengthResult(url, None$.MODULE$);
                        }
                    }
                    either = right;
                } else {
                    either = package$.MODULE$.Left().apply(new ArtifactError.DownloadError(new StringBuilder(42).append("Cannot do HEAD request with connection ").append(uRLConnection).append(" (").append(url).append(")").toString(), None$.MODULE$));
                }
                left = either;
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    CacheUrl$.MODULE$.closeConn(conn);
                }
                throw throwable;
            }
            if (conn == null) break block10;
            CacheUrl$.MODULE$.closeConn(conn);
        }
        return left;
    }

    public <F> Downloader<F> apply(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int bufferSize, Sync<F> S) {
        return new Downloader<F>(artifact, cachePolicy, location, actualChecksums, allCredentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, bufferSize, S);
    }

    private final void helper$1(long count, InputStream in$1, byte[] b$1, OutputStream out$1, CacheLogger logger$2, String url$9) {
        int read;
        while ((read = in$1.read(b$1)) >= 0) {
            out$1.write(b$1, 0, read);
            out$1.flush();
            logger$2.downloadProgress(url$9, count + (long)read);
            count += (long)read;
        }
    }

    private final Either helper$2(int retry, String url$10, Function0 f$1) {
        Either res;
        Option option;
        block8: {
            while (true) {
                Option resOpt;
                Option option2;
                try {
                    Option res0 = CacheLocks$.MODULE$.withUrlLock(url$10, (Function0<Either> & Serializable)() -> {
                        Left left;
                        try {
                            left = (Left)f$1.apply();
                        }
                        catch (Throwable throwable) {
                            FileNotFoundException fileNotFoundException;
                            Throwable throwable2 = throwable;
                            if (!(throwable2 instanceof FileNotFoundException) || (fileNotFoundException = (FileNotFoundException)throwable2).getMessage() == null) {
                                throw throwable;
                            }
                            Left left2 = package$.MODULE$.Left().apply(new ArtifactError.NotFound(fileNotFoundException.getMessage(), ArtifactError$NotFound$.MODULE$.$lessinit$greater$default$2()));
                            left = left2;
                        }
                        return left;
                    });
                    Either res2 = (Either)res0.getOrElse((Function0<Left> & Serializable)() -> package$.MODULE$.Left().apply(new ArtifactError.ConcurrentDownload(url$10)));
                    option2 = new Some<Either>(res2);
                }
                catch (Throwable throwable) {
                    Option<Throwable> option3;
                    Option option4;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof SSLException && retry >= 1) {
                        option4 = None$.MODULE$;
                    } else if (throwable2 != null && !(option3 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable e = option3.get();
                        ArtifactError.DownloadError ex = new ArtifactError.DownloadError(new StringBuilder(26).append("Caught ").append(e).append(Option$.MODULE$.apply(e.getMessage()).fold((Function0<String> & Serializable)() -> "", (Function1<String, String> & Serializable)x$25 -> new StringBuilder(3).append(" (").append((String)x$25).append(")").toString())).append(" while downloading ").append(url$10).toString(), new Some<Throwable>(e));
                        if (Boolean.getBoolean("bloop.shaded.coursierapi.shaded.coursier.cache.throw-exceptions")) {
                            throw ex;
                        }
                        option4 = new Some(package$.MODULE$.Left().apply(ex));
                    } else {
                        throw throwable;
                    }
                    option2 = option4;
                }
                option = resOpt = option2;
                if (option instanceof Some) break block8;
                if (!None$.MODULE$.equals(option)) break;
                --retry;
            }
            throw new MatchError(option);
        }
        Option option5 = option;
        Either either = res = (Either)((Some)option5).value();
        return either;
    }

    private Downloader$() {
    }
}

