/*
 * Decompiled with CFR 0.152.
 */
package bloop.shaded.coursierapi.shaded.coursier.error;

import bloop.shaded.coursierapi.shaded.coursier.core.Dependency;
import bloop.shaded.coursierapi.shaded.coursier.core.Module;
import bloop.shaded.coursierapi.shaded.coursier.core.Parse$;
import bloop.shaded.coursierapi.shaded.coursier.core.Resolution;
import bloop.shaded.coursierapi.shaded.coursier.core.Version;
import bloop.shaded.coursierapi.shaded.coursier.core.Version$;
import bloop.shaded.coursierapi.shaded.coursier.core.VersionConstraint;
import bloop.shaded.coursierapi.shaded.coursier.core.compatibility.package$;
import bloop.shaded.coursierapi.shaded.coursier.error.CoursierError;
import bloop.shaded.coursierapi.shaded.coursier.error.ResolutionError$;
import bloop.shaded.coursierapi.shaded.coursier.error.ResolutionError$Simple$;
import bloop.shaded.coursierapi.shaded.coursier.error.conflict.UnsatisfiedRule;
import bloop.shaded.coursierapi.shaded.coursier.graph.ReverseModuleTree;
import bloop.shaded.coursierapi.shaded.coursier.graph.ReverseModuleTree$;
import bloop.shaded.coursierapi.shaded.coursier.params.rule.Rule;
import bloop.shaded.coursierapi.shaded.coursier.util.Print;
import bloop.shaded.coursierapi.shaded.coursier.util.Print$;
import bloop.shaded.coursierapi.shaded.coursier.util.Print$Colors$;
import bloop.shaded.coursierapi.shaded.coursier.util.Tree$;
import bloop.shaded.coursierapi.shaded.scala.Function0;
import bloop.shaded.coursierapi.shaded.scala.Function1;
import bloop.shaded.coursierapi.shaded.scala.Option;
import bloop.shaded.coursierapi.shaded.scala.Predef$;
import bloop.shaded.coursierapi.shaded.scala.Some;
import bloop.shaded.coursierapi.shaded.scala.Tuple2;
import bloop.shaded.coursierapi.shaded.scala.Tuple3;
import bloop.shaded.coursierapi.shaded.scala.collection.IterableOnceOps;
import bloop.shaded.coursierapi.shaded.scala.collection.IterableOps;
import bloop.shaded.coursierapi.shaded.scala.collection.SeqOps;
import bloop.shaded.coursierapi.shaded.scala.collection.immutable.Seq;
import bloop.shaded.coursierapi.shaded.scala.collection.immutable.Set;
import bloop.shaded.coursierapi.shaded.scala.math.Ordering$;
import bloop.shaded.coursierapi.shaded.scala.math.Ordering$Boolean$;
import bloop.shaded.coursierapi.shaded.scala.math.Ordering$String$;
import bloop.shaded.coursierapi.shaded.scala.runtime.BoxesRunTime;
import java.io.Serializable;

public abstract class ResolutionError
extends CoursierError {
    private final Resolution resolution;

    public Resolution resolution() {
        return this.resolution;
    }

    public ResolutionError(Resolution resolution, String message, Throwable cause) {
        this.resolution = resolution;
        super(message, cause);
    }

    public static final class CantDownloadModule
    extends Simple {
        private final Module module;
        private final String version;
        private final Seq<String> perRepositoryErrors;

        public CantDownloadModule(Resolution resolution, Module module, String version, Seq<String> perRepositoryErrors) {
            this.module = module;
            this.version = version;
            this.perRepositoryErrors = perRepositoryErrors;
            super(resolution, new StringBuilder(0).append(new StringBuilder(19).append("Error downloading ").append(module).append(":").append(version).toString()).append(System.lineSeparator()).append(((IterableOnceOps)perRepositoryErrors.map(new Serializable(){

                public final String apply(String x$1) {
                    return new StringBuilder(2).append("  ").append(x$1.replace(System.lineSeparator(), new StringBuilder(2).append("  ").append(System.lineSeparator()).toString())).toString();
                }
            })).mkString(System.lineSeparator())).toString(), ResolutionError$Simple$.MODULE$.$lessinit$greater$default$3());
        }
    }

    public static final class ConflictingDependencies
    extends Simple {
        private final Set<Dependency> dependencies;

        public ConflictingDependencies(Resolution resolution, Set<Dependency> dependencies) {
            this.dependencies = dependencies;
            Set roots = (Set)resolution.conflicts().map(new Serializable(){

                public final Module apply(Dependency x$2) {
                    return x$2.module();
                }
            });
            Seq<ReverseModuleTree> trees = ReverseModuleTree$.MODULE$.apply(resolution, (Seq)roots.toVector().sortBy((Function1)((Object)new Serializable(){

                public final Tuple3<String, String, String> apply(Module m) {
                    return new Tuple3<String, String, String>(m.organization(), m.name(), m.nameWithAttributes());
                }
            }), Ordering$.MODULE$.Tuple3(Ordering$String$.MODULE$, Ordering$String$.MODULE$, Ordering$String$.MODULE$)), ReverseModuleTree$.MODULE$.apply$default$3());
            Print.Colors colors0 = Print$Colors$.MODULE$.get(package$.MODULE$.coloredOutput());
            Seq renderedTrees = (Seq)trees.map(new Serializable(colors0){
                private final Print.Colors colors0$1;

                public final String apply(ReverseModuleTree t) {
                    String rendered = Tree$.MODULE$.apply(t.dependees().toVector(), (Function1<ReverseModuleTree, Seq> & Serializable)x$3 -> x$3.dependees()).customRender(false, "  ", new Some<String>(""), (Function1<ReverseModuleTree, String> & Serializable)node -> {
                        String string;
                        if (node.excludedDependsOn()) {
                            string = new StringBuilder(15).append($this.colors0$1.yellow()).append("(excluded by)").append($this.colors0$1.reset()).append(" ").append(node.module()).append(":").append(node.reconciledVersion()).toString();
                        } else {
                            Module module = node.dependsOnModule();
                            Module module2 = t.module();
                            if (!(module != null ? !((Object)module).equals(module2) : module2 != null)) {
                                boolean assumeCompatibleVersions = Print$.MODULE$.compatibleVersions(node.dependsOnVersion(), node.dependsOnReconciledVersion());
                                string = new StringBuilder(0).append(new StringBuilder(2).append(node.module()).append(":").append(node.reconciledVersion()).append(" ").toString()).append((Object)(assumeCompatibleVersions ? $this.colors0$1.yellow() : $this.colors0$1.red())).append(new StringBuilder(6).append("wants ").append(node.dependsOnVersion()).toString()).append($this.colors0$1.reset()).toString();
                            } else {
                                String string2 = node.dependsOnVersion();
                                String string3 = node.dependsOnReconciledVersion();
                                if (string2 == null ? string3 != null : !string2.equals(string3)) {
                                    boolean assumeCompatibleVersions = Print$.MODULE$.compatibleVersions(node.dependsOnVersion(), node.dependsOnReconciledVersion());
                                    string = new StringBuilder(0).append(new StringBuilder(2).append(node.module()).append(":").append(node.reconciledVersion()).append(" ").toString()).append((Object)(assumeCompatibleVersions ? $this.colors0$1.yellow() : $this.colors0$1.red())).append(new StringBuilder(7).append("wants ").append(node.dependsOnModule()).append(":").append(node.dependsOnVersion()).toString()).append($this.colors0$1.reset()).toString();
                                } else {
                                    string = new StringBuilder(1).append(node.module()).append(":").append(node.reconciledVersion()).toString();
                                }
                            }
                        }
                        return string;
                    });
                    Seq dependeesWantVersions = (Seq)((IterableOps)((SeqOps)((IterableOps)((SeqOps)t.dependees().map((Function1<ReverseModuleTree, String> & Serializable)x$4 -> x$4.dependsOnVersion())).distinct()).map((Function1<String, Tuple2> & Serializable)ver -> {
                        VersionConstraint constraint = Parse$.MODULE$.versionConstraint((String)ver);
                        Version sortWith = (Version)constraint.preferred().headOption().orElse((Function0<Option> & Serializable)() -> constraint.interval().from()).getOrElse((Function0<Version> & Serializable)() -> Version$.MODULE$.apply(""));
                        return new Tuple2<Tuple2<Boolean, Version>, String>(new Tuple2<Boolean, Version>(BoxesRunTime.boxToBoolean(constraint.preferred().isEmpty()), sortWith), (String)ver);
                    })).sortBy((Function1<Tuple2, Tuple2> & Serializable)x$5 -> (Tuple2)x$5._1(), Ordering$.MODULE$.Tuple2(Ordering$Boolean$.MODULE$, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())))).map((Function1<Tuple2, String> & Serializable)x$6 -> (String)x$6._2());
                    return new StringBuilder(0).append(new StringBuilder(11).append(t.module().repr()).append(":").append(dependeesWantVersions.mkString(" or ")).append(" wanted by").toString()).append(System.lineSeparator()).append(System.lineSeparator()).append(rendered).append(System.lineSeparator()).toString();
                }
                {
                    this.colors0$1 = colors0$1;
                }
            });
            super(resolution, new StringBuilder(25).append("Conflicting dependencies:").append(System.lineSeparator()).append(renderedTrees.mkString(System.lineSeparator())).toString(), ResolutionError$Simple$.MODULE$.$lessinit$greater$default$3());
        }
    }

    public static final class MaximumIterationReached
    extends Simple {
        public MaximumIterationReached(Resolution resolution) {
            super(resolution, "Maximum number of iterations reached", ResolutionError$Simple$.MODULE$.$lessinit$greater$default$3());
        }
    }

    public static final class Several
    extends ResolutionError {
        private final Simple head;
        private final Seq<Simple> tail;

        public Simple head() {
            return this.head;
        }

        public Seq<Simple> tail() {
            return this.tail;
        }

        public Several(Simple head, Seq<Simple> tail) {
            this.head = head;
            this.tail = tail;
            Simple simple = head;
            super(head.resolution(), ((IterableOnceOps)((IterableOps)tail.$plus$colon(simple)).map(new Serializable(){

                public final String apply(Simple x$7) {
                    return x$7.getMessage();
                }
            })).mkString(System.lineSeparator()), ResolutionError$.MODULE$.$lessinit$greater$default$3());
        }
    }

    public static abstract class Simple
    extends ResolutionError {
        public Simple(Resolution resolution, String message, Throwable cause) {
            super(resolution, message, cause);
        }
    }

    public static abstract class UnsatisfiableRule
    extends Simple {
        private final Rule rule;
        private final UnsatisfiedRule conflict;

        public UnsatisfiableRule(Resolution resolution, Rule rule, UnsatisfiedRule conflict, String message) {
            this.rule = rule;
            this.conflict = conflict;
            super(resolution, message, conflict);
        }
    }
}

