/*
 * Decompiled with CFR 0.152.
 */
package bloop.bloopgun.util;

import bloop.bloopgun.core.AvailableAtPath;
import bloop.bloopgun.core.LocatedServer;
import bloop.bloopgun.util.GlobalSettings;
import bloop.bloopgun.util.GlobalSettings$;
import bloop.shaded.snailgun.logging.Logger;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Properties$;
import scala.util.control.NonFatal$;

public final class Environment$ {
    public static Environment$ MODULE$;
    private final boolean isWindows;
    private final boolean isCygwin;
    private final List<String> PerformanceSensitiveOptsForBloop;

    static {
        new Environment$();
    }

    public final boolean isWindows() {
        return this.isWindows;
    }

    public final boolean isCygwin() {
        return this.isCygwin;
    }

    public Path cwd() {
        return Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    public Path homeDirectory() {
        return Paths.get(System.getProperty("user.home"), new String[0]);
    }

    public Path defaultBloopDirectory() {
        return this.homeDirectory().resolve(".bloop");
    }

    public Path bloopGlobalSettingsPath() {
        return this.defaultBloopDirectory().resolve("bloop.json");
    }

    public Either<String, GlobalSettings> bloopGlobalSettings(Logger logger) {
        return Files.isReadable(this.bloopGlobalSettingsPath()) ? GlobalSettings$.MODULE$.readFromFile(this.bloopGlobalSettingsPath(), logger) : package$.MODULE$.Right().apply((Object)GlobalSettings$.MODULE$.default());
    }

    public Option<Path> executablePath() {
        Some some;
        try {
            some = new Some((Object)Paths.get(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public List<String> detectJvmOptionsForServer(LocatedServer server, List<String> serverArgs, Logger logger) {
        Nil$ nil$;
        List jvmServerArgs = (List)serverArgs.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("-J")));
        List jvmOptionsFromHome = Environment$.readJvmOptsFile$1(this.defaultBloopDirectory().resolve(".jvmopts"), logger);
        LocatedServer locatedServer = server;
        if (locatedServer instanceof AvailableAtPath) {
            AvailableAtPath availableAtPath = (AvailableAtPath)locatedServer;
            Path binary = availableAtPath.binary();
            nil$ = Environment$.readJvmOptsFile$1(binary.getParent().resolve(".jvmopts"), logger);
        } else {
            nil$ = Nil$.MODULE$;
        }
        Nil$ jvmOptionsFromPathNextToBinary = nil$;
        return (List)((List)((List)jvmOptionsFromHome.$plus$plus((GenTraversableOnce)jvmOptionsFromPathNextToBinary, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)jvmServerArgs, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> new StringOps(Predef$.MODULE$.augmentString(x$2)).stripPrefix("-J"), List$.MODULE$.canBuildFrom());
    }

    public List<String> PerformanceSensitiveOptsForBloop() {
        return this.PerformanceSensitiveOptsForBloop;
    }

    private static final List readJvmOptsFile$1(Path jvmOptsFile, Logger logger$1) {
        Nil$ nil$;
        if (!Files.isReadable(jvmOptsFile)) {
            if (Files.exists(jvmOptsFile, new LinkOption[0])) {
                logger$1.error(new StringBuilder(19).append("Ignored unreadable ").append(jvmOptsFile.toAbsolutePath()).toString());
            }
            nil$ = Nil$.MODULE$;
        } else {
            String contents = new String(Files.readAllBytes(jvmOptsFile), StandardCharsets.UTF_8);
            nil$ = new StringOps(Predef$.MODULE$.augmentString(contents)).linesIterator().toList();
        }
        return nil$;
    }

    private Environment$() {
        boolean bl;
        MODULE$ = this;
        this.isWindows = Properties$.MODULE$.isWin();
        Option option = Option$.MODULE$.apply((Object)System.getenv("OSTYPE"));
        if (option instanceof Some) {
            Some some = (Some)option;
            String x = (String)some.value();
            bl = x.toLowerCase(Locale.ENGLISH).contains("cygwin");
        } else {
            bl = false;
        }
        this.isCygwin = bl;
        this.PerformanceSensitiveOptsForBloop = new .colon.colon((Object)"-Xss4m", (List)new .colon.colon((Object)"-XX:MaxInlineLevel=20", (List)new .colon.colon((Object)"-XX:+UseParallelGC", (List)Nil$.MODULE$)));
    }
}

