/*
 * Decompiled with CFR 0.152.
 */
package bloop.shaded.coursierapi.shaded.coursier.cache.internal;

import bloop.shaded.coursierapi.shaded.coursier.cache.ArtifactError;
import bloop.shaded.coursierapi.shaded.coursier.cache.ArtifactError$NotFound$;
import bloop.shaded.coursierapi.shaded.coursier.cache.CacheLogger;
import bloop.shaded.coursierapi.shaded.coursier.cache.CachePolicy;
import bloop.shaded.coursierapi.shaded.coursier.cache.CachePolicy$FetchMissing$;
import bloop.shaded.coursierapi.shaded.coursier.cache.CachePolicy$ForceDownload$;
import bloop.shaded.coursierapi.shaded.coursier.cache.CachePolicy$LocalOnly$;
import bloop.shaded.coursierapi.shaded.coursier.cache.CachePolicy$LocalOnlyIfValid$;
import bloop.shaded.coursierapi.shaded.coursier.cache.CachePolicy$LocalUpdate$;
import bloop.shaded.coursierapi.shaded.coursier.cache.CachePolicy$LocalUpdateChanging$;
import bloop.shaded.coursierapi.shaded.coursier.cache.CachePolicy$Update$;
import bloop.shaded.coursierapi.shaded.coursier.cache.CachePolicy$UpdateChanging$;
import bloop.shaded.coursierapi.shaded.coursier.cache.FileCache$;
import bloop.shaded.coursierapi.shaded.coursier.cache.internal.DownloadResult;
import bloop.shaded.coursierapi.shaded.coursier.cache.internal.DownloadResult$;
import bloop.shaded.coursierapi.shaded.coursier.cache.internal.Downloader$Blocking$;
import bloop.shaded.coursierapi.shaded.coursier.core.Authentication;
import bloop.shaded.coursierapi.shaded.coursier.credentials.DirectCredentials;
import bloop.shaded.coursierapi.shaded.coursier.paths.Util;
import bloop.shaded.coursierapi.shaded.coursier.util.Artifact;
import bloop.shaded.coursierapi.shaded.coursier.util.EitherT;
import bloop.shaded.coursierapi.shaded.coursier.util.Monad$ops$;
import bloop.shaded.coursierapi.shaded.coursier.util.Sync;
import bloop.shaded.coursierapi.shaded.scala.Array$;
import bloop.shaded.coursierapi.shaded.scala.Function0;
import bloop.shaded.coursierapi.shaded.scala.Function1;
import bloop.shaded.coursierapi.shaded.scala.MatchError;
import bloop.shaded.coursierapi.shaded.scala.None$;
import bloop.shaded.coursierapi.shaded.scala.Option;
import bloop.shaded.coursierapi.shaded.scala.Option$;
import bloop.shaded.coursierapi.shaded.scala.Predef$;
import bloop.shaded.coursierapi.shaded.scala.Product;
import bloop.shaded.coursierapi.shaded.scala.Some;
import bloop.shaded.coursierapi.shaded.scala.collection.Iterator;
import bloop.shaded.coursierapi.shaded.scala.collection.StringOps$;
import bloop.shaded.coursierapi.shaded.scala.collection.immutable.Seq;
import bloop.shaded.coursierapi.shaded.scala.collection.immutable.Seq$;
import bloop.shaded.coursierapi.shaded.scala.concurrent.duration.Duration;
import bloop.shaded.coursierapi.shaded.scala.package$;
import bloop.shaded.coursierapi.shaded.scala.runtime.BoxedUnit;
import bloop.shaded.coursierapi.shaded.scala.runtime.BoxesRunTime;
import bloop.shaded.coursierapi.shaded.scala.runtime.ScalaRunTime$;
import bloop.shaded.coursierapi.shaded.scala.runtime.Statics;
import bloop.shaded.coursierapi.shaded.scala.util.Either;
import bloop.shaded.coursierapi.shaded.scala.util.Left;
import bloop.shaded.coursierapi.shaded.scala.util.Right;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public final class Downloader<F>
implements Serializable,
Product {
    private Option<File> referenceFileOpt;
    private volatile Downloader<F> Blocking$module;
    private final Artifact artifact;
    private final CachePolicy cachePolicy;
    private final File location;
    private final Seq<String> actualChecksums;
    private final F allCredentials;
    private final CacheLogger logger;
    private final ExecutorService pool;
    private final Option<Duration> ttl;
    private final boolean localArtifactsShouldBeCached;
    private final boolean followHttpToHttpsRedirections;
    private final boolean followHttpsToHttpRedirections;
    private final Option<Object> maxRedirections;
    private final int sslRetry;
    private final Option<SSLSocketFactory> sslSocketFactoryOpt;
    private final Option<HostnameVerifier> hostnameVerifierOpt;
    private final int bufferSize;
    private final Sync<F> S;
    private final boolean cacheErrors;
    private final CachePolicy.Mixed actualCachePolicy;
    private volatile boolean bitmap$0;

    @Override
    public Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    public Downloader<F> coursier$cache$internal$Downloader$$Blocking() {
        if (this.Blocking$module == null) {
            this.Blocking$lzycompute$1();
        }
        return this.Blocking$module;
    }

    public Artifact artifact() {
        return this.artifact;
    }

    public CachePolicy cachePolicy() {
        return this.cachePolicy;
    }

    public File location() {
        return this.location;
    }

    public Seq<String> actualChecksums() {
        return this.actualChecksums;
    }

    public F allCredentials() {
        return this.allCredentials;
    }

    public CacheLogger logger() {
        return this.logger;
    }

    public ExecutorService pool() {
        return this.pool;
    }

    public Option<Duration> ttl() {
        return this.ttl;
    }

    public boolean localArtifactsShouldBeCached() {
        return this.localArtifactsShouldBeCached;
    }

    public boolean followHttpToHttpsRedirections() {
        return this.followHttpToHttpsRedirections;
    }

    public boolean followHttpsToHttpRedirections() {
        return this.followHttpsToHttpRedirections;
    }

    public Option<Object> maxRedirections() {
        return this.maxRedirections;
    }

    public int sslRetry() {
        return this.sslRetry;
    }

    public Option<SSLSocketFactory> sslSocketFactoryOpt() {
        return this.sslSocketFactoryOpt;
    }

    public Option<HostnameVerifier> hostnameVerifierOpt() {
        return this.hostnameVerifierOpt;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public Sync<F> S() {
        return this.S;
    }

    private <T> F blockingIO(Function0<T> f) {
        return this.S().schedule(this.pool(), f);
    }

    private <T> EitherT<F, ArtifactError, T> blockingIOE(Function0<Either<ArtifactError, T>> f) {
        return new EitherT(this.S().schedule(this.pool(), f));
    }

    private File localFile(String url, Option<String> user) {
        return FileCache$.MODULE$.localFile0(url, this.location(), user, this.localArtifactsShouldBeCached());
    }

    private Option<File> referenceFileOpt$lzycompute() {
        Downloader downloader = this;
        synchronized (downloader) {
            if (!this.bitmap$0) {
                this.referenceFileOpt = this.artifact().extra().get("metadata").map((Function1<Artifact, File> & Serializable)a -> this.localFile(a.url(), a.authentication().map((Function1<Authentication, String> & Serializable)x$1 -> x$1.user())));
                this.bitmap$0 = true;
            }
        }
        return this.referenceFileOpt;
    }

    private Option<File> referenceFileOpt() {
        return !this.bitmap$0 ? this.referenceFileOpt$lzycompute() : this.referenceFileOpt;
    }

    private boolean cacheErrors() {
        return this.cacheErrors;
    }

    private boolean cacheErrors0() {
        return this.cacheErrors() || this.referenceFileOpt().exists((Function1<File, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.exists()));
    }

    private F urlLastModified(String url, Option<Object> currentLastModifiedOpt, CacheLogger logger) {
        return Monad$ops$.MODULE$.toAllMonadOps(this.allCredentials(), this.S()).flatMap((Function1<Seq, Object> & Serializable)allCredentials0 -> this.blockingIO((Function0<Either> & Serializable)() -> this.coursier$cache$internal$Downloader$$Blocking().urlLastModified(url, currentLastModifiedOpt, logger, (Seq<DirectCredentials>)allCredentials0)));
    }

    public File coursier$cache$internal$Downloader$$ttlFile(File file) {
        return new File(file.getParent(), new StringBuilder(9).append(".").append(file.getName()).append(".checked").toString());
    }

    private EitherT<F, ArtifactError, Object> shouldDownload(File file, String url, boolean checkRemote) {
        return this.blockingIOE((Function0<Either> & Serializable)() -> this.checkErrFile$1(file, url)).flatMap((Function1<BoxedUnit, EitherT> & Serializable)x$16 -> {
            BoxedUnit boxedUnit = x$16;
            EitherT eitherT = new EitherT(this.checkShouldDownload$1(file, checkRemote, url)).map((Function1<Object, Object> & Serializable)res -> BoxesRunTime.boxToBoolean(BoxesRunTime.unboxToBoolean(res)), this.S());
            return eitherT;
        }, this.S());
    }

    private F remote(File file, String url, boolean keepHeaderChecksums) {
        return Monad$ops$.MODULE$.toAllMonadOps(this.allCredentials(), this.S()).flatMap((Function1<Seq, Object> & Serializable)allCredentials0 -> this.blockingIO((Function0<Either> & Serializable)() -> this.coursier$cache$internal$Downloader$$Blocking().remote(file, url, keepHeaderChecksums, (Seq<DirectCredentials>)allCredentials0)));
    }

    private File errFile(File file) {
        return new File(file.getParentFile(), new StringBuilder(7).append(".").append(file.getName()).append(".error").toString());
    }

    private F remoteKeepErrors(File file, String url, boolean keepHeaderChecksums) {
        File errFile0 = this.errFile(file);
        return Monad$ops$.MODULE$.toAllMonadOps(this.remote(file, url, keepHeaderChecksums), this.S()).flatMap((Function1<Either, Object> & Serializable)e -> this.blockingIO((Function0<Either> & Serializable)() -> {
            Either either;
            ArtifactError.NotFound notFound;
            Left left;
            ArtifactError nf;
            Either either2 = e;
            if (either2 instanceof Left && (nf = (ArtifactError)(left = (Left)either2).value()) instanceof ArtifactError.NotFound && (notFound = (ArtifactError.NotFound)nf).permanent().contains(BoxesRunTime.boxToBoolean(true))) {
                this.createErrFileBlocking$1(errFile0);
                either = left;
            } else {
                Downloader.deleteErrFileBlocking$1(errFile0);
                either = either2;
            }
            return either;
        }));
    }

    private F checkFileExists(File file, String url, boolean log) {
        return this.blockingIO((Function0<Either> & Serializable)() -> {
            Either either;
            if (file.exists()) {
                this.logger().foundLocally(url);
                either = package$.MODULE$.Right().apply(BoxedUnit.UNIT);
            } else {
                either = package$.MODULE$.Left().apply(new ArtifactError.NotFound(file.toString(), ArtifactError$NotFound$.MODULE$.$lessinit$greater$default$2()));
            }
            return either;
        });
    }

    private boolean checkFileExists$default$3() {
        return true;
    }

    private CachePolicy.Mixed actualCachePolicy() {
        return this.actualCachePolicy;
    }

    private F downloadUrl(String url, boolean keepHeaderChecksums) {
        this.logger().checkingArtifact(url, this.artifact());
        File file = this.localFile(url, this.artifact().authentication().map((Function1<Authentication, String> & Serializable)x$17 -> x$17.user()));
        Object run0 = this.artifact().changing() && !this.cachePolicy().acceptsChangingArtifacts() ? this.S().point(package$.MODULE$.Left().apply(new ArtifactError.ForbiddenChangingArtifact(url))) : this.run$1(url, file, keepHeaderChecksums);
        return Monad$ops$.MODULE$.toAllMonadOps(run0, this.S()).map((Function1<Either, DownloadResult> & Serializable)e -> DownloadResult$.MODULE$.apply(url, file, e.left().toOption()));
    }

    public F download() {
        F mainTask = this.downloadUrl(this.artifact().url(), true);
        return Monad$ops$.MODULE$.toAllMonadOps(mainTask, this.S()).flatMap((Function1<DownloadResult, Object> & Serializable)r -> {
            Object f;
            if (r.errorOpt().isEmpty()) {
                Seq l2 = (Seq)this.actualChecksums().map((Function1<String, Object> & Serializable)c -> {
                    File candidate = FileCache$.MODULE$.auxiliaryFile(r.file(), (String)c);
                    return Monad$ops$.MODULE$.toAllMonadOps(this.blockingIO(() -> candidate.exists()), this.S()).map((Function1<Object, Seq> & Serializable)x0$1 -> Downloader.$anonfun$download$5(this, c, candidate, BoxesRunTime.unboxToBoolean(x0$1)));
                });
                f = Monad$ops$.MODULE$.toAllMonadOps(this.S().gather(l2), this.S()).flatMap((Function1<Seq, Object> & Serializable)l -> this.S().gather((Seq)l.flatten(Predef$.MODULE$.$conforms())));
            } else {
                Seq l3 = (Seq)this.actualChecksums().flatMap((Function1<String, Seq> & Serializable)c -> this.checksumRes$1((String)c));
                f = this.S().gather(l3);
            }
            Object l0 = f;
            return Monad$ops$.MODULE$.toAllMonadOps(l0, this.S()).map((Function1<Seq, Seq> & Serializable)x$24 -> {
                DownloadResult downloadResult = r;
                return (Seq)x$24.$plus$colon(downloadResult);
            });
        });
    }

    public String toString() {
        StringBuilder b = new StringBuilder("Downloader(");
        b.append(String.valueOf(this.artifact()));
        b.append(", ");
        b.append(String.valueOf(this.cachePolicy()));
        b.append(", ");
        b.append(String.valueOf(this.location()));
        b.append(", ");
        b.append(String.valueOf(this.actualChecksums()));
        b.append(", ");
        b.append(String.valueOf(this.allCredentials()));
        b.append(", ");
        b.append(String.valueOf(this.logger()));
        b.append(", ");
        b.append(String.valueOf(this.pool()));
        b.append(", ");
        b.append(String.valueOf(this.ttl()));
        b.append(", ");
        b.append(String.valueOf(this.localArtifactsShouldBeCached()));
        b.append(", ");
        b.append(String.valueOf(this.followHttpToHttpsRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.followHttpsToHttpRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.maxRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.sslRetry()));
        b.append(", ");
        b.append(String.valueOf(this.sslSocketFactoryOpt()));
        b.append(", ");
        b.append(String.valueOf(this.hostnameVerifierOpt()));
        b.append(", ");
        b.append(String.valueOf(this.bufferSize()));
        b.append(", ");
        b.append(String.valueOf(this.S()));
        b.append(")");
        return b.toString();
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof Downloader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        Downloader other = (Downloader)obj;
        if (!true) return false;
        Artifact artifact = this.artifact();
        Artifact artifact2 = other.artifact();
        if (artifact == null) {
            if (artifact2 != null) {
                return false;
            }
        } else if (!((Object)artifact).equals(artifact2)) return false;
        CachePolicy cachePolicy = this.cachePolicy();
        CachePolicy cachePolicy2 = other.cachePolicy();
        if (cachePolicy == null) {
            if (cachePolicy2 != null) {
                return false;
            }
        } else if (!cachePolicy.equals(cachePolicy2)) return false;
        File file = this.location();
        File file2 = other.location();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        Seq<String> seq = this.actualChecksums();
        Seq<String> seq2 = other.actualChecksums();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!BoxesRunTime.equals(this.allCredentials(), other.allCredentials())) return false;
        CacheLogger cacheLogger = this.logger();
        CacheLogger cacheLogger2 = other.logger();
        if (cacheLogger == null) {
            if (cacheLogger2 != null) {
                return false;
            }
        } else if (!cacheLogger.equals(cacheLogger2)) return false;
        ExecutorService executorService = this.pool();
        ExecutorService executorService2 = other.pool();
        if (executorService == null) {
            if (executorService2 != null) {
                return false;
            }
        } else if (!executorService.equals(executorService2)) return false;
        Option<Duration> option = this.ttl();
        Option<Duration> option2 = other.ttl();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.localArtifactsShouldBeCached() != other.localArtifactsShouldBeCached()) return false;
        if (this.followHttpToHttpsRedirections() != other.followHttpToHttpsRedirections()) return false;
        if (this.followHttpsToHttpRedirections() != other.followHttpsToHttpRedirections()) return false;
        Option<Object> option3 = this.maxRedirections();
        Option<Object> option4 = other.maxRedirections();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (this.sslRetry() != other.sslRetry()) return false;
        Option<SSLSocketFactory> option5 = this.sslSocketFactoryOpt();
        Option<SSLSocketFactory> option6 = other.sslSocketFactoryOpt();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        Option<HostnameVerifier> option7 = this.hostnameVerifierOpt();
        Option<HostnameVerifier> option8 = other.hostnameVerifierOpt();
        if (option7 == null) {
            if (option8 != null) {
                return false;
            }
        } else if (!option7.equals(option8)) return false;
        if (this.bufferSize() != other.bufferSize()) return false;
        Sync<F> sync = this.S();
        Sync<F> sync2 = other.S();
        if (sync == null) {
            if (sync2 == null) return true;
            return false;
        } else {
            if (!sync.equals(sync2)) return false;
            return true;
        }
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash("Downloader");
        code = 37 * code + Statics.anyHash(this.artifact());
        code = 37 * code + Statics.anyHash(this.cachePolicy());
        code = 37 * code + Statics.anyHash(this.location());
        code = 37 * code + Statics.anyHash(this.actualChecksums());
        code = 37 * code + Statics.anyHash(this.allCredentials());
        code = 37 * code + Statics.anyHash(this.logger());
        code = 37 * code + Statics.anyHash(this.pool());
        code = 37 * code + Statics.anyHash(this.ttl());
        code = 37 * code + (this.localArtifactsShouldBeCached() ? 1231 : 1237);
        code = 37 * code + (this.followHttpToHttpsRedirections() ? 1231 : 1237);
        code = 37 * code + (this.followHttpsToHttpRedirections() ? 1231 : 1237);
        code = 37 * code + Statics.anyHash(this.maxRedirections());
        code = 37 * code + this.sslRetry();
        code = 37 * code + Statics.anyHash(this.sslSocketFactoryOpt());
        code = 37 * code + Statics.anyHash(this.hostnameVerifierOpt());
        code = 37 * code + this.bufferSize();
        code = 37 * code + Statics.anyHash(this.S());
        return 37 * code;
    }

    @Override
    public String productPrefix() {
        return "Downloader";
    }

    @Override
    public int productArity() {
        return 17;
    }

    @Override
    public Object productElement(int n) {
        Serializable serializable;
        int n2 = n;
        switch (n2) {
            case 0: {
                serializable = this.artifact();
                break;
            }
            case 1: {
                serializable = this.cachePolicy();
                break;
            }
            case 2: {
                serializable = this.location();
                break;
            }
            case 3: {
                serializable = this.actualChecksums();
                break;
            }
            case 4: {
                serializable = this.allCredentials();
                break;
            }
            case 5: {
                serializable = this.logger();
                break;
            }
            case 6: {
                serializable = this.pool();
                break;
            }
            case 7: {
                serializable = this.ttl();
                break;
            }
            case 8: {
                serializable = BoxesRunTime.boxToBoolean(this.localArtifactsShouldBeCached());
                break;
            }
            case 9: {
                serializable = BoxesRunTime.boxToBoolean(this.followHttpToHttpsRedirections());
                break;
            }
            case 10: {
                serializable = BoxesRunTime.boxToBoolean(this.followHttpsToHttpRedirections());
                break;
            }
            case 11: {
                serializable = this.maxRedirections();
                break;
            }
            case 12: {
                serializable = BoxesRunTime.boxToInteger(this.sslRetry());
                break;
            }
            case 13: {
                serializable = this.sslSocketFactoryOpt();
                break;
            }
            case 14: {
                serializable = this.hostnameVerifierOpt();
                break;
            }
            case 15: {
                serializable = BoxesRunTime.boxToInteger(this.bufferSize());
                break;
            }
            case 16: {
                serializable = this.S();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(n2)).toString());
            }
        }
        return serializable;
    }

    private final void Blocking$lzycompute$1() {
        Downloader downloader = this;
        synchronized (downloader) {
            if (this.Blocking$module == null) {
                this.Blocking$module = new Downloader$Blocking$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$shouldDownload$2(Duration x$14) {
        return !x$14.isFinite();
    }

    private final Either checkErrFile$1(File file$3, String url$5) {
        Either either;
        File errFile0 = this.errFile(file$3);
        if (this.referenceFileOpt().exists((Function1<File, Object> & Serializable)x$13 -> BoxesRunTime.boxToBoolean(x$13.exists())) && errFile0.exists()) {
            either = package$.MODULE$.Left().apply(new ArtifactError.NotFound(url$5, new Some<Object>(BoxesRunTime.boxToBoolean(true))));
        } else if (this.cacheErrors() && errFile0.exists()) {
            long ts = errFile0.lastModified();
            long now = System.currentTimeMillis();
            either = ts > 0L && (this.ttl().exists((Function1<Duration, Object> & Serializable)x$14 -> BoxesRunTime.boxToBoolean(Downloader.$anonfun$shouldDownload$2(x$14))) || now < ts + BoxesRunTime.unboxToLong(this.ttl().fold(() -> 0L, (Function1<Duration, Object> & Serializable)x$15 -> BoxesRunTime.boxToLong(x$15.toMillis())))) ? package$.MODULE$.Left().apply(new ArtifactError.NotFound(url$5, ArtifactError$NotFound$.MODULE$.$lessinit$greater$default$2())) : package$.MODULE$.Right().apply(BoxedUnit.UNIT);
        } else {
            either = package$.MODULE$.Right().apply(BoxedUnit.UNIT);
        }
        return either;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object checkNeeded$1(File file$3) {
        boolean bl = false;
        Some some = null;
        Option<Duration> option = this.ttl();
        if (None$.MODULE$.equals(option)) {
            return this.S().point(BoxesRunTime.boxToBoolean(true));
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Duration ttl = (Duration)some.value();
            if (!ttl.isFinite()) {
                return this.S().point(BoxesRunTime.boxToBoolean(false));
            }
        }
        if (!bl) throw new MatchError(option);
        Duration ttl = (Duration)some.value();
        return this.blockingIO(() -> BoxesRunTime.unboxToBoolean(this.coursier$cache$internal$Downloader$$Blocking().lastCheck(file$3).fold(() -> true, ts -> {
            long now = System.currentTimeMillis();
            return now > ts + ttl.toMillis();
        })));
    }

    public static final /* synthetic */ boolean $anonfun$shouldDownload$10(Option fileLastModOpt$1, Option urlLastModOpt) {
        Option<Object> fromDatesOpt = fileLastModOpt$1.flatMap((Function1<Object, Option> & Serializable)fileLastMod -> urlLastModOpt.map(urlLastMod -> fileLastMod < urlLastMod));
        return BoxesRunTime.unboxToBoolean(fromDatesOpt.getOrElse(() -> true));
    }

    private final EitherT doCheckRemote$1(File file$3, String url$5) {
        return this.blockingIOE((Function0<Either> & Serializable)() -> this.coursier$cache$internal$Downloader$$Blocking().fileLastModified(file$3)).flatMap((Function1<Option, EitherT> & Serializable)fileLastModOpt -> new EitherT(this.urlLastModified(url$5, (Option<Object>)fileLastModOpt, this.logger())).map((Function1<Option, Object> & Serializable)urlLastModOpt -> BoxesRunTime.boxToBoolean(Downloader.$anonfun$shouldDownload$10(fileLastModOpt, urlLastModOpt)), this.S()), this.S());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Object $anonfun$shouldDownload$16(Downloader $this, boolean checkRemote$1, File file$3, String url$5, boolean x0$2) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = x0$2;
        if (!bl3) {
            return $this.S().point(package$.MODULE$.Right().apply(BoxesRunTime.boxToBoolean(false)));
        }
        if (bl3) {
            bl = true;
            bl2 = bl3;
            if (!checkRemote$1) {
                return $this.S().point(package$.MODULE$.Right().apply(BoxesRunTime.boxToBoolean(true)));
            }
        }
        if (!bl) throw new MatchError(BoxesRunTime.boxToBoolean(bl3));
        if (!checkRemote$1) throw new MatchError(BoxesRunTime.boxToBoolean(bl3));
        return Monad$ops$.MODULE$.toAllMonadOps($this.doCheckRemote$1(file$3, url$5).run(), $this.S()).flatMap((Function1<Either, Object> & Serializable)x0$3 -> {
            Right right;
            boolean bl;
            Either either = x0$3;
            Object f = either instanceof Right && !(bl = BoxesRunTime.unboxToBoolean((right = (Right)either).value())) ? $this.blockingIO((Function0<Right> & Serializable)() -> {
                $this.coursier$cache$internal$Downloader$$Blocking().doTouchCheckFile(file$3, url$5, false);
                return package$.MODULE$.Right().apply(BoxesRunTime.boxToBoolean(false));
            }) : $this.S().point(either);
            return f;
        });
    }

    public static final /* synthetic */ Object $anonfun$shouldDownload$15(Downloader $this, boolean checkRemote$1, File file$3, String url$5, boolean x0$1) {
        Object f;
        boolean bl = x0$1;
        if (!bl) {
            f = $this.S().point(package$.MODULE$.Right().apply(BoxesRunTime.boxToBoolean(true)));
        } else if (bl) {
            f = Monad$ops$.MODULE$.toAllMonadOps($this.checkNeeded$1(file$3), $this.S()).flatMap((Function1<Object, Object> & Serializable)x0$2 -> Downloader.$anonfun$shouldDownload$16($this, checkRemote$1, file$3, url$5, BoxesRunTime.unboxToBoolean(x0$2)));
        } else {
            throw new MatchError(BoxesRunTime.boxToBoolean(bl));
        }
        return f;
    }

    private final Object checkShouldDownload$1(File file$3, boolean checkRemote$1, String url$5) {
        return Monad$ops$.MODULE$.toAllMonadOps(this.blockingIO(() -> file$3.exists()), this.S()).flatMap((Function1<Object, Object> & Serializable)x0$1 -> Downloader.$anonfun$shouldDownload$15(this, checkRemote$1, file$3, url$5, BoxesRunTime.unboxToBoolean(x0$1)));
    }

    private final Object createErrFileBlocking$1(File errFile0$1) {
        Object object;
        if (this.cacheErrors0()) {
            Path p = errFile0$1.toPath();
            Util.createDirectories(p.getParent());
            object = Files.write(p, Array$.MODULE$.emptyByteArray(), new OpenOption[0]);
        } else {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    private static final Object deleteErrFileBlocking$1(File errFile0$1) {
        return errFile0$1.exists() ? BoxesRunTime.boxToBoolean(errFile0$1.delete()) : BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$downloadUrl$3(BoxedUnit x$18) {
        BoxedUnit boxedUnit = x$18;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ EitherT $anonfun$downloadUrl$2(Downloader $this, File file$6, String url$8, boolean keepHeaderChecksums$3, boolean needsUpdate) {
        Object f = needsUpdate ? $this.remoteKeepErrors(file$6, url$8, keepHeaderChecksums$3) : $this.S().point(package$.MODULE$.Right().apply(BoxedUnit.UNIT));
        return new EitherT(f).map((Function1<BoxedUnit, Object> & Serializable)x$18 -> {
            Downloader.$anonfun$downloadUrl$3(x$18);
            return BoxedUnit.UNIT;
        }, $this.S());
    }

    private final EitherT maybeUpdate$1(File file$6, String url$8, boolean keepHeaderChecksums$3) {
        return this.shouldDownload(file$6, url$8, true).flatMap((Function1<Object, EitherT> & Serializable)needsUpdate -> Downloader.$anonfun$downloadUrl$2(this, file$6, url$8, keepHeaderChecksums$3, BoxesRunTime.unboxToBoolean(needsUpdate)), this.S());
    }

    public static final /* synthetic */ void $anonfun$downloadUrl$5(BoxedUnit x$19) {
        BoxedUnit boxedUnit = x$19;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$downloadUrl$8(BoxedUnit x$21) {
        BoxedUnit boxedUnit = x$21;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ EitherT $anonfun$downloadUrl$7(Downloader $this, File file$6, boolean needsUpdate) {
        Right e = needsUpdate ? package$.MODULE$.Left().apply(new ArtifactError.FileTooOldOrNotFound(file$6.toString())) : package$.MODULE$.Right().apply(BoxedUnit.UNIT);
        return new EitherT($this.S().point(e)).map((Function1<BoxedUnit, Object> & Serializable)x$21 -> {
            Downloader.$anonfun$downloadUrl$8(x$21);
            return BoxedUnit.UNIT;
        }, $this.S());
    }

    private final Object run$1(String url$8, File file$6, boolean keepHeaderChecksums$3) {
        F f;
        if (url$8.startsWith("file:/") && !this.localArtifactsShouldBeCached()) {
            f = this.checkFileExists(file$6, url$8, this.checkFileExists$default$3());
        } else {
            F f2;
            CachePolicy.Mixed mixed = this.actualCachePolicy();
            if (CachePolicy$LocalOnly$.MODULE$.equals(mixed)) {
                f2 = this.checkFileExists(file$6, url$8, this.checkFileExists$default$3());
            } else {
                boolean bl = CachePolicy$LocalUpdateChanging$.MODULE$.equals(mixed) ? true : CachePolicy$LocalUpdate$.MODULE$.equals(mixed);
                if (bl) {
                    EitherT e = new EitherT(this.checkFileExists(file$6, url$8, false)).flatMap((Function1<BoxedUnit, EitherT> & Serializable)x$20 -> {
                        BoxedUnit boxedUnit = x$20;
                        EitherT eitherT = this.maybeUpdate$1(file$6, url$8, keepHeaderChecksums$3).map((Function1<BoxedUnit, Object> & Serializable)x$19 -> {
                            Downloader.$anonfun$downloadUrl$5(x$19);
                            return BoxedUnit.UNIT;
                        }, this.S());
                        return eitherT;
                    }, this.S());
                    f2 = e.run();
                } else if (CachePolicy$LocalOnlyIfValid$.MODULE$.equals(mixed)) {
                    EitherT e = new EitherT(this.checkFileExists(file$6, url$8, false)).flatMap((Function1<BoxedUnit, EitherT> & Serializable)x$22 -> {
                        BoxedUnit boxedUnit = x$22;
                        EitherT eitherT = this.shouldDownload(file$6, url$8, false).flatMap((Function1<Object, EitherT> & Serializable)needsUpdate -> Downloader.$anonfun$downloadUrl$7(this, file$6, BoxesRunTime.unboxToBoolean(needsUpdate)), this.S());
                        return eitherT;
                    }, this.S());
                    f2 = e.run();
                } else {
                    boolean bl2 = CachePolicy$UpdateChanging$.MODULE$.equals(mixed) ? true : CachePolicy$Update$.MODULE$.equals(mixed);
                    if (bl2) {
                        f2 = this.maybeUpdate$1(file$6, url$8, keepHeaderChecksums$3).run();
                    } else if (CachePolicy$FetchMissing$.MODULE$.equals(mixed)) {
                        f2 = new EitherT(this.checkFileExists(file$6, url$8, this.checkFileExists$default$3())).orElse((Function0<EitherT> & Serializable)() -> new EitherT(this.remoteKeepErrors(file$6, url$8, keepHeaderChecksums$3)), this.S()).run();
                    } else if (CachePolicy$ForceDownload$.MODULE$.equals(mixed)) {
                        f2 = this.remoteKeepErrors(file$6, url$8, keepHeaderChecksums$3);
                    } else {
                        throw new MatchError(mixed);
                    }
                }
            }
            f = f2;
        }
        return f;
    }

    private final Seq checksumRes$1(String c) {
        return (Seq)Option$.MODULE$.option2Iterable(this.artifact().checksumUrls().get(c)).toSeq().map((Function1<String, Object> & Serializable)url -> this.downloadUrl((String)url, false));
    }

    public static final /* synthetic */ boolean $anonfun$download$6(char x$23) {
        return x$23 != '-';
    }

    private final String fallbackUrl$1(String c$2) {
        return new StringBuilder(1).append(this.artifact().url()).append(".").append(StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(c$2.toLowerCase(Locale.ROOT)), (Function1<Object, Object> & Serializable)x$23 -> BoxesRunTime.boxToBoolean(Downloader.$anonfun$download$6(BoxesRunTime.unboxToChar(x$23))))).toString();
    }

    public static final /* synthetic */ Seq $anonfun$download$5(Downloader $this, String c$2, File candidate$1, boolean x0$1) {
        Seq seq;
        boolean bl = x0$1;
        if (!bl) {
            seq = $this.checksumRes$1(c$2);
        } else if (bl) {
            String url = (String)$this.artifact().checksumUrls().getOrElse(c$2, (Function0<String> & Serializable)() -> $this.fallbackUrl$1(c$2));
            seq = (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{$this.S().point(DownloadResult$.MODULE$.apply(url, candidate$1))}));
        } else {
            throw new MatchError(BoxesRunTime.boxToBoolean(bl));
        }
        return seq;
    }

    public Downloader(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int bufferSize, Sync<F> S) {
        CachePolicy.Mixed mixed;
        this.artifact = artifact;
        this.cachePolicy = cachePolicy;
        this.location = location;
        this.actualChecksums = actualChecksums;
        this.allCredentials = allCredentials;
        this.logger = logger;
        this.pool = pool;
        this.ttl = ttl;
        this.localArtifactsShouldBeCached = localArtifactsShouldBeCached;
        this.followHttpToHttpsRedirections = followHttpToHttpsRedirections;
        this.followHttpsToHttpRedirections = followHttpsToHttpRedirections;
        this.maxRedirections = maxRedirections;
        this.sslRetry = sslRetry;
        this.sslSocketFactoryOpt = sslSocketFactoryOpt;
        this.hostnameVerifierOpt = hostnameVerifierOpt;
        this.bufferSize = bufferSize;
        this.S = S;
        Product.$init$(this);
        this.cacheErrors = artifact.changing() && artifact.extra().contains("cache-errors");
        CachePolicy.Mixed mixed2 = cachePolicy.acceptChanging();
        if (CachePolicy$UpdateChanging$.MODULE$.equals(mixed2) && !artifact.changing()) {
            mixed = CachePolicy$FetchMissing$.MODULE$;
        } else {
            boolean bl = CachePolicy$LocalUpdateChanging$.MODULE$.equals(mixed2) ? true : CachePolicy$LocalOnlyIfValid$.MODULE$.equals(mixed2);
            mixed = bl && !artifact.changing() ? CachePolicy$LocalOnly$.MODULE$ : mixed2;
        }
        this.actualCachePolicy = mixed;
    }
}

