/*
 * Decompiled with CFR 0.152.
 */
package bloop.shaded.coursierapi.shaded.scala.math;

import bloop.shaded.coursierapi.shaded.scala.math.BigDecimal;
import bloop.shaded.coursierapi.shaded.scala.math.BigInt$;
import bloop.shaded.coursierapi.shaded.scala.math.Ordered;
import bloop.shaded.coursierapi.shaded.scala.math.ScalaNumber;
import bloop.shaded.coursierapi.shaded.scala.math.ScalaNumericAnyConversions;
import bloop.shaded.coursierapi.shaded.scala.math.ScalaNumericConversions;
import bloop.shaded.coursierapi.shaded.scala.runtime.BoxesRunTime;
import bloop.shaded.coursierapi.shaded.scala.runtime.Statics;
import java.math.BigInteger;

public final class BigInt
extends ScalaNumber
implements Ordered<BigInt>,
ScalaNumericConversions {
    private final BigInteger bigInteger;

    @Override
    public boolean $less$eq(Object that) {
        return Ordered.$less$eq$(this, that);
    }

    @Override
    public boolean $greater$eq(Object that) {
        return Ordered.$greater$eq$(this, that);
    }

    @Override
    public int compareTo(Object that) {
        return Ordered.compareTo$(this, that);
    }

    @Override
    public byte toByte() {
        return ScalaNumericAnyConversions.toByte$(this);
    }

    @Override
    public short toShort() {
        return ScalaNumericAnyConversions.toShort$(this);
    }

    @Override
    public int toInt() {
        return ScalaNumericAnyConversions.toInt$(this);
    }

    @Override
    public long toLong() {
        return ScalaNumericAnyConversions.toLong$(this);
    }

    @Override
    public float toFloat() {
        return ScalaNumericAnyConversions.toFloat$(this);
    }

    @Override
    public double toDouble() {
        return ScalaNumericAnyConversions.toDouble$(this);
    }

    @Override
    public int unifiedPrimitiveHashcode() {
        return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$(this);
    }

    @Override
    public boolean unifiedPrimitiveEquals(Object x) {
        return ScalaNumericAnyConversions.unifiedPrimitiveEquals$(this, x);
    }

    public BigInteger bigInteger() {
        return this.bigInteger;
    }

    public int hashCode() {
        if (this.isValidLong()) {
            return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$(this);
        }
        return Statics.anyHash(this.bigInteger());
    }

    public boolean equals(Object that) {
        boolean bl;
        if (that instanceof BigInt) {
            BigInt bigInt = (BigInt)that;
            bl = this.equals(bigInt);
        } else if (that instanceof BigDecimal) {
            bl = ((BigDecimal)that).equals(this);
        } else if (that instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(that);
            bl = this.isValidDouble() && this.doubleValue() == d;
        } else if (that instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(that);
            bl = this.isValidFloat() && this.floatValue() == f;
        } else {
            bl = this.isValidLong() && ScalaNumericAnyConversions.unifiedPrimitiveEquals$(this, that);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isValidByte() {
        void int2bigInt_i;
        BigInt bigInt;
        int n = -128;
        BigInt$ int2bigInt_this = BigInt$.MODULE$;
        BigInt bigInt2 = bigInt = int2bigInt_this.apply((int)int2bigInt_i);
        Object var3_2 = null;
        bigInt = null;
        BigInt $greater$eq_that = bigInt2;
        Object var1_4 = null;
        if (Ordered.$greater$eq$(this, $greater$eq_that)) {
            void int2bigInt_i2;
            BigInt bigInt3;
            int n2 = 127;
            BigInt$ int2bigInt_this2 = BigInt$.MODULE$;
            BigInt bigInt4 = bigInt3 = int2bigInt_this2.apply((int)int2bigInt_i2);
            Object var6_6 = null;
            bigInt3 = null;
            BigInt $less$eq_that = bigInt4;
            Object var2_8 = null;
            if (Ordered.$less$eq$(this, $less$eq_that)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isValidShort() {
        void int2bigInt_i;
        BigInt bigInt;
        int n = Short.MIN_VALUE;
        BigInt$ int2bigInt_this = BigInt$.MODULE$;
        BigInt bigInt2 = bigInt = int2bigInt_this.apply((int)int2bigInt_i);
        Object var3_2 = null;
        bigInt = null;
        BigInt $greater$eq_that = bigInt2;
        Object var1_4 = null;
        if (Ordered.$greater$eq$(this, $greater$eq_that)) {
            void int2bigInt_i2;
            BigInt bigInt3;
            int n2 = Short.MAX_VALUE;
            BigInt$ int2bigInt_this2 = BigInt$.MODULE$;
            BigInt bigInt4 = bigInt3 = int2bigInt_this2.apply((int)int2bigInt_i2);
            Object var6_6 = null;
            bigInt3 = null;
            BigInt $less$eq_that = bigInt4;
            Object var2_8 = null;
            if (Ordered.$less$eq$(this, $less$eq_that)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isValidChar() {
        void int2bigInt_i;
        BigInt bigInt;
        boolean bl = false;
        BigInt$ int2bigInt_this = BigInt$.MODULE$;
        BigInt bigInt2 = bigInt = int2bigInt_this.apply((int)int2bigInt_i);
        Object var3_2 = null;
        bigInt = null;
        BigInt $greater$eq_that = bigInt2;
        Object var1_4 = null;
        if (Ordered.$greater$eq$(this, $greater$eq_that)) {
            void int2bigInt_i2;
            BigInt bigInt3;
            int n = 65535;
            BigInt$ int2bigInt_this2 = BigInt$.MODULE$;
            BigInt bigInt4 = bigInt3 = int2bigInt_this2.apply((int)int2bigInt_i2);
            Object var6_6 = null;
            bigInt3 = null;
            BigInt $less$eq_that = bigInt4;
            Object var2_8 = null;
            if (Ordered.$less$eq$(this, $less$eq_that)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isValidInt() {
        void int2bigInt_i;
        BigInt bigInt;
        int n = Integer.MIN_VALUE;
        BigInt$ int2bigInt_this = BigInt$.MODULE$;
        BigInt bigInt2 = bigInt = int2bigInt_this.apply((int)int2bigInt_i);
        Object var3_2 = null;
        bigInt = null;
        BigInt $greater$eq_that = bigInt2;
        Object var1_4 = null;
        if (Ordered.$greater$eq$(this, $greater$eq_that)) {
            void int2bigInt_i2;
            BigInt bigInt3;
            int n2 = Integer.MAX_VALUE;
            BigInt$ int2bigInt_this2 = BigInt$.MODULE$;
            BigInt bigInt4 = bigInt3 = int2bigInt_this2.apply((int)int2bigInt_i2);
            Object var6_6 = null;
            bigInt3 = null;
            BigInt $less$eq_that = bigInt4;
            Object var2_8 = null;
            if (Ordered.$less$eq$(this, $less$eq_that)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isValidLong() {
        void long2bigInt_l;
        BigInt bigInt;
        long l = Long.MIN_VALUE;
        BigInt$ long2bigInt_this = BigInt$.MODULE$;
        BigInt bigInt2 = bigInt = long2bigInt_this.apply((long)long2bigInt_l);
        Object var3_2 = null;
        bigInt = null;
        BigInt $greater$eq_that = bigInt2;
        Object var1_4 = null;
        if (Ordered.$greater$eq$(this, $greater$eq_that)) {
            void long2bigInt_l2;
            BigInt bigInt3;
            long l2 = Long.MAX_VALUE;
            BigInt$ long2bigInt_this2 = BigInt$.MODULE$;
            BigInt bigInt4 = bigInt3 = long2bigInt_this2.apply((long)long2bigInt_l2);
            Object var7_6 = null;
            bigInt3 = null;
            BigInt $less$eq_that = bigInt4;
            Object var2_8 = null;
            if (Ordered.$less$eq$(this, $less$eq_that)) {
                return true;
            }
        }
        return false;
    }

    public boolean isValidFloat() {
        block5: {
            block4: {
                int bitLen = this.bitLength();
                if (bitLen <= 24) break block4;
                int lowest = this.lowestSetBit();
                if (!(bitLen <= 128 && lowest >= bitLen - 24 && lowest < 128)) break block5;
            }
            if (!this.bitLengthOverflow()) {
                return true;
            }
        }
        return false;
    }

    public boolean isValidDouble() {
        block5: {
            block4: {
                int bitLen = this.bitLength();
                if (bitLen <= 53) break block4;
                int lowest = this.lowestSetBit();
                if (!(bitLen <= 1024 && lowest >= bitLen - 53 && lowest < 1024)) break block5;
            }
            if (!this.bitLengthOverflow()) {
                return true;
            }
        }
        return false;
    }

    private boolean bitLengthOverflow() {
        BigInteger shifted = this.bigInteger().shiftRight(Integer.MAX_VALUE);
        return shifted.signum() != 0 && !shifted.equals(BigInt$.MODULE$.scala$math$BigInt$$minusOne());
    }

    @Override
    public boolean isWhole() {
        return true;
    }

    @Override
    public BigInteger underlying() {
        return this.bigInteger();
    }

    public boolean equals(BigInt that) {
        return this.compare(that) == 0;
    }

    @Override
    public int compare(BigInt that) {
        return this.bigInteger().compareTo(that.bigInteger());
    }

    public int lowestSetBit() {
        return this.bigInteger().getLowestSetBit();
    }

    public int bitLength() {
        return this.bigInteger().bitLength();
    }

    @Override
    public byte byteValue() {
        return (byte)this.intValue();
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    @Override
    public int intValue() {
        return this.bigInteger().intValue();
    }

    @Override
    public long longValue() {
        return this.bigInteger().longValue();
    }

    @Override
    public float floatValue() {
        return this.bigInteger().floatValue();
    }

    @Override
    public double doubleValue() {
        return this.bigInteger().doubleValue();
    }

    public String toString() {
        return this.bigInteger().toString();
    }

    public BigInt(BigInteger bigInteger) {
        this.bigInteger = bigInteger;
    }
}

