/*
 * Decompiled with CFR 0.152.
 */
package bloop.shaded.snailgun.protocol;

import bloop.shaded.snailgun.Terminal;
import bloop.shaded.snailgun.logging.Logger;
import bloop.shaded.snailgun.protocol.Action;
import bloop.shaded.snailgun.protocol.Action$SendStdin$;
import bloop.shaded.snailgun.protocol.ChunkTypes;
import bloop.shaded.snailgun.protocol.ChunkTypes$Argument$;
import bloop.shaded.snailgun.protocol.ChunkTypes$Command$;
import bloop.shaded.snailgun.protocol.ChunkTypes$Directory$;
import bloop.shaded.snailgun.protocol.ChunkTypes$Environment$;
import bloop.shaded.snailgun.protocol.ChunkTypes$Exit$;
import bloop.shaded.snailgun.protocol.ChunkTypes$Heartbeat$;
import bloop.shaded.snailgun.protocol.ChunkTypes$SendInput$;
import bloop.shaded.snailgun.protocol.ChunkTypes$Stderr$;
import bloop.shaded.snailgun.protocol.ChunkTypes$Stdin$;
import bloop.shaded.snailgun.protocol.ChunkTypes$StdinEOF$;
import bloop.shaded.snailgun.protocol.ChunkTypes$Stdout$;
import bloop.shaded.snailgun.protocol.Defaults$Time$;
import bloop.shaded.snailgun.protocol.Streams;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u0011#\u0001\u001dB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0011!!\u0006A!A!\u0002\u0013)\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u000b\r\u0004A\u0011\u00013\t\u000f1\u0004!\u0019!C\u0005[\"11\u000f\u0001Q\u0001\n9Dq\u0001\u001e\u0001C\u0002\u0013%Q\u000f\u0003\u0004z\u0001\u0001\u0006IA\u001e\u0005\bu\u0002\u0011\r\u0011\"\u0003|\u0011\u0019a\b\u0001)A\u0005+\"9Q\u0010\u0001b\u0001\n\u0013Y\bB\u0002@\u0001A\u0003%Q\u000b\u0003\u0005\u0000\u0001\t\u0007I\u0011BA\u0001\u0011!\tY\u0001\u0001Q\u0001\n\u0005\r\u0001\"CA\u0007\u0001\t\u0007I\u0011BA\u0001\u0011!\ty\u0001\u0001Q\u0001\n\u0005\r\u0001\u0002CA\t\u0001\t\u0007I\u0011A7\t\u000f\u0005M\u0001\u0001)A\u0005]\"A\u0011Q\u0003\u0001C\u0002\u0013\u0005Q\u000eC\u0004\u0002\u0018\u0001\u0001\u000b\u0011\u00028\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0001bBA(\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u0003s\u0002A\u0011AA>\u0011\u001d\ti\t\u0001C\u0001\u0003\u001fCq!a'\u0001\t\u0003\ti\nC\u0004\u0002\"\u0002!I!a)\t\u000f\u0005=\u0006\u0001\"\u0003\u00022\"9\u0011\u0011\u001a\u0001\u0005\n\u0005-'\u0001\u0003)s_R|7m\u001c7\u000b\u0005\r\"\u0013\u0001\u00039s_R|7m\u001c7\u000b\u0003\u0015\n\u0001b\u001d8bS2<WO\\\u0002\u0001'\t\u0001\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\bgR\u0014X-Y7t!\t\u0001\u0014'D\u0001#\u0013\t\u0011$EA\u0004TiJ,\u0017-\\:\u0002\u0007\r<H\r\u0005\u00026y5\taG\u0003\u00028q\u0005!a-\u001b7f\u0015\tI$(A\u0002oS>T\u0011aO\u0001\u0005U\u00064\u0018-\u0003\u0002>m\t!\u0001+\u0019;i\u0003-)gN^5s_:lWM\u001c;\u0011\t\u0001;%J\u0013\b\u0003\u0003\u0016\u0003\"A\u0011\u0016\u000e\u0003\rS!\u0001\u0012\u0014\u0002\rq\u0012xn\u001c;?\u0013\t1%&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011&\u00131!T1q\u0015\t1%\u0006\u0005\u0002A\u0017&\u0011A*\u0013\u0002\u0007'R\u0014\u0018N\\4\u0002\r1|wmZ3s!\ty%+D\u0001Q\u0015\t\tF%A\u0004m_\u001e<\u0017N\\4\n\u0005M\u0003&A\u0002'pO\u001e,'/A\u000bti>\u0004h)\u001e:uQ\u0016\u0014\bK]8dKN\u001c\u0018N\\4\u0011\u0005YkV\"A,\u000b\u0005aK\u0016AB1u_6L7M\u0003\u0002[7\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005qS\u0014\u0001B;uS2L!AX,\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003IIg\u000e^3sC\u000e$\u0018N^3TKN\u001c\u0018n\u001c8\u0011\u0005%\n\u0017B\u00012+\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtDcB3gO\"L'n\u001b\t\u0003a\u0001AQAL\u0004A\u0002=BQaM\u0004A\u0002QBQAP\u0004A\u0002}BQ!T\u0004A\u00029CQ\u0001V\u0004A\u0002UCQaX\u0004A\u0002\u0001\f1\"\u00192t_2,H/Z\"xIV\ta\u000e\u0005\u0002pe6\t\u0001O\u0003\u0002ru\u0005!A.\u00198h\u0013\ta\u0005/\u0001\u0007bEN|G.\u001e;f\u0007^$\u0007%\u0001\u0005fq&$8i\u001c3f+\u00051\bC\u0001,x\u0013\tAxKA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\nKbLGoQ8eK\u0002\n\u0011\"[:Sk:t\u0017N\\4\u0016\u0003U\u000b!\"[:Sk:t\u0017N\\4!\u0003=\tg.\u001f+ie\u0016\fGMR1jY\u0016$\u0017\u0001E1osRC'/Z1e\r\u0006LG.\u001a3!\u0003I\u0019XM\u001c3Ti\u0012LgnU3nCBDwN]3\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u000fi\u0011!W\u0005\u0004\u0003\u0013I&!C*f[\u0006\u0004\bn\u001c:f\u0003M\u0019XM\u001c3Ti\u0012LgnU3nCBDwN]3!\u0003=9\u0018-\u001b;UKJl\u0017N\\1uS>t\u0017\u0001E<bSR$VM]7j]\u0006$\u0018n\u001c8!\u0003Qq\u0015-\u001b7hk:4\u0015\u000e\\3TKB\f'/\u0019;pe\u0006)b*Y5mOVtg)\u001b7f'\u0016\u0004\u0018M]1u_J\u0004\u0013\u0001\u0006(bS2<WO\u001c)bi\"\u001cV\r]1sCR|'/A\u000bOC&dw-\u001e8QCRD7+\u001a9be\u0006$xN\u001d\u0011\u0002\u001d\u0005dG.\u00128wSJ|g.\\3oiV\tq(A\u0006tK:$7i\\7nC:$GCCA\u0011\u0003O\tY#!\u000e\u0002FA\u0019\u0011&a\t\n\u0007\u0005\u0015\"FA\u0002J]RDa!!\u000b\u001a\u0001\u0004Q\u0015aA2nI\"9\u0011QF\rA\u0002\u0005=\u0012aB2nI\u0006\u0013xm\u001d\t\u0005S\u0005E\"*C\u0002\u00024)\u0012Q!\u0011:sCfDq!a\u000e\u001a\u0001\u0004\tI$\u0001\u0003pkR\u0004\u0004\u0003BA\u001e\u0003\u0003j!!!\u0010\u000b\u0007\u0005}\"(\u0001\u0002j_&!\u00111IA\u001f\u00051yU\u000f\u001e9viN#(/Z1n\u0011\u001d\t9%\u0007a\u0001\u0003\u0013\n1!\u001b81!\u0011\tY$a\u0013\n\t\u00055\u0013Q\b\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW.A\u0005tK:$7\t[;oWRA\u00111KA-\u0003W\ny\u0007E\u0002*\u0003+J1!a\u0016+\u0005\u0011)f.\u001b;\t\u000f\u0005m#\u00041\u0001\u0002^\u0005\u0019A\u000f]3\u0011\t\u0005}\u0013Q\r\b\u0004a\u0005\u0005\u0014bAA2E\u0005Q1\t[;oWRK\b/Z:\n\t\u0005\u001d\u0014\u0011\u000e\u0002\n\u0007\",hn\u001b+za\u0016T1!a\u0019#\u0011\u0019\tiG\u0007a\u0001\u0015\u0006\u0019Qn]4\t\u000f\u0005E$\u00041\u0001\u0002t\u0005\u0019q.\u001e;\u0011\t\u0005m\u0012QO\u0005\u0005\u0003o\niD\u0001\tECR\fw*\u001e;qkR\u001cFO]3b[\u00061\u0002O]8dKN\u001c8\t[;oW\u001a\u0013x.\\*feZ,'\u000f\u0006\u0003\u0002~\u0005\r\u0005c\u0001\u0019\u0002\u0000%\u0019\u0011\u0011\u0011\u0012\u0003\r\u0005\u001bG/[8o\u0011\u001d\t)i\u0007a\u0001\u0003\u000f\u000b!!\u001b8\u0011\t\u0005m\u0012\u0011R\u0005\u0005\u0003\u0017\u000biDA\bECR\f\u0017J\u001c9viN#(/Z1n\u0003\u0001\u001a'/Z1uK\"+\u0017M\u001d;cK\u0006$\u0018I\u001c3TQV$Hm\\<o)\"\u0014X-\u00193\u0015\r\u0005E\u0015qSAM!\ry\u00171S\u0005\u0004\u0003+\u0003(A\u0002+ie\u0016\fG\rC\u0004\u0002\u0006r\u0001\r!a\"\t\u000f\u0005ED\u00041\u0001\u0002t\u0005\t2M]3bi\u0016\u001cF\u000fZ5o)\"\u0014X-\u00193\u0015\t\u0005E\u0015q\u0014\u0005\b\u0003cj\u0002\u0019AA:\u0003\u0005\u001ax/\u00197m_^,\u0005pY3qi&|gn]%g'\u0016\u0014h/\u001a:GS:L7\u000f[3e)\u0011\t\u0019&!*\t\u0011\u0005\u001df\u0004\"a\u0001\u0003S\u000b\u0011A\u001a\t\u0006S\u0005-\u00161K\u0005\u0004\u0003[S#\u0001\u0003\u001fcs:\fW.\u001a \u0002\u001dA\u0014\u0018N\u001c;Fq\u000e,\u0007\u000f^5p]R!\u00111KAZ\u0011\u001d\t)l\ba\u0001\u0003o\u000b\u0011\"\u001a=dKB$\u0018n\u001c8\u0011\t\u0005e\u00161\u0019\b\u0005\u0003w\u000byLD\u0002C\u0003{K\u0011aK\u0005\u0004\u0003\u0003T\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u000b\f9MA\u0005UQJ|w/\u00192mK*\u0019\u0011\u0011\u0019\u0016\u0002\u0019\u0011\fW-\\8o)\"\u0014X-\u00193\u0015\t\u0005E\u0015Q\u001a\u0005\b\u0003\u001f\u0004\u0003\u0019AAi\u0003\u0011\u0011XO\u001c\u0019\u0011\u000b%\n\u0019.a\u0015\n\u0007\u0005U'FA\u0005Gk:\u001cG/[8oa\u0001")
public class Protocol {
    private final Streams streams;
    private final Map<String, String> environment;
    private final Logger logger;
    private final AtomicBoolean stopFurtherProcessing;
    private final boolean interactiveSession;
    private final String absoluteCwd;
    private final AtomicInteger exitCode;
    private final AtomicBoolean isRunning;
    private final AtomicBoolean snailgun$protocol$Protocol$$anyThreadFailed;
    private final Semaphore sendStdinSemaphore;
    private final Semaphore waitTermination;
    private final String NailgunFileSeparator;
    private final String NailgunPathSeparator;

    private String absoluteCwd() {
        return this.absoluteCwd;
    }

    private AtomicInteger exitCode() {
        return this.exitCode;
    }

    private AtomicBoolean isRunning() {
        return this.isRunning;
    }

    public AtomicBoolean snailgun$protocol$Protocol$$anyThreadFailed() {
        return this.snailgun$protocol$Protocol$$anyThreadFailed;
    }

    private Semaphore sendStdinSemaphore() {
        return this.sendStdinSemaphore;
    }

    private Semaphore waitTermination() {
        return this.waitTermination;
    }

    public String NailgunFileSeparator() {
        return this.NailgunFileSeparator;
    }

    public String NailgunPathSeparator() {
        return this.NailgunPathSeparator;
    }

    public Map<String, String> allEnvironment() {
        return this.environment.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NAILGUN_FILESEPARATOR"), (Object)this.NailgunFileSeparator()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NAILGUN_PATHSEPARATOR"), (Object)this.NailgunPathSeparator()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NAILGUN_TTY_0"), (Object)this.skipIfNative$1((Function0 & Serializable & scala.Serializable)() -> Protocol.interactive$1(0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NAILGUN_TTY_1"), (Object)this.skipIfNative$1((Function0 & Serializable & scala.Serializable)() -> Protocol.interactive$1(1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NAILGUN_TTY_2"), (Object)this.skipIfNative$1((Function0 & Serializable & scala.Serializable)() -> Protocol.interactive$1(2)))})));
    }

    public int sendCommand(String cmd, String[] cmdArgs, OutputStream out0, InputStream in0) {
        Thread scheduleHeartbeat;
        Thread sendStdin;
        block16: {
            this.isRunning().set(true);
            DataInputStream in = new DataInputStream(in0);
            DataOutputStream out = new DataOutputStream(out0);
            sendStdin = this.createStdinThread(out);
            scheduleHeartbeat = this.createHeartbeatAndShutdownThread(in, out);
            scheduleHeartbeat.start();
            try {
                try {
                    this.logger.debug(new StringBuilder(38).append("Sending arguments '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs)).mkString(" ")).append("' to Nailgun server").toString());
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                        this.sendChunk(ChunkTypes$Argument$.MODULE$, x$1, out);
                        return BoxedUnit.UNIT;
                    });
                    this.logger.debug("Sending environment variables to Nailgun server");
                    this.allEnvironment().foreach((Function1 & Serializable & scala.Serializable)kv -> {
                        this.sendChunk(ChunkTypes$Environment$.MODULE$, new StringBuilder(1).append(kv._1()).append("=").append(kv._2()).toString(), out);
                        return BoxedUnit.UNIT;
                    });
                    this.logger.debug(new StringBuilder(44).append("Sending working directory ").append(this.absoluteCwd()).append(" to Nailgun server").toString());
                    this.sendChunk(ChunkTypes$Directory$.MODULE$, this.absoluteCwd(), out);
                    this.logger.debug(new StringBuilder(34).append("Sending command to ").append(cmd).append(" Nailgun server").toString());
                    this.sendChunk(ChunkTypes$Command$.MODULE$, cmd, out);
                    this.logger.debug("Finished sending command information to Nailgun server");
                    this.logger.debug("Starting thread to read stdin...");
                    sendStdin.start();
                    while (this.exitCode().get() == -1) {
                        Boolean bl;
                        Action action = this.processChunkFromServer(in);
                        this.logger.debug(new StringBuilder(36).append("Received action ").append(action).append(" from Nailgun server").toString());
                        Action action2 = action;
                        if (action2 instanceof Action.Exit) {
                            Action.Exit exit = (Action.Exit)action2;
                            int code = exit.code();
                            bl = BoxesRunTime.boxToBoolean((boolean)this.exitCode().compareAndSet(-1, code));
                            continue;
                        }
                        if (action2 instanceof Action.ExitForcefully) {
                            Boolean bl2;
                            Action.ExitForcefully exitForcefully = (Action.ExitForcefully)action2;
                            Throwable error = exitForcefully.error();
                            String string = cmd;
                            String string2 = "ng-stop";
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                bl2 = BoxesRunTime.boxToBoolean((boolean)this.exitCode().compareAndSet(-1, 0));
                            } else {
                                this.exitCode().compareAndSet(-1, 1);
                                this.snailgun$protocol$Protocol$$printException(error);
                                bl2 = BoxedUnit.UNIT;
                            }
                            bl = bl2;
                            continue;
                        }
                        if (action2 instanceof Action.Print) {
                            Action.Print print = (Action.Print)action2;
                            byte[] bytes = print.bytes();
                            OutputStream out2 = print.out();
                            out2.write(bytes);
                            bl = BoxedUnit.UNIT;
                            continue;
                        }
                        if (Action$SendStdin$.MODULE$.equals(action2)) {
                            this.sendStdinSemaphore().release();
                            bl = BoxedUnit.UNIT;
                            continue;
                        }
                        throw new MatchError((Object)action2);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        BoxedUnit boxedUnit;
                        Throwable exception = (Throwable)option.get();
                        this.exitCode().compareAndSet(-1, 1);
                        if (!this.stopFurtherProcessing.get()) {
                            this.snailgun$protocol$Protocol$$printException(exception);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        break block16;
                    }
                    throw throwable;
                }
            }
            finally {
                this.isRunning().compareAndSet(true, false);
                this.waitTermination().release(Integer.MAX_VALUE);
                this.sendStdinSemaphore().release(Integer.MAX_VALUE);
            }
        }
        if (this.stopFurtherProcessing.get()) {
            sendStdin.interrupt();
        }
        this.logger.debug("Waiting for stdin thread to finish...");
        sendStdin.join();
        this.logger.debug("Waiting for heartbeat thread to finish...");
        scheduleHeartbeat.join();
        this.logger.debug("Returning exit code...");
        return this.exitCode().get();
    }

    public void sendChunk(ChunkTypes.ChunkType tpe, String msg, DataOutputStream out) {
        byte[] payload = msg.getBytes(StandardCharsets.UTF_8);
        out.writeInt(payload.length);
        out.writeByte(tpe.toByteRepr());
        out.write(payload);
        out.flush();
    }

    public Action processChunkFromServer(DataInputStream in) {
        Action action;
        Try readAction = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Action action;
            byte chunkType;
            int bytesToRead = in.readInt();
            byte by = chunkType = in.readByte();
            if (ChunkTypes$SendInput$.MODULE$.toByteRepr() == by) {
                action = Action$SendStdin$.MODULE$;
            } else if (ChunkTypes$Stdout$.MODULE$.toByteRepr() == by) {
                action = new Action.Print(Protocol.readPayload$1(bytesToRead, in), $this.streams.out());
            } else if (ChunkTypes$Stderr$.MODULE$.toByteRepr() == by) {
                action = new Action.Print(Protocol.readPayload$1(bytesToRead, in), $this.streams.err());
            } else if (ChunkTypes$Exit$.MODULE$.toByteRepr() == by) {
                byte[] bytes = Protocol.readPayload$1(bytesToRead, in);
                int code = Integer.parseInt(new String(bytes, StandardCharsets.US_ASCII).trim());
                action = new Action.Exit(code);
            } else {
                RuntimeException error = new RuntimeException(new StringBuilder(23).append("Unexpected chunk type: ").append(chunkType).toString());
                action = new Action.ExitForcefully(error);
            }
            return action;
        });
        Try try_ = readAction;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Product action2 = (Product)success.value();
            action = (Action)action2;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            action = new Action.ExitForcefully(exception);
        } else {
            throw new MatchError((Object)try_);
        }
        return action;
    }

    public Thread createHeartbeatAndShutdownThread(DataInputStream in, DataOutputStream out) {
        return this.daemonThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            boolean bl = true;
            while (bl) {
                boolean acquired = this.waitTermination().tryAcquire(Defaults$Time$.MODULE$.DefaultHeartbeatIntervalMillis(), TimeUnit.MILLISECONDS);
                if (acquired) {
                    bl = false;
                    continue;
                }
                this.swallowExceptionsIfServerFinished((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    if ($this.stopFurtherProcessing.get()) {
                        DataOutputStream dataOutputStream = out;
                        synchronized (dataOutputStream) {
                            out.flush();
                            try {
                                in.close();
                            }
                            finally {
                                out.close();
                            }
                        }
                    }
                    DataOutputStream dataOutputStream = out;
                    synchronized (dataOutputStream) {
                        this.sendChunk(ChunkTypes$Heartbeat$.MODULE$, "", out);
                    }
                });
            }
        });
    }

    public Thread createStdinThread(DataOutputStream out) {
        return this.daemonThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader($this.streams.in()));){
                boolean bl = true;
                while (bl) {
                    if (this.shouldStop$1()) {
                        bl = false;
                        continue;
                    }
                    this.sendStdinSemaphore().acquire();
                    if (this.shouldStop$1()) {
                        bl = false;
                        continue;
                    }
                    String line = reader.readLine();
                    if (this.shouldStop$1()) {
                        bl = false;
                        continue;
                    }
                    if (line.length() == 0) continue;
                    this.swallowExceptionsIfServerFinished((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        DataOutputStream dataOutputStream = out;
                        synchronized (dataOutputStream) {
                            if (line == null) {
                                this.sendChunk(ChunkTypes$StdinEOF$.MODULE$, "", out);
                            } else {
                                this.sendChunk(ChunkTypes$Stdin$.MODULE$, line, out);
                            }
                        }
                    });
                }
            }
        });
    }

    private void swallowExceptionsIfServerFinished(Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable exception = (Throwable)option.get();
                boolean acquired = this.waitTermination().tryAcquire(Defaults$Time$.MODULE$.SendThreadWaitTerminationMillis(), TimeUnit.MILLISECONDS);
                if (!acquired) {
                    throw exception;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public void snailgun$protocol$Protocol$$printException(Throwable exception) {
        this.logger.error("Unexpected error forces client exit!");
        this.logger.trace(exception);
    }

    /*
     * WARNING - void declaration
     */
    private Thread daemonThread(Function0<BoxedUnit> run0) {
        void var2_2;
        Thread t = new Thread(this, run0){
            private final /* synthetic */ Protocol $outer;
            private final Function0 run0$1;

            public void run() {
                try {
                    this.run0$1.apply$mcV$sp();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        BoxedUnit boxedUnit;
                        Throwable exception = (Throwable)option.get();
                        if (this.$outer.snailgun$protocol$Protocol$$anyThreadFailed().compareAndSet(false, true)) {
                            this.$outer.snailgun$protocol$Protocol$$printException(exception);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    }
                    throw throwable;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.run0$1 = run0$1;
            }
        };
        t.setDaemon(true);
        return var2_2;
    }

    private static final String interactive$1(int fd) {
        return Integer.toString(Terminal.hasTerminalAttached(fd));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String skipIfNative$1(Function0 f) {
        if (!this.interactiveSession) return "0";
        String string = System.getProperty("java.vm.name");
        String string2 = "Substrate VM";
        if (string == null) {
            if (string2 == null) return "0";
        } else if (string.equals(string2)) {
            return "0";
        }
        String string3 = (String)f.apply();
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    private static final byte[] readPayload$1(int length, DataInputStream in) {
        void var3_3;
        int read;
        byte[] bytes = new byte[length];
        for (int total = 0; total < length; total += read) {
            read = in.read(bytes, total, length - total);
            if (read >= 0) continue;
            throw new EOFException("Couldn't read bytes from server");
        }
        return var3_3;
    }

    private final boolean shouldStop$1() {
        return !this.isRunning().get() || this.stopFurtherProcessing.get();
    }

    public Protocol(Streams streams, Path cwd, Map<String, String> environment, Logger logger, AtomicBoolean stopFurtherProcessing, boolean interactiveSession) {
        this.streams = streams;
        this.environment = environment;
        this.logger = logger;
        this.stopFurtherProcessing = stopFurtherProcessing;
        this.interactiveSession = interactiveSession;
        this.absoluteCwd = ((Object)cwd.toAbsolutePath()).toString();
        this.exitCode = new AtomicInteger(-1);
        this.isRunning = new AtomicBoolean(false);
        this.snailgun$protocol$Protocol$$anyThreadFailed = new AtomicBoolean(false);
        this.sendStdinSemaphore = new Semaphore(0);
        this.waitTermination = new Semaphore(0);
        this.NailgunFileSeparator = File.separator;
        this.NailgunPathSeparator = File.pathSeparator;
    }
}

