/*
 * Decompiled with CFR 0.152.
 */
package bloop.shaded.coursierapi.shaded.coursier.internal;

import bloop.shaded.coursierapi.shaded.coursier.cache.CacheLocks$;
import bloop.shaded.coursierapi.shaded.coursier.core.Classifier;
import bloop.shaded.coursierapi.shaded.coursier.core.Dependency;
import bloop.shaded.coursierapi.shaded.coursier.core.Module;
import bloop.shaded.coursierapi.shaded.coursier.core.Repository;
import bloop.shaded.coursierapi.shaded.coursier.core.Type;
import bloop.shaded.coursierapi.shaded.coursier.params.ResolutionParams;
import bloop.shaded.coursierapi.shaded.coursier.paths.CachePath;
import bloop.shaded.coursierapi.shaded.scala.Function0;
import bloop.shaded.coursierapi.shaded.scala.Function1;
import bloop.shaded.coursierapi.shaded.scala.None$;
import bloop.shaded.coursierapi.shaded.scala.Option;
import bloop.shaded.coursierapi.shaded.scala.Predef$;
import bloop.shaded.coursierapi.shaded.scala.Product;
import bloop.shaded.coursierapi.shaded.scala.Some;
import bloop.shaded.coursierapi.shaded.scala.Tuple2;
import bloop.shaded.coursierapi.shaded.scala.collection.IterableOnce;
import bloop.shaded.coursierapi.shaded.scala.collection.IterableOnceOps;
import bloop.shaded.coursierapi.shaded.scala.collection.Iterator;
import bloop.shaded.coursierapi.shaded.scala.collection.StringOps$;
import bloop.shaded.coursierapi.shaded.scala.collection.immutable.Seq;
import bloop.shaded.coursierapi.shaded.scala.collection.immutable.Vector;
import bloop.shaded.coursierapi.shaded.scala.runtime.BoxesRunTime;
import bloop.shaded.coursierapi.shaded.scala.runtime.ScalaRunTime$;
import bloop.shaded.coursierapi.shaded.scala.runtime.Statics;
import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;

public final class FetchCache
implements Serializable,
Product {
    private final Path base;

    @Override
    public Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    public Path base() {
        return this.base;
    }

    public Path dir(Key key) {
        return this.base().resolve(new StringBuilder(1).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(key.sha1()), 2)).append("/").append(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(key.sha1()), 2)).toString());
    }

    public Path resultFile(Key key) {
        return this.dir(key).resolve("artifacts");
    }

    public Option<Seq<File>> read(Key key) {
        Vector artifacts2;
        Path resultFile0 = this.resultFile(key);
        return Files.isRegularFile(resultFile0, new LinkOption[0]) ? ((artifacts2 = StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(new String(Files.readAllBytes(resultFile0), StandardCharsets.UTF_8))).map((Function1<String, String> & Serializable)x$1 -> x$1.trim()).filter((Function1<String, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2)))).map((Function1<String, Path> & Serializable)x$3 -> Paths.get(x$3, new String[0])).toVector()).forall((Function1<Path, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(FetchCache.$anonfun$read$4(x$4))) ? new Some<Object>(artifacts2.map((Function1<Path, File> & Serializable)x$5 -> x$5.toFile())) : None$.MODULE$) : None$.MODULE$;
    }

    public boolean write(Key key, Seq<File> artifacts2) {
        Path resultFile0 = this.resultFile(key);
        Path tmpFile = CachePath.temporaryFile(resultFile0.toFile()).toPath();
        return BoxesRunTime.unboxToBoolean(CacheLocks$.MODULE$.withLockOr(this.base().toFile(), resultFile0.toFile(), () -> {
            FetchCache.doWrite$1(tmpFile, artifacts2, resultFile0);
            return true;
        }, (Function0<Some> & Serializable)() -> new Some<Boolean>(BoxesRunTime.boxToBoolean(false))));
    }

    public String toString() {
        StringBuilder b = new StringBuilder("FetchCache(");
        b.append(String.valueOf(this.base()));
        b.append(")");
        return b.toString();
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof FetchCache && true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        FetchCache other = (FetchCache)obj;
        if (!true) return false;
        Path path = this.base();
        Path path2 = other.base();
        if (path != null) {
            if (!((Object)path).equals(path2)) return false;
            return true;
        }
        if (path2 == null) return true;
        return false;
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash("FetchCache");
        code = 37 * code + Statics.anyHash(this.base());
        return 37 * code;
    }

    @Override
    public String productPrefix() {
        return "FetchCache";
    }

    @Override
    public int productArity() {
        return 1;
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(n2));
            }
        }
        return this.base();
    }

    public static final /* synthetic */ boolean $anonfun$read$4(Path x$4) {
        return Files.isRegularFile(x$4, new LinkOption[0]);
    }

    private static final void doWrite$1(Path tmpFile$1, Seq artifacts$1, Path resultFile0$1) {
        Files.write(tmpFile$1, ((IterableOnceOps)artifacts$1.map((Function1<File, String> & Serializable)x$6 -> x$6.getAbsolutePath())).mkString("\n").getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.move(tmpFile$1, resultFile0$1, StandardCopyOption.ATOMIC_MOVE);
    }

    public FetchCache(Path base) {
        this.base = base;
        Product.$init$(this);
    }

    public static final class Key
    implements Serializable,
    Product {
        private String repr;
        private String sha1;
        private final Seq<Dependency> dependencies;
        private final Seq<Repository> repositories;
        private final ResolutionParams resolutionParams;
        private final Seq<Tuple2<Module, String>> forceVersion;
        private final Seq<Tuple2<String, String>> properties;
        private final Seq<Tuple2<String, String>> forcedProperties;
        private final Seq<String> profiles;
        private final String cacheLocation;
        private final Seq<Classifier> classifiers;
        private final Option<Object> mainArtifacts;
        private final Option<Seq<Type>> artifactTypesOpt;
        private volatile byte bitmap$0;

        public Seq<Dependency> dependencies() {
            return this.dependencies;
        }

        public Seq<Repository> repositories() {
            return this.repositories;
        }

        public ResolutionParams resolutionParams() {
            return this.resolutionParams;
        }

        public Seq<Tuple2<Module, String>> forceVersion() {
            return this.forceVersion;
        }

        public Seq<Tuple2<String, String>> properties() {
            return this.properties;
        }

        public Seq<Tuple2<String, String>> forcedProperties() {
            return this.forcedProperties;
        }

        public Seq<String> profiles() {
            return this.profiles;
        }

        public String cacheLocation() {
            return this.cacheLocation;
        }

        public Seq<Classifier> classifiers() {
            return this.classifiers;
        }

        public Option<Object> mainArtifacts() {
            return this.mainArtifacts;
        }

        public Option<Seq<Type>> artifactTypesOpt() {
            return this.artifactTypesOpt;
        }

        private String repr$lzycompute() {
            Key key = this;
            synchronized (key) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.repr = this.productIterator().mkString("(", ", ", ")");
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.repr;
        }

        public String repr() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.repr$lzycompute() : this.repr;
        }

        private String sha1$lzycompute() {
            Key key = this;
            synchronized (key) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    MessageDigest md = MessageDigest.getInstance("SHA-1");
                    byte[] b = md.digest(this.repr().getBytes(StandardCharsets.UTF_8));
                    String s = new BigInteger(1, b).toString(16);
                    this.sha1 = new StringBuilder(0).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0"), 40 - s.length())).append(s).toString();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.sha1;
        }

        public String sha1() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.sha1$lzycompute() : this.sha1;
        }

        @Override
        public String productPrefix() {
            return "Key";
        }

        @Override
        public int productArity() {
            return 11;
        }

        @Override
        public Object productElement(int x$1) {
            IterableOnce<Object> iterableOnce;
            int n = x$1;
            switch (n) {
                case 0: {
                    iterableOnce = this.dependencies();
                    break;
                }
                case 1: {
                    iterableOnce = this.repositories();
                    break;
                }
                case 2: {
                    iterableOnce = this.resolutionParams();
                    break;
                }
                case 3: {
                    iterableOnce = this.forceVersion();
                    break;
                }
                case 4: {
                    iterableOnce = this.properties();
                    break;
                }
                case 5: {
                    iterableOnce = this.forcedProperties();
                    break;
                }
                case 6: {
                    iterableOnce = this.profiles();
                    break;
                }
                case 7: {
                    iterableOnce = this.cacheLocation();
                    break;
                }
                case 8: {
                    iterableOnce = this.classifiers();
                    break;
                }
                case 9: {
                    iterableOnce = this.mainArtifacts();
                    break;
                }
                case 10: {
                    iterableOnce = this.artifactTypesOpt();
                    break;
                }
                default: {
                    iterableOnce = Statics.ioobe(x$1);
                    break;
                }
            }
            return iterableOnce;
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Key)) return false;
            boolean bl = true;
            if (!bl) return false;
            Key key = (Key)x$1;
            Seq<Dependency> seq = this.dependencies();
            Seq<Dependency> seq2 = key.dependencies();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<Repository> seq3 = this.repositories();
            Seq<Repository> seq4 = key.repositories();
            if (seq3 == null) {
                if (seq4 != null) {
                    return false;
                }
            } else if (!seq3.equals(seq4)) return false;
            ResolutionParams resolutionParams = this.resolutionParams();
            ResolutionParams resolutionParams2 = key.resolutionParams();
            if (resolutionParams == null) {
                if (resolutionParams2 != null) {
                    return false;
                }
            } else if (!((Object)resolutionParams).equals(resolutionParams2)) return false;
            Seq<Tuple2<Module, String>> seq5 = this.forceVersion();
            Seq<Tuple2<Module, String>> seq6 = key.forceVersion();
            if (seq5 == null) {
                if (seq6 != null) {
                    return false;
                }
            } else if (!seq5.equals(seq6)) return false;
            Seq<Tuple2<String, String>> seq7 = this.properties();
            Seq<Tuple2<String, String>> seq8 = key.properties();
            if (seq7 == null) {
                if (seq8 != null) {
                    return false;
                }
            } else if (!seq7.equals(seq8)) return false;
            Seq<Tuple2<String, String>> seq9 = this.forcedProperties();
            Seq<Tuple2<String, String>> seq10 = key.forcedProperties();
            if (seq9 == null) {
                if (seq10 != null) {
                    return false;
                }
            } else if (!seq9.equals(seq10)) return false;
            Seq<String> seq11 = this.profiles();
            Seq<String> seq12 = key.profiles();
            if (seq11 == null) {
                if (seq12 != null) {
                    return false;
                }
            } else if (!seq11.equals(seq12)) return false;
            String string = this.cacheLocation();
            String string2 = key.cacheLocation();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Seq<Classifier> seq13 = this.classifiers();
            Seq<Classifier> seq14 = key.classifiers();
            if (seq13 == null) {
                if (seq14 != null) {
                    return false;
                }
            } else if (!seq13.equals(seq14)) return false;
            Option<Object> option = this.mainArtifacts();
            Option<Object> option2 = key.mainArtifacts();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Seq<Type>> option3 = this.artifactTypesOpt();
            Option<Seq<Type>> option4 = key.artifactTypesOpt();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public Key(Seq<Dependency> dependencies, Seq<Repository> repositories, ResolutionParams resolutionParams, Seq<Tuple2<Module, String>> forceVersion, Seq<Tuple2<String, String>> properties, Seq<Tuple2<String, String>> forcedProperties, Seq<String> profiles, String cacheLocation, Seq<Classifier> classifiers, Option<Object> mainArtifacts, Option<Seq<Type>> artifactTypesOpt) {
            this.dependencies = dependencies;
            this.repositories = repositories;
            this.resolutionParams = resolutionParams;
            this.forceVersion = forceVersion;
            this.properties = properties;
            this.forcedProperties = forcedProperties;
            this.profiles = profiles;
            this.cacheLocation = cacheLocation;
            this.classifiers = classifiers;
            this.mainArtifacts = mainArtifacts;
            this.artifactTypesOpt = artifactTypesOpt;
            Product.$init$(this);
        }
    }
}

