/*
 * Decompiled with CFR 0.152.
 */
package bloop.shaded.coursierapi.shaded.coursier.cache;

import bloop.shaded.coursierapi.shaded.coursier.cache.CacheDefaults$;
import bloop.shaded.coursierapi.shaded.coursier.cache.CacheLogger$;
import bloop.shaded.coursierapi.shaded.coursier.cache.FileCache;
import bloop.shaded.coursierapi.shaded.coursier.cache.internal.FileUtil;
import bloop.shaded.coursierapi.shaded.coursier.cache.internal.FileUtil$;
import bloop.shaded.coursierapi.shaded.coursier.paths.CachePath;
import bloop.shaded.coursierapi.shaded.coursier.util.Sync;
import bloop.shaded.coursierapi.shaded.coursier.util.Task;
import bloop.shaded.coursierapi.shaded.coursier.util.Task$;
import bloop.shaded.coursierapi.shaded.scala.$less$colon$less$;
import bloop.shaded.coursierapi.shaded.scala.Function1;
import bloop.shaded.coursierapi.shaded.scala.None$;
import bloop.shaded.coursierapi.shaded.scala.Option;
import bloop.shaded.coursierapi.shaded.scala.Predef$;
import bloop.shaded.coursierapi.shaded.scala.collection.ArrayOps$;
import bloop.shaded.coursierapi.shaded.scala.collection.StringOps$;
import bloop.shaded.coursierapi.shaded.scala.package$;
import bloop.shaded.coursierapi.shaded.scala.runtime.BoxedUnit;
import bloop.shaded.coursierapi.shaded.scala.runtime.BoxesRunTime;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.util.Locale;

public final class FileCache$
implements Serializable {
    public static final FileCache$ MODULE$ = new FileCache$();

    public File localFile0(String url, File cache, Option<String> user, boolean localArtifactsShouldBeCached) {
        return CachePath.localFile(url, cache, (String)user.orNull($less$colon$less$.MODULE$.refl()), localArtifactsShouldBeCached);
    }

    private String auxiliaryFilePrefix(File file) {
        return new StringBuilder(3).append(".").append(file.getName()).append("__").toString();
    }

    public void clearAuxiliaryFiles(File file) {
        String prefix = this.auxiliaryFilePrefix(file);
        FilenameFilter filter = new FilenameFilter(prefix){
            private final String prefix$1;

            public boolean accept(File dir, String name) {
                return name.startsWith(this.prefix$1);
            }
            {
                this.prefix$1 = prefix$1;
            }
        };
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(file.getParentFile().listFiles(filter)), (Function1<File, Object> & Serializable)f -> BoxesRunTime.boxToBoolean(f.delete()));
    }

    public File auxiliaryFile(File file, String key) {
        String key0 = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(key.toLowerCase(Locale.ROOT)), (Function1<Object, Object> & Serializable)x$21 -> BoxesRunTime.boxToBoolean(FileCache$.$anonfun$auxiliaryFile$1(BoxesRunTime.unboxToChar(x$21))));
        return new File(file.getParentFile(), new StringBuilder(0).append(this.auxiliaryFilePrefix(file)).append(key0).toString());
    }

    public <F> FileCache<F> apply(Sync<F> S) {
        return this.apply(CacheDefaults$.MODULE$.location(), S);
    }

    public BigInteger coursier$cache$FileCache$$persistedDigest(File location, String sumType, File localFile) {
        byte[] byArray;
        String location0 = new StringBuilder(0).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(location.getCanonicalPath()), File.separator)).append(File.separator).toString();
        boolean isInCache = localFile.getCanonicalPath().startsWith(location0);
        if (!isInCache) {
            byArray = this.computeDigest(sumType, localFile);
        } else {
            File cacheFile = this.auxiliaryFile(localFile, new StringBuilder(9).append(sumType).append(".computed").toString());
            Path cacheFilePath = cacheFile.toPath();
            try {
                byArray = Files.readAllBytes(cacheFilePath);
            }
            catch (NoSuchFileException noSuchFileException) {
                byte[] bytes = this.computeDigest(sumType, localFile);
                Path tmpFile = File.createTempFile(cacheFile.getName(), ".tmp", cacheFile.getParentFile()).toPath();
                try {
                    Object object;
                    Files.write(tmpFile, bytes, new OpenOption[0]);
                    try {
                        object = Files.move(tmpFile, cacheFilePath, StandardCopyOption.ATOMIC_MOVE);
                    }
                    catch (FileAlreadyExistsException fileAlreadyExistsException) {
                        object = BoxedUnit.UNIT;
                    }
                }
                finally {
                    Files.deleteIfExists(tmpFile);
                }
                byArray = bytes;
            }
        }
        byte[] digested = byArray;
        return new BigInteger(1, digested);
    }

    private byte[] computeDigest(String sumType, File localFile) {
        MessageDigest md = MessageDigest.getInstance(sumType);
        try (FileInputStream is = null;){
            is = new FileInputStream(localFile);
            FileUtil$.MODULE$.withContent(is, new FileUtil.UpdateDigest(md), FileUtil$.MODULE$.withContent$default$3());
        }
        return md.digest();
    }

    public <F> FileCache<F> apply(File location, Sync<F> sync) {
        return new FileCache<F>(location, CacheDefaults$.MODULE$.cachePolicies(), CacheDefaults$.MODULE$.checksums(), CacheDefaults$.MODULE$.credentials(), CacheLogger$.MODULE$.nop(), CacheDefaults$.MODULE$.pool(), CacheDefaults$.MODULE$.ttl(), false, true, false, CacheDefaults$.MODULE$.maxRedirections(), CacheDefaults$.MODULE$.sslRetryCount(), None$.MODULE$, None$.MODULE$, CacheDefaults$.MODULE$.defaultRetryCount(), CacheDefaults$.MODULE$.bufferSize(), package$.MODULE$.Nil(), sync);
    }

    public <F> Sync<Task> apply$default$1() {
        return Task$.MODULE$.sync();
    }

    public static final /* synthetic */ boolean $anonfun$auxiliaryFile$1(char x$21) {
        return x$21 != '-';
    }

    private FileCache$() {
    }
}

