/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.bsp.testkit.mock;

import ch.epfl.scala.bsp.testkit.mock.AbstractMockServer;
import ch.epfl.scala.bsp.testkit.mock.HappyMockServer;
import ch.epfl.scala.bsp.testkit.mock.MockServer;
import ch.epfl.scala.bsp4j.BspConnectionDetails;
import ch.epfl.scala.bsp4j.BuildClient;
import com.google.gson.Gson;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;

public final class MockServer$ {
    public static final MockServer$ MODULE$ = new MockServer$();
    private static final ExecutorService executorService = Executors.newFixedThreadPool(4);

    public ExecutorService executorService() {
        return executorService;
    }

    public void main(String[] args) {
        String string;
        File cwd = new File(".").getCanonicalFile();
        boolean bl = false;
        Some some = null;
        Option option = ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])args));
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string2 = (String)some.value();
            if ("config".equals(string2)) {
                File configFile;
                String scriptPath = System.getProperty("script.path");
                File scriptFile = new File(scriptPath);
                if (this.createConnectionFile(scriptFile, configFile = new File(cwd, ".bsp/mockserver.json"))) {
                    Predef$.MODULE$.println((Object)new StringBuilder(21).append("config file written: ").append(configFile).toString());
                    return;
                }
                Predef$.MODULE$.println((Object)new StringBuilder(27).append("file could not be created: ").append(configFile).toString());
                return;
            }
        }
        if (bl && "bsp".equals(string = (String)some.value())) {
            HappyMockServer server = new HappyMockServer(cwd);
            Launcher<BuildClient> launcher = this.clientLauncher(server, System.in, System.out);
            BuildClient client = (BuildClient)launcher.getRemoteProxy();
            server.client_$eq(client);
            Future running = launcher.startListening();
            System.err.println("Mock server listening");
            running.get();
            return;
        }
        System.err.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("supported commands:\n            |config - create .bsp configuration in working directory\n            |bsp - start bsp server\n            |")));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean createConnectionFile(File scriptFile, File file) {
        File parent = file.getParentFile();
        if (!parent.isDirectory()) {
            if (!parent.mkdirs()) return false;
        }
        BspConnectionDetails details = new BspConnectionDetails("BSP Mock Server", CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)String.valueOf(scriptFile), (List)new .colon.colon((Object)"bsp", (List)Nil$.MODULE$))).asJava(), "1.0", "2.0", CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"java", (List)new .colon.colon((Object)"scala", (List)Nil$.MODULE$))).asJava());
        String detailsJson = new Gson().toJson((Object)details);
        java.util.List json = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)detailsJson, (List)Nil$.MODULE$)).asJava();
        Files.write(file.toPath(), (Iterable<? extends CharSequence>)json, new OpenOption[0]);
        if (!file.isFile()) return false;
        return true;
    }

    public MockServer.LocalMockServer startMockServer(File testBaseDir) {
        PipedInputStream clientIn = new PipedInputStream();
        PipedOutputStream serverOut = new PipedOutputStream(clientIn);
        PipedInputStream serverIn = new PipedInputStream();
        PipedOutputStream clientOut = new PipedOutputStream(serverIn);
        HappyMockServer server = new HappyMockServer(testBaseDir);
        Launcher<BuildClient> launcher = this.clientLauncher(server, serverIn, serverOut);
        BuildClient client = (BuildClient)launcher.getRemoteProxy();
        server.client_$eq(client);
        Future running = launcher.startListening();
        return new MockServer.LocalMockServer(running, clientIn, clientOut);
    }

    public Launcher<BuildClient> clientLauncher(AbstractMockServer server, InputStream in, OutputStream out) {
        return new Launcher.Builder().setOutput(out).setInput(in).setLocalService((Object)server).setExecutorService(this.executorService()).setRemoteInterface(BuildClient.class).create();
    }

    private MockServer$() {
    }
}

