/*
 * Decompiled with CFR 0.152.
 */
package buildpress;

import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import buildpress.BuildpressError;
import buildpress.ClonedRepository;
import buildpress.Repository;
import buildpress.RepositoryCache;
import buildpress.config.Config;
import buildpress.config.Config$;
import buildpress.package$;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;

public final class RepositoryCache$
implements scala.Serializable {
    public static RepositoryCache$ MODULE$;

    static {
        new RepositoryCache$();
    }

    public RepositoryCache empty(Path source) {
        return new RepositoryCache(source, (List<ClonedRepository>)Nil$.MODULE$);
    }

    public Either<BuildpressError.PersistFailure, BoxedUnit> persist(RepositoryCache cache) {
        Right right;
        Config.RepoCacheFile repr = new Config.RepoCacheFile("1.0.0", new Config.RepoCacheEntries((List)cache.repositories().map((Function1 & Serializable & scala.Serializable)repo -> new Config.RepoCacheEntry(repo.metadata().id(), repo.metadata().uri(), repo.localPath(), repo.buildSettingsHashes()), List$.MODULE$.canBuildFrom())));
        try {
            Right$ right$ = scala.package$.MODULE$.Right();
            Config$.MODULE$.write(repr, cache.source());
            right = right$.apply((Object)BoxedUnit.UNIT);
        }
        catch (IOException t) {
            String msg = new StringBuilder(48).append("Unexpected error when persisting cache file ").append(new AbsolutePath(cache.source())).append(": '").append(t.getMessage()).append("'").toString();
            right = scala.package$.MODULE$.Left().apply((Object)new BuildpressError.PersistFailure(package$.MODULE$.error(msg), (Option<Throwable>)new Some((Object)t)));
        }
        return right;
    }

    public Path repoCacheMetadataFile(Path home) {
        return AbsolutePath$.MODULE$.resolve$extension1(home, Config$.MODULE$.BuildpressCacheFileName());
    }

    public Path repoCacheDirectory(Path home) {
        return AbsolutePath$.MODULE$.resolve$extension1(home, "cache");
    }

    public Either<BuildpressError.ParseFailure, RepositoryCache> parse(Path home) {
        Path buildpressCacheFile = this.repoCacheMetadataFile(home);
        if (AbsolutePath$.MODULE$.exists$extension(buildpressCacheFile)) {
            Either either = Config$.MODULE$.readBuildpressConfig(buildpressCacheFile);
            if (either instanceof Left) {
                Left left = (Left)either;
                String err = (String)left.value();
                return scala.package$.MODULE$.Left().apply((Object)new BuildpressError.ParseFailure(err, (Option<Throwable>)None$.MODULE$));
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                Config.RepoCacheFile cf = (Config.RepoCacheFile)right.value();
                return scala.package$.MODULE$.Right().apply((Object)new RepositoryCache(buildpressCacheFile, (List<ClonedRepository>)((List)cf.cache().repos().map((Function1 & Serializable & scala.Serializable)rce -> new ClonedRepository(new Repository(rce.id(), rce.uri()), AbsolutePath$.MODULE$.apply(rce.localPath(), AbsolutePath$.MODULE$.workingDirectory()), rce.hashes()), List$.MODULE$.canBuildFrom()))));
            }
            throw new MatchError((Object)either);
        }
        return scala.package$.MODULE$.Right().apply((Object)this.empty(buildpressCacheFile));
    }

    public RepositoryCache apply(Path source, List<ClonedRepository> repositories) {
        return new RepositoryCache(source, repositories);
    }

    public Option<Tuple2<AbsolutePath, List<ClonedRepository>>> unapply(RepositoryCache x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)new AbsolutePath(x$0.source()), x$0.repositories()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RepositoryCache$() {
        MODULE$ = this;
    }
}

