/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection;

import dotty.runtime.LazyBoolean;
import dotty.runtime.LazyInt;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import strawman.collection.IterableOnce;
import strawman.collection.Iterator$;
import strawman.collection.Iterator$$anon$24$;
import strawman.collection.Seq;
import strawman.collection.immutable.ImmutableArray;
import strawman.collection.immutable.ImmutableArray$;
import strawman.collection.mutable.ArrayBuffer;
import strawman.collection.mutable.ArrayBuffer$;

public interface Iterator
extends IterableOnce {
    @Override
    default public void $init$() {
    }

    public boolean hasNext();

    public Object next();

    @Override
    default public Iterator iterator() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    default public boolean forall(Function1 p) {
        void var2_2;
        boolean res = true;
        while (res && this.hasNext()) {
            res = BoxesRunTime.unboxToBoolean((Object)p.apply(this.next()));
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    default public boolean exists(Function1 p) {
        void var2_2;
        boolean res = false;
        while (!res && this.hasNext()) {
            res = BoxesRunTime.unboxToBoolean((Object)p.apply(this.next()));
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    default public int count(Function1 p) {
        void var2_2;
        int res = 0;
        while (this.hasNext()) {
            if (!BoxesRunTime.unboxToBoolean((Object)p.apply(this.next()))) continue;
            ++res;
        }
        return (int)var2_2;
    }

    default public Option find(Function1 p) {
        while (this.hasNext()) {
            Object a = this.next();
            if (!BoxesRunTime.unboxToBoolean((Object)p.apply(a))) continue;
            return Some$.MODULE$.apply(a);
        }
        return None$.MODULE$;
    }

    default public GroupedIterator grouped(int size) {
        return new GroupedIterator(this, this, size, size);
    }

    default public GroupedIterator sliding(int size, int step) {
        return new GroupedIterator(this, this, size, step);
    }

    default public int sliding$default$2() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    default public Object foldLeft(Object z, Function2 op) {
        void var3_3;
        Object result = z;
        while (this.hasNext()) {
            result = op.apply(result, this.next());
        }
        return var3_3;
    }

    default public Object foldRight(Object z, Function2 op) {
        return this.hasNext() ? op.apply(this.next(), this.foldRight(z, op)) : z;
    }

    default public Iterator scanLeft(Object z, Function2 op) {
        return new Iterator(z, op, this){
            public final Object strawman$collection$Iterator$$anon$24$$z$1;
            public final Function2 strawman$collection$Iterator$$anon$24$$op$4;
            private Iterator current;
            private final Iterator $outer;
            {
                this.strawman$collection$Iterator$$anon$24$$z$1 = z$2;
                this.strawman$collection$Iterator$$anon$24$$op$4 = op$5;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.current = new Iterator(this){
                    private final $anon$24 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public boolean hasNext() {
                        return true;
                    }

                    public Object next() {
                        this.strawman$collection$Iterator$_$$anon$_$$anon$$$outer().strawman$collection$Iterator$$anon$24$$current_$eq(new Iterator(this.strawman$collection$Iterator$_$$anon$_$$anon$$$outer().strawman$collection$Iterator$$anon$24$$z$1, this){
                            private Object acc;
                            private final $anon$24$$anon$23 $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.acc = z$3;
                            }

                            private Object acc() {
                                return this.acc;
                            }

                            private void acc_$eq(Object x$1) {
                                this.acc = x$1;
                            }

                            public Object next() {
                                this.acc_$eq(this.strawman$collection$Iterator$_$$anon$_$$anon$_$$anon$$$outer().strawman$collection$Iterator$_$$anon$_$$anon$$$outer().strawman$collection$Iterator$$anon$24$$op$4.apply(this.acc(), this.strawman$collection$Iterator$_$$anon$_$$anon$_$$anon$$$outer().strawman$collection$Iterator$_$$anon$_$$anon$$$outer().strawman$collection$Iterator$_$$anon$$$outer().next()));
                                return this.acc();
                            }

                            public boolean hasNext() {
                                return this.strawman$collection$Iterator$_$$anon$_$$anon$_$$anon$$$outer().strawman$collection$Iterator$_$$anon$_$$anon$$$outer().strawman$collection$Iterator$_$$anon$$$outer().hasNext();
                            }

                            private $anon$24$$anon$23 $outer() {
                                return this.$outer;
                            }

                            public final $anon$24$$anon$23 strawman$collection$Iterator$_$$anon$_$$anon$_$$anon$$$outer() {
                                return this.$outer();
                            }
                        });
                        return this.strawman$collection$Iterator$_$$anon$_$$anon$$$outer().strawman$collection$Iterator$$anon$24$$z$1;
                    }

                    private $anon$24 $outer() {
                        return this.$outer;
                    }

                    public final $anon$24 strawman$collection$Iterator$_$$anon$_$$anon$$$outer() {
                        return this.$outer();
                    }
                };
            }

            private Iterator current() {
                return this.current;
            }

            public void strawman$collection$Iterator$$anon$24$$current_$eq(Iterator x$1) {
                this.current = x$1;
            }

            public Object next() {
                return this.current().next();
            }

            public boolean hasNext() {
                return this.current().hasNext();
            }

            private Iterator $outer() {
                return this.$outer;
            }

            public final Iterator strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public void foreach(Function1 f) {
        while (this.hasNext()) {
            f.apply(this.next());
        }
    }

    default public int indexWhere(Function1 p, int from) {
        int i = package$.MODULE$.max(from, 0);
        this.drop(from);
        while (this.hasNext()) {
            if (BoxesRunTime.unboxToBoolean((Object)p.apply(this.next()))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    default public int length() {
        void var1_1;
        int len = 0;
        while (this.hasNext()) {
            ++len;
            this.next();
        }
        return (int)var1_1;
    }

    default public Iterator filter(Function1 p) {
        return new Iterator(p, this){
            private final Function1 p$1;
            private Object hd;
            private boolean hdDefined;
            private final Iterator $outer;
            {
                this.p$1 = p$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hdDefined = false;
            }

            private Object hd() {
                return this.hd;
            }

            private void hd_$eq(Object x$1) {
                this.hd = x$1;
            }

            private boolean hdDefined() {
                return this.hdDefined;
            }

            private void hdDefined_$eq(boolean x$1) {
                this.hdDefined = x$1;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() {
                if (this.hdDefined()) return true;
                do {
                    if (!this.strawman$collection$Iterator$_$$anon$$$outer().hasNext()) {
                        return false;
                    }
                    this.hd_$eq(this.strawman$collection$Iterator$_$$anon$$$outer().next());
                } while (!BoxesRunTime.unboxToBoolean((Object)this.p$1.apply(this.hd())));
                this.hdDefined_$eq(true);
                if (true) return true;
                return false;
            }

            public Object next() {
                Object object;
                if (this.hasNext()) {
                    this.hdDefined_$eq(false);
                    object = this.hd();
                } else {
                    object = Iterator$.MODULE$.empty().next();
                }
                return object;
            }

            private Iterator $outer() {
                return this.$outer;
            }

            public final Iterator strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public Iterator map(Function1 f) {
        return new Iterator(f, this){
            private final Function1 f$4;
            private final Iterator $outer;
            {
                this.f$4 = f$6;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public boolean hasNext() {
                return this.strawman$collection$Iterator$_$$anon$$$outer().hasNext();
            }

            public Object next() {
                return this.f$4.apply(this.strawman$collection$Iterator$_$$anon$$$outer().next());
            }

            private Iterator $outer() {
                return this.$outer;
            }

            public final Iterator strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public Iterator flatMap(Function1 f) {
        return new Iterator(f, this){
            private final Function1 f$5;
            private Iterator myCurrent;
            private final Iterator $outer;
            {
                this.f$5 = f$7;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.myCurrent = Iterator$.MODULE$.empty();
            }

            private Iterator myCurrent() {
                return this.myCurrent;
            }

            private void myCurrent_$eq(Iterator x$1) {
                this.myCurrent = x$1;
            }

            private Iterator current() {
                while (!this.myCurrent().hasNext() && this.strawman$collection$Iterator$_$$anon$$$outer().hasNext()) {
                    this.myCurrent_$eq(((IterableOnce)this.f$5.apply(this.strawman$collection$Iterator$_$$anon$$$outer().next())).iterator());
                }
                return this.myCurrent();
            }

            public boolean hasNext() {
                return this.current().hasNext();
            }

            public Object next() {
                return this.current().next();
            }

            private Iterator $outer() {
                return this.$outer;
            }

            public final Iterator strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public Iterator $plus$plus(IterableOnce xs) {
        return new Iterator(xs, this){
            private final IterableOnce xs$6;
            private Iterator myCurrent;
            private boolean first;
            private final Iterator $outer;
            {
                this.xs$6 = xs$9;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.myCurrent = this.strawman$collection$Iterator$_$$anon$$$outer();
                this.first = true;
            }

            private Iterator myCurrent() {
                return this.myCurrent;
            }

            private void myCurrent_$eq(Iterator x$1) {
                this.myCurrent = x$1;
            }

            private boolean first() {
                return this.first;
            }

            private void first_$eq(boolean x$1) {
                this.first = x$1;
            }

            private Iterator current() {
                block0: {
                    if (this.myCurrent().hasNext() || !this.first()) break block0;
                    this.myCurrent_$eq(this.xs$6.iterator());
                    this.first_$eq(false);
                }
                return this.myCurrent();
            }

            public boolean hasNext() {
                return this.current().hasNext();
            }

            public Object next() {
                return this.current().next();
            }

            private Iterator $outer() {
                return this.$outer;
            }

            public final Iterator strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public Iterator take(int n) {
        return new Iterator(n, this){
            private final int n$1;
            private int i;
            private final Iterator $outer;
            {
                this.n$1 = n$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.i = 0;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                return this.strawman$collection$Iterator$_$$anon$$$outer().hasNext() && this.i() < this.n$1;
            }

            public Object next() {
                Object object;
                if (this.hasNext()) {
                    this.i_$eq(this.i() + 1);
                    object = this.strawman$collection$Iterator$_$$anon$$$outer().next();
                } else {
                    object = Iterator$.MODULE$.empty().next();
                }
                return object;
            }

            private Iterator $outer() {
                return this.$outer;
            }

            public final Iterator strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public Iterator takeRight(int n) {
        return n <= 0 ? Iterator$.MODULE$.empty() : new Iterator(n, this){
            private final int n$2;
            private int index;
            private int count;
            private ArrayBuffer buffer$lzy1;
            private boolean bufferbitmap$1;
            private final Iterator $outer;
            {
                this.n$2 = n$5;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Iterator.super.$init$();
                this.index = 0;
                this.count = 0;
            }

            /*
             * WARNING - void declaration
             */
            private ArrayBuffer buffer() {
                ArrayBuffer arrayBuffer;
                if (this.bufferbitmap$1) {
                    arrayBuffer = this.buffer$lzy1;
                } else {
                    void var1_1;
                    this.bufferbitmap$1 = true;
                    ArrayBuffer buf = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    while (this.strawman$collection$Iterator$_$$anon$$$outer().hasNext()) {
                        Object object;
                        if (this.index >= buf.length()) {
                            Object elem = this.strawman$collection$Iterator$_$$anon$$$outer().next();
                            ArrayBuffer Growable_this = buf;
                            object = Growable_this.add(elem);
                        } else {
                            buf.update(this.index, this.strawman$collection$Iterator$_$$anon$$$outer().next());
                            object = BoxedUnit.UNIT;
                        }
                        int n = this.index + 1 >= this.n$2 ? 0 : (this.index = this.index + 1);
                        if (this.count >= this.n$2) continue;
                        ++this.count;
                    }
                    this.index = this.index >= buf.length() ? 0 : this.index;
                    arrayBuffer = this.buffer$lzy1 = var1_1;
                }
                return arrayBuffer;
            }

            public boolean hasNext() {
                return this.buffer() != null && this.count > 0;
            }

            /*
             * WARNING - void declaration
             */
            public Object next() {
                void var1_1;
                Object value = this.buffer().apply(this.index);
                this.index = this.index + 1 >= this.buffer().length() ? 0 : this.index + 1;
                --this.count;
                return var1_1;
            }

            private Iterator $outer() {
                return this.$outer;
            }

            public final Iterator strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public Iterator takeWhile(Function1 p) {
        return new Iterator(p, this){
            private final Function1 p$2;
            private Object hd;
            private boolean hdDefined;
            private Iterator tail;
            private final Iterator $outer;
            {
                this.p$2 = p$5;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hdDefined = false;
                this.tail = this.strawman$collection$Iterator$_$$anon$$$outer();
            }

            private Object hd() {
                return this.hd;
            }

            private void hd_$eq(Object x$1) {
                this.hd = x$1;
            }

            private boolean hdDefined() {
                return this.hdDefined;
            }

            private void hdDefined_$eq(boolean x$1) {
                this.hdDefined = x$1;
            }

            private Iterator tail() {
                return this.tail;
            }

            private void tail_$eq(Iterator x$1) {
                this.tail = x$1;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() {
                if (this.hdDefined()) return true;
                if (!this.tail().hasNext()) return false;
                this.hd_$eq(this.tail().next());
                if (BoxesRunTime.unboxToBoolean((Object)this.p$2.apply(this.hd()))) {
                    this.hdDefined_$eq(true);
                } else {
                    this.tail_$eq(Iterator$.MODULE$.empty());
                }
                if (this.hdDefined()) return true;
                return false;
            }

            public Object next() {
                Object object;
                if (this.hasNext()) {
                    this.hdDefined_$eq(false);
                    object = this.hd();
                } else {
                    object = Iterator$.MODULE$.empty().next();
                }
                return object;
            }

            private Iterator $outer() {
                return this.$outer;
            }

            public final Iterator strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public Iterator drop(int n) {
        for (int i = 0; i < n && this.hasNext(); ++i) {
            this.next();
        }
        return this;
    }

    default public Iterator dropRight(int n) {
        return n <= 0 ? this : new Iterator(n, this){
            private final int n$3;
            private int index;
            private ArrayBuffer buffer$lzy2;
            private boolean bufferbitmap$2;
            private final Iterator $outer;
            {
                this.n$3 = n$6;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Iterator.super.$init$();
                this.index = 0;
            }

            /*
             * WARNING - void declaration
             */
            private ArrayBuffer buffer() {
                ArrayBuffer arrayBuffer;
                if (this.bufferbitmap$2) {
                    arrayBuffer = this.buffer$lzy2;
                } else {
                    void var1_1;
                    this.bufferbitmap$2 = true;
                    ArrayBuffer buf = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    while (this.index < this.n$3 && this.strawman$collection$Iterator$_$$anon$$$outer().hasNext()) {
                        Object elem = this.strawman$collection$Iterator$_$$anon$$$outer().next();
                        ArrayBuffer Growable_this = buf;
                        Growable_this.add(elem);
                        ++this.index;
                    }
                    this.index = 0;
                    arrayBuffer = this.buffer$lzy2 = var1_1;
                }
                return arrayBuffer;
            }

            public boolean hasNext() {
                return this.buffer() != null && this.strawman$collection$Iterator$_$$anon$$$outer().hasNext();
            }

            /*
             * WARNING - void declaration
             */
            public Object next() {
                void var1_1;
                Object value = this.buffer().apply(this.index);
                this.buffer().update(this.index, this.strawman$collection$Iterator$_$$anon$$$outer().next());
                this.index = this.index + 1 >= this.buffer().length() ? 0 : this.index + 1;
                return var1_1;
            }

            private Iterator $outer() {
                return this.$outer;
            }

            public final Iterator strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public Iterator dropWhile(Function1 p) {
        return new Iterator(p, this){
            private final Function1 p$3;
            private int status;
            private Object fst;
            private final Iterator $outer;
            {
                this.p$3 = p$6;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.status = -1;
            }

            public boolean hasNext() {
                boolean bl;
                if (this.status == 1) {
                    bl = this.strawman$collection$Iterator$_$$anon$$$outer().hasNext();
                } else if (this.status == 0) {
                    bl = true;
                } else {
                    while (this.strawman$collection$Iterator$_$$anon$$$outer().hasNext()) {
                        Object a = this.strawman$collection$Iterator$_$$anon$$$outer().next();
                        if (BoxesRunTime.unboxToBoolean((Object)this.p$3.apply(a))) continue;
                        this.fst = a;
                        this.status = 0;
                        return true;
                    }
                    this.status = 1;
                    bl = false;
                }
                return bl;
            }

            public Object next() {
                Object object;
                if (this.hasNext()) {
                    if (this.status == 1) {
                        object = this.strawman$collection$Iterator$_$$anon$$$outer().next();
                    } else {
                        this.status = 1;
                        object = this.fst;
                    }
                } else {
                    object = Iterator$.MODULE$.empty().next();
                }
                return object;
            }

            private Iterator $outer() {
                return this.$outer;
            }

            public final Iterator strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public Iterator zip(IterableOnce that) {
        return new Iterator(that, this){
            private final IterableOnce that$1;
            private final Iterator thatIterator;
            private final Iterator $outer;
            {
                this.that$1 = that$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.thatIterator = that$2.iterator();
            }

            public Iterator thatIterator() {
                return this.thatIterator;
            }

            public boolean hasNext() {
                return this.strawman$collection$Iterator$_$$anon$$$outer().hasNext() && this.thatIterator().hasNext();
            }

            public Tuple2 next() {
                return Tuple2$.MODULE$.apply(this.strawman$collection$Iterator$_$$anon$$$outer().next(), this.thatIterator().next());
            }

            private Iterator $outer() {
                return this.$outer;
            }

            public final Iterator strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public Iterator zipWithIndex() {
        return new Iterator(this){
            private int idx;
            private final Iterator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.idx = 0;
            }

            public int idx() {
                return this.idx;
            }

            public void idx_$eq(int x$1) {
                this.idx = x$1;
            }

            public boolean hasNext() {
                return this.strawman$collection$Iterator$_$$anon$$$outer().hasNext();
            }

            /*
             * WARNING - void declaration
             */
            public Tuple2 next() {
                void var1_1;
                Tuple2 ret = Tuple2$.MODULE$.apply(this.strawman$collection$Iterator$_$$anon$$$outer().next(), (Object)BoxesRunTime.boxToInteger((int)this.idx()));
                this.idx_$eq(this.idx() + 1);
                return var1_1;
            }

            private Iterator $outer() {
                return this.$outer;
            }

            public final Iterator strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public boolean sameElements(IterableOnce that) {
        Iterator those = that.iterator();
        while (this.hasNext() && those.hasNext()) {
            if (BoxesRunTime.equals((Object)this.next(), (Object)those.next())) continue;
            return false;
        }
        return this.hasNext() == those.hasNext();
    }

    public static class GroupedIterator
    implements Iterator {
        private final Iterator self;
        private final int size;
        private final int step;
        private ArrayBuffer buffer;
        private boolean filled;
        private boolean _partial;
        private Option pad;
        private final Iterator $outer;

        public GroupedIterator(Iterator $outer, Iterator self, int size, int step) {
            this.self = self;
            this.size = size;
            this.step = step;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Predef$.MODULE$.require(size >= 1 && step >= 1, () -> this.$init$$$anonfun$1(size, step));
            this.buffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            this.filled = false;
            this._partial = true;
            this.pad = None$.MODULE$;
        }

        public GroupedIterator withPadding(Function0 x) {
            this.pad = Some$.MODULE$.apply(() -> this.withPadding$$anonfun$1(x));
            return this;
        }

        public GroupedIterator withPartial(boolean x) {
            block0: {
                this._partial = x;
                if (!this._partial) break block0;
                this.pad = None$.MODULE$;
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private Seq takeDestructively(int size) {
            void var2_2;
            ArrayBuffer buf = new ArrayBuffer();
            for (int i = 0; i < size && this.self.hasNext(); ++i) {
                Object elem = this.self.next();
                ArrayBuffer Growable_this = buf;
                Growable_this.add(elem);
            }
            return var2_2;
        }

        private ImmutableArray padding(int x) {
            return ImmutableArray$.MODULE$.fill(x, this::padding$$anonfun$1);
        }

        private int gap() {
            return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.step - this.size), 0);
        }

        private boolean go(int count) {
            Seq xs;
            Seq seq;
            LazyInt lazyInt = new LazyInt();
            LazyBoolean lazyBoolean = new LazyBoolean();
            int prevSize = this.buffer.size();
            Seq res = this.takeDestructively(count);
            int shortBy = count - res.length();
            if (shortBy > 0 && this.pad.isDefined()) {
                ImmutableArray xs2 = this.padding(shortBy);
                Seq IterableOps_this = res;
                seq = (Seq)IterableOps_this.concat(xs2);
            } else {
                seq = xs = res;
            }
            return xs.isEmpty() ? false : (this._partial ? this.deliver$1(prevSize, xs, lazyInt, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.len$1(xs, lazyInt)), this.size)) : (this.incomplete$1(count, xs, lazyInt, lazyBoolean) ? false : (this.isFirst$1(prevSize) ? this.deliver$1(prevSize, xs, lazyInt, this.len$1(xs, lazyInt)) : this.deliver$1(prevSize, xs, lazyInt, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.step), this.size)))));
        }

        private boolean fill() {
            return !this.self.hasNext() ? false : (this.buffer.isEmpty() ? this.go(this.size) : this.go(this.step));
        }

        @Override
        public boolean hasNext() {
            return this.filled || this.fill();
        }

        @Override
        public ImmutableArray next() {
            Object object = !this.filled ? BoxesRunTime.boxToBoolean((boolean)this.fill()) : BoxedUnit.UNIT;
            if (!this.filled) {
                throw new NoSuchElementException("next on empty iterator");
            }
            this.filled = false;
            return ImmutableArray$.MODULE$.fromArrayBuffer(this.buffer);
        }

        private Iterator $outer() {
            return this.$outer;
        }

        public final Iterator strawman$collection$Iterator$GroupedIterator$$$outer() {
            return this.$outer();
        }

        private String $init$$$anonfun$1(int size$1, int step$1) {
            return StringContext$.MODULE$.apply((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size=", "%d and step=", "%d, but both must be positive"})).f((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size$1), BoxesRunTime.boxToInteger((int)step$1)}));
        }

        private Object withPadding$$anonfun$1(Function0 x$1) {
            return x$1.apply();
        }

        private Object padding$$anonfun$1() {
            return ((Function0)this.pad.get()).apply();
        }

        private boolean isFirst$1(int prevSize$1) {
            return prevSize$1 == 0;
        }

        private int len$lzyINIT1$1(Seq xs$1, LazyInt len$lzy1$1) {
            Integer n;
            LazyInt lazyInt = len$lzy1$1;
            synchronized (lazyInt) {
                int n2;
                if (len$lzy1$1.initialized()) {
                    n2 = len$lzy1$1.value();
                } else {
                    len$lzy1$1.initialized_$eq(true);
                    len$lzy1$1.value_$eq(xs$1.length());
                    n2 = len$lzy1$1.value();
                }
                n = BoxesRunTime.boxToInteger((int)n2);
            }
            return BoxesRunTime.unboxToInt((Object)n);
        }

        private int len$1(Seq xs$2, LazyInt len$lzy1$2) {
            return len$lzy1$2.initialized() ? len$lzy1$2.value() : this.len$lzyINIT1$1(xs$2, len$lzy1$2);
        }

        private boolean incomplete$lzyINIT1$1(int count$1, Seq xs$3, LazyInt len$lzy1$3, LazyBoolean incomplete$lzy1$1) {
            Boolean bl;
            LazyBoolean lazyBoolean = incomplete$lzy1$1;
            synchronized (lazyBoolean) {
                boolean bl2;
                if (incomplete$lzy1$1.initialized()) {
                    bl2 = incomplete$lzy1$1.value();
                } else {
                    incomplete$lzy1$1.initialized_$eq(true);
                    incomplete$lzy1$1.value_$eq(this.len$1(xs$3, len$lzy1$3) < count$1);
                    bl2 = incomplete$lzy1$1.value();
                }
                bl = BoxesRunTime.boxToBoolean((boolean)bl2);
            }
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }

        private boolean incomplete$1(int count$2, Seq xs$4, LazyInt len$lzy1$4, LazyBoolean incomplete$lzy1$2) {
            return incomplete$lzy1$2.initialized() ? incomplete$lzy1$2.value() : this.incomplete$lzyINIT1$1(count$2, xs$4, len$lzy1$4, incomplete$lzy1$2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean deliver$1(int prevSize$2, Seq xs$5, LazyInt len$lzy1$5, int howMany) {
            if (howMany <= 0 || !this.isFirst$1(prevSize$2) && this.len$1(xs$5, len$lzy1$5) <= this.gap()) return false;
            Object object = !this.isFirst$1(prevSize$2) ? this.buffer.dropInPlace(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.step), prevSize$2)) : BoxedUnit.UNIT;
            int available = this.isFirst$1(prevSize$2) ? this.len$1(xs$5, len$lzy1$5) : RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(howMany), this.len$1(xs$5, len$lzy1$5) - this.gap());
            Seq xs = (Seq)xs$5.takeRight(available);
            ArrayBuffer Growable_this = this.buffer;
            Growable_this.addAll(xs);
            this.filled = true;
            if (true) return true;
            return false;
        }
    }
}

