/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import strawman.collection.IndexedSeqOps;
import strawman.collection.IndexedView;
import strawman.collection.Iterable;
import strawman.collection.IterableFactory;
import strawman.collection.IterableOps;
import strawman.collection.Iterator;
import strawman.collection.SeqOps;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.immutable.IndexedSeq;
import strawman.collection.immutable.IndexedSeq$;
import strawman.collection.immutable.Nil$;
import strawman.collection.immutable.Range$;
import strawman.collection.immutable.RangeIterator;
import strawman.collection.mutable.Builder;

public final class Range
implements IterableOps,
SeqOps,
IndexedSeqOps,
IndexedSeq,
StrictOptimizedIterableOps,
Serializable {
    private final int start;
    private final int end;
    private final int step;
    private final boolean isInclusive;
    private final boolean isEmpty;
    private final int length;
    private final int lastElement;

    public Range(int start, int end, int step, boolean isInclusive) {
        int n;
        int n2;
        this.start = start;
        this.end = end;
        this.step = step;
        this.isInclusive = isInclusive;
        boolean bl = this.isEmpty = start > end && step > 0 || start < end && step < 0 || start == end && !isInclusive;
        if (step == 0) {
            throw new IllegalArgumentException("step cannot be 0.");
        }
        if (this.isEmpty()) {
            n2 = 0;
        } else {
            long len = this.longLength();
            n2 = len > Integer.MAX_VALUE ? -1 : (int)len;
        }
        this.length = n2;
        int n3 = step;
        switch (n3) {
            case 1: {
                if (isInclusive) {
                    n = end;
                    break;
                }
                n = end - 1;
                break;
            }
            case -1: {
                if (isInclusive) {
                    n = end;
                    break;
                }
                n = end + 1;
                break;
            }
            default: {
                int remainder = (int)(this.gap() % (long)step);
                if (remainder != 0) {
                    n = end - remainder;
                    break;
                }
                if (isInclusive) {
                    n = end;
                    break;
                }
                n = end - step;
                break;
            }
        }
        this.lastElement = n;
    }

    @Override
    public int hashCode() {
        return SeqOps.super.hashCode();
    }

    @Override
    public IndexedView view() {
        return IndexedSeqOps.super.view();
    }

    @Override
    public Iterable reversed() {
        return IndexedSeqOps.super.reversed();
    }

    @Override
    public Tuple2 partition(Function1 p) {
        return StrictOptimizedIterableOps.super.partition(p);
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public int step() {
        return this.step;
    }

    public boolean isInclusive() {
        return this.isInclusive;
    }

    @Override
    public IterableFactory iterableFactory() {
        return IndexedSeq$.MODULE$;
    }

    @Override
    public IndexedSeq fromSpecificIterable(Iterable coll) {
        return (IndexedSeq)this.fromIterable(coll);
    }

    @Override
    public Builder newSpecificBuilder() {
        return IndexedSeq$.MODULE$.newBuilder();
    }

    @Override
    public Iterator iterator() {
        return new RangeIterator(this.start(), this.step(), this.lastElement(), this.isEmpty());
    }

    private long gap() {
        return (long)this.end() - (long)this.start();
    }

    private boolean isExact() {
        return this.gap() % (long)this.step() == 0L;
    }

    private boolean hasStub() {
        return this.isInclusive() || !this.isExact();
    }

    private long longLength() {
        return this.gap() / (long)this.step() + (long)(this.hasStub() ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public int length() {
        return this.length;
    }

    private int lastElement() {
        return this.lastElement;
    }

    public int last() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.head();
        }
        return this.lastElement();
    }

    public int head() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.head();
        }
        return this.start();
    }

    @Override
    public Range init() {
        Object object = this.isEmpty() ? Nil$.MODULE$.init() : BoxedUnit.UNIT;
        return this.dropRight(1);
    }

    @Override
    public Range tail() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.tail();
        }
        return this.length() == 1 ? this.newEmptyRange(this.end()) : new Range(this.start() + this.step(), this.end(), this.step(), this.isInclusive());
    }

    public Range copy(int start, int end, int step, boolean isInclusive) {
        return new Range(start, end, step, isInclusive);
    }

    public int copy$default$1() {
        return this.start();
    }

    public int copy$default$2() {
        return this.end();
    }

    public int copy$default$3() {
        return this.step();
    }

    public boolean copy$default$4() {
        return this.isInclusive();
    }

    public Range by(int step) {
        return this.copy(this.start(), this.end(), step, this.copy$default$4());
    }

    @Override
    public int size() {
        return this.length();
    }

    private void validateMaxLength() {
        if (this.length() < 0) {
            throw this.fail();
        }
    }

    private String description() {
        Object[] objectArray = new Object[4];
        objectArray[0] = BoxesRunTime.boxToInteger((int)this.start());
        objectArray[1] = this.isInclusive() ? "to" : "until";
        objectArray[2] = BoxesRunTime.boxToInteger((int)this.end());
        objectArray[3] = BoxesRunTime.boxToInteger((int)this.step());
        return new StringOps(Predef$.MODULE$.augmentString("%d %s %d by %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
    }

    private Nothing$ fail() {
        throw new IllegalArgumentException(new StringBuilder().append((Object)this.description()).append((Object)": seqs cannot contain more than Int.MaxValue elements.").toString());
    }

    public int apply(int idx) {
        this.validateMaxLength();
        if (idx < 0 || idx >= this.length()) {
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)idx)).toString());
        }
        return this.start() + this.step() * idx;
    }

    @Override
    public void foreach(Function1 f) {
        if (!this.isEmpty()) {
            int i = this.start();
            while (true) {
                f.apply((Object)BoxesRunTime.boxToInteger((int)i));
                if (i == this.lastElement()) {
                    return;
                }
                i += this.step();
            }
        }
    }

    @Override
    public Range take(int n) {
        return n <= 0 || this.isEmpty() ? this.newEmptyRange(this.start()) : (n >= this.length() && this.length() >= 0 ? this : new Range(this.start(), this.locationAfterN(n - 1), this.step(), true));
    }

    @Override
    public Range drop(int n) {
        return n <= 0 || this.isEmpty() ? this : (n >= this.length() && this.length() >= 0 ? this.newEmptyRange(this.end()) : this.copy(this.locationAfterN(n), this.end(), this.step(), this.copy$default$4()));
    }

    @Override
    public Range takeRight(int n) {
        Range range;
        if (n <= 0) {
            range = this.newEmptyRange(this.start());
        } else if (this.length() >= 0) {
            range = this.drop(this.length() - n);
        } else {
            int y = this.last();
            long x = (long)y - (long)this.step() * (long)(n - 1);
            range = this.step() > 0 && x < (long)this.start() || this.step() < 0 && x > (long)this.start() ? this : Range$.MODULE$.inclusive((int)x, y, this.step());
        }
        return range;
    }

    @Override
    public Range dropRight(int n) {
        Range range;
        if (n <= 0) {
            range = this;
        } else if (this.length() >= 0) {
            range = this.take(this.length() - n);
        } else {
            int y = this.last() - this.step() * n;
            range = this.step() > 0 && y < this.start() || this.step() < 0 && y > this.start() ? this.newEmptyRange(this.start()) : Range$.MODULE$.inclusive(this.start(), y, this.step());
        }
        return range;
    }

    private long argTakeWhile(Function1 p) {
        long l;
        if (this.isEmpty()) {
            l = Int$.MODULE$.int2long(this.start());
        } else {
            int current;
            int stop = this.last();
            for (current = this.start(); current != stop && BoxesRunTime.unboxToBoolean((Object)p.apply((Object)BoxesRunTime.boxToInteger((int)current))); current += this.step()) {
            }
            l = current != stop || !BoxesRunTime.unboxToBoolean((Object)p.apply((Object)BoxesRunTime.boxToInteger((int)current))) ? Int$.MODULE$.int2long(current) : (long)current + (long)this.step();
        }
        return l;
    }

    @Override
    public Range takeWhile(Function1 p) {
        Range range;
        long stop = this.argTakeWhile(p);
        if (stop == (long)this.start()) {
            range = this.newEmptyRange(this.start());
        } else {
            int x = (int)(stop - (long)this.step());
            range = x == this.last() ? this : Range$.MODULE$.inclusive(this.start(), x, this.step());
        }
        return range;
    }

    @Override
    public Range dropWhile(Function1 p) {
        Range range;
        long stop = this.argTakeWhile(p);
        if (stop == (long)this.start()) {
            range = this;
        } else {
            int x = (int)(stop - (long)this.step());
            range = x == this.last() ? this.newEmptyRange(this.last()) : Range$.MODULE$.inclusive(x + this.step(), this.last(), this.step());
        }
        return range;
    }

    @Override
    public Tuple2 span(Function1 p) {
        Tuple2 tuple2;
        long border = this.argTakeWhile(p);
        if (border == (long)this.start()) {
            tuple2 = Tuple2$.MODULE$.apply((Object)this.newEmptyRange(this.start()), (Object)this);
        } else {
            int x = (int)(border - (long)this.step());
            tuple2 = x == this.last() ? Tuple2$.MODULE$.apply((Object)this, (Object)this.newEmptyRange(this.last())) : Tuple2$.MODULE$.apply((Object)Range$.MODULE$.inclusive(this.start(), x, this.step()), (Object)Range$.MODULE$.inclusive(x + this.step(), this.last(), this.step()));
        }
        return tuple2;
    }

    @Override
    public Range slice(int from, int until) {
        Range range;
        if (from <= 0) {
            range = this.take(until);
        } else if (until >= this.length() && this.length() >= 0) {
            range = this.drop(from);
        } else {
            int fromValue = this.locationAfterN(from);
            range = from >= until ? this.newEmptyRange(fromValue) : Range$.MODULE$.inclusive(fromValue, this.locationAfterN(until - 1), this.step());
        }
        return range;
    }

    @Override
    public Tuple2 splitAt(int n) {
        return Tuple2$.MODULE$.apply((Object)this.take(n), (Object)this.drop(n));
    }

    private int locationAfterN(int n) {
        return this.start() + this.step() * n;
    }

    private Range newEmptyRange(int value) {
        return new Range(value, value, this.step(), false);
    }

    @Override
    public Range reverse() {
        return this.isEmpty() ? this : new Range(this.last(), this.start(), -this.step(), true);
    }

    public Range inclusive() {
        return this.isInclusive() ? this : new Range(this.start(), this.end(), this.step(), true);
    }

    public boolean contains(int x) {
        return x == this.end() && !this.isInclusive() ? false : (this.step() > 0 ? (x < this.start() || x > this.end() ? false : this.step() == 1 || (x - this.start()) % this.step() == 0) : (x < this.end() || x > this.start() ? false : this.step() == -1 || (x - this.start()) % this.step() == 0));
    }

    public int sum(Numeric num) {
        int n;
        if (num == Numeric.IntIsIntegral$.MODULE$) {
            n = this.isEmpty() ? 0 : (this.size() == 1 ? this.head() : (int)((long)this.size() * ((long)this.head() + (long)this.last()) / 2L));
        } else if (this.isEmpty()) {
            n = num.toInt(num.zero());
        } else {
            Object acc = num.zero();
            int i = this.head();
            while (true) {
                acc = num.plus(acc, (Object)BoxesRunTime.boxToInteger((int)i));
                if (i == this.lastElement()) {
                    return num.toInt(acc);
                }
                i += this.step();
            }
        }
        return n;
    }

    public int min(Ordering ord) {
        package$.MODULE$.Ordering();
        return ord == Ordering.Int$.MODULE$ ? (this.step() > 0 ? this.head() : this.last()) : BoxesRunTime.unboxToInt((Object)IterableOps.super.min(ord));
    }

    public int max(Ordering ord) {
        package$.MODULE$.Ordering();
        return ord == Ordering.Int$.MODULE$ ? (this.step() > 0 ? this.last() : this.head()) : BoxesRunTime.unboxToInt((Object)IterableOps.super.max(ord));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (!(object instanceof Range)) {
            bl = SeqOps.super.equals(other);
            return bl;
        }
        Range x = (Range)object;
        if (this.isEmpty()) {
            bl = x.isEmpty();
            return bl;
        }
        if (x.nonEmpty() && this.start() == x.start()) {
            int l0 = this.last();
            if (l0 == x.last()) {
                if (this.start() == l0) return true;
                if (this.step() == x.step()) return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public String toString() {
        String stepped;
        String preposition;
        String string = this.isInclusive() ? "to" : (preposition = "until");
        String string2 = this.step() == 1 ? "" : (stepped = StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" by ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.step())})));
        String prefix = this.isEmpty() ? "empty " : (!this.isExact() ? "inexact " : "");
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "Range ", " ", " ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, BoxesRunTime.boxToInteger((int)this.start()), preposition, BoxesRunTime.boxToInteger((int)this.end()), stepped}));
    }
}

