/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import strawman.collection.Iterable;
import strawman.collection.IterableFactory;
import strawman.collection.IterableOnce;
import strawman.collection.Iterator;
import strawman.collection.SortedIterableFactory;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.immutable.RedBlackTree;
import strawman.collection.immutable.RedBlackTree$;
import strawman.collection.immutable.Set;
import strawman.collection.immutable.Set$;
import strawman.collection.immutable.SetOps;
import strawman.collection.immutable.SortedSet;
import strawman.collection.immutable.TreeSet$;
import strawman.collection.mutable.Builder;

public final class TreeSet
implements strawman.collection.SetOps,
SetOps,
SortedSet,
StrictOptimizedIterableOps {
    private final RedBlackTree.Tree tree;
    private final Ordering ordering;

    public static Object fill(int n, Function0 function0, Ordering ordering) {
        return TreeSet$.MODULE$.fill(n, function0, ordering);
    }

    public static Builder newBuilder(Ordering ordering) {
        return TreeSet$.MODULE$.newBuilder(ordering);
    }

    private TreeSet(RedBlackTree.Tree tree, Ordering ordering) {
        this.tree = tree;
        this.ordering = ordering;
        Function1.class.$init$((Function1)this);
        if (ordering == null) {
            throw new NullPointerException("ordering must not be null");
        }
    }

    public Function1 compose(Function1 g) {
        return Function1.class.compose((Function1)this, (Function1)g);
    }

    public Function1 andThen(Function1 g) {
        return Function1.class.andThen((Function1)this, (Function1)g);
    }

    @Override
    public String toString() {
        return Function1.class.toString((Function1)this);
    }

    @Override
    public boolean equals(Object that) {
        return strawman.collection.SetOps.super.equals(that);
    }

    @Override
    public int hashCode() {
        return strawman.collection.SetOps.super.hashCode();
    }

    @Override
    public TreeSet concat(IterableOnce that) {
        return (TreeSet)SetOps.super.concat(that);
    }

    @Override
    public Tuple2 partition(Function1 p) {
        return StrictOptimizedIterableOps.super.partition(p);
    }

    @Override
    public Ordering ordering() {
        return this.ordering;
    }

    public TreeSet(Ordering ordering) {
        this(null, ordering);
    }

    @Override
    public IterableFactory iterableFactory() {
        return Set$.MODULE$;
    }

    @Override
    public SortedIterableFactory sortedIterableFactory() {
        return TreeSet$.MODULE$;
    }

    @Override
    public TreeSet fromSpecificIterable(Iterable coll) {
        return TreeSet$.MODULE$.sortedFromIterable(coll, this.ordering());
    }

    @Override
    public TreeSet sortedFromIterable(Iterable coll, Ordering evidence$56) {
        return TreeSet$.MODULE$.sortedFromIterable(coll, evidence$56);
    }

    @Override
    public Builder newSpecificBuilder() {
        return TreeSet$.MODULE$.newBuilder(this.ordering());
    }

    private TreeSet newSet(RedBlackTree.Tree t) {
        return new TreeSet(t, this.ordering());
    }

    @Override
    public int size() {
        return RedBlackTree$.MODULE$.count(this.tree);
    }

    @Override
    public Object head() {
        return RedBlackTree$.MODULE$.smallest(this.tree).key();
    }

    @Override
    public Object last() {
        return RedBlackTree$.MODULE$.greatest(this.tree).key();
    }

    @Override
    public TreeSet tail() {
        return new TreeSet(RedBlackTree$.MODULE$.delete(this.tree, this.firstKey(), this.ordering()), this.ordering());
    }

    @Override
    public TreeSet init() {
        return new TreeSet(RedBlackTree$.MODULE$.delete(this.tree, this.lastKey(), this.ordering()), this.ordering());
    }

    @Override
    public TreeSet drop(int n) {
        return n <= 0 ? this : (n >= this.size() ? this.empty() : this.newSet(RedBlackTree$.MODULE$.drop(this.tree, n, this.ordering())));
    }

    @Override
    public TreeSet take(int n) {
        return n <= 0 ? this.empty() : (n >= this.size() ? this : this.newSet(RedBlackTree$.MODULE$.take(this.tree, n, this.ordering())));
    }

    @Override
    public TreeSet slice(int from, int until) {
        return until <= from ? this.empty() : (from <= 0 ? this.take(until) : (until >= this.size() ? this.drop(from) : this.newSet(RedBlackTree$.MODULE$.slice(this.tree, from, until, this.ordering()))));
    }

    @Override
    public TreeSet dropRight(int n) {
        return this.take(this.size() - package$.MODULE$.max(n, 0));
    }

    @Override
    public TreeSet takeRight(int n) {
        return this.drop(this.size() - package$.MODULE$.max(n, 0));
    }

    /*
     * WARNING - void declaration
     */
    private int countWhile(Function1 p) {
        void var2_2;
        int result = 0;
        Iterator it = this.iterator();
        while (it.hasNext() && BoxesRunTime.unboxToBoolean((Object)p.apply(it.next()))) {
            ++result;
        }
        return (int)var2_2;
    }

    @Override
    public TreeSet dropWhile(Function1 p) {
        return this.drop(this.countWhile(p));
    }

    @Override
    public TreeSet takeWhile(Function1 p) {
        return this.take(this.countWhile(p));
    }

    @Override
    public Tuple2 span(Function1 p) {
        return this.splitAt(this.countWhile(p));
    }

    @Override
    public void foreach(Function1 f) {
        RedBlackTree$.MODULE$.foreachKey(this.tree, f);
    }

    @Override
    public Iterator iterator() {
        return RedBlackTree$.MODULE$.keysIterator(this.tree, (Option)RedBlackTree$.MODULE$.keysIterator$default$2(), this.ordering());
    }

    @Override
    public Iterator keysIteratorFrom(Object start) {
        return RedBlackTree$.MODULE$.keysIterator(this.tree, (Option)Some$.MODULE$.apply(start), this.ordering());
    }

    public Set unordered() {
        return this;
    }

    @Override
    public boolean contains(Object elem) {
        return RedBlackTree$.MODULE$.contains(this.tree, elem, this.ordering());
    }

    @Override
    public TreeSet empty() {
        return TreeSet$.MODULE$.empty(this.ordering());
    }

    @Override
    public TreeSet range(Object from, Object until) {
        return this.newSet(RedBlackTree$.MODULE$.range(this.tree, from, until, this.ordering()));
    }

    @Override
    public TreeSet rangeImpl(Option from, Option until) {
        return this.newSet(RedBlackTree$.MODULE$.rangeImpl(this.tree, from, until, this.ordering()));
    }

    @Override
    public TreeSet incl(Object elem) {
        return this.newSet(RedBlackTree$.MODULE$.update(this.tree, elem, BoxedUnit.UNIT, false, this.ordering()));
    }

    @Override
    public TreeSet excl(Object elem) {
        return !RedBlackTree$.MODULE$.contains(this.tree, elem, this.ordering()) ? this : this.newSet(RedBlackTree$.MODULE$.delete(this.tree, elem, this.ordering()));
    }
}

