/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.mutable;

import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import strawman.collection.IndexedSeq;
import strawman.collection.IndexedSeqOps;
import strawman.collection.Iterable;
import strawman.collection.IterableFactory;
import strawman.collection.IterableOnce;
import strawman.collection.IterableOps;
import strawman.collection.Iterator;
import strawman.collection.SeqOps;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.mutable.ArrayBuffer$;
import strawman.collection.mutable.ArrayBufferView;
import strawman.collection.mutable.Builder;
import strawman.collection.mutable.Growable;
import strawman.collection.mutable.IndexedOptimizedGrowableSeq;
import strawman.collection.mutable.RefArrayUtils$;

public class ArrayBuffer
implements IterableOps,
SeqOps,
IndexedSeqOps,
IndexedSeq,
Growable,
IndexedOptimizedGrowableSeq,
StrictOptimizedIterableOps {
    private final Object[] initElems;
    private final int initLength;
    private Object[] array;
    private int end;

    public static Object fill(int n, Function0 function0) {
        return ArrayBuffer$.MODULE$.fill(n, function0);
    }

    public static Builder newBuilder() {
        return ArrayBuffer$.MODULE$.newBuilder();
    }

    public static ArrayBuffer empty() {
        return ArrayBuffer$.MODULE$.empty();
    }

    public ArrayBuffer(Object[] initElems, int initLength) {
        this.initElems = initElems;
        this.initLength = initLength;
        this.array = initElems;
        this.end = initLength;
    }

    @Override
    public String toString() {
        return IterableOps.super.toString();
    }

    @Override
    public boolean equals(Object o) {
        return SeqOps.super.equals(o);
    }

    @Override
    public int hashCode() {
        return SeqOps.super.hashCode();
    }

    @Override
    public Iterable reversed() {
        return IndexedSeqOps.super.reversed();
    }

    @Override
    public ArrayBuffer takeRight(int n) {
        return (ArrayBuffer)IndexedSeqOps.super.takeRight(n);
    }

    @Override
    public ArrayBuffer dropRight(int n) {
        return (ArrayBuffer)IndexedSeqOps.super.dropRight(n);
    }

    @Override
    public Tuple2 partition(Function1 p) {
        return StrictOptimizedIterableOps.super.partition(p);
    }

    public ArrayBuffer() {
        this(new Object[16], 0);
    }

    public ArrayBuffer(int initLength) {
        this(new Object[initLength], initLength);
    }

    private Object[] array() {
        return this.array;
    }

    private void array_$eq(Object[] x$1) {
        this.array = x$1;
    }

    private int end() {
        return this.end;
    }

    private void end_$eq(int x$1) {
        this.end = x$1;
    }

    private void ensureSize(int n) {
        this.array_$eq(RefArrayUtils$.MODULE$.ensureSize(this.array(), this.end(), n));
    }

    private void reduceToSize(int n) {
        RefArrayUtils$.MODULE$.nullElems(this.array(), n, this.end());
        this.end_$eq(n);
    }

    private void checkWithinBounds(int lo, int hi) {
        if (lo < 0) {
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)lo)).toString());
        }
        if (hi > this.end()) {
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)hi)).toString());
        }
    }

    @Override
    public Object apply(int n) {
        return this.array()[n];
    }

    @Override
    public void update(int n, Object elem) {
        this.array()[n] = elem;
    }

    @Override
    public int length() {
        return this.end();
    }

    @Override
    public int knownSize() {
        return this.length();
    }

    @Override
    public ArrayBufferView view() {
        return new ArrayBufferView(this.array(), this.end());
    }

    @Override
    public Iterator iterator() {
        return this.view().iterator();
    }

    @Override
    public IterableFactory iterableFactory() {
        return ArrayBuffer$.MODULE$;
    }

    @Override
    public ArrayBuffer fromSpecificIterable(Iterable coll) {
        return (ArrayBuffer)this.fromIterable(coll);
    }

    @Override
    public Builder newSpecificBuilder() {
        return ArrayBuffer$.MODULE$.newBuilder();
    }

    @Override
    public void clear() {
        this.end_$eq(0);
    }

    @Override
    public ArrayBuffer add(Object elem) {
        this.ensureSize(this.end() + 1);
        this.update(this.end(), elem);
        this.end_$eq(this.end() + 1);
        return this;
    }

    @Override
    public ArrayBuffer addAll(IterableOnce elems) {
        Growable growable;
        IterableOnce iterableOnce = elems;
        if (iterableOnce instanceof ArrayBuffer) {
            ArrayBuffer elems2 = (ArrayBuffer)iterableOnce;
            this.ensureSize(this.length() + elems2.length());
            Array$.MODULE$.copy((Object)elems2.array(), 0, (Object)this.array(), this.length(), elems2.length());
            this.end_$eq(this.length() + elems2.length());
            growable = BoxedUnit.UNIT;
        } else {
            growable = Growable.super.addAll(elems);
        }
        return this;
    }

    @Override
    public void insert(int idx, Object elem) {
        this.checkWithinBounds(idx, idx);
        this.ensureSize(this.end() + 1);
        Array$.MODULE$.copy((Object)this.array(), idx, (Object)this.array(), idx + 1, this.end() - idx);
        this.update(idx, elem);
    }

    @Override
    public void insertAll(int idx, IterableOnce elems) {
        this.checkWithinBounds(idx, idx);
        IterableOnce iterableOnce = elems;
        if (iterableOnce instanceof Iterable) {
            Iterable elems2 = (Iterable)iterableOnce;
            int elemsLength = elems2.size();
            this.ensureSize(this.length() + elemsLength);
            Array$.MODULE$.copy((Object)this.array(), idx, (Object)this.array(), idx + elemsLength, this.end() - idx);
            Iterable iterable = elems2;
            if (iterable instanceof ArrayBuffer) {
                ArrayBuffer elems3 = (ArrayBuffer)iterable;
                Array$.MODULE$.copy((Object)elems3.array(), 0, (Object)this.array(), idx, elemsLength);
            } else {
                Iterator it = elems2.iterator();
                for (int i = 0; i < elemsLength; ++i) {
                    this.update(idx + i, it.next());
                }
            }
        } else {
            ArrayBuffer Growable_this = new ArrayBuffer();
            ArrayBuffer buf = Growable_this.addAll(elems);
            this.insertAll(idx, buf);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object remove(int idx) {
        void var2_2;
        this.checkWithinBounds(idx, idx + 1);
        Object res = this.apply(idx);
        Array$.MODULE$.copy((Object)this.array(), idx + 1, (Object)this.array(), idx, this.end() - (idx + 1));
        this.reduceToSize(this.end() - 1);
        return var2_2;
    }

    @Override
    public void remove(int from, int n) {
        block0: {
            if (n <= 0) break block0;
            this.checkWithinBounds(from, from + n);
            Array$.MODULE$.copy((Object)this.array(), from + n, (Object)this.array(), from, this.end() - (from + n));
            this.reduceToSize(this.end() - n);
        }
    }

    @Override
    public String className() {
        return "ArrayBuffer";
    }
}

