/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.mutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.JProcedure1;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import strawman.collection.ArrayOps;
import strawman.collection.IterableFactory$;
import strawman.collection.Iterator;
import strawman.collection.immutable.List$;
import strawman.collection.mutable.HashEntry;
import strawman.collection.mutable.HashTable$;
import strawman.collection.package$;
import strawman.collection.package$DebugUtils$;

public abstract class HashTable
implements HashUtils {
    private transient int _loadFactor = HashTable$.MODULE$.defaultLoadFactor();
    private transient HashEntry[] table = new HashEntry[this.initialCapacity()];
    private transient int tableSize = 0;
    private transient int threshold = this.initialThreshold(this._loadFactor());
    private transient int[] sizemap = null;
    private transient int seedvalue = this.tableSizeSeed();

    public static int loadFactorDenum() {
        return HashTable$.MODULE$.loadFactorDenum();
    }

    public static int nextPositivePowerOfTwo(int n) {
        return HashTable$.MODULE$.nextPositivePowerOfTwo(n);
    }

    public static int newThreshold(int n, int n2) {
        return HashTable$.MODULE$.newThreshold(n, n2);
    }

    public static int defaultLoadFactor() {
        return HashTable$.MODULE$.defaultLoadFactor();
    }

    public static int capacity(int n) {
        return HashTable$.MODULE$.capacity(n);
    }

    public static int sizeForThreshold(int n, int n2) {
        return HashTable$.MODULE$.sizeForThreshold(n, n2);
    }

    public int _loadFactor() {
        return this._loadFactor;
    }

    public void _loadFactor_$eq(int x$1) {
        this._loadFactor = x$1;
    }

    public HashEntry[] table() {
        return this.table;
    }

    public void table_$eq(HashEntry[] x$1) {
        this.table = x$1;
    }

    public int tableSize() {
        return this.tableSize;
    }

    public void tableSize_$eq(int x$1) {
        this.tableSize = x$1;
    }

    public final int size() {
        return this.tableSize();
    }

    public int threshold() {
        return this.threshold;
    }

    public void threshold_$eq(int x$1) {
        this.threshold = x$1;
    }

    public int[] sizemap() {
        return this.sizemap;
    }

    public void sizemap_$eq(int[] x$1) {
        this.sizemap = x$1;
    }

    public int seedvalue() {
        return this.seedvalue;
    }

    public void seedvalue_$eq(int x$1) {
        this.seedvalue = x$1;
    }

    public int tableSizeSeed() {
        return Integer.bitCount(this.table().length - 1);
    }

    public int initialSize() {
        return 16;
    }

    private int initialThreshold(int _loadFactor) {
        return HashTable$.MODULE$.newThreshold(_loadFactor, this.initialCapacity());
    }

    private int initialCapacity() {
        return HashTable$.MODULE$.capacity(this.initialSize());
    }

    /*
     * WARNING - void declaration
     */
    public int strawman$collection$mutable$HashTable$$lastPopulatedIndex() {
        void var1_1;
        for (int idx = this.table().length - 1; this.table()[idx] == null && idx > 0; --idx) {
        }
        return (int)var1_1;
    }

    public void init(ObjectInputStream in, Function0 readEntry) {
        in.defaultReadObject();
        this._loadFactor_$eq(in.readInt());
        Predef$.MODULE$.assert(this._loadFactor() > 0);
        int size = in.readInt();
        this.tableSize_$eq(0);
        Predef$.MODULE$.assert(size >= 0);
        this.seedvalue_$eq(in.readInt());
        boolean smDefined = in.readBoolean();
        this.table_$eq(new HashEntry[HashTable$.MODULE$.capacity(HashTable$.MODULE$.sizeForThreshold(this._loadFactor(), size))]);
        this.threshold_$eq(HashTable$.MODULE$.newThreshold(this._loadFactor(), this.table().length));
        if (smDefined) {
            this.sizeMapInit(this.table().length);
        } else {
            this.sizemap_$eq(null);
        }
        for (int index = 0; index < size; ++index) {
            this.addEntry((HashEntry)readEntry.apply());
        }
    }

    public void serializeTo(ObjectOutputStream out, Function1 writeEntry) {
        out.defaultWriteObject();
        out.writeInt(this._loadFactor());
        out.writeInt(this.tableSize());
        out.writeInt(this.seedvalue());
        out.writeBoolean(this.isSizeMapDefined());
        this.foreachEntry(writeEntry);
    }

    public final HashEntry findEntry(Object key) {
        return this.findEntry0(key, this.index(this.elemHashCode(key)));
    }

    /*
     * WARNING - void declaration
     */
    public final HashEntry findEntry0(Object key, int h) {
        void var3_3;
        for (HashEntry e = this.table()[h]; e != null && !this.elemEquals(e.key(), key); e = e.next()) {
        }
        return var3_3;
    }

    public final void addEntry(HashEntry e) {
        this.addEntry0(e, this.index(this.elemHashCode(e.key())));
    }

    public final void addEntry0(HashEntry e, int h) {
        block0: {
            e.next_$eq(this.table()[h]);
            this.table()[h] = e;
            this.tableSize_$eq(this.tableSize() + 1);
            this.nnSizeMapAdd(h);
            if (this.tableSize() <= this.threshold()) break block0;
            this.resize(2 * this.table().length);
        }
    }

    public HashEntry findOrAddEntry(Object key, Object value) {
        HashEntry hashEntry;
        int h = this.index(this.elemHashCode(key));
        HashEntry e = this.findEntry0(key, h);
        if (e != null) {
            hashEntry = e;
        } else {
            this.addEntry0(this.createNewEntry(key, value), h);
            hashEntry = null;
        }
        return hashEntry;
    }

    public abstract HashEntry createNewEntry(Object var1, Object var2);

    public final HashEntry removeEntry(Object key) {
        int h = this.index(this.elemHashCode(key));
        HashEntry e = this.table()[h];
        if (e != null) {
            HashEntry e1;
            if (this.elemEquals(e.key(), key)) {
                this.table()[h] = e.next();
                this.tableSize_$eq(this.tableSize() - 1);
                this.nnSizeMapRemove(h);
                e.next_$eq(null);
                return e;
            }
            for (e1 = e.next(); e1 != null && !this.elemEquals(e1.key(), key); e1 = e1.next()) {
                e = e1;
            }
            if (e1 != null) {
                e.next_$eq(e1.next());
                this.tableSize_$eq(this.tableSize() - 1);
                this.nnSizeMapRemove(h);
                e1.next_$eq(null);
                return e1;
            }
        }
        return null;
    }

    public Iterator entriesIterator() {
        return new Iterator(this){
            private final HashEntry[] iterTable;
            private int idx;
            private HashEntry es;
            private final HashTable $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.iterTable = this.strawman$collection$mutable$HashTable$_$$anon$$$outer().table();
                this.idx = this.strawman$collection$mutable$HashTable$_$$anon$$$outer().strawman$collection$mutable$HashTable$$lastPopulatedIndex();
                this.es = this.iterTable()[this.idx()];
            }

            public HashEntry[] iterTable() {
                return this.iterTable;
            }

            public int idx() {
                return this.idx;
            }

            public void idx_$eq(int x$1) {
                this.idx = x$1;
            }

            public HashEntry es() {
                return this.es;
            }

            public void es_$eq(HashEntry x$1) {
                this.es = x$1;
            }

            public boolean hasNext() {
                return this.es() != null;
            }

            /*
             * WARNING - void declaration
             */
            public HashEntry next() {
                void var1_1;
                HashEntry res = this.es();
                this.es_$eq(this.es().next());
                while (this.es() == null && this.idx() > 0) {
                    this.idx_$eq(this.idx() - 1);
                    this.es_$eq(this.iterTable()[this.idx()]);
                }
                return var1_1;
            }

            private HashTable $outer() {
                return this.$outer;
            }

            public final HashTable strawman$collection$mutable$HashTable$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    public void foreachEntry(Function1 f) {
        HashEntry[] iterTable = this.table();
        int idx = this.strawman$collection$mutable$HashTable$$lastPopulatedIndex();
        HashEntry es = iterTable[idx];
        while (es != null) {
            HashEntry next = es.next();
            f.apply((Object)es);
            es = next;
            while (es == null && idx > 0) {
                es = iterTable[--idx];
            }
        }
    }

    public void clearTable() {
        for (int i = this.table().length - 1; i >= 0; --i) {
            this.table()[i] = null;
        }
        this.tableSize_$eq(0);
        this.nnSizeMapReset(0);
    }

    private void resize(int newSize) {
        HashEntry[] oldTable = this.table();
        this.table_$eq(new HashEntry[newSize]);
        this.nnSizeMapReset(this.table().length);
        for (int i = oldTable.length - 1; i >= 0; --i) {
            HashEntry e = oldTable[i];
            while (e != null) {
                int h = this.index(this.elemHashCode(e.key()));
                HashEntry e1 = e.next();
                e.next_$eq(this.table()[h]);
                this.table()[h] = e;
                e = e1;
                this.nnSizeMapAdd(h);
            }
        }
        this.threshold_$eq(HashTable$.MODULE$.newThreshold(this._loadFactor(), newSize));
    }

    public final void nnSizeMapAdd(int h) {
        block0: {
            if (this.sizemap() == null) break block0;
            int[] $26$ = this.sizemap();
            int i$5 = h >> this.sizeMapBucketBitSize();
            $26$[i$5] = $26$[i$5] + 1;
        }
    }

    public final void nnSizeMapRemove(int h) {
        block0: {
            if (this.sizemap() == null) break block0;
            int[] $27$ = this.sizemap();
            int i$6 = h >> this.sizeMapBucketBitSize();
            $27$[i$6] = $27$[i$6] - 1;
        }
    }

    public final void nnSizeMapReset(int tableLength) {
        block2: {
            if (this.sizemap() == null) break block2;
            int nsize = this.calcSizeMapSize(tableLength);
            if (this.sizemap().length != nsize) {
                this.sizemap_$eq(new int[nsize]);
            } else {
                Arrays.fill(this.sizemap(), 0);
            }
        }
    }

    public final int totalSizeMapBuckets() {
        return this.sizeMapBucketSize() < this.table().length ? 1 : this.table().length / this.sizeMapBucketSize();
    }

    public final int calcSizeMapSize(int tableLength) {
        return (tableLength >> this.sizeMapBucketBitSize()) + 1;
    }

    public void sizeMapInit(int tableLength) {
        this.sizemap_$eq(new int[this.calcSizeMapSize(tableLength)]);
    }

    public final void sizeMapInitAndRebuild() {
        this.sizeMapInit(this.table().length);
        int tableidx = 0;
        int bucketidx = 0;
        HashEntry[] tbl = this.table();
        int tableuntil = 0;
        tableuntil = tbl.length < this.sizeMapBucketSize() ? tbl.length : this.sizeMapBucketSize();
        int totalbuckets = this.totalSizeMapBuckets();
        while (bucketidx < totalbuckets) {
            int currbucketsize = 0;
            while (tableidx < tableuntil) {
                for (HashEntry e = tbl[tableidx]; e != null; e = e.next()) {
                    ++currbucketsize;
                }
                ++tableidx;
            }
            this.sizemap()[bucketidx] = currbucketsize;
            tableuntil += this.sizeMapBucketSize();
            ++bucketidx;
        }
    }

    public void printSizeMap() {
        Predef$.MODULE$.println(new ArrayOps(package$.MODULE$.arrayToArrayOps(this.sizemap())).to(IterableFactory$.MODULE$.toSpecific(List$.MODULE$)));
    }

    public final void sizeMapDisable() {
        this.sizemap_$eq(null);
    }

    public final boolean isSizeMapDefined() {
        return this.sizemap() != null;
    }

    public boolean alwaysInitSizeMap() {
        return false;
    }

    public boolean elemEquals(Object key1, Object key2) {
        return BoxesRunTime.equals((Object)key1, (Object)key2);
    }

    public final int index(int hcode) {
        int ones = this.table().length - 1;
        int exponent = Integer.numberOfLeadingZeros(ones);
        return this.improve(hcode, this.seedvalue()) >>> exponent & ones;
    }

    public void initWithContents(Contents c) {
        block2: {
            if (c != null) {
                this._loadFactor_$eq(c.loadFactor());
                this.table_$eq(c.table());
                this.tableSize_$eq(c.tableSize());
                this.threshold_$eq(c.threshold());
                this.seedvalue_$eq(c.seedvalue());
                this.sizemap_$eq(c.sizemap());
            }
            if (!this.alwaysInitSizeMap()) break block2;
            if (this.sizemap() == null) {
                this.sizeMapInitAndRebuild();
            }
        }
    }

    public Contents hashTableContents() {
        return new Contents(this._loadFactor(), this.table(), this.tableSize(), this.threshold(), this.seedvalue(), this.sizemap());
    }

    public static class Contents {
        private final int loadFactor;
        private final HashEntry[] table;
        private final int tableSize;
        private final int threshold;
        private final int seedvalue;
        private final int[] sizemap;

        public Contents(int loadFactor, HashEntry[] table, int tableSize, int threshold, int seedvalue, int[] sizemap) {
            this.loadFactor = loadFactor;
            this.table = table;
            this.tableSize = tableSize;
            this.threshold = threshold;
            this.seedvalue = seedvalue;
            this.sizemap = sizemap;
        }

        public int loadFactor() {
            return this.loadFactor;
        }

        public HashEntry[] table() {
            return this.table;
        }

        public int tableSize() {
            return this.tableSize;
        }

        public int threshold() {
            return this.threshold;
        }

        public int seedvalue() {
            return this.seedvalue;
        }

        public int[] sizemap() {
            return this.sizemap;
        }

        public String debugInformation() {
            return package$DebugUtils$.MODULE$.buildString((Function1)((JProcedure1)this::debugInformation$$anonfun$1));
        }

        private void debugInformation$$anonfun$1(Function1 append) {
            append.apply((Object)"Hash table contents");
            append.apply((Object)"-------------------");
            append.apply((Object)new StringBuilder().append((Object)"Table: [").append((Object)package$DebugUtils$.MODULE$.arrayString(this.table(), 0, this.table().length)).append((Object)"]").toString());
            append.apply((Object)new StringBuilder().append((Object)"Table size: ").append((Object)BoxesRunTime.boxToInteger((int)this.tableSize())).toString());
            append.apply((Object)new StringBuilder().append((Object)"Load factor: ").append((Object)BoxesRunTime.boxToInteger((int)this.loadFactor())).toString());
            append.apply((Object)new StringBuilder().append((Object)"Seedvalue: ").append((Object)BoxesRunTime.boxToInteger((int)this.seedvalue())).toString());
            append.apply((Object)new StringBuilder().append((Object)"Threshold: ").append((Object)BoxesRunTime.boxToInteger((int)this.threshold())).toString());
            append.apply((Object)new StringBuilder().append((Object)"Sizemap: [").append((Object)package$DebugUtils$.MODULE$.arrayString(this.sizemap(), 0, this.sizemap().length)).append((Object)"]").toString());
        }
    }

    public static interface HashUtils {
        default public void $init$() {
        }

        default public int sizeMapBucketBitSize() {
            return 5;
        }

        default public int sizeMapBucketSize() {
            return 1 << this.sizeMapBucketBitSize();
        }

        default public int elemHashCode(Object key) {
            return ScalaRunTime$.MODULE$.hash(key);
        }

        default public int improve(int hcode, int seed) {
            return Integer.rotateRight(scala.util.hashing.package$.MODULE$.byteswap32(hcode), seed);
        }
    }
}

