/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.mutable;

import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import strawman.collection.Iterable;
import strawman.collection.IterableFactory;
import strawman.collection.IterableOnce;
import strawman.collection.IterableOps;
import strawman.collection.Iterator;
import strawman.collection.Seq;
import strawman.collection.SeqOps;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.immutable.$colon$colon;
import strawman.collection.immutable.List;
import strawman.collection.immutable.Nil$;
import strawman.collection.mutable.Builder;
import strawman.collection.mutable.GrowableSeq;
import strawman.collection.mutable.ListBuffer$;

public class ListBuffer
implements IterableOps,
SeqOps,
GrowableSeq,
StrictOptimizedIterableOps {
    private List first = Nil$.MODULE$;
    private $colon$colon last0 = null;
    private boolean aliased = false;
    private int len = 0;

    public static Object fill(int n, Function0 function0) {
        return ListBuffer$.MODULE$.fill(n, function0);
    }

    public static Builder newBuilder() {
        return ListBuffer$.MODULE$.newBuilder();
    }

    public static ListBuffer empty() {
        return ListBuffer$.MODULE$.empty();
    }

    @Override
    public String toString() {
        return IterableOps.super.toString();
    }

    @Override
    public boolean equals(Object o) {
        return SeqOps.super.equals(o);
    }

    @Override
    public int hashCode() {
        return SeqOps.super.hashCode();
    }

    @Override
    public Tuple2 partition(Function1 p) {
        return StrictOptimizedIterableOps.super.partition(p);
    }

    private List first() {
        return this.first;
    }

    private void first_$eq(List x$1) {
        this.first = x$1;
    }

    private $colon$colon last0() {
        return this.last0;
    }

    private void last0_$eq($colon$colon x$1) {
        this.last0 = x$1;
    }

    private boolean aliased() {
        return this.aliased;
    }

    private void aliased_$eq(boolean x$1) {
        this.aliased = x$1;
    }

    private int len() {
        return this.len;
    }

    private void len_$eq(int x$1) {
        this.len = x$1;
    }

    @Override
    public Iterator iterator() {
        return this.first().iterator();
    }

    @Override
    public IterableFactory iterableFactory() {
        return ListBuffer$.MODULE$;
    }

    @Override
    public ListBuffer fromSpecificIterable(Iterable coll) {
        return (ListBuffer)this.fromIterable(coll);
    }

    @Override
    public Object apply(int i) {
        return this.first().apply(i);
    }

    @Override
    public int length() {
        return this.len();
    }

    @Override
    public int knownSize() {
        return this.len();
    }

    @Override
    public Builder newSpecificBuilder() {
        return ListBuffer$.MODULE$.newBuilder();
    }

    private void copyElems() {
        ListBuffer buf = ListBuffer$.MODULE$.fromIterable(this);
        this.first_$eq(buf.first());
        this.last0_$eq(buf.last0());
        this.aliased_$eq(false);
    }

    private void ensureUnaliased() {
        block0: {
            if (!this.aliased()) break block0;
            this.copyElems();
        }
    }

    public List toList() {
        this.aliased_$eq(true);
        return this.first();
    }

    @Override
    public void clear() {
        this.first_$eq(Nil$.MODULE$);
    }

    @Override
    public ListBuffer add(Object elem) {
        this.ensureUnaliased();
        Object object = elem;
        $colon$colon last1 = ($colon$colon)Nil$.MODULE$.$colon$colon(object);
        if (this.len() == 0) {
            this.first_$eq(last1);
        } else {
            this.last0().next_$eq(last1);
        }
        this.last0_$eq(last1);
        this.len_$eq(this.len() + 1);
        return this;
    }

    private $colon$colon locate(int i) {
        $colon$colon $colon$colon;
        if (i == 0) {
            $colon$colon = null;
        } else if (i == this.len()) {
            $colon$colon = this.last0();
        } else {
            List p = this.first();
            for (int j = i - 1; j > 0; --j) {
                p = (List)p.tail();
            }
            $colon$colon = ($colon$colon)p;
        }
        return $colon$colon;
    }

    private List getNext($colon$colon p) {
        return p == null ? this.first() : p.next();
    }

    private void setNext($colon$colon p, List nx) {
        if (p == null) {
            this.first_$eq(nx);
        } else {
            p.next_$eq(nx);
        }
    }

    @Override
    public void update(int idx, Object elem) {
        this.ensureUnaliased();
        if (idx < 0 || idx >= this.len()) {
            throw new IndexOutOfBoundsException();
        }
        $colon$colon p = this.locate(idx);
        Object object = elem;
        this.setNext(p, ((List)this.getNext(p).tail()).$colon$colon(object));
    }

    @Override
    public void insert(int idx, Object elem) {
        this.ensureUnaliased();
        if (idx < 0 || idx > this.len()) {
            throw new IndexOutOfBoundsException();
        }
        if (idx == this.len()) {
            ListBuffer Growable_this = this;
            Growable_this.add(elem);
        } else {
            $colon$colon p = this.locate(idx);
            Object object = elem;
            this.setNext(p, this.getNext(p).$colon$colon(object));
            this.len_$eq(this.len() + 1);
        }
    }

    private void insertAfter($colon$colon p, Iterator it) {
        $colon$colon prev = p;
        List follow = this.getNext(prev);
        while (it.hasNext()) {
            this.len_$eq(this.len() + 1);
            Object object = it.next();
            $colon$colon next = ($colon$colon)follow.$colon$colon(object);
            this.setNext(prev, next);
            prev = next;
        }
    }

    @Override
    public void insertAll(int idx, IterableOnce elems) {
        block3: {
            this.ensureUnaliased();
            Iterator it = elems.iterator();
            if (!it.hasNext()) break block3;
            this.ensureUnaliased();
            if (idx < 0 || idx > this.len()) {
                throw new IndexOutOfBoundsException();
            }
            if (idx == this.len()) {
                ListBuffer Growable_this = this;
                Growable_this.addAll(elems);
            } else {
                this.insertAfter(this.locate(idx), it);
            }
        }
    }

    @Override
    public Object remove(int idx) {
        this.ensureUnaliased();
        if (idx < 0 || idx >= this.len()) {
            throw new IndexOutOfBoundsException();
        }
        this.len_$eq(this.len() - 1);
        $colon$colon p = this.locate(idx);
        List nx = this.getNext(p);
        this.setNext(p, (List)nx.tail());
        return nx.head();
    }

    @Override
    public void remove(int idx, int n) {
        block1: {
            if (n <= 0) break block1;
            this.ensureUnaliased();
            if (idx < 0 || idx + n > this.len()) {
                throw new IndexOutOfBoundsException();
            }
            this.removeAfter(this.locate(idx), n);
        }
    }

    private void removeAfter($colon$colon prev, int n) {
        this.setNext(prev, ListBuffer.ahead$1(this.getNext(prev), n));
        this.len_$eq(this.len() - n);
    }

    @Override
    public ListBuffer mapInPlace(Function1 f) {
        this.ensureUnaliased();
        ListBuffer buf = new ListBuffer();
        this.foreach(arg_0 -> this.mapInPlace$$anonfun$1(f, buf, arg_0));
        this.first_$eq(buf.first());
        this.last0_$eq(buf.last0());
        return this;
    }

    @Override
    public ListBuffer flatMapInPlace(Function1 f) {
        this.ensureUnaliased();
        $colon$colon prev = null;
        List cur = this.first();
        while (!cur.isEmpty()) {
            List follow = (List)cur.tail();
            this.setNext(prev, follow);
            this.len_$eq(this.len() - 1);
            this.insertAfter(prev, ((IterableOnce)f.apply(cur.head())).iterator());
            cur = follow;
        }
        return this;
    }

    @Override
    public ListBuffer filterInPlace(Function1 p) {
        this.ensureUnaliased();
        $colon$colon prev = null;
        List cur = this.first();
        while (!cur.isEmpty()) {
            List follow = (List)cur.tail();
            if (!BoxesRunTime.unboxToBoolean((Object)p.apply(cur.head()))) {
                this.setNext(prev, follow);
                this.len_$eq(this.len() - 1);
            }
            prev = ($colon$colon)cur;
            cur = follow;
        }
        return this;
    }

    @Override
    public ListBuffer patchInPlace(int from, Seq patch, int replaced) {
        this.ensureUnaliased();
        $colon$colon p = this.locate(from);
        this.removeAfter(p, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(replaced), this.length() - from));
        this.insertAfter(p, patch.iterator());
        return this;
    }

    @Override
    public String className() {
        return "ListBuffer";
    }

    /*
     * Enabled aggressive block sorting
     */
    private static List ahead$1(List p, int n) {
        int n2 = n;
        List list = p;
        while (n2 != 0) {
            --n2;
            list = (List)list.tail();
        }
        return list;
    }

    private ListBuffer mapInPlace$$anonfun$1(Function1 f$17, ListBuffer buf$4, Object elem) {
        Object elem2 = f$17.apply(elem);
        ListBuffer Growable_this = buf$4;
        return Growable_this.add(elem2);
    }
}

