/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.mutable;

import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.math.Ordering;
import strawman.collection.Iterable;
import strawman.collection.Iterator;
import strawman.collection.MapFactory;
import strawman.collection.MapOps;
import strawman.collection.SortedMapFactory;
import strawman.collection.SortedMapOps;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.mutable.Builder;
import strawman.collection.mutable.Map$;
import strawman.collection.mutable.RedBlackTree;
import strawman.collection.mutable.RedBlackTree$;
import strawman.collection.mutable.RedBlackTree$Tree$;
import strawman.collection.mutable.SortedMap;
import strawman.collection.mutable.TreeMap$;

public class TreeMap
implements MapOps,
SortedMapOps,
strawman.collection.mutable.MapOps,
SortedMap,
StrictOptimizedIterableOps,
Serializable {
    public final RedBlackTree.Tree strawman$collection$mutable$TreeMap$$tree;
    private final Ordering ordering;

    public static Builder newBuilder(Ordering ordering) {
        return TreeMap$.MODULE$.newBuilder(ordering);
    }

    public static TreeMap sortedFromIterable(Iterable iterable, Ordering ordering) {
        return TreeMap$.MODULE$.sortedFromIterable(iterable, ordering);
    }

    public TreeMap(RedBlackTree.Tree tree, Ordering ordering) {
        this.strawman$collection$mutable$TreeMap$$tree = tree;
        this.ordering = ordering;
        Function1.class.$init$((Function1)this);
        PartialFunction.class.$init$((PartialFunction)this);
    }

    public Function1 compose(Function1 g) {
        return Function1.class.compose((Function1)this, (Function1)g);
    }

    @Override
    public String toString() {
        return Function1.class.toString((Function1)this);
    }

    public PartialFunction orElse(PartialFunction that) {
        return PartialFunction.class.orElse((PartialFunction)this, (PartialFunction)that);
    }

    public PartialFunction andThen(Function1 k) {
        return PartialFunction.class.andThen((PartialFunction)this, (Function1)k);
    }

    public Function1 lift() {
        return PartialFunction.class.lift((PartialFunction)this);
    }

    public Object applyOrElse(Object x, Function1 function1) {
        return PartialFunction.class.applyOrElse((PartialFunction)this, (Object)x, (Function1)function1);
    }

    public Function1 runWith(Function1 action) {
        return PartialFunction.class.runWith((PartialFunction)this, (Function1)action);
    }

    @Override
    public boolean equals(Object o) {
        return MapOps.super.equals(o);
    }

    @Override
    public int hashCode() {
        return MapOps.super.hashCode();
    }

    @Override
    public TreeMap concat(Iterable xs) {
        return (TreeMap)SortedMapOps.super.concat(xs);
    }

    @Override
    public TreeMap $plus$plus(Iterable xs) {
        return (TreeMap)SortedMapOps.super.$plus$plus(xs);
    }

    @Override
    public TreeMap clone() {
        return (TreeMap)strawman.collection.mutable.MapOps.super.clone();
    }

    @Override
    public Tuple2 partition(Function1 p) {
        return StrictOptimizedIterableOps.super.partition(p);
    }

    @Override
    public Ordering ordering() {
        return this.ordering;
    }

    @Override
    public MapFactory mapFactory() {
        return Map$.MODULE$;
    }

    @Override
    public SortedMapFactory sortedMapFactory() {
        return TreeMap$.MODULE$;
    }

    public TreeMap(Ordering ord) {
        this(RedBlackTree$Tree$.MODULE$.empty(), ord);
    }

    @Override
    public TreeMap fromSpecificIterable(Iterable coll) {
        return TreeMap$.MODULE$.sortedFromIterable(coll, this.ordering());
    }

    @Override
    public TreeMap sortedMapFromIterable(Iterable it, Ordering ordering) {
        return TreeMap$.MODULE$.sortedFromIterable(it, ordering);
    }

    @Override
    public Builder newSpecificBuilder() {
        return TreeMap$.MODULE$.newBuilder(this.ordering());
    }

    @Override
    public Iterator iterator() {
        return RedBlackTree$.MODULE$.iterator(this.strawman$collection$mutable$TreeMap$$tree, (Option)RedBlackTree$.MODULE$.iterator$default$2(), (Option)RedBlackTree$.MODULE$.iterator$default$3(), this.ordering());
    }

    @Override
    public Iterator keysIteratorFrom(Object start) {
        return RedBlackTree$.MODULE$.keysIterator(this.strawman$collection$mutable$TreeMap$$tree, (Option)Some$.MODULE$.apply(start), (Option)RedBlackTree$.MODULE$.keysIterator$default$3(), this.ordering());
    }

    @Override
    public TreeMap empty() {
        return TreeMap$.MODULE$.empty(this.ordering());
    }

    public TreeMap add(Tuple2 elem) {
        RedBlackTree$.MODULE$.insert(this.strawman$collection$mutable$TreeMap$$tree, elem._1(), elem._2(), this.ordering());
        return this;
    }

    @Override
    public TreeMap subtract(Object elem) {
        RedBlackTree$.MODULE$.delete(this.strawman$collection$mutable$TreeMap$$tree, elem, this.ordering());
        return this;
    }

    @Override
    public void clear() {
        RedBlackTree$.MODULE$.clear(this.strawman$collection$mutable$TreeMap$$tree);
    }

    @Override
    public Option get(Object key) {
        return RedBlackTree$.MODULE$.get(this.strawman$collection$mutable$TreeMap$$tree, key, this.ordering());
    }

    @Override
    public TreeMap rangeImpl(Option from, Option until) {
        return new TreeMapView(this, from, until);
    }

    @Override
    public void foreach(Function1 f) {
        RedBlackTree$.MODULE$.foreach(this.strawman$collection$mutable$TreeMap$$tree, f);
    }

    @Override
    public int size() {
        return RedBlackTree$.MODULE$.size(this.strawman$collection$mutable$TreeMap$$tree);
    }

    @Override
    public boolean isEmpty() {
        return RedBlackTree$.MODULE$.isEmpty(this.strawman$collection$mutable$TreeMap$$tree);
    }

    @Override
    public boolean contains(Object key) {
        return RedBlackTree$.MODULE$.contains(this.strawman$collection$mutable$TreeMap$$tree, key, this.ordering());
    }

    public Tuple2 head() {
        return (Tuple2)RedBlackTree$.MODULE$.min(this.strawman$collection$mutable$TreeMap$$tree).get();
    }

    public Tuple2 last() {
        return (Tuple2)RedBlackTree$.MODULE$.max(this.strawman$collection$mutable$TreeMap$$tree).get();
    }

    @Override
    public String className() {
        return "TreeMap";
    }

    public RedBlackTree.Tree strawman$collection$mutable$TreeMap$$TreeMapView$superArg$1(Option from, Option until) {
        return this.strawman$collection$mutable$TreeMap$$tree;
    }

    public Ordering strawman$collection$mutable$TreeMap$$TreeMapView$superArg$2(Option from, Option until) {
        return this.ordering();
    }

    private static final class TreeMapView
    extends TreeMap
    implements strawman.collection.mutable.MapOps {
        private final Option from;
        private final Option until;
        private final TreeMap $outer;

        public TreeMapView(TreeMap $outer, Option from, Option until) {
            this.from = from;
            this.until = until;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer.strawman$collection$mutable$TreeMap$$TreeMapView$superArg$1(from, until), $outer.strawman$collection$mutable$TreeMap$$TreeMapView$superArg$2(from, until));
        }

        /*
         * Enabled aggressive block sorting
         */
        private Option pickLowerBound(Option newFrom) {
            Tuple2 tuple2;
            Option option;
            Option option2;
            Option option3;
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)this.from, (Object)newFrom);
            Option option4 = Tuple2$.MODULE$.unapply(tuple22);
            if (!option4.isEmpty()) {
                Tuple2 tuple23 = (Tuple2)option4.get();
                Option option5 = (Option)tuple23._1();
                Option option6 = (Option)tuple23._2();
                if (option5 instanceof Some) {
                    Some some = (Some)option5;
                    Option option7 = Some$.MODULE$.unapply((Some)option5);
                    if (!option7.isEmpty()) {
                        Object object;
                        Object fr = object = option7.get();
                        if (option6 instanceof Some) {
                            Some some2 = (Some)option6;
                            Option option8 = Some$.MODULE$.unapply((Some)option6);
                            if (!option8.isEmpty()) {
                                Object object2;
                                Object newFr = object2 = option8.get();
                                option3 = Some$.MODULE$.apply(this.ordering().max(fr, newFr));
                                return option3;
                            }
                        }
                    }
                }
            }
            if (!(option2 = Tuple2$.MODULE$.unapply(tuple22)).isEmpty() && None$.MODULE$.equals(option = (Option)(tuple2 = (Tuple2)option2.get())._1())) {
                None$ none$ = (None$)option;
                Option option9 = (Option)tuple2._2();
                option3 = newFrom;
                return option3;
            }
            option3 = this.from;
            return option3;
        }

        /*
         * Enabled aggressive block sorting
         */
        private Option pickUpperBound(Option newUntil) {
            Tuple2 tuple2;
            Option option;
            Option option2;
            Option option3;
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)this.until, (Object)newUntil);
            Option option4 = Tuple2$.MODULE$.unapply(tuple22);
            if (!option4.isEmpty()) {
                Tuple2 tuple23 = (Tuple2)option4.get();
                Option option5 = (Option)tuple23._1();
                Option option6 = (Option)tuple23._2();
                if (option5 instanceof Some) {
                    Some some = (Some)option5;
                    Option option7 = Some$.MODULE$.unapply((Some)option5);
                    if (!option7.isEmpty()) {
                        Object object;
                        Object unt = object = option7.get();
                        if (option6 instanceof Some) {
                            Some some2 = (Some)option6;
                            Option option8 = Some$.MODULE$.unapply((Some)option6);
                            if (!option8.isEmpty()) {
                                Object object2;
                                Object newUnt = object2 = option8.get();
                                option3 = Some$.MODULE$.apply(this.ordering().min(unt, newUnt));
                                return option3;
                            }
                        }
                    }
                }
            }
            if (!(option2 = Tuple2$.MODULE$.unapply(tuple22)).isEmpty() && None$.MODULE$.equals(option = (Option)(tuple2 = (Tuple2)option2.get())._1())) {
                None$ none$ = (None$)option;
                Option option9 = (Option)tuple2._2();
                option3 = newUntil;
                return option3;
            }
            option3 = this.until;
            return option3;
        }

        private boolean isInsideViewBounds(Object key) {
            boolean beforeUntil;
            boolean afterFrom;
            boolean bl = this.from.isEmpty() || this.ordering().compare(this.from.get(), key) <= 0 ? true : (afterFrom = false);
            boolean bl2 = this.until.isEmpty() || this.ordering().compare(key, this.until.get()) < 0 ? true : (beforeUntil = false);
            return afterFrom && beforeUntil;
        }

        @Override
        public TreeMap rangeImpl(Option from, Option until) {
            return new TreeMapView(this.strawman$collection$mutable$TreeMap$TreeMapView$$$outer(), this.pickLowerBound(from), this.pickUpperBound(until));
        }

        @Override
        public Option get(Object key) {
            return this.isInsideViewBounds(key) ? RedBlackTree$.MODULE$.get(this.strawman$collection$mutable$TreeMap$TreeMapView$$$outer().strawman$collection$mutable$TreeMap$$tree, key, this.ordering()) : None$.MODULE$;
        }

        @Override
        public Iterator iterator() {
            return RedBlackTree$.MODULE$.iterator(this.strawman$collection$mutable$TreeMap$TreeMapView$$$outer().strawman$collection$mutable$TreeMap$$tree, this.from, this.until, this.ordering());
        }

        @Override
        public Iterator keysIteratorFrom(Object start) {
            return RedBlackTree$.MODULE$.keysIterator(this.strawman$collection$mutable$TreeMap$TreeMapView$$$outer().strawman$collection$mutable$TreeMap$$tree, this.pickLowerBound((Option)Some$.MODULE$.apply(start)), this.until, this.ordering());
        }

        @Override
        public int size() {
            return this.iterator().length();
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public boolean contains(Object key) {
            return this.isInsideViewBounds(key) && RedBlackTree$.MODULE$.contains(this.strawman$collection$mutable$TreeMap$TreeMapView$$$outer().strawman$collection$mutable$TreeMap$$tree, key, this.ordering());
        }

        @Override
        public Tuple2 head() {
            return (Tuple2)this.headOption().get();
        }

        /*
         * Enabled aggressive block sorting
         */
        public Option headOption() {
            Option option;
            Option entry = !this.from.isDefined() ? RedBlackTree$.MODULE$.min(this.strawman$collection$mutable$TreeMap$TreeMapView$$$outer().strawman$collection$mutable$TreeMap$$tree) : RedBlackTree$.MODULE$.minAfter(this.strawman$collection$mutable$TreeMap$TreeMapView$$$outer().strawman$collection$mutable$TreeMap$$tree, this.from.get(), this.ordering());
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)entry, (Object)this.until);
            Option option2 = Tuple2$.MODULE$.unapply(tuple2);
            if (!option2.isEmpty()) {
                Tuple2 tuple22 = (Tuple2)option2.get();
                Option option3 = (Option)tuple22._1();
                Option option4 = (Option)tuple22._2();
                if (option3 instanceof Some) {
                    Some some = (Some)option3;
                    Option option5 = Some$.MODULE$.unapply((Some)option3);
                    if (!option5.isEmpty()) {
                        Tuple2 tuple23;
                        Tuple2 e = tuple23 = (Tuple2)option5.get();
                        if (option4 instanceof Some) {
                            Some some2 = (Some)option4;
                            Option option6 = Some$.MODULE$.unapply((Some)option4);
                            if (!option6.isEmpty()) {
                                Object object;
                                Object unt = object = option6.get();
                                if (this.ordering().compare(e._1(), unt) >= 0) {
                                    option = None$.MODULE$;
                                    return option;
                                }
                            }
                        }
                    }
                }
            }
            option = entry;
            return option;
        }

        @Override
        public Tuple2 last() {
            return (Tuple2)this.lastOption().get();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Option lastOption() {
            Option option;
            Option entry = !this.until.isDefined() ? RedBlackTree$.MODULE$.max(this.strawman$collection$mutable$TreeMap$TreeMapView$$$outer().strawman$collection$mutable$TreeMap$$tree) : RedBlackTree$.MODULE$.maxBefore(this.strawman$collection$mutable$TreeMap$TreeMapView$$$outer().strawman$collection$mutable$TreeMap$$tree, this.until.get(), this.ordering());
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)entry, (Object)this.from);
            Option option2 = Tuple2$.MODULE$.unapply(tuple2);
            if (!option2.isEmpty()) {
                Tuple2 tuple22 = (Tuple2)option2.get();
                Option option3 = (Option)tuple22._1();
                Option option4 = (Option)tuple22._2();
                if (option3 instanceof Some) {
                    Some some = (Some)option3;
                    Option option5 = Some$.MODULE$.unapply((Some)option3);
                    if (!option5.isEmpty()) {
                        Tuple2 tuple23;
                        Tuple2 e = tuple23 = (Tuple2)option5.get();
                        if (option4 instanceof Some) {
                            Some some2 = (Some)option4;
                            Option option6 = Some$.MODULE$.unapply((Some)option4);
                            if (!option6.isEmpty()) {
                                Object object;
                                Object fr = object = option6.get();
                                if (this.ordering().compare(e._1(), fr) < 0) {
                                    option = None$.MODULE$;
                                    return option;
                                }
                            }
                        }
                    }
                }
            }
            option = entry;
            return option;
        }

        @Override
        public void foreach(Function1 f) {
            this.iterator().foreach(f);
        }

        @Override
        public TreeMap clone() {
            return ((TreeMap)strawman.collection.mutable.MapOps.super.clone()).rangeImpl(this.from, this.until);
        }

        private TreeMap $outer() {
            return this.$outer;
        }

        public final TreeMap strawman$collection$mutable$TreeMap$TreeMapView$$$outer() {
            return this.$outer();
        }
    }
}

