/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection;

import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import strawman.collection.IndexedView;
import strawman.collection.Iterator;
import strawman.collection.View;

public final class Iterator$ {
    public static final Iterator$ MODULE$;
    private final Iterator empty;

    static {
        new Iterator$();
    }

    public Iterator$() {
        MODULE$ = this;
        this.empty = new Iterator(){

            public boolean hasNext() {
                return false;
            }

            public Nothing$ next() {
                throw new NoSuchElementException("next on empty iterator");
            }
        };
    }

    public Iterator empty() {
        return this.empty;
    }

    public Iterator single(Object a) {
        return new Iterator(a){
            private final Object a$1;
            private boolean consumed;
            {
                this.a$1 = a$2;
                this.consumed = false;
            }

            private boolean consumed() {
                return this.consumed;
            }

            private void consumed_$eq(boolean x$1) {
                this.consumed = x$1;
            }

            public boolean hasNext() {
                return !this.consumed();
            }

            public Object next() {
                Object object;
                if (this.consumed()) {
                    object = Iterator$.MODULE$.empty().next();
                } else {
                    this.consumed_$eq(true);
                    object = this.a$1;
                }
                return object;
            }
        };
    }

    public Iterator apply(Seq xs) {
        return new View(xs){
            private final Seq xs$6;
            private final int length;
            {
                this.xs$6 = xs$7;
                this.length = xs$7.length();
            }

            public View view() {
                return View.super.view();
            }

            public String toString() {
                return View.super.toString();
            }

            public String className() {
                return View.super.className();
            }

            public int knownSize() {
                return IndexedView.super.knownSize();
            }

            public IndexedView take(int n) {
                return IndexedView.super.take(n);
            }

            public IndexedView takeRight(int n) {
                return IndexedView.super.takeRight(n);
            }

            public IndexedView drop(int n) {
                return IndexedView.super.drop(n);
            }

            public IndexedView dropRight(int n) {
                return IndexedView.super.dropRight(n);
            }

            public IndexedView map(Function1 f) {
                return IndexedView.super.map(f);
            }

            public int length() {
                return this.length;
            }

            public Object apply(int n) {
                return this.xs$6.apply(n);
            }
        }.iterator();
    }

    public Iterator from(int start) {
        return this.from(start, 1);
    }

    public Iterator from(int start, int step) {
        return new Iterator(start, step){
            private final int start$3;
            private final int step$2;
            private int i;
            {
                this.start$3 = start$4;
                this.step$2 = step$3;
                this.i = start$4;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public int next() {
                void var1_1;
                int result = this.i();
                this.i_$eq(this.i() + this.step$2);
                return (int)var1_1;
            }
        };
    }

    public Iterator range(int start, int end) {
        return this.range(start, end, 1);
    }

    public Iterator range(int start, int end, int step) {
        return new Iterator(start, end, step){
            private final int start$5;
            private final int end$1;
            private final int step$4;
            private int i;
            {
                this.start$5 = start$6;
                this.end$1 = end$2;
                this.step$4 = step$5;
                if (step$5 == 0) {
                    throw new IllegalArgumentException("zero step");
                }
                this.i = start$6;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                return !(this.step$4 > 0 && this.i() >= this.end$1 || this.step$4 < 0 && this.i() <= this.end$1);
            }

            /*
             * WARNING - void declaration
             */
            public int next() {
                int n;
                if (this.hasNext()) {
                    void var1_1;
                    int result = this.i();
                    this.i_$eq(this.i() + this.step$4);
                    n = var1_1;
                } else {
                    n = BoxesRunTime.unboxToInt((Object)Iterator$.MODULE$.empty().next());
                }
                return n;
            }
        };
    }

    public Iterator iterate(Object start, Function1 f) {
        return new Iterator(start, f){
            private final Object start$7;
            private final Function1 f$6;
            private boolean first;
            private Object acc;
            {
                this.start$7 = start$8;
                this.f$6 = f$7;
                this.first = true;
                this.acc = start$8;
            }

            public boolean hasNext() {
                return true;
            }

            public Object next() {
                if (this.first) {
                    this.first = false;
                } else {
                    this.acc = this.f$6.apply(this.acc);
                }
                return this.acc;
            }
        };
    }

    public Iterator continually(Function0 elem) {
        return new Iterator(elem){
            private final Function0 elem$2;
            {
                this.elem$2 = elem$3;
            }

            public boolean hasNext() {
                return true;
            }

            public Object next() {
                return this.elem$2.apply();
            }
        };
    }
}

