/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import strawman.collection.Hashing$;
import strawman.collection.IterableFactory;
import strawman.collection.IterableOnce;
import strawman.collection.Iterator;
import strawman.collection.Iterator$;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.immutable.HashSet$;
import strawman.collection.immutable.Iterable;
import strawman.collection.immutable.ListSet;
import strawman.collection.immutable.ListSet$;
import strawman.collection.immutable.Set;
import strawman.collection.immutable.SetOps;
import strawman.collection.immutable.TrieIterator;
import strawman.collection.mutable.Builder;

public interface HashSet
extends Set,
StrictOptimizedIterableOps,
Serializable {
    @Override
    default public void $init$() {
    }

    @Override
    default public IterableFactory iterableFactory() {
        return HashSet$.MODULE$;
    }

    @Override
    default public HashSet fromSpecificIterable(strawman.collection.Iterable coll) {
        return (HashSet)this.fromIterable(coll);
    }

    @Override
    default public Builder newSpecificBuilder() {
        return HashSet$.MODULE$.newBuilder();
    }

    @Override
    default public boolean contains(Object elem) {
        return this.get0(elem, Hashing$.MODULE$.computeHash(elem), 0);
    }

    @Override
    default public HashSet incl(Object elem) {
        return this.updated0(elem, Hashing$.MODULE$.computeHash(elem), 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    default public HashSet excl(Object elem) {
        void var2_2;
        HashSet s = this.removed0(elem, Hashing$.MODULE$.computeHash(elem), 0);
        return s == null ? HashSet$.MODULE$.empty() : var2_2;
    }

    @Override
    default public HashSet empty() {
        return HashSet$.MODULE$.empty();
    }

    @Override
    default public HashSet tail() {
        Object elem = this.head();
        HashSet SetOps_this = this;
        return SetOps_this.excl(elem);
    }

    @Override
    default public HashSet init() {
        Object elem = this.last();
        HashSet SetOps_this = this;
        return SetOps_this.excl(elem);
    }

    public boolean get0(Object var1, int var2, int var3);

    public HashSet updated0(Object var1, int var2, int var3);

    public HashSet removed0(Object var1, int var2, int var3);

    public static final class HashSet1
    extends LeafHashSet {
        private final Object key;
        private final int hash;

        public HashSet1(Object key, int hash) {
            this.key = key;
            this.hash = hash;
        }

        public Object key() {
            return this.key;
        }

        @Override
        public int hash() {
            return this.hash;
        }

        @Override
        public Iterator iterator() {
            return Iterator$.MODULE$.single(this.key());
        }

        @Override
        public void foreach(Function1 f) {
            f.apply(this.key());
        }

        @Override
        public Object head() {
            return this.key();
        }

        @Override
        public HashSet tail() {
            return HashSet$.MODULE$.empty();
        }

        @Override
        public Object last() {
            return this.key();
        }

        @Override
        public HashSet init() {
            return HashSet$.MODULE$.empty();
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean get0(Object key, int hash, int level) {
            return hash == this.hash() && BoxesRunTime.equals((Object)key, (Object)this.key());
        }

        @Override
        public HashSet updated0(Object key, int hash, int level) {
            return hash == this.hash() && BoxesRunTime.equals((Object)key, (Object)this.key()) ? this : (hash != this.hash() ? HashSet$.MODULE$.strawman$collection$immutable$HashSet$$$makeHashTrieSet(this.hash(), this, hash, new HashSet1(key, hash), level) : new HashSetCollision1(hash, (ListSet)ListSet$.MODULE$.empty().$plus(this.key()).$plus(key)));
        }

        @Override
        public HashSet removed0(Object key, int hash, int level) {
            return hash == this.hash() && BoxesRunTime.equals((Object)key, (Object)this.key()) ? null : this;
        }
    }

    public static final class HashSetCollision1
    extends LeafHashSet {
        private final int hash;
        private final ListSet ks;

        public HashSetCollision1(int hash, ListSet ks) {
            this.hash = hash;
            this.ks = ks;
        }

        @Override
        public int hash() {
            return this.hash;
        }

        public ListSet ks() {
            return this.ks;
        }

        @Override
        public int size() {
            return this.ks().size();
        }

        @Override
        public Iterator iterator() {
            return this.ks().iterator();
        }

        @Override
        public void foreach(Function1 f) {
            this.ks().foreach(f);
        }

        @Override
        public boolean get0(Object key, int hash, int level) {
            return hash == this.hash() ? this.ks().contains(key) : false;
        }

        @Override
        public HashSet updated0(Object key, int hash, int level) {
            return hash == this.hash() ? new HashSetCollision1(hash, (ListSet)this.ks().$plus(key)) : HashSet$.MODULE$.strawman$collection$immutable$HashSet$$$makeHashTrieSet(this.hash(), this, hash, new HashSet1(key, hash), level);
        }

        @Override
        public HashSet removed0(Object key, int hash, int level) {
            LeafHashSet leafHashSet;
            if (hash == this.hash()) {
                ListSet SetOps_this = this.ks();
                ListSet ks1 = SetOps_this.excl(key);
                int n = ks1.size();
                if (0 == n) {
                    leafHashSet = null;
                } else if (1 == n) {
                    leafHashSet = new HashSet1(ks1.head(), hash);
                } else {
                    int size = n;
                    leafHashSet = size == this.ks().size() ? this : new HashSetCollision1(hash, ks1);
                }
            } else {
                leafHashSet = this;
            }
            return leafHashSet;
        }

        private void writeObject(ObjectOutputStream out) {
            throw package$.MODULE$.error("cannot serialize an immutable.HashSet where all items have the same 32-bit hash code");
        }

        private void readObject(ObjectInputStream in) {
            throw package$.MODULE$.error("cannot deserialize an immutable.HashSet where all items have the same 32-bit hash code");
        }
    }

    public static final class HashTrieSet
    implements strawman.collection.SetOps,
    SetOps,
    StrictOptimizedIterableOps,
    HashSet {
        private final int bitmap;
        private final HashSet[] elems;
        private final int size0;

        public HashTrieSet(int bitmap, HashSet[] elems, int size0) {
            this.bitmap = bitmap;
            this.elems = elems;
            this.size0 = size0;
            Function1.class.$init$((Function1)this);
            Predef$.MODULE$.assert(Integer.bitCount(bitmap) == elems.length);
        }

        public Function1 compose(Function1 g) {
            return Function1.class.compose((Function1)this, (Function1)g);
        }

        public Function1 andThen(Function1 g) {
            return Function1.class.andThen((Function1)this, (Function1)g);
        }

        @Override
        public boolean equals(Object that) {
            return strawman.collection.SetOps.super.equals(that);
        }

        @Override
        public int hashCode() {
            return strawman.collection.SetOps.super.hashCode();
        }

        @Override
        public String toString() {
            return strawman.collection.SetOps.super.toString();
        }

        @Override
        public HashSet concat(IterableOnce that) {
            return (HashSet)SetOps.super.concat(that);
        }

        @Override
        public Tuple2 partition(Function1 p) {
            return StrictOptimizedIterableOps.super.partition(p);
        }

        @Override
        public Tuple2 span(Function1 p) {
            return StrictOptimizedIterableOps.super.span(p);
        }

        @Override
        public Tuple2 unzip(Predef$.less.colon.less asPair) {
            return StrictOptimizedIterableOps.super.unzip(asPair);
        }

        @Override
        public HashSet tail() {
            return HashSet.super.tail();
        }

        @Override
        public HashSet init() {
            return HashSet.super.init();
        }

        private int bitmap() {
            return this.bitmap;
        }

        public HashSet[] elems() {
            return this.elems;
        }

        private int size0() {
            return this.size0;
        }

        @Override
        public int size() {
            return this.size0();
        }

        @Override
        public Iterator iterator() {
            return new TrieIterator(this){
                private final HashTrieSet $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.strawman$collection$immutable$HashSet$HashTrieSet$iterator$$$anon$superArg$2$1());
                }

                public final Object getElem(Object cc) {
                    return ((HashSet1)cc).key();
                }

                private HashTrieSet $outer() {
                    return this.$outer;
                }

                public final HashTrieSet strawman$collection$immutable$HashSet$HashTrieSet$_$$anon$$$outer() {
                    return this.$outer();
                }
            };
        }

        @Override
        public void foreach(Function1 f) {
            for (int i = 0; i < this.elems().length; ++i) {
                this.elems()[i].foreach(f);
            }
        }

        @Override
        public boolean get0(Object key, int hash, int level) {
            boolean bl;
            int index = hash >>> level & 0x1F;
            int mask = 1 << index;
            if (this.bitmap() == -1) {
                bl = this.elems()[index & 0x1F].get0(key, hash, level + 5);
            } else if ((this.bitmap() & mask) != 0) {
                int offset = Integer.bitCount(this.bitmap() & mask - 1);
                bl = this.elems()[offset].get0(key, hash, level + 5);
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public HashSet updated0(Object key, int hash, int level) {
            HashTrieSet hashTrieSet;
            int index = hash >>> level & 0x1F;
            int mask = 1 << index;
            int offset = Integer.bitCount(this.bitmap() & mask - 1);
            if ((this.bitmap() & mask) != 0) {
                HashSet subNew;
                HashSet sub = this.elems()[offset];
                if (sub == (subNew = sub.updated0(key, hash, level + 5))) {
                    hashTrieSet = this;
                } else {
                    HashSet[] elemsNew = Arrays.copyOf(this.elems(), this.elems().length);
                    elemsNew[offset] = subNew;
                    hashTrieSet = new HashTrieSet(this.bitmap(), elemsNew, this.size() + (subNew.size() - sub.size()));
                }
            } else {
                HashSet[] elemsNew = new HashSet[this.elems().length + 1];
                Array$.MODULE$.copy((Object)this.elems(), 0, (Object)elemsNew, 0, offset);
                elemsNew[offset] = new HashSet1(key, hash);
                Array$.MODULE$.copy((Object)this.elems(), offset, (Object)elemsNew, offset + 1, this.elems().length - offset);
                int bitmapNew = this.bitmap() | mask;
                hashTrieSet = new HashTrieSet(bitmapNew, elemsNew, this.size() + 1);
            }
            return hashTrieSet;
        }

        @Override
        public HashSet removed0(Object key, int hash, int level) {
            HashSet hashSet;
            int index = hash >>> level & 0x1F;
            int mask = 1 << index;
            int offset = Integer.bitCount(this.bitmap() & mask - 1);
            if ((this.bitmap() & mask) != 0) {
                HashSet subNew;
                HashSet sub = this.elems()[offset];
                if (sub == (subNew = sub.removed0(key, hash, level + 5))) {
                    hashSet = this;
                } else if (subNew == null) {
                    int bitmapNew = this.bitmap() ^ mask;
                    if (bitmapNew != 0) {
                        HashSet[] elemsNew = new HashSet[this.elems().length - 1];
                        Array$.MODULE$.copy((Object)this.elems(), 0, (Object)elemsNew, 0, offset);
                        Array$.MODULE$.copy((Object)this.elems(), offset + 1, (Object)elemsNew, offset, this.elems().length - offset - 1);
                        int sizeNew = this.size() - sub.size();
                        hashSet = elemsNew.length == 1 && !(elemsNew[0] instanceof HashTrieSet) ? elemsNew[0] : new HashTrieSet(bitmapNew, elemsNew, sizeNew);
                    } else {
                        hashSet = null;
                    }
                } else if (this.elems().length == 1 && !(subNew instanceof HashTrieSet)) {
                    hashSet = subNew;
                } else {
                    HashSet[] elemsNew = Arrays.copyOf(this.elems(), this.elems().length);
                    elemsNew[offset] = subNew;
                    int sizeNew = this.size() + (subNew.size() - sub.size());
                    hashSet = new HashTrieSet(this.bitmap(), elemsNew, sizeNew);
                }
            } else {
                hashSet = this;
            }
            return hashSet;
        }

        public Iterable[] strawman$collection$immutable$HashSet$HashTrieSet$iterator$$$anon$superArg$2$1() {
            return this.elems();
        }
    }

    public static abstract class LeafHashSet
    implements strawman.collection.SetOps,
    SetOps,
    StrictOptimizedIterableOps,
    HashSet {
        public LeafHashSet() {
            Function1.class.$init$((Function1)this);
        }

        public Function1 compose(Function1 g) {
            return Function1.class.compose((Function1)this, (Function1)g);
        }

        public Function1 andThen(Function1 g) {
            return Function1.class.andThen((Function1)this, (Function1)g);
        }

        @Override
        public boolean equals(Object that) {
            return strawman.collection.SetOps.super.equals(that);
        }

        @Override
        public int hashCode() {
            return strawman.collection.SetOps.super.hashCode();
        }

        @Override
        public String toString() {
            return strawman.collection.SetOps.super.toString();
        }

        @Override
        public HashSet concat(IterableOnce that) {
            return (HashSet)SetOps.super.concat(that);
        }

        @Override
        public Tuple2 partition(Function1 p) {
            return StrictOptimizedIterableOps.super.partition(p);
        }

        @Override
        public Tuple2 span(Function1 p) {
            return StrictOptimizedIterableOps.super.span(p);
        }

        @Override
        public Tuple2 unzip(Predef$.less.colon.less asPair) {
            return StrictOptimizedIterableOps.super.unzip(asPair);
        }

        @Override
        public HashSet tail() {
            return HashSet.super.tail();
        }

        @Override
        public HashSet init() {
            return HashSet.super.init();
        }

        public abstract int hash();
    }
}

